
// Copyright (C) 2023 basysKom GmbH, opensource@basyskom.com
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#include "qopcuanodeids.h"

QT_BEGIN_NAMESPACE

/*!
    \namespace QOpcUa::NodeIds
    \inmodule QtOpcUa
    \inheaderfile QtOpcUa/qopcuanodeids.h
    \brief This namespace contains enums with known node ids.
*/

/*!
    \enum QOpcUa::NodeIds::Namespace0

    Contains all numeric node identifiers from namespace 0 defined in the OPC Foundation's
    \l {https://opcfoundation.org/UA/schemas/1.05/NodeIds.csv} {NodeIds.csv} file.

    The values in this enum follow the naming from the CSV file and can be converted between
    enum and node id string using \l QOpcUa::namespace0Id() and \l QOpcUa::namespace0IdFromNodeId().
    \l QOpcUa::namespace0IdName() provides a conversion from enum value to the name string from the CSV file.

    \code
    QScopedPointer<QOpcUaNode> rootNode(client->node(QOpcUa::namespace0Id(QOpcUa::NodeIds::RootFolder)));
    \endcode

    \value Unknown
    \value Boolean
    \value SByte
    \value Byte
    \value Int16
    \value UInt16
    \value Int32
    \value UInt32
    \value Int64
    \value UInt64
    \value Float
    \value Double
    \value String
    \value DateTime
    \value Guid
    \value ByteString
    \value XmlElement
    \value NodeId
    \value ExpandedNodeId
    \value StatusCode
    \value QualifiedName
    \value LocalizedText
    \value Structure
    \value DataValue
    \value BaseDataType
    \value DiagnosticInfo
    \value Number
    \value Integer
    \value UInteger
    \value Enumeration
    \value Image
    \value References
    \value NonHierarchicalReferences
    \value HierarchicalReferences
    \value HasChild
    \value Organizes
    \value HasEventSource
    \value HasModellingRule
    \value HasEncoding
    \value HasDescription
    \value HasTypeDefinition
    \value GeneratesEvent
    \value Aggregates
    \value HasSubtype
    \value HasProperty
    \value HasComponent
    \value HasNotifier
    \value HasOrderedComponent
    \value Decimal
    \value FromState
    \value ToState
    \value HasCause
    \value HasEffect
    \value HasHistoricalConfiguration
    \value BaseObjectType
    \value FolderType
    \value BaseVariableType
    \value BaseDataVariableType
    \value PropertyType
    \value DataTypeDescriptionType
    \value DataTypeDictionaryType
    \value DataTypeSystemType
    \value DataTypeEncodingType
    \value ModellingRuleType
    \value ModellingRule_Mandatory
    \value ModellingRule_Optional
    \value ModellingRule_ExposesItsArray
    \value RootFolder
    \value ObjectsFolder
    \value TypesFolder
    \value ViewsFolder
    \value ObjectTypesFolder
    \value VariableTypesFolder
    \value DataTypesFolder
    \value ReferenceTypesFolder
    \value XmlSchema_TypeSystem
    \value OPCBinarySchema_TypeSystem
    \value PermissionType
    \value AccessRestrictionType
    \value RolePermissionType
    \value DataTypeDefinition
    \value StructureType
    \value StructureDefinition
    \value EnumDefinition
    \value StructureField
    \value EnumField
    \value DataTypeDescriptionType_DataTypeVersion
    \value DataTypeDescriptionType_DictionaryFragment
    \value DataTypeDictionaryType_DataTypeVersion
    \value DataTypeDictionaryType_NamespaceUri
    \value HasSubStateMachine
    \value NamingRuleType
    \value DataTypeDefinition_Encoding_DefaultBinary
    \value StructureDefinition_Encoding_DefaultBinary
    \value EnumDefinition_Encoding_DefaultBinary
    \value DataSetMetaDataType_Encoding_DefaultBinary
    \value DataTypeDescription_Encoding_DefaultBinary
    \value StructureDescription_Encoding_DefaultBinary
    \value EnumDescription_Encoding_DefaultBinary
    \value RolePermissionType_Encoding_DefaultBinary
    \value HasArgumentDescription
    \value HasOptionalInputArgumentDescription
    \value IdType
    \value NodeClass
    \value Node
    \value Node_Encoding_DefaultXml
    \value Node_Encoding_DefaultBinary
    \value ObjectNode
    \value ObjectNode_Encoding_DefaultXml
    \value ObjectNode_Encoding_DefaultBinary
    \value ObjectTypeNode
    \value ObjectTypeNode_Encoding_DefaultXml
    \value ObjectTypeNode_Encoding_DefaultBinary
    \value VariableNode
    \value VariableNode_Encoding_DefaultXml
    \value VariableNode_Encoding_DefaultBinary
    \value VariableTypeNode
    \value VariableTypeNode_Encoding_DefaultXml
    \value VariableTypeNode_Encoding_DefaultBinary
    \value ReferenceTypeNode
    \value ReferenceTypeNode_Encoding_DefaultXml
    \value ReferenceTypeNode_Encoding_DefaultBinary
    \value MethodNode
    \value MethodNode_Encoding_DefaultXml
    \value MethodNode_Encoding_DefaultBinary
    \value ViewNode
    \value ViewNode_Encoding_DefaultXml
    \value ViewNode_Encoding_DefaultBinary
    \value DataTypeNode
    \value DataTypeNode_Encoding_DefaultXml
    \value DataTypeNode_Encoding_DefaultBinary
    \value ReferenceNode
    \value ReferenceNode_Encoding_DefaultXml
    \value ReferenceNode_Encoding_DefaultBinary
    \value IntegerId
    \value Counter
    \value Duration
    \value NumericRange
    \value UtcTime
    \value LocaleId
    \value Argument
    \value Argument_Encoding_DefaultXml
    \value Argument_Encoding_DefaultBinary
    \value StatusResult
    \value StatusResult_Encoding_DefaultXml
    \value StatusResult_Encoding_DefaultBinary
    \value MessageSecurityMode
    \value UserTokenType
    \value UserTokenPolicy
    \value UserTokenPolicy_Encoding_DefaultXml
    \value UserTokenPolicy_Encoding_DefaultBinary
    \value ApplicationType
    \value ApplicationDescription
    \value ApplicationDescription_Encoding_DefaultXml
    \value ApplicationDescription_Encoding_DefaultBinary
    \value ApplicationInstanceCertificate
    \value EndpointDescription
    \value EndpointDescription_Encoding_DefaultXml
    \value EndpointDescription_Encoding_DefaultBinary
    \value SecurityTokenRequestType
    \value UserIdentityToken
    \value UserIdentityToken_Encoding_DefaultXml
    \value UserIdentityToken_Encoding_DefaultBinary
    \value AnonymousIdentityToken
    \value AnonymousIdentityToken_Encoding_DefaultXml
    \value AnonymousIdentityToken_Encoding_DefaultBinary
    \value UserNameIdentityToken
    \value UserNameIdentityToken_Encoding_DefaultXml
    \value UserNameIdentityToken_Encoding_DefaultBinary
    \value X509IdentityToken
    \value X509IdentityToken_Encoding_DefaultXml
    \value X509IdentityToken_Encoding_DefaultBinary
    \value EndpointConfiguration
    \value EndpointConfiguration_Encoding_DefaultXml
    \value EndpointConfiguration_Encoding_DefaultBinary
    \value BuildInfo
    \value BuildInfo_Encoding_DefaultXml
    \value BuildInfo_Encoding_DefaultBinary
    \value SignedSoftwareCertificate
    \value SignedSoftwareCertificate_Encoding_DefaultXml
    \value SignedSoftwareCertificate_Encoding_DefaultBinary
    \value AttributeWriteMask
    \value NodeAttributesMask
    \value NodeAttributes
    \value NodeAttributes_Encoding_DefaultXml
    \value NodeAttributes_Encoding_DefaultBinary
    \value ObjectAttributes
    \value ObjectAttributes_Encoding_DefaultXml
    \value ObjectAttributes_Encoding_DefaultBinary
    \value VariableAttributes
    \value VariableAttributes_Encoding_DefaultXml
    \value VariableAttributes_Encoding_DefaultBinary
    \value MethodAttributes
    \value MethodAttributes_Encoding_DefaultXml
    \value MethodAttributes_Encoding_DefaultBinary
    \value ObjectTypeAttributes
    \value ObjectTypeAttributes_Encoding_DefaultXml
    \value ObjectTypeAttributes_Encoding_DefaultBinary
    \value VariableTypeAttributes
    \value VariableTypeAttributes_Encoding_DefaultXml
    \value VariableTypeAttributes_Encoding_DefaultBinary
    \value ReferenceTypeAttributes
    \value ReferenceTypeAttributes_Encoding_DefaultXml
    \value ReferenceTypeAttributes_Encoding_DefaultBinary
    \value DataTypeAttributes
    \value DataTypeAttributes_Encoding_DefaultXml
    \value DataTypeAttributes_Encoding_DefaultBinary
    \value ViewAttributes
    \value ViewAttributes_Encoding_DefaultXml
    \value ViewAttributes_Encoding_DefaultBinary
    \value AddNodesItem
    \value AddNodesItem_Encoding_DefaultXml
    \value AddNodesItem_Encoding_DefaultBinary
    \value AddReferencesItem
    \value AddReferencesItem_Encoding_DefaultXml
    \value AddReferencesItem_Encoding_DefaultBinary
    \value DeleteNodesItem
    \value DeleteNodesItem_Encoding_DefaultXml
    \value DeleteNodesItem_Encoding_DefaultBinary
    \value DeleteReferencesItem
    \value DeleteReferencesItem_Encoding_DefaultXml
    \value DeleteReferencesItem_Encoding_DefaultBinary
    \value SessionAuthenticationToken
    \value RequestHeader
    \value RequestHeader_Encoding_DefaultXml
    \value RequestHeader_Encoding_DefaultBinary
    \value ResponseHeader
    \value ResponseHeader_Encoding_DefaultXml
    \value ResponseHeader_Encoding_DefaultBinary
    \value ServiceFault
    \value ServiceFault_Encoding_DefaultXml
    \value ServiceFault_Encoding_DefaultBinary
    \value FindServersRequest
    \value FindServersRequest_Encoding_DefaultXml
    \value FindServersRequest_Encoding_DefaultBinary
    \value FindServersResponse
    \value FindServersResponse_Encoding_DefaultXml
    \value FindServersResponse_Encoding_DefaultBinary
    \value GetEndpointsRequest
    \value GetEndpointsRequest_Encoding_DefaultXml
    \value GetEndpointsRequest_Encoding_DefaultBinary
    \value GetEndpointsResponse
    \value GetEndpointsResponse_Encoding_DefaultXml
    \value GetEndpointsResponse_Encoding_DefaultBinary
    \value RegisteredServer
    \value RegisteredServer_Encoding_DefaultXml
    \value RegisteredServer_Encoding_DefaultBinary
    \value RegisterServerRequest
    \value RegisterServerRequest_Encoding_DefaultXml
    \value RegisterServerRequest_Encoding_DefaultBinary
    \value RegisterServerResponse
    \value RegisterServerResponse_Encoding_DefaultXml
    \value RegisterServerResponse_Encoding_DefaultBinary
    \value ChannelSecurityToken
    \value ChannelSecurityToken_Encoding_DefaultXml
    \value ChannelSecurityToken_Encoding_DefaultBinary
    \value OpenSecureChannelRequest
    \value OpenSecureChannelRequest_Encoding_DefaultXml
    \value OpenSecureChannelRequest_Encoding_DefaultBinary
    \value OpenSecureChannelResponse
    \value OpenSecureChannelResponse_Encoding_DefaultXml
    \value OpenSecureChannelResponse_Encoding_DefaultBinary
    \value CloseSecureChannelRequest
    \value CloseSecureChannelRequest_Encoding_DefaultXml
    \value CloseSecureChannelRequest_Encoding_DefaultBinary
    \value CloseSecureChannelResponse
    \value CloseSecureChannelResponse_Encoding_DefaultXml
    \value CloseSecureChannelResponse_Encoding_DefaultBinary
    \value SignatureData
    \value SignatureData_Encoding_DefaultXml
    \value SignatureData_Encoding_DefaultBinary
    \value CreateSessionRequest
    \value CreateSessionRequest_Encoding_DefaultXml
    \value CreateSessionRequest_Encoding_DefaultBinary
    \value CreateSessionResponse
    \value CreateSessionResponse_Encoding_DefaultXml
    \value CreateSessionResponse_Encoding_DefaultBinary
    \value ActivateSessionRequest
    \value ActivateSessionRequest_Encoding_DefaultXml
    \value ActivateSessionRequest_Encoding_DefaultBinary
    \value ActivateSessionResponse
    \value ActivateSessionResponse_Encoding_DefaultXml
    \value ActivateSessionResponse_Encoding_DefaultBinary
    \value CloseSessionRequest
    \value CloseSessionRequest_Encoding_DefaultXml
    \value CloseSessionRequest_Encoding_DefaultBinary
    \value CloseSessionResponse
    \value CloseSessionResponse_Encoding_DefaultXml
    \value CloseSessionResponse_Encoding_DefaultBinary
    \value CancelRequest
    \value CancelRequest_Encoding_DefaultXml
    \value CancelRequest_Encoding_DefaultBinary
    \value CancelResponse
    \value CancelResponse_Encoding_DefaultXml
    \value CancelResponse_Encoding_DefaultBinary
    \value AddNodesResult
    \value AddNodesResult_Encoding_DefaultXml
    \value AddNodesResult_Encoding_DefaultBinary
    \value AddNodesRequest
    \value AddNodesRequest_Encoding_DefaultXml
    \value AddNodesRequest_Encoding_DefaultBinary
    \value AddNodesResponse
    \value AddNodesResponse_Encoding_DefaultXml
    \value AddNodesResponse_Encoding_DefaultBinary
    \value AddReferencesRequest
    \value AddReferencesRequest_Encoding_DefaultXml
    \value AddReferencesRequest_Encoding_DefaultBinary
    \value AddReferencesResponse
    \value AddReferencesResponse_Encoding_DefaultXml
    \value AddReferencesResponse_Encoding_DefaultBinary
    \value DeleteNodesRequest
    \value DeleteNodesRequest_Encoding_DefaultXml
    \value DeleteNodesRequest_Encoding_DefaultBinary
    \value DeleteNodesResponse
    \value DeleteNodesResponse_Encoding_DefaultXml
    \value DeleteNodesResponse_Encoding_DefaultBinary
    \value DeleteReferencesRequest
    \value DeleteReferencesRequest_Encoding_DefaultXml
    \value DeleteReferencesRequest_Encoding_DefaultBinary
    \value DeleteReferencesResponse
    \value DeleteReferencesResponse_Encoding_DefaultXml
    \value DeleteReferencesResponse_Encoding_DefaultBinary
    \value BrowseDirection
    \value ViewDescription
    \value ViewDescription_Encoding_DefaultXml
    \value ViewDescription_Encoding_DefaultBinary
    \value BrowseDescription
    \value BrowseDescription_Encoding_DefaultXml
    \value BrowseDescription_Encoding_DefaultBinary
    \value BrowseResultMask
    \value ReferenceDescription
    \value ReferenceDescription_Encoding_DefaultXml
    \value ReferenceDescription_Encoding_DefaultBinary
    \value ContinuationPoint
    \value BrowseResult
    \value BrowseResult_Encoding_DefaultXml
    \value BrowseResult_Encoding_DefaultBinary
    \value BrowseRequest
    \value BrowseRequest_Encoding_DefaultXml
    \value BrowseRequest_Encoding_DefaultBinary
    \value BrowseResponse
    \value BrowseResponse_Encoding_DefaultXml
    \value BrowseResponse_Encoding_DefaultBinary
    \value BrowseNextRequest
    \value BrowseNextRequest_Encoding_DefaultXml
    \value BrowseNextRequest_Encoding_DefaultBinary
    \value BrowseNextResponse
    \value BrowseNextResponse_Encoding_DefaultXml
    \value BrowseNextResponse_Encoding_DefaultBinary
    \value RelativePathElement
    \value RelativePathElement_Encoding_DefaultXml
    \value RelativePathElement_Encoding_DefaultBinary
    \value RelativePath
    \value RelativePath_Encoding_DefaultXml
    \value RelativePath_Encoding_DefaultBinary
    \value BrowsePath
    \value BrowsePath_Encoding_DefaultXml
    \value BrowsePath_Encoding_DefaultBinary
    \value BrowsePathTarget
    \value BrowsePathTarget_Encoding_DefaultXml
    \value BrowsePathTarget_Encoding_DefaultBinary
    \value BrowsePathResult
    \value BrowsePathResult_Encoding_DefaultXml
    \value BrowsePathResult_Encoding_DefaultBinary
    \value TranslateBrowsePathsToNodeIdsRequest
    \value TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultXml
    \value TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultBinary
    \value TranslateBrowsePathsToNodeIdsResponse
    \value TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultXml
    \value TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultBinary
    \value RegisterNodesRequest
    \value RegisterNodesRequest_Encoding_DefaultXml
    \value RegisterNodesRequest_Encoding_DefaultBinary
    \value RegisterNodesResponse
    \value RegisterNodesResponse_Encoding_DefaultXml
    \value RegisterNodesResponse_Encoding_DefaultBinary
    \value UnregisterNodesRequest
    \value UnregisterNodesRequest_Encoding_DefaultXml
    \value UnregisterNodesRequest_Encoding_DefaultBinary
    \value UnregisterNodesResponse
    \value UnregisterNodesResponse_Encoding_DefaultXml
    \value UnregisterNodesResponse_Encoding_DefaultBinary
    \value QueryDataDescription
    \value QueryDataDescription_Encoding_DefaultXml
    \value QueryDataDescription_Encoding_DefaultBinary
    \value NodeTypeDescription
    \value NodeTypeDescription_Encoding_DefaultXml
    \value NodeTypeDescription_Encoding_DefaultBinary
    \value FilterOperator
    \value QueryDataSet
    \value QueryDataSet_Encoding_DefaultXml
    \value QueryDataSet_Encoding_DefaultBinary
    \value NodeReference
    \value NodeReference_Encoding_DefaultXml
    \value NodeReference_Encoding_DefaultBinary
    \value ContentFilterElement
    \value ContentFilterElement_Encoding_DefaultXml
    \value ContentFilterElement_Encoding_DefaultBinary
    \value ContentFilter
    \value ContentFilter_Encoding_DefaultXml
    \value ContentFilter_Encoding_DefaultBinary
    \value FilterOperand
    \value FilterOperand_Encoding_DefaultXml
    \value FilterOperand_Encoding_DefaultBinary
    \value ElementOperand
    \value ElementOperand_Encoding_DefaultXml
    \value ElementOperand_Encoding_DefaultBinary
    \value LiteralOperand
    \value LiteralOperand_Encoding_DefaultXml
    \value LiteralOperand_Encoding_DefaultBinary
    \value AttributeOperand
    \value AttributeOperand_Encoding_DefaultXml
    \value AttributeOperand_Encoding_DefaultBinary
    \value SimpleAttributeOperand
    \value SimpleAttributeOperand_Encoding_DefaultXml
    \value SimpleAttributeOperand_Encoding_DefaultBinary
    \value ContentFilterElementResult
    \value ContentFilterElementResult_Encoding_DefaultXml
    \value ContentFilterElementResult_Encoding_DefaultBinary
    \value ContentFilterResult
    \value ContentFilterResult_Encoding_DefaultXml
    \value ContentFilterResult_Encoding_DefaultBinary
    \value ParsingResult
    \value ParsingResult_Encoding_DefaultXml
    \value ParsingResult_Encoding_DefaultBinary
    \value QueryFirstRequest
    \value QueryFirstRequest_Encoding_DefaultXml
    \value QueryFirstRequest_Encoding_DefaultBinary
    \value QueryFirstResponse
    \value QueryFirstResponse_Encoding_DefaultXml
    \value QueryFirstResponse_Encoding_DefaultBinary
    \value QueryNextRequest
    \value QueryNextRequest_Encoding_DefaultXml
    \value QueryNextRequest_Encoding_DefaultBinary
    \value QueryNextResponse
    \value QueryNextResponse_Encoding_DefaultXml
    \value QueryNextResponse_Encoding_DefaultBinary
    \value TimestampsToReturn
    \value ReadValueId
    \value ReadValueId_Encoding_DefaultXml
    \value ReadValueId_Encoding_DefaultBinary
    \value ReadRequest
    \value ReadRequest_Encoding_DefaultXml
    \value ReadRequest_Encoding_DefaultBinary
    \value ReadResponse
    \value ReadResponse_Encoding_DefaultXml
    \value ReadResponse_Encoding_DefaultBinary
    \value HistoryReadValueId
    \value HistoryReadValueId_Encoding_DefaultXml
    \value HistoryReadValueId_Encoding_DefaultBinary
    \value HistoryReadResult
    \value HistoryReadResult_Encoding_DefaultXml
    \value HistoryReadResult_Encoding_DefaultBinary
    \value HistoryReadDetails
    \value HistoryReadDetails_Encoding_DefaultXml
    \value HistoryReadDetails_Encoding_DefaultBinary
    \value ReadEventDetails
    \value ReadEventDetails_Encoding_DefaultXml
    \value ReadEventDetails_Encoding_DefaultBinary
    \value ReadRawModifiedDetails
    \value ReadRawModifiedDetails_Encoding_DefaultXml
    \value ReadRawModifiedDetails_Encoding_DefaultBinary
    \value ReadProcessedDetails
    \value ReadProcessedDetails_Encoding_DefaultXml
    \value ReadProcessedDetails_Encoding_DefaultBinary
    \value ReadAtTimeDetails
    \value ReadAtTimeDetails_Encoding_DefaultXml
    \value ReadAtTimeDetails_Encoding_DefaultBinary
    \value HistoryData
    \value HistoryData_Encoding_DefaultXml
    \value HistoryData_Encoding_DefaultBinary
    \value HistoryEvent
    \value HistoryEvent_Encoding_DefaultXml
    \value HistoryEvent_Encoding_DefaultBinary
    \value HistoryReadRequest
    \value HistoryReadRequest_Encoding_DefaultXml
    \value HistoryReadRequest_Encoding_DefaultBinary
    \value HistoryReadResponse
    \value HistoryReadResponse_Encoding_DefaultXml
    \value HistoryReadResponse_Encoding_DefaultBinary
    \value WriteValue
    \value WriteValue_Encoding_DefaultXml
    \value WriteValue_Encoding_DefaultBinary
    \value WriteRequest
    \value WriteRequest_Encoding_DefaultXml
    \value WriteRequest_Encoding_DefaultBinary
    \value WriteResponse
    \value WriteResponse_Encoding_DefaultXml
    \value WriteResponse_Encoding_DefaultBinary
    \value HistoryUpdateDetails
    \value HistoryUpdateDetails_Encoding_DefaultXml
    \value HistoryUpdateDetails_Encoding_DefaultBinary
    \value UpdateDataDetails
    \value UpdateDataDetails_Encoding_DefaultXml
    \value UpdateDataDetails_Encoding_DefaultBinary
    \value UpdateEventDetails
    \value UpdateEventDetails_Encoding_DefaultXml
    \value UpdateEventDetails_Encoding_DefaultBinary
    \value DeleteRawModifiedDetails
    \value DeleteRawModifiedDetails_Encoding_DefaultXml
    \value DeleteRawModifiedDetails_Encoding_DefaultBinary
    \value DeleteAtTimeDetails
    \value DeleteAtTimeDetails_Encoding_DefaultXml
    \value DeleteAtTimeDetails_Encoding_DefaultBinary
    \value DeleteEventDetails
    \value DeleteEventDetails_Encoding_DefaultXml
    \value DeleteEventDetails_Encoding_DefaultBinary
    \value HistoryUpdateResult
    \value HistoryUpdateResult_Encoding_DefaultXml
    \value HistoryUpdateResult_Encoding_DefaultBinary
    \value HistoryUpdateRequest
    \value HistoryUpdateRequest_Encoding_DefaultXml
    \value HistoryUpdateRequest_Encoding_DefaultBinary
    \value HistoryUpdateResponse
    \value HistoryUpdateResponse_Encoding_DefaultXml
    \value HistoryUpdateResponse_Encoding_DefaultBinary
    \value CallMethodRequest
    \value CallMethodRequest_Encoding_DefaultXml
    \value CallMethodRequest_Encoding_DefaultBinary
    \value CallMethodResult
    \value CallMethodResult_Encoding_DefaultXml
    \value CallMethodResult_Encoding_DefaultBinary
    \value CallRequest
    \value CallRequest_Encoding_DefaultXml
    \value CallRequest_Encoding_DefaultBinary
    \value CallResponse
    \value CallResponse_Encoding_DefaultXml
    \value CallResponse_Encoding_DefaultBinary
    \value MonitoringMode
    \value DataChangeTrigger
    \value DeadbandType
    \value MonitoringFilter
    \value MonitoringFilter_Encoding_DefaultXml
    \value MonitoringFilter_Encoding_DefaultBinary
    \value DataChangeFilter
    \value DataChangeFilter_Encoding_DefaultXml
    \value DataChangeFilter_Encoding_DefaultBinary
    \value EventFilter
    \value EventFilter_Encoding_DefaultXml
    \value EventFilter_Encoding_DefaultBinary
    \value AggregateFilter
    \value AggregateFilter_Encoding_DefaultXml
    \value AggregateFilter_Encoding_DefaultBinary
    \value MonitoringFilterResult
    \value MonitoringFilterResult_Encoding_DefaultXml
    \value MonitoringFilterResult_Encoding_DefaultBinary
    \value EventFilterResult
    \value EventFilterResult_Encoding_DefaultXml
    \value EventFilterResult_Encoding_DefaultBinary
    \value AggregateFilterResult
    \value AggregateFilterResult_Encoding_DefaultXml
    \value AggregateFilterResult_Encoding_DefaultBinary
    \value MonitoringParameters
    \value MonitoringParameters_Encoding_DefaultXml
    \value MonitoringParameters_Encoding_DefaultBinary
    \value MonitoredItemCreateRequest
    \value MonitoredItemCreateRequest_Encoding_DefaultXml
    \value MonitoredItemCreateRequest_Encoding_DefaultBinary
    \value MonitoredItemCreateResult
    \value MonitoredItemCreateResult_Encoding_DefaultXml
    \value MonitoredItemCreateResult_Encoding_DefaultBinary
    \value CreateMonitoredItemsRequest
    \value CreateMonitoredItemsRequest_Encoding_DefaultXml
    \value CreateMonitoredItemsRequest_Encoding_DefaultBinary
    \value CreateMonitoredItemsResponse
    \value CreateMonitoredItemsResponse_Encoding_DefaultXml
    \value CreateMonitoredItemsResponse_Encoding_DefaultBinary
    \value MonitoredItemModifyRequest
    \value MonitoredItemModifyRequest_Encoding_DefaultXml
    \value MonitoredItemModifyRequest_Encoding_DefaultBinary
    \value MonitoredItemModifyResult
    \value MonitoredItemModifyResult_Encoding_DefaultXml
    \value MonitoredItemModifyResult_Encoding_DefaultBinary
    \value ModifyMonitoredItemsRequest
    \value ModifyMonitoredItemsRequest_Encoding_DefaultXml
    \value ModifyMonitoredItemsRequest_Encoding_DefaultBinary
    \value ModifyMonitoredItemsResponse
    \value ModifyMonitoredItemsResponse_Encoding_DefaultXml
    \value ModifyMonitoredItemsResponse_Encoding_DefaultBinary
    \value SetMonitoringModeRequest
    \value SetMonitoringModeRequest_Encoding_DefaultXml
    \value SetMonitoringModeRequest_Encoding_DefaultBinary
    \value SetMonitoringModeResponse
    \value SetMonitoringModeResponse_Encoding_DefaultXml
    \value SetMonitoringModeResponse_Encoding_DefaultBinary
    \value SetTriggeringRequest
    \value SetTriggeringRequest_Encoding_DefaultXml
    \value SetTriggeringRequest_Encoding_DefaultBinary
    \value SetTriggeringResponse
    \value SetTriggeringResponse_Encoding_DefaultXml
    \value SetTriggeringResponse_Encoding_DefaultBinary
    \value DeleteMonitoredItemsRequest
    \value DeleteMonitoredItemsRequest_Encoding_DefaultXml
    \value DeleteMonitoredItemsRequest_Encoding_DefaultBinary
    \value DeleteMonitoredItemsResponse
    \value DeleteMonitoredItemsResponse_Encoding_DefaultXml
    \value DeleteMonitoredItemsResponse_Encoding_DefaultBinary
    \value CreateSubscriptionRequest
    \value CreateSubscriptionRequest_Encoding_DefaultXml
    \value CreateSubscriptionRequest_Encoding_DefaultBinary
    \value CreateSubscriptionResponse
    \value CreateSubscriptionResponse_Encoding_DefaultXml
    \value CreateSubscriptionResponse_Encoding_DefaultBinary
    \value ModifySubscriptionRequest
    \value ModifySubscriptionRequest_Encoding_DefaultXml
    \value ModifySubscriptionRequest_Encoding_DefaultBinary
    \value ModifySubscriptionResponse
    \value ModifySubscriptionResponse_Encoding_DefaultXml
    \value ModifySubscriptionResponse_Encoding_DefaultBinary
    \value SetPublishingModeRequest
    \value SetPublishingModeRequest_Encoding_DefaultXml
    \value SetPublishingModeRequest_Encoding_DefaultBinary
    \value SetPublishingModeResponse
    \value SetPublishingModeResponse_Encoding_DefaultXml
    \value SetPublishingModeResponse_Encoding_DefaultBinary
    \value NotificationMessage
    \value NotificationMessage_Encoding_DefaultXml
    \value NotificationMessage_Encoding_DefaultBinary
    \value MonitoredItemNotification
    \value MonitoredItemNotification_Encoding_DefaultXml
    \value MonitoredItemNotification_Encoding_DefaultBinary
    \value DataChangeNotification
    \value DataChangeNotification_Encoding_DefaultXml
    \value DataChangeNotification_Encoding_DefaultBinary
    \value StatusChangeNotification
    \value StatusChangeNotification_Encoding_DefaultXml
    \value StatusChangeNotification_Encoding_DefaultBinary
    \value SubscriptionAcknowledgement
    \value SubscriptionAcknowledgement_Encoding_DefaultXml
    \value SubscriptionAcknowledgement_Encoding_DefaultBinary
    \value PublishRequest
    \value PublishRequest_Encoding_DefaultXml
    \value PublishRequest_Encoding_DefaultBinary
    \value PublishResponse
    \value PublishResponse_Encoding_DefaultXml
    \value PublishResponse_Encoding_DefaultBinary
    \value RepublishRequest
    \value RepublishRequest_Encoding_DefaultXml
    \value RepublishRequest_Encoding_DefaultBinary
    \value RepublishResponse
    \value RepublishResponse_Encoding_DefaultXml
    \value RepublishResponse_Encoding_DefaultBinary
    \value TransferResult
    \value TransferResult_Encoding_DefaultXml
    \value TransferResult_Encoding_DefaultBinary
    \value TransferSubscriptionsRequest
    \value TransferSubscriptionsRequest_Encoding_DefaultXml
    \value TransferSubscriptionsRequest_Encoding_DefaultBinary
    \value TransferSubscriptionsResponse
    \value TransferSubscriptionsResponse_Encoding_DefaultXml
    \value TransferSubscriptionsResponse_Encoding_DefaultBinary
    \value DeleteSubscriptionsRequest
    \value DeleteSubscriptionsRequest_Encoding_DefaultXml
    \value DeleteSubscriptionsRequest_Encoding_DefaultBinary
    \value DeleteSubscriptionsResponse
    \value DeleteSubscriptionsResponse_Encoding_DefaultXml
    \value DeleteSubscriptionsResponse_Encoding_DefaultBinary
    \value RedundancySupport
    \value ServerState
    \value RedundantServerDataType
    \value RedundantServerDataType_Encoding_DefaultXml
    \value RedundantServerDataType_Encoding_DefaultBinary
    \value SamplingIntervalDiagnosticsDataType
    \value SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml
    \value SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary
    \value ServerDiagnosticsSummaryDataType
    \value ServerDiagnosticsSummaryDataType_Encoding_DefaultXml
    \value ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary
    \value ServerStatusDataType
    \value ServerStatusDataType_Encoding_DefaultXml
    \value ServerStatusDataType_Encoding_DefaultBinary
    \value SessionDiagnosticsDataType
    \value SessionDiagnosticsDataType_Encoding_DefaultXml
    \value SessionDiagnosticsDataType_Encoding_DefaultBinary
    \value SessionSecurityDiagnosticsDataType
    \value SessionSecurityDiagnosticsDataType_Encoding_DefaultXml
    \value SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary
    \value ServiceCounterDataType
    \value ServiceCounterDataType_Encoding_DefaultXml
    \value ServiceCounterDataType_Encoding_DefaultBinary
    \value SubscriptionDiagnosticsDataType
    \value SubscriptionDiagnosticsDataType_Encoding_DefaultXml
    \value SubscriptionDiagnosticsDataType_Encoding_DefaultBinary
    \value ModelChangeStructureDataType
    \value ModelChangeStructureDataType_Encoding_DefaultXml
    \value ModelChangeStructureDataType_Encoding_DefaultBinary
    \value Range
    \value Range_Encoding_DefaultXml
    \value Range_Encoding_DefaultBinary
    \value EUInformation
    \value EUInformation_Encoding_DefaultXml
    \value EUInformation_Encoding_DefaultBinary
    \value ExceptionDeviationFormat
    \value Annotation
    \value Annotation_Encoding_DefaultXml
    \value Annotation_Encoding_DefaultBinary
    \value ProgramDiagnosticDataType
    \value ProgramDiagnosticDataType_Encoding_DefaultXml
    \value ProgramDiagnosticDataType_Encoding_DefaultBinary
    \value SemanticChangeStructureDataType
    \value SemanticChangeStructureDataType_Encoding_DefaultXml
    \value SemanticChangeStructureDataType_Encoding_DefaultBinary
    \value EventNotificationList
    \value EventNotificationList_Encoding_DefaultXml
    \value EventNotificationList_Encoding_DefaultBinary
    \value EventFieldList
    \value EventFieldList_Encoding_DefaultXml
    \value EventFieldList_Encoding_DefaultBinary
    \value HistoryEventFieldList
    \value HistoryEventFieldList_Encoding_DefaultXml
    \value HistoryEventFieldList_Encoding_DefaultBinary
    \value IssuedIdentityToken
    \value IssuedIdentityToken_Encoding_DefaultXml
    \value IssuedIdentityToken_Encoding_DefaultBinary
    \value NotificationData
    \value NotificationData_Encoding_DefaultXml
    \value NotificationData_Encoding_DefaultBinary
    \value AggregateConfiguration
    \value AggregateConfiguration_Encoding_DefaultXml
    \value AggregateConfiguration_Encoding_DefaultBinary
    \value ImageBMP
    \value ImageGIF
    \value ImageJPG
    \value ImagePNG
    \value ServerType
    \value ServerType_ServerArray
    \value ServerType_NamespaceArray
    \value ServerType_ServerStatus
    \value ServerType_ServiceLevel
    \value ServerType_ServerCapabilities
    \value ServerType_ServerDiagnostics
    \value ServerType_VendorServerInfo
    \value ServerType_ServerRedundancy
    \value ServerCapabilitiesType
    \value ServerCapabilitiesType_ServerProfileArray
    \value ServerCapabilitiesType_LocaleIdArray
    \value ServerCapabilitiesType_MinSupportedSampleRate
    \value ServerCapabilitiesType_ModellingRules
    \value ServerDiagnosticsType
    \value ServerDiagnosticsType_ServerDiagnosticsSummary
    \value ServerDiagnosticsType_SamplingIntervalDiagnosticsArray
    \value ServerDiagnosticsType_SubscriptionDiagnosticsArray
    \value ServerDiagnosticsType_EnabledFlag
    \value SessionsDiagnosticsSummaryType
    \value SessionsDiagnosticsSummaryType_SessionDiagnosticsArray
    \value SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray
    \value SessionDiagnosticsObjectType
    \value SessionDiagnosticsObjectType_SessionDiagnostics
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics
    \value SessionDiagnosticsObjectType_SubscriptionDiagnosticsArray
    \value VendorServerInfoType
    \value ServerRedundancyType
    \value ServerRedundancyType_RedundancySupport
    \value TransparentRedundancyType
    \value TransparentRedundancyType_CurrentServerId
    \value TransparentRedundancyType_RedundantServerArray
    \value NonTransparentRedundancyType
    \value NonTransparentRedundancyType_ServerUriArray
    \value BaseEventType
    \value BaseEventType_EventId
    \value BaseEventType_EventType
    \value BaseEventType_SourceNode
    \value BaseEventType_SourceName
    \value BaseEventType_Time
    \value BaseEventType_ReceiveTime
    \value BaseEventType_Message
    \value BaseEventType_Severity
    \value AuditEventType
    \value AuditEventType_ActionTimeStamp
    \value AuditEventType_Status
    \value AuditEventType_ServerId
    \value AuditEventType_ClientAuditEntryId
    \value AuditEventType_ClientUserId
    \value AuditSecurityEventType
    \value AuditChannelEventType
    \value AuditOpenSecureChannelEventType
    \value AuditOpenSecureChannelEventType_ClientCertificate
    \value AuditOpenSecureChannelEventType_RequestType
    \value AuditOpenSecureChannelEventType_SecurityPolicyUri
    \value AuditOpenSecureChannelEventType_SecurityMode
    \value AuditOpenSecureChannelEventType_RequestedLifetime
    \value AuditSessionEventType
    \value AuditSessionEventType_SessionId
    \value AuditCreateSessionEventType
    \value AuditCreateSessionEventType_SecureChannelId
    \value AuditCreateSessionEventType_ClientCertificate
    \value AuditCreateSessionEventType_RevisedSessionTimeout
    \value AuditActivateSessionEventType
    \value AuditActivateSessionEventType_ClientSoftwareCertificates
    \value AuditActivateSessionEventType_UserIdentityToken
    \value AuditCancelEventType
    \value AuditCancelEventType_RequestHandle
    \value AuditCertificateEventType
    \value AuditCertificateEventType_Certificate
    \value AuditCertificateDataMismatchEventType
    \value AuditCertificateDataMismatchEventType_InvalidHostname
    \value AuditCertificateDataMismatchEventType_InvalidUri
    \value AuditCertificateExpiredEventType
    \value AuditCertificateInvalidEventType
    \value AuditCertificateUntrustedEventType
    \value AuditCertificateRevokedEventType
    \value AuditCertificateMismatchEventType
    \value AuditNodeManagementEventType
    \value AuditAddNodesEventType
    \value AuditAddNodesEventType_NodesToAdd
    \value AuditDeleteNodesEventType
    \value AuditDeleteNodesEventType_NodesToDelete
    \value AuditAddReferencesEventType
    \value AuditAddReferencesEventType_ReferencesToAdd
    \value AuditDeleteReferencesEventType
    \value AuditDeleteReferencesEventType_ReferencesToDelete
    \value AuditUpdateEventType
    \value AuditWriteUpdateEventType
    \value AuditWriteUpdateEventType_IndexRange
    \value AuditWriteUpdateEventType_OldValue
    \value AuditWriteUpdateEventType_NewValue
    \value AuditHistoryUpdateEventType
    \value AuditUpdateMethodEventType
    \value AuditUpdateMethodEventType_MethodId
    \value AuditUpdateMethodEventType_InputArguments
    \value SystemEventType
    \value DeviceFailureEventType
    \value BaseModelChangeEventType
    \value GeneralModelChangeEventType
    \value GeneralModelChangeEventType_Changes
    \value ServerVendorCapabilityType
    \value ServerStatusType
    \value ServerStatusType_StartTime
    \value ServerStatusType_CurrentTime
    \value ServerStatusType_State
    \value ServerStatusType_BuildInfo
    \value ServerDiagnosticsSummaryType
    \value ServerDiagnosticsSummaryType_ServerViewCount
    \value ServerDiagnosticsSummaryType_CurrentSessionCount
    \value ServerDiagnosticsSummaryType_CumulatedSessionCount
    \value ServerDiagnosticsSummaryType_SecurityRejectedSessionCount
    \value ServerDiagnosticsSummaryType_RejectedSessionCount
    \value ServerDiagnosticsSummaryType_SessionTimeoutCount
    \value ServerDiagnosticsSummaryType_SessionAbortCount
    \value ServerDiagnosticsSummaryType_PublishingIntervalCount
    \value ServerDiagnosticsSummaryType_CurrentSubscriptionCount
    \value ServerDiagnosticsSummaryType_CumulatedSubscriptionCount
    \value ServerDiagnosticsSummaryType_SecurityRejectedRequestsCount
    \value ServerDiagnosticsSummaryType_RejectedRequestsCount
    \value SamplingIntervalDiagnosticsArrayType
    \value SamplingIntervalDiagnosticsType
    \value SamplingIntervalDiagnosticsType_SamplingInterval
    \value SubscriptionDiagnosticsArrayType
    \value SubscriptionDiagnosticsType
    \value SubscriptionDiagnosticsType_SessionId
    \value SubscriptionDiagnosticsType_SubscriptionId
    \value SubscriptionDiagnosticsType_Priority
    \value SubscriptionDiagnosticsType_PublishingInterval
    \value SubscriptionDiagnosticsType_MaxKeepAliveCount
    \value SubscriptionDiagnosticsType_MaxNotificationsPerPublish
    \value SubscriptionDiagnosticsType_PublishingEnabled
    \value SubscriptionDiagnosticsType_ModifyCount
    \value SubscriptionDiagnosticsType_EnableCount
    \value SubscriptionDiagnosticsType_DisableCount
    \value SubscriptionDiagnosticsType_RepublishRequestCount
    \value SubscriptionDiagnosticsType_RepublishMessageRequestCount
    \value SubscriptionDiagnosticsType_RepublishMessageCount
    \value SubscriptionDiagnosticsType_TransferRequestCount
    \value SubscriptionDiagnosticsType_TransferredToAltClientCount
    \value SubscriptionDiagnosticsType_TransferredToSameClientCount
    \value SubscriptionDiagnosticsType_PublishRequestCount
    \value SubscriptionDiagnosticsType_DataChangeNotificationsCount
    \value SubscriptionDiagnosticsType_NotificationsCount
    \value SessionDiagnosticsArrayType
    \value SessionDiagnosticsVariableType
    \value SessionDiagnosticsVariableType_SessionId
    \value SessionDiagnosticsVariableType_SessionName
    \value SessionDiagnosticsVariableType_ClientDescription
    \value SessionDiagnosticsVariableType_ServerUri
    \value SessionDiagnosticsVariableType_EndpointUrl
    \value SessionDiagnosticsVariableType_LocaleIds
    \value SessionDiagnosticsVariableType_ActualSessionTimeout
    \value SessionDiagnosticsVariableType_ClientConnectionTime
    \value SessionDiagnosticsVariableType_ClientLastContactTime
    \value SessionDiagnosticsVariableType_CurrentSubscriptionsCount
    \value SessionDiagnosticsVariableType_CurrentMonitoredItemsCount
    \value SessionDiagnosticsVariableType_CurrentPublishRequestsInQueue
    \value SessionDiagnosticsVariableType_ReadCount
    \value SessionDiagnosticsVariableType_HistoryReadCount
    \value SessionDiagnosticsVariableType_WriteCount
    \value SessionDiagnosticsVariableType_HistoryUpdateCount
    \value SessionDiagnosticsVariableType_CallCount
    \value SessionDiagnosticsVariableType_CreateMonitoredItemsCount
    \value SessionDiagnosticsVariableType_ModifyMonitoredItemsCount
    \value SessionDiagnosticsVariableType_SetMonitoringModeCount
    \value SessionDiagnosticsVariableType_SetTriggeringCount
    \value SessionDiagnosticsVariableType_DeleteMonitoredItemsCount
    \value SessionDiagnosticsVariableType_CreateSubscriptionCount
    \value SessionDiagnosticsVariableType_ModifySubscriptionCount
    \value SessionDiagnosticsVariableType_SetPublishingModeCount
    \value SessionDiagnosticsVariableType_PublishCount
    \value SessionDiagnosticsVariableType_RepublishCount
    \value SessionDiagnosticsVariableType_TransferSubscriptionsCount
    \value SessionDiagnosticsVariableType_DeleteSubscriptionsCount
    \value SessionDiagnosticsVariableType_AddNodesCount
    \value SessionDiagnosticsVariableType_AddReferencesCount
    \value SessionDiagnosticsVariableType_DeleteNodesCount
    \value SessionDiagnosticsVariableType_DeleteReferencesCount
    \value SessionDiagnosticsVariableType_BrowseCount
    \value SessionDiagnosticsVariableType_BrowseNextCount
    \value SessionDiagnosticsVariableType_TranslateBrowsePathsToNodeIdsCount
    \value SessionDiagnosticsVariableType_QueryFirstCount
    \value SessionDiagnosticsVariableType_QueryNextCount
    \value SessionSecurityDiagnosticsArrayType
    \value SessionSecurityDiagnosticsType
    \value SessionSecurityDiagnosticsType_SessionId
    \value SessionSecurityDiagnosticsType_ClientUserIdOfSession
    \value SessionSecurityDiagnosticsType_ClientUserIdHistory
    \value SessionSecurityDiagnosticsType_AuthenticationMechanism
    \value SessionSecurityDiagnosticsType_Encoding
    \value SessionSecurityDiagnosticsType_TransportProtocol
    \value SessionSecurityDiagnosticsType_SecurityMode
    \value SessionSecurityDiagnosticsType_SecurityPolicyUri
    \value Server
    \value Server_ServerArray
    \value Server_NamespaceArray
    \value Server_ServerStatus
    \value Server_ServerStatus_StartTime
    \value Server_ServerStatus_CurrentTime
    \value Server_ServerStatus_State
    \value Server_ServerStatus_BuildInfo
    \value Server_ServerStatus_BuildInfo_ProductName
    \value Server_ServerStatus_BuildInfo_ProductUri
    \value Server_ServerStatus_BuildInfo_ManufacturerName
    \value Server_ServerStatus_BuildInfo_SoftwareVersion
    \value Server_ServerStatus_BuildInfo_BuildNumber
    \value Server_ServerStatus_BuildInfo_BuildDate
    \value Server_ServiceLevel
    \value Server_ServerCapabilities
    \value Server_ServerCapabilities_ServerProfileArray
    \value Server_ServerCapabilities_LocaleIdArray
    \value Server_ServerCapabilities_MinSupportedSampleRate
    \value Server_ServerDiagnostics
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount
    \value Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray
    \value Server_ServerDiagnostics_SubscriptionDiagnosticsArray
    \value Server_ServerDiagnostics_EnabledFlag
    \value Server_VendorServerInfo
    \value Server_ServerRedundancy
    \value StateMachineType
    \value StateType
    \value StateType_StateNumber
    \value InitialStateType
    \value TransitionType
    \value TransitionEventType
    \value TransitionType_TransitionNumber
    \value AuditUpdateStateEventType
    \value HistoricalDataConfigurationType
    \value HistoricalDataConfigurationType_Stepped
    \value HistoricalDataConfigurationType_Definition
    \value HistoricalDataConfigurationType_MaxTimeInterval
    \value HistoricalDataConfigurationType_MinTimeInterval
    \value HistoricalDataConfigurationType_ExceptionDeviation
    \value HistoricalDataConfigurationType_ExceptionDeviationFormat
    \value HistoryServerCapabilitiesType
    \value HistoryServerCapabilitiesType_AccessHistoryDataCapability
    \value HistoryServerCapabilitiesType_AccessHistoryEventsCapability
    \value HistoryServerCapabilitiesType_InsertDataCapability
    \value HistoryServerCapabilitiesType_ReplaceDataCapability
    \value HistoryServerCapabilitiesType_UpdateDataCapability
    \value HistoryServerCapabilitiesType_DeleteRawCapability
    \value HistoryServerCapabilitiesType_DeleteAtTimeCapability
    \value AggregateFunctionType
    \value AggregateFunction_Interpolative
    \value AggregateFunction_Average
    \value AggregateFunction_TimeAverage
    \value AggregateFunction_Total
    \value AggregateFunction_Minimum
    \value AggregateFunction_Maximum
    \value AggregateFunction_MinimumActualTime
    \value AggregateFunction_MaximumActualTime
    \value AggregateFunction_Range
    \value AggregateFunction_AnnotationCount
    \value AggregateFunction_Count
    \value AggregateFunction_NumberOfTransitions
    \value AggregateFunction_Start
    \value AggregateFunction_End
    \value AggregateFunction_Delta
    \value AggregateFunction_DurationGood
    \value AggregateFunction_DurationBad
    \value AggregateFunction_PercentGood
    \value AggregateFunction_PercentBad
    \value AggregateFunction_WorstQuality
    \value DataItemType
    \value DataItemType_Definition
    \value DataItemType_ValuePrecision
    \value AnalogItemType
    \value AnalogItemType_EURange
    \value AnalogItemType_InstrumentRange
    \value AnalogItemType_EngineeringUnits
    \value DiscreteItemType
    \value TwoStateDiscreteType
    \value TwoStateDiscreteType_FalseState
    \value TwoStateDiscreteType_TrueState
    \value MultiStateDiscreteType
    \value MultiStateDiscreteType_EnumStrings
    \value ProgramTransitionEventType
    \value ProgramTransitionEventType_IntermediateResult
    \value ProgramDiagnosticType
    \value ProgramDiagnosticType_CreateSessionId
    \value ProgramDiagnosticType_CreateClientName
    \value ProgramDiagnosticType_InvocationCreationTime
    \value ProgramDiagnosticType_LastTransitionTime
    \value ProgramDiagnosticType_LastMethodCall
    \value ProgramDiagnosticType_LastMethodSessionId
    \value ProgramDiagnosticType_LastMethodInputArguments
    \value ProgramDiagnosticType_LastMethodOutputArguments
    \value ProgramDiagnosticType_LastMethodCallTime
    \value ProgramDiagnosticType_LastMethodReturnStatus
    \value ProgramStateMachineType
    \value ProgramStateMachineType_Creatable
    \value ProgramStateMachineType_Deletable
    \value ProgramStateMachineType_AutoDelete
    \value ProgramStateMachineType_RecycleCount
    \value ProgramStateMachineType_InstanceCount
    \value ProgramStateMachineType_MaxInstanceCount
    \value ProgramStateMachineType_MaxRecycleCount
    \value ProgramStateMachineType_ProgramDiagnostic
    \value ProgramStateMachineType_Ready
    \value ProgramStateMachineType_Ready_StateNumber
    \value ProgramStateMachineType_Running
    \value ProgramStateMachineType_Running_StateNumber
    \value ProgramStateMachineType_Suspended
    \value ProgramStateMachineType_Suspended_StateNumber
    \value ProgramStateMachineType_Halted
    \value ProgramStateMachineType_Halted_StateNumber
    \value ProgramStateMachineType_HaltedToReady
    \value ProgramStateMachineType_HaltedToReady_TransitionNumber
    \value ProgramStateMachineType_ReadyToRunning
    \value ProgramStateMachineType_ReadyToRunning_TransitionNumber
    \value ProgramStateMachineType_RunningToHalted
    \value ProgramStateMachineType_RunningToHalted_TransitionNumber
    \value ProgramStateMachineType_RunningToReady
    \value ProgramStateMachineType_RunningToReady_TransitionNumber
    \value ProgramStateMachineType_RunningToSuspended
    \value ProgramStateMachineType_RunningToSuspended_TransitionNumber
    \value ProgramStateMachineType_SuspendedToRunning
    \value ProgramStateMachineType_SuspendedToRunning_TransitionNumber
    \value ProgramStateMachineType_SuspendedToHalted
    \value ProgramStateMachineType_SuspendedToHalted_TransitionNumber
    \value ProgramStateMachineType_SuspendedToReady
    \value ProgramStateMachineType_SuspendedToReady_TransitionNumber
    \value ProgramStateMachineType_ReadyToHalted
    \value ProgramStateMachineType_ReadyToHalted_TransitionNumber
    \value ProgramStateMachineType_Start
    \value ProgramStateMachineType_Suspend
    \value ProgramStateMachineType_Resume
    \value ProgramStateMachineType_Halt
    \value ProgramStateMachineType_Reset
    \value SessionDiagnosticsVariableType_RegisterNodesCount
    \value SessionDiagnosticsVariableType_UnregisterNodesCount
    \value ServerCapabilitiesType_MaxBrowseContinuationPoints
    \value ServerCapabilitiesType_MaxQueryContinuationPoints
    \value ServerCapabilitiesType_MaxHistoryContinuationPoints
    \value Server_ServerCapabilities_MaxBrowseContinuationPoints
    \value Server_ServerCapabilities_MaxQueryContinuationPoints
    \value Server_ServerCapabilities_MaxHistoryContinuationPoints
    \value SemanticChangeEventType
    \value SemanticChangeEventType_Changes
    \value ServerType_Auditing
    \value ServerDiagnosticsType_SessionsDiagnosticsSummary
    \value AuditChannelEventType_SecureChannelId
    \value AuditOpenSecureChannelEventType_ClientCertificateThumbprint
    \value AuditCreateSessionEventType_ClientCertificateThumbprint
    \value AuditUrlMismatchEventType
    \value AuditUrlMismatchEventType_EndpointUrl
    \value AuditWriteUpdateEventType_AttributeId
    \value AuditHistoryUpdateEventType_ParameterDataTypeId
    \value ServerStatusType_SecondsTillShutdown
    \value ServerStatusType_ShutdownReason
    \value ServerCapabilitiesType_AggregateFunctions
    \value StateVariableType
    \value StateVariableType_Id
    \value StateVariableType_Name
    \value StateVariableType_Number
    \value StateVariableType_EffectiveDisplayName
    \value FiniteStateVariableType
    \value FiniteStateVariableType_Id
    \value TransitionVariableType
    \value TransitionVariableType_Id
    \value TransitionVariableType_Name
    \value TransitionVariableType_Number
    \value TransitionVariableType_TransitionTime
    \value FiniteTransitionVariableType
    \value FiniteTransitionVariableType_Id
    \value StateMachineType_CurrentState
    \value StateMachineType_LastTransition
    \value FiniteStateMachineType
    \value FiniteStateMachineType_CurrentState
    \value FiniteStateMachineType_LastTransition
    \value TransitionEventType_Transition
    \value TransitionEventType_FromState
    \value TransitionEventType_ToState
    \value AuditUpdateStateEventType_OldStateId
    \value AuditUpdateStateEventType_NewStateId
    \value ConditionType
    \value RefreshStartEventType
    \value RefreshEndEventType
    \value RefreshRequiredEventType
    \value AuditConditionEventType
    \value AuditConditionEnableEventType
    \value AuditConditionCommentEventType
    \value DialogConditionType
    \value DialogConditionType_Prompt
    \value AcknowledgeableConditionType
    \value AlarmConditionType
    \value ShelvedStateMachineType
    \value ShelvedStateMachineType_Unshelved
    \value ShelvedStateMachineType_TimedShelved
    \value ShelvedStateMachineType_OneShotShelved
    \value ShelvedStateMachineType_UnshelvedToTimedShelved
    \value ShelvedStateMachineType_UnshelvedToOneShotShelved
    \value ShelvedStateMachineType_TimedShelvedToUnshelved
    \value ShelvedStateMachineType_TimedShelvedToOneShotShelved
    \value ShelvedStateMachineType_OneShotShelvedToUnshelved
    \value ShelvedStateMachineType_OneShotShelvedToTimedShelved
    \value ShelvedStateMachineType_Unshelve
    \value ShelvedStateMachineType_OneShotShelve
    \value ShelvedStateMachineType_TimedShelve
    \value LimitAlarmType
    \value ShelvedStateMachineType_TimedShelve_InputArguments
    \value Server_ServerStatus_SecondsTillShutdown
    \value Server_ServerStatus_ShutdownReason
    \value Server_Auditing
    \value Server_ServerCapabilities_ModellingRules
    \value Server_ServerCapabilities_AggregateFunctions
    \value SubscriptionDiagnosticsType_EventNotificationsCount
    \value AuditHistoryEventUpdateEventType
    \value AuditHistoryEventUpdateEventType_Filter
    \value AuditHistoryValueUpdateEventType
    \value AuditHistoryDeleteEventType
    \value AuditHistoryRawModifyDeleteEventType
    \value AuditHistoryRawModifyDeleteEventType_IsDeleteModified
    \value AuditHistoryRawModifyDeleteEventType_StartTime
    \value AuditHistoryRawModifyDeleteEventType_EndTime
    \value AuditHistoryAtTimeDeleteEventType
    \value AuditHistoryAtTimeDeleteEventType_ReqTimes
    \value AuditHistoryAtTimeDeleteEventType_OldValues
    \value AuditHistoryEventDeleteEventType
    \value AuditHistoryEventDeleteEventType_EventIds
    \value AuditHistoryEventDeleteEventType_OldValues
    \value AuditHistoryEventUpdateEventType_UpdatedNode
    \value AuditHistoryValueUpdateEventType_UpdatedNode
    \value AuditHistoryDeleteEventType_UpdatedNode
    \value AuditHistoryEventUpdateEventType_PerformInsertReplace
    \value AuditHistoryEventUpdateEventType_NewValues
    \value AuditHistoryEventUpdateEventType_OldValues
    \value AuditHistoryValueUpdateEventType_PerformInsertReplace
    \value AuditHistoryValueUpdateEventType_NewValues
    \value AuditHistoryValueUpdateEventType_OldValues
    \value AuditHistoryRawModifyDeleteEventType_OldValues
    \value EventQueueOverflowEventType
    \value EventTypesFolder
    \value ServerCapabilitiesType_SoftwareCertificates
    \value SessionDiagnosticsVariableType_MaxResponseMessageSize
    \value BuildInfoType
    \value BuildInfoType_ProductUri
    \value BuildInfoType_ManufacturerName
    \value BuildInfoType_ProductName
    \value BuildInfoType_SoftwareVersion
    \value BuildInfoType_BuildNumber
    \value BuildInfoType_BuildDate
    \value SessionSecurityDiagnosticsType_ClientCertificate
    \value HistoricalDataConfigurationType_AggregateConfiguration
    \value DefaultBinary
    \value DefaultXml
    \value AlwaysGeneratesEvent
    \value Icon
    \value NodeVersion
    \value LocalTime
    \value AllowNulls
    \value EnumValues
    \value InputArguments
    \value OutputArguments
    \value ServerType_ServerStatus_StartTime
    \value ServerType_ServerStatus_CurrentTime
    \value ServerType_ServerStatus_State
    \value ServerType_ServerStatus_BuildInfo
    \value ServerType_ServerStatus_BuildInfo_ProductUri
    \value ServerType_ServerStatus_BuildInfo_ManufacturerName
    \value ServerType_ServerStatus_BuildInfo_ProductName
    \value ServerType_ServerStatus_BuildInfo_SoftwareVersion
    \value ServerType_ServerStatus_BuildInfo_BuildNumber
    \value ServerType_ServerStatus_BuildInfo_BuildDate
    \value ServerType_ServerStatus_SecondsTillShutdown
    \value ServerType_ServerStatus_ShutdownReason
    \value ServerType_ServerCapabilities_ServerProfileArray
    \value ServerType_ServerCapabilities_LocaleIdArray
    \value ServerType_ServerCapabilities_MinSupportedSampleRate
    \value ServerType_ServerCapabilities_MaxBrowseContinuationPoints
    \value ServerType_ServerCapabilities_MaxQueryContinuationPoints
    \value ServerType_ServerCapabilities_MaxHistoryContinuationPoints
    \value ServerType_ServerCapabilities_SoftwareCertificates
    \value ServerType_ServerCapabilities_ModellingRules
    \value ServerType_ServerCapabilities_AggregateFunctions
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_ServerViewCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSessionCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSessionCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedSessionCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionTimeoutCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SessionAbortCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_PublishingIntervalCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CurrentSubscriptionCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_CumulatedSubscriptionCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_SecurityRejectedRequestsCount
    \value ServerType_ServerDiagnostics_ServerDiagnosticsSummary_RejectedRequestsCount
    \value ServerType_ServerDiagnostics_SamplingIntervalDiagnosticsArray
    \value ServerType_ServerDiagnostics_SubscriptionDiagnosticsArray
    \value ServerType_ServerDiagnostics_SessionsDiagnosticsSummary
    \value ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray
    \value ServerType_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray
    \value ServerType_ServerDiagnostics_EnabledFlag
    \value ServerType_ServerRedundancy_RedundancySupport
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_ServerViewCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSessionCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSessionCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedSessionCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedSessionCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_SessionTimeoutCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_SessionAbortCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_PublishingIntervalCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_CurrentSubscriptionCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_CumulatedSubscriptionCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_SecurityRejectedRequestsCount
    \value ServerDiagnosticsType_ServerDiagnosticsSummary_RejectedRequestsCount
    \value ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionDiagnosticsArray
    \value ServerDiagnosticsType_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray
    \value SessionDiagnosticsObjectType_SessionDiagnostics_SessionId
    \value SessionDiagnosticsObjectType_SessionDiagnostics_SessionName
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ClientDescription
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ServerUri
    \value SessionDiagnosticsObjectType_SessionDiagnostics_EndpointUrl
    \value SessionDiagnosticsObjectType_SessionDiagnostics_LocaleIds
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ActualSessionTimeout
    \value SessionDiagnosticsObjectType_SessionDiagnostics_MaxResponseMessageSize
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ClientConnectionTime
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ClientLastContactTime
    \value SessionDiagnosticsObjectType_SessionDiagnostics_CurrentSubscriptionsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_CurrentMonitoredItemsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_CurrentPublishRequestsInQueue
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ReadCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_HistoryReadCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_WriteCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_HistoryUpdateCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_CallCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_CreateMonitoredItemsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ModifyMonitoredItemsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_SetMonitoringModeCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_SetTriggeringCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_DeleteMonitoredItemsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_CreateSubscriptionCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_ModifySubscriptionCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_SetPublishingModeCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_PublishCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_RepublishCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_TransferSubscriptionsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_DeleteSubscriptionsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_AddNodesCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_AddReferencesCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_DeleteNodesCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_DeleteReferencesCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_BrowseCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_BrowseNextCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_QueryFirstCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_QueryNextCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_RegisterNodesCount
    \value SessionDiagnosticsObjectType_SessionDiagnostics_UnregisterNodesCount
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SessionId
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdOfSession
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientUserIdHistory
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_AuthenticationMechanism
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_Encoding
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_TransportProtocol
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityMode
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_SecurityPolicyUri
    \value SessionDiagnosticsObjectType_SessionSecurityDiagnostics_ClientCertificate
    \value TransparentRedundancyType_RedundancySupport
    \value NonTransparentRedundancyType_RedundancySupport
    \value BaseEventType_LocalTime
    \value EventQueueOverflowEventType_EventId
    \value EventQueueOverflowEventType_EventType
    \value EventQueueOverflowEventType_SourceNode
    \value EventQueueOverflowEventType_SourceName
    \value EventQueueOverflowEventType_Time
    \value EventQueueOverflowEventType_ReceiveTime
    \value EventQueueOverflowEventType_LocalTime
    \value EventQueueOverflowEventType_Message
    \value EventQueueOverflowEventType_Severity
    \value AuditEventType_EventId
    \value AuditEventType_EventType
    \value AuditEventType_SourceNode
    \value AuditEventType_SourceName
    \value AuditEventType_Time
    \value AuditEventType_ReceiveTime
    \value AuditEventType_LocalTime
    \value AuditEventType_Message
    \value AuditEventType_Severity
    \value AuditSecurityEventType_EventId
    \value AuditSecurityEventType_EventType
    \value AuditSecurityEventType_SourceNode
    \value AuditSecurityEventType_SourceName
    \value AuditSecurityEventType_Time
    \value AuditSecurityEventType_ReceiveTime
    \value AuditSecurityEventType_LocalTime
    \value AuditSecurityEventType_Message
    \value AuditSecurityEventType_Severity
    \value AuditSecurityEventType_ActionTimeStamp
    \value AuditSecurityEventType_Status
    \value AuditSecurityEventType_ServerId
    \value AuditSecurityEventType_ClientAuditEntryId
    \value AuditSecurityEventType_ClientUserId
    \value AuditChannelEventType_EventId
    \value AuditChannelEventType_EventType
    \value AuditChannelEventType_SourceNode
    \value AuditChannelEventType_SourceName
    \value AuditChannelEventType_Time
    \value AuditChannelEventType_ReceiveTime
    \value AuditChannelEventType_LocalTime
    \value AuditChannelEventType_Message
    \value AuditChannelEventType_Severity
    \value AuditChannelEventType_ActionTimeStamp
    \value AuditChannelEventType_Status
    \value AuditChannelEventType_ServerId
    \value AuditChannelEventType_ClientAuditEntryId
    \value AuditChannelEventType_ClientUserId
    \value AuditOpenSecureChannelEventType_EventId
    \value AuditOpenSecureChannelEventType_EventType
    \value AuditOpenSecureChannelEventType_SourceNode
    \value AuditOpenSecureChannelEventType_SourceName
    \value AuditOpenSecureChannelEventType_Time
    \value AuditOpenSecureChannelEventType_ReceiveTime
    \value AuditOpenSecureChannelEventType_LocalTime
    \value AuditOpenSecureChannelEventType_Message
    \value AuditOpenSecureChannelEventType_Severity
    \value AuditOpenSecureChannelEventType_ActionTimeStamp
    \value AuditOpenSecureChannelEventType_Status
    \value AuditOpenSecureChannelEventType_ServerId
    \value AuditOpenSecureChannelEventType_ClientAuditEntryId
    \value AuditOpenSecureChannelEventType_ClientUserId
    \value AuditOpenSecureChannelEventType_SecureChannelId
    \value AuditSessionEventType_EventId
    \value AuditSessionEventType_EventType
    \value AuditSessionEventType_SourceNode
    \value AuditSessionEventType_SourceName
    \value AuditSessionEventType_Time
    \value AuditSessionEventType_ReceiveTime
    \value AuditSessionEventType_LocalTime
    \value AuditSessionEventType_Message
    \value AuditSessionEventType_Severity
    \value AuditSessionEventType_ActionTimeStamp
    \value AuditSessionEventType_Status
    \value AuditSessionEventType_ServerId
    \value AuditSessionEventType_ClientAuditEntryId
    \value AuditSessionEventType_ClientUserId
    \value AuditCreateSessionEventType_EventId
    \value AuditCreateSessionEventType_EventType
    \value AuditCreateSessionEventType_SourceNode
    \value AuditCreateSessionEventType_SourceName
    \value AuditCreateSessionEventType_Time
    \value AuditCreateSessionEventType_ReceiveTime
    \value AuditCreateSessionEventType_LocalTime
    \value AuditCreateSessionEventType_Message
    \value AuditCreateSessionEventType_Severity
    \value AuditCreateSessionEventType_ActionTimeStamp
    \value AuditCreateSessionEventType_Status
    \value AuditCreateSessionEventType_ServerId
    \value AuditCreateSessionEventType_ClientAuditEntryId
    \value AuditCreateSessionEventType_ClientUserId
    \value AuditUrlMismatchEventType_EventId
    \value AuditUrlMismatchEventType_EventType
    \value AuditUrlMismatchEventType_SourceNode
    \value AuditUrlMismatchEventType_SourceName
    \value AuditUrlMismatchEventType_Time
    \value AuditUrlMismatchEventType_ReceiveTime
    \value AuditUrlMismatchEventType_LocalTime
    \value AuditUrlMismatchEventType_Message
    \value AuditUrlMismatchEventType_Severity
    \value AuditUrlMismatchEventType_ActionTimeStamp
    \value AuditUrlMismatchEventType_Status
    \value AuditUrlMismatchEventType_ServerId
    \value AuditUrlMismatchEventType_ClientAuditEntryId
    \value AuditUrlMismatchEventType_ClientUserId
    \value AuditUrlMismatchEventType_SecureChannelId
    \value AuditUrlMismatchEventType_ClientCertificate
    \value AuditUrlMismatchEventType_ClientCertificateThumbprint
    \value AuditUrlMismatchEventType_RevisedSessionTimeout
    \value AuditActivateSessionEventType_EventId
    \value AuditActivateSessionEventType_EventType
    \value AuditActivateSessionEventType_SourceNode
    \value AuditActivateSessionEventType_SourceName
    \value AuditActivateSessionEventType_Time
    \value AuditActivateSessionEventType_ReceiveTime
    \value AuditActivateSessionEventType_LocalTime
    \value AuditActivateSessionEventType_Message
    \value AuditActivateSessionEventType_Severity
    \value AuditActivateSessionEventType_ActionTimeStamp
    \value AuditActivateSessionEventType_Status
    \value AuditActivateSessionEventType_ServerId
    \value AuditActivateSessionEventType_ClientAuditEntryId
    \value AuditActivateSessionEventType_ClientUserId
    \value AuditActivateSessionEventType_SessionId
    \value AuditCancelEventType_EventId
    \value AuditCancelEventType_EventType
    \value AuditCancelEventType_SourceNode
    \value AuditCancelEventType_SourceName
    \value AuditCancelEventType_Time
    \value AuditCancelEventType_ReceiveTime
    \value AuditCancelEventType_LocalTime
    \value AuditCancelEventType_Message
    \value AuditCancelEventType_Severity
    \value AuditCancelEventType_ActionTimeStamp
    \value AuditCancelEventType_Status
    \value AuditCancelEventType_ServerId
    \value AuditCancelEventType_ClientAuditEntryId
    \value AuditCancelEventType_ClientUserId
    \value AuditCancelEventType_SessionId
    \value AuditCertificateEventType_EventId
    \value AuditCertificateEventType_EventType
    \value AuditCertificateEventType_SourceNode
    \value AuditCertificateEventType_SourceName
    \value AuditCertificateEventType_Time
    \value AuditCertificateEventType_ReceiveTime
    \value AuditCertificateEventType_LocalTime
    \value AuditCertificateEventType_Message
    \value AuditCertificateEventType_Severity
    \value AuditCertificateEventType_ActionTimeStamp
    \value AuditCertificateEventType_Status
    \value AuditCertificateEventType_ServerId
    \value AuditCertificateEventType_ClientAuditEntryId
    \value AuditCertificateEventType_ClientUserId
    \value AuditCertificateDataMismatchEventType_EventId
    \value AuditCertificateDataMismatchEventType_EventType
    \value AuditCertificateDataMismatchEventType_SourceNode
    \value AuditCertificateDataMismatchEventType_SourceName
    \value AuditCertificateDataMismatchEventType_Time
    \value AuditCertificateDataMismatchEventType_ReceiveTime
    \value AuditCertificateDataMismatchEventType_LocalTime
    \value AuditCertificateDataMismatchEventType_Message
    \value AuditCertificateDataMismatchEventType_Severity
    \value AuditCertificateDataMismatchEventType_ActionTimeStamp
    \value AuditCertificateDataMismatchEventType_Status
    \value AuditCertificateDataMismatchEventType_ServerId
    \value AuditCertificateDataMismatchEventType_ClientAuditEntryId
    \value AuditCertificateDataMismatchEventType_ClientUserId
    \value AuditCertificateDataMismatchEventType_Certificate
    \value AuditCertificateExpiredEventType_EventId
    \value AuditCertificateExpiredEventType_EventType
    \value AuditCertificateExpiredEventType_SourceNode
    \value AuditCertificateExpiredEventType_SourceName
    \value AuditCertificateExpiredEventType_Time
    \value AuditCertificateExpiredEventType_ReceiveTime
    \value AuditCertificateExpiredEventType_LocalTime
    \value AuditCertificateExpiredEventType_Message
    \value AuditCertificateExpiredEventType_Severity
    \value AuditCertificateExpiredEventType_ActionTimeStamp
    \value AuditCertificateExpiredEventType_Status
    \value AuditCertificateExpiredEventType_ServerId
    \value AuditCertificateExpiredEventType_ClientAuditEntryId
    \value AuditCertificateExpiredEventType_ClientUserId
    \value AuditCertificateExpiredEventType_Certificate
    \value AuditCertificateInvalidEventType_EventId
    \value AuditCertificateInvalidEventType_EventType
    \value AuditCertificateInvalidEventType_SourceNode
    \value AuditCertificateInvalidEventType_SourceName
    \value AuditCertificateInvalidEventType_Time
    \value AuditCertificateInvalidEventType_ReceiveTime
    \value AuditCertificateInvalidEventType_LocalTime
    \value AuditCertificateInvalidEventType_Message
    \value AuditCertificateInvalidEventType_Severity
    \value AuditCertificateInvalidEventType_ActionTimeStamp
    \value AuditCertificateInvalidEventType_Status
    \value AuditCertificateInvalidEventType_ServerId
    \value AuditCertificateInvalidEventType_ClientAuditEntryId
    \value AuditCertificateInvalidEventType_ClientUserId
    \value AuditCertificateInvalidEventType_Certificate
    \value AuditCertificateUntrustedEventType_EventId
    \value AuditCertificateUntrustedEventType_EventType
    \value AuditCertificateUntrustedEventType_SourceNode
    \value AuditCertificateUntrustedEventType_SourceName
    \value AuditCertificateUntrustedEventType_Time
    \value AuditCertificateUntrustedEventType_ReceiveTime
    \value AuditCertificateUntrustedEventType_LocalTime
    \value AuditCertificateUntrustedEventType_Message
    \value AuditCertificateUntrustedEventType_Severity
    \value AuditCertificateUntrustedEventType_ActionTimeStamp
    \value AuditCertificateUntrustedEventType_Status
    \value AuditCertificateUntrustedEventType_ServerId
    \value AuditCertificateUntrustedEventType_ClientAuditEntryId
    \value AuditCertificateUntrustedEventType_ClientUserId
    \value AuditCertificateUntrustedEventType_Certificate
    \value AuditCertificateRevokedEventType_EventId
    \value AuditCertificateRevokedEventType_EventType
    \value AuditCertificateRevokedEventType_SourceNode
    \value AuditCertificateRevokedEventType_SourceName
    \value AuditCertificateRevokedEventType_Time
    \value AuditCertificateRevokedEventType_ReceiveTime
    \value AuditCertificateRevokedEventType_LocalTime
    \value AuditCertificateRevokedEventType_Message
    \value AuditCertificateRevokedEventType_Severity
    \value AuditCertificateRevokedEventType_ActionTimeStamp
    \value AuditCertificateRevokedEventType_Status
    \value AuditCertificateRevokedEventType_ServerId
    \value AuditCertificateRevokedEventType_ClientAuditEntryId
    \value AuditCertificateRevokedEventType_ClientUserId
    \value AuditCertificateRevokedEventType_Certificate
    \value AuditCertificateMismatchEventType_EventId
    \value AuditCertificateMismatchEventType_EventType
    \value AuditCertificateMismatchEventType_SourceNode
    \value AuditCertificateMismatchEventType_SourceName
    \value AuditCertificateMismatchEventType_Time
    \value AuditCertificateMismatchEventType_ReceiveTime
    \value AuditCertificateMismatchEventType_LocalTime
    \value AuditCertificateMismatchEventType_Message
    \value AuditCertificateMismatchEventType_Severity
    \value AuditCertificateMismatchEventType_ActionTimeStamp
    \value AuditCertificateMismatchEventType_Status
    \value AuditCertificateMismatchEventType_ServerId
    \value AuditCertificateMismatchEventType_ClientAuditEntryId
    \value AuditCertificateMismatchEventType_ClientUserId
    \value AuditCertificateMismatchEventType_Certificate
    \value AuditNodeManagementEventType_EventId
    \value AuditNodeManagementEventType_EventType
    \value AuditNodeManagementEventType_SourceNode
    \value AuditNodeManagementEventType_SourceName
    \value AuditNodeManagementEventType_Time
    \value AuditNodeManagementEventType_ReceiveTime
    \value AuditNodeManagementEventType_LocalTime
    \value AuditNodeManagementEventType_Message
    \value AuditNodeManagementEventType_Severity
    \value AuditNodeManagementEventType_ActionTimeStamp
    \value AuditNodeManagementEventType_Status
    \value AuditNodeManagementEventType_ServerId
    \value AuditNodeManagementEventType_ClientAuditEntryId
    \value AuditNodeManagementEventType_ClientUserId
    \value AuditAddNodesEventType_EventId
    \value AuditAddNodesEventType_EventType
    \value AuditAddNodesEventType_SourceNode
    \value AuditAddNodesEventType_SourceName
    \value AuditAddNodesEventType_Time
    \value AuditAddNodesEventType_ReceiveTime
    \value AuditAddNodesEventType_LocalTime
    \value AuditAddNodesEventType_Message
    \value AuditAddNodesEventType_Severity
    \value AuditAddNodesEventType_ActionTimeStamp
    \value AuditAddNodesEventType_Status
    \value AuditAddNodesEventType_ServerId
    \value AuditAddNodesEventType_ClientAuditEntryId
    \value AuditAddNodesEventType_ClientUserId
    \value AuditDeleteNodesEventType_EventId
    \value AuditDeleteNodesEventType_EventType
    \value AuditDeleteNodesEventType_SourceNode
    \value AuditDeleteNodesEventType_SourceName
    \value AuditDeleteNodesEventType_Time
    \value AuditDeleteNodesEventType_ReceiveTime
    \value AuditDeleteNodesEventType_LocalTime
    \value AuditDeleteNodesEventType_Message
    \value AuditDeleteNodesEventType_Severity
    \value AuditDeleteNodesEventType_ActionTimeStamp
    \value AuditDeleteNodesEventType_Status
    \value AuditDeleteNodesEventType_ServerId
    \value AuditDeleteNodesEventType_ClientAuditEntryId
    \value AuditDeleteNodesEventType_ClientUserId
    \value AuditAddReferencesEventType_EventId
    \value AuditAddReferencesEventType_EventType
    \value AuditAddReferencesEventType_SourceNode
    \value AuditAddReferencesEventType_SourceName
    \value AuditAddReferencesEventType_Time
    \value AuditAddReferencesEventType_ReceiveTime
    \value AuditAddReferencesEventType_LocalTime
    \value AuditAddReferencesEventType_Message
    \value AuditAddReferencesEventType_Severity
    \value AuditAddReferencesEventType_ActionTimeStamp
    \value AuditAddReferencesEventType_Status
    \value AuditAddReferencesEventType_ServerId
    \value AuditAddReferencesEventType_ClientAuditEntryId
    \value AuditAddReferencesEventType_ClientUserId
    \value AuditDeleteReferencesEventType_EventId
    \value AuditDeleteReferencesEventType_EventType
    \value AuditDeleteReferencesEventType_SourceNode
    \value AuditDeleteReferencesEventType_SourceName
    \value AuditDeleteReferencesEventType_Time
    \value AuditDeleteReferencesEventType_ReceiveTime
    \value AuditDeleteReferencesEventType_LocalTime
    \value AuditDeleteReferencesEventType_Message
    \value AuditDeleteReferencesEventType_Severity
    \value AuditDeleteReferencesEventType_ActionTimeStamp
    \value AuditDeleteReferencesEventType_Status
    \value AuditDeleteReferencesEventType_ServerId
    \value AuditDeleteReferencesEventType_ClientAuditEntryId
    \value AuditDeleteReferencesEventType_ClientUserId
    \value AuditUpdateEventType_EventId
    \value AuditUpdateEventType_EventType
    \value AuditUpdateEventType_SourceNode
    \value AuditUpdateEventType_SourceName
    \value AuditUpdateEventType_Time
    \value AuditUpdateEventType_ReceiveTime
    \value AuditUpdateEventType_LocalTime
    \value AuditUpdateEventType_Message
    \value AuditUpdateEventType_Severity
    \value AuditUpdateEventType_ActionTimeStamp
    \value AuditUpdateEventType_Status
    \value AuditUpdateEventType_ServerId
    \value AuditUpdateEventType_ClientAuditEntryId
    \value AuditUpdateEventType_ClientUserId
    \value AuditWriteUpdateEventType_EventId
    \value AuditWriteUpdateEventType_EventType
    \value AuditWriteUpdateEventType_SourceNode
    \value AuditWriteUpdateEventType_SourceName
    \value AuditWriteUpdateEventType_Time
    \value AuditWriteUpdateEventType_ReceiveTime
    \value AuditWriteUpdateEventType_LocalTime
    \value AuditWriteUpdateEventType_Message
    \value AuditWriteUpdateEventType_Severity
    \value AuditWriteUpdateEventType_ActionTimeStamp
    \value AuditWriteUpdateEventType_Status
    \value AuditWriteUpdateEventType_ServerId
    \value AuditWriteUpdateEventType_ClientAuditEntryId
    \value AuditWriteUpdateEventType_ClientUserId
    \value AuditHistoryUpdateEventType_EventId
    \value AuditHistoryUpdateEventType_EventType
    \value AuditHistoryUpdateEventType_SourceNode
    \value AuditHistoryUpdateEventType_SourceName
    \value AuditHistoryUpdateEventType_Time
    \value AuditHistoryUpdateEventType_ReceiveTime
    \value AuditHistoryUpdateEventType_LocalTime
    \value AuditHistoryUpdateEventType_Message
    \value AuditHistoryUpdateEventType_Severity
    \value AuditHistoryUpdateEventType_ActionTimeStamp
    \value AuditHistoryUpdateEventType_Status
    \value AuditHistoryUpdateEventType_ServerId
    \value AuditHistoryUpdateEventType_ClientAuditEntryId
    \value AuditHistoryUpdateEventType_ClientUserId
    \value AuditHistoryEventUpdateEventType_EventId
    \value AuditHistoryEventUpdateEventType_EventType
    \value AuditHistoryEventUpdateEventType_SourceNode
    \value AuditHistoryEventUpdateEventType_SourceName
    \value AuditHistoryEventUpdateEventType_Time
    \value AuditHistoryEventUpdateEventType_ReceiveTime
    \value AuditHistoryEventUpdateEventType_LocalTime
    \value AuditHistoryEventUpdateEventType_Message
    \value AuditHistoryEventUpdateEventType_Severity
    \value AuditHistoryEventUpdateEventType_ActionTimeStamp
    \value AuditHistoryEventUpdateEventType_Status
    \value AuditHistoryEventUpdateEventType_ServerId
    \value AuditHistoryEventUpdateEventType_ClientAuditEntryId
    \value AuditHistoryEventUpdateEventType_ClientUserId
    \value AuditHistoryEventUpdateEventType_ParameterDataTypeId
    \value AuditHistoryValueUpdateEventType_EventId
    \value AuditHistoryValueUpdateEventType_EventType
    \value AuditHistoryValueUpdateEventType_SourceNode
    \value AuditHistoryValueUpdateEventType_SourceName
    \value AuditHistoryValueUpdateEventType_Time
    \value AuditHistoryValueUpdateEventType_ReceiveTime
    \value AuditHistoryValueUpdateEventType_LocalTime
    \value AuditHistoryValueUpdateEventType_Message
    \value AuditHistoryValueUpdateEventType_Severity
    \value AuditHistoryValueUpdateEventType_ActionTimeStamp
    \value AuditHistoryValueUpdateEventType_Status
    \value AuditHistoryValueUpdateEventType_ServerId
    \value AuditHistoryValueUpdateEventType_ClientAuditEntryId
    \value AuditHistoryValueUpdateEventType_ClientUserId
    \value AuditHistoryValueUpdateEventType_ParameterDataTypeId
    \value AuditHistoryDeleteEventType_EventId
    \value AuditHistoryDeleteEventType_EventType
    \value AuditHistoryDeleteEventType_SourceNode
    \value AuditHistoryDeleteEventType_SourceName
    \value AuditHistoryDeleteEventType_Time
    \value AuditHistoryDeleteEventType_ReceiveTime
    \value AuditHistoryDeleteEventType_LocalTime
    \value AuditHistoryDeleteEventType_Message
    \value AuditHistoryDeleteEventType_Severity
    \value AuditHistoryDeleteEventType_ActionTimeStamp
    \value AuditHistoryDeleteEventType_Status
    \value AuditHistoryDeleteEventType_ServerId
    \value AuditHistoryDeleteEventType_ClientAuditEntryId
    \value AuditHistoryDeleteEventType_ClientUserId
    \value AuditHistoryDeleteEventType_ParameterDataTypeId
    \value AuditHistoryRawModifyDeleteEventType_EventId
    \value AuditHistoryRawModifyDeleteEventType_EventType
    \value AuditHistoryRawModifyDeleteEventType_SourceNode
    \value AuditHistoryRawModifyDeleteEventType_SourceName
    \value AuditHistoryRawModifyDeleteEventType_Time
    \value AuditHistoryRawModifyDeleteEventType_ReceiveTime
    \value AuditHistoryRawModifyDeleteEventType_LocalTime
    \value AuditHistoryRawModifyDeleteEventType_Message
    \value AuditHistoryRawModifyDeleteEventType_Severity
    \value AuditHistoryRawModifyDeleteEventType_ActionTimeStamp
    \value AuditHistoryRawModifyDeleteEventType_Status
    \value AuditHistoryRawModifyDeleteEventType_ServerId
    \value AuditHistoryRawModifyDeleteEventType_ClientAuditEntryId
    \value AuditHistoryRawModifyDeleteEventType_ClientUserId
    \value AuditHistoryRawModifyDeleteEventType_ParameterDataTypeId
    \value AuditHistoryRawModifyDeleteEventType_UpdatedNode
    \value AuditHistoryAtTimeDeleteEventType_EventId
    \value AuditHistoryAtTimeDeleteEventType_EventType
    \value AuditHistoryAtTimeDeleteEventType_SourceNode
    \value AuditHistoryAtTimeDeleteEventType_SourceName
    \value AuditHistoryAtTimeDeleteEventType_Time
    \value AuditHistoryAtTimeDeleteEventType_ReceiveTime
    \value AuditHistoryAtTimeDeleteEventType_LocalTime
    \value AuditHistoryAtTimeDeleteEventType_Message
    \value AuditHistoryAtTimeDeleteEventType_Severity
    \value AuditHistoryAtTimeDeleteEventType_ActionTimeStamp
    \value AuditHistoryAtTimeDeleteEventType_Status
    \value AuditHistoryAtTimeDeleteEventType_ServerId
    \value AuditHistoryAtTimeDeleteEventType_ClientAuditEntryId
    \value AuditHistoryAtTimeDeleteEventType_ClientUserId
    \value AuditHistoryAtTimeDeleteEventType_ParameterDataTypeId
    \value AuditHistoryAtTimeDeleteEventType_UpdatedNode
    \value AuditHistoryEventDeleteEventType_EventId
    \value AuditHistoryEventDeleteEventType_EventType
    \value AuditHistoryEventDeleteEventType_SourceNode
    \value AuditHistoryEventDeleteEventType_SourceName
    \value AuditHistoryEventDeleteEventType_Time
    \value AuditHistoryEventDeleteEventType_ReceiveTime
    \value AuditHistoryEventDeleteEventType_LocalTime
    \value AuditHistoryEventDeleteEventType_Message
    \value AuditHistoryEventDeleteEventType_Severity
    \value AuditHistoryEventDeleteEventType_ActionTimeStamp
    \value AuditHistoryEventDeleteEventType_Status
    \value AuditHistoryEventDeleteEventType_ServerId
    \value AuditHistoryEventDeleteEventType_ClientAuditEntryId
    \value AuditHistoryEventDeleteEventType_ClientUserId
    \value AuditHistoryEventDeleteEventType_ParameterDataTypeId
    \value AuditHistoryEventDeleteEventType_UpdatedNode
    \value AuditUpdateMethodEventType_EventId
    \value AuditUpdateMethodEventType_EventType
    \value AuditUpdateMethodEventType_SourceNode
    \value AuditUpdateMethodEventType_SourceName
    \value AuditUpdateMethodEventType_Time
    \value AuditUpdateMethodEventType_ReceiveTime
    \value AuditUpdateMethodEventType_LocalTime
    \value AuditUpdateMethodEventType_Message
    \value AuditUpdateMethodEventType_Severity
    \value AuditUpdateMethodEventType_ActionTimeStamp
    \value AuditUpdateMethodEventType_Status
    \value AuditUpdateMethodEventType_ServerId
    \value AuditUpdateMethodEventType_ClientAuditEntryId
    \value AuditUpdateMethodEventType_ClientUserId
    \value SystemEventType_EventId
    \value SystemEventType_EventType
    \value SystemEventType_SourceNode
    \value SystemEventType_SourceName
    \value SystemEventType_Time
    \value SystemEventType_ReceiveTime
    \value SystemEventType_LocalTime
    \value SystemEventType_Message
    \value SystemEventType_Severity
    \value DeviceFailureEventType_EventId
    \value DeviceFailureEventType_EventType
    \value DeviceFailureEventType_SourceNode
    \value DeviceFailureEventType_SourceName
    \value DeviceFailureEventType_Time
    \value DeviceFailureEventType_ReceiveTime
    \value DeviceFailureEventType_LocalTime
    \value DeviceFailureEventType_Message
    \value DeviceFailureEventType_Severity
    \value BaseModelChangeEventType_EventId
    \value BaseModelChangeEventType_EventType
    \value BaseModelChangeEventType_SourceNode
    \value BaseModelChangeEventType_SourceName
    \value BaseModelChangeEventType_Time
    \value BaseModelChangeEventType_ReceiveTime
    \value BaseModelChangeEventType_LocalTime
    \value BaseModelChangeEventType_Message
    \value BaseModelChangeEventType_Severity
    \value GeneralModelChangeEventType_EventId
    \value GeneralModelChangeEventType_EventType
    \value GeneralModelChangeEventType_SourceNode
    \value GeneralModelChangeEventType_SourceName
    \value GeneralModelChangeEventType_Time
    \value GeneralModelChangeEventType_ReceiveTime
    \value GeneralModelChangeEventType_LocalTime
    \value GeneralModelChangeEventType_Message
    \value GeneralModelChangeEventType_Severity
    \value SemanticChangeEventType_EventId
    \value SemanticChangeEventType_EventType
    \value SemanticChangeEventType_SourceNode
    \value SemanticChangeEventType_SourceName
    \value SemanticChangeEventType_Time
    \value SemanticChangeEventType_ReceiveTime
    \value SemanticChangeEventType_LocalTime
    \value SemanticChangeEventType_Message
    \value SemanticChangeEventType_Severity
    \value ServerStatusType_BuildInfo_ProductUri
    \value ServerStatusType_BuildInfo_ManufacturerName
    \value ServerStatusType_BuildInfo_ProductName
    \value ServerStatusType_BuildInfo_SoftwareVersion
    \value ServerStatusType_BuildInfo_BuildNumber
    \value ServerStatusType_BuildInfo_BuildDate
    \value Server_ServerCapabilities_SoftwareCertificates
    \value Server_ServerDiagnostics_ServerDiagnosticsSummary_RejectedSessionCount
    \value Server_ServerDiagnostics_SessionsDiagnosticsSummary
    \value Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionDiagnosticsArray
    \value Server_ServerDiagnostics_SessionsDiagnosticsSummary_SessionSecurityDiagnosticsArray
    \value Server_ServerRedundancy_RedundancySupport
    \value FiniteStateVariableType_Name
    \value FiniteStateVariableType_Number
    \value FiniteStateVariableType_EffectiveDisplayName
    \value FiniteTransitionVariableType_Name
    \value FiniteTransitionVariableType_Number
    \value FiniteTransitionVariableType_TransitionTime
    \value StateMachineType_CurrentState_Id
    \value StateMachineType_CurrentState_Name
    \value StateMachineType_CurrentState_Number
    \value StateMachineType_CurrentState_EffectiveDisplayName
    \value StateMachineType_LastTransition_Id
    \value StateMachineType_LastTransition_Name
    \value StateMachineType_LastTransition_Number
    \value StateMachineType_LastTransition_TransitionTime
    \value FiniteStateMachineType_CurrentState_Id
    \value FiniteStateMachineType_CurrentState_Name
    \value FiniteStateMachineType_CurrentState_Number
    \value FiniteStateMachineType_CurrentState_EffectiveDisplayName
    \value FiniteStateMachineType_LastTransition_Id
    \value FiniteStateMachineType_LastTransition_Name
    \value FiniteStateMachineType_LastTransition_Number
    \value FiniteStateMachineType_LastTransition_TransitionTime
    \value InitialStateType_StateNumber
    \value TransitionEventType_EventId
    \value TransitionEventType_EventType
    \value TransitionEventType_SourceNode
    \value TransitionEventType_SourceName
    \value TransitionEventType_Time
    \value TransitionEventType_ReceiveTime
    \value TransitionEventType_LocalTime
    \value TransitionEventType_Message
    \value TransitionEventType_Severity
    \value TransitionEventType_FromState_Id
    \value TransitionEventType_FromState_Name
    \value TransitionEventType_FromState_Number
    \value TransitionEventType_FromState_EffectiveDisplayName
    \value TransitionEventType_ToState_Id
    \value TransitionEventType_ToState_Name
    \value TransitionEventType_ToState_Number
    \value TransitionEventType_ToState_EffectiveDisplayName
    \value TransitionEventType_Transition_Id
    \value TransitionEventType_Transition_Name
    \value TransitionEventType_Transition_Number
    \value TransitionEventType_Transition_TransitionTime
    \value AuditUpdateStateEventType_EventId
    \value AuditUpdateStateEventType_EventType
    \value AuditUpdateStateEventType_SourceNode
    \value AuditUpdateStateEventType_SourceName
    \value AuditUpdateStateEventType_Time
    \value AuditUpdateStateEventType_ReceiveTime
    \value AuditUpdateStateEventType_LocalTime
    \value AuditUpdateStateEventType_Message
    \value AuditUpdateStateEventType_Severity
    \value AuditUpdateStateEventType_ActionTimeStamp
    \value AuditUpdateStateEventType_Status
    \value AuditUpdateStateEventType_ServerId
    \value AuditUpdateStateEventType_ClientAuditEntryId
    \value AuditUpdateStateEventType_ClientUserId
    \value AuditUpdateStateEventType_MethodId
    \value AuditUpdateStateEventType_InputArguments
    \value AnalogItemType_Definition
    \value AnalogItemType_ValuePrecision
    \value DiscreteItemType_Definition
    \value DiscreteItemType_ValuePrecision
    \value TwoStateDiscreteType_Definition
    \value TwoStateDiscreteType_ValuePrecision
    \value MultiStateDiscreteType_Definition
    \value MultiStateDiscreteType_ValuePrecision
    \value ProgramTransitionEventType_EventId
    \value ProgramTransitionEventType_EventType
    \value ProgramTransitionEventType_SourceNode
    \value ProgramTransitionEventType_SourceName
    \value ProgramTransitionEventType_Time
    \value ProgramTransitionEventType_ReceiveTime
    \value ProgramTransitionEventType_LocalTime
    \value ProgramTransitionEventType_Message
    \value ProgramTransitionEventType_Severity
    \value ProgramTransitionEventType_FromState
    \value ProgramTransitionEventType_FromState_Id
    \value ProgramTransitionEventType_FromState_Name
    \value ProgramTransitionEventType_FromState_Number
    \value ProgramTransitionEventType_FromState_EffectiveDisplayName
    \value ProgramTransitionEventType_ToState
    \value ProgramTransitionEventType_ToState_Id
    \value ProgramTransitionEventType_ToState_Name
    \value ProgramTransitionEventType_ToState_Number
    \value ProgramTransitionEventType_ToState_EffectiveDisplayName
    \value ProgramTransitionEventType_Transition
    \value ProgramTransitionEventType_Transition_Id
    \value ProgramTransitionEventType_Transition_Name
    \value ProgramTransitionEventType_Transition_Number
    \value ProgramTransitionEventType_Transition_TransitionTime
    \value ProgramTransitionAuditEventType
    \value ProgramTransitionAuditEventType_EventId
    \value ProgramTransitionAuditEventType_EventType
    \value ProgramTransitionAuditEventType_SourceNode
    \value ProgramTransitionAuditEventType_SourceName
    \value ProgramTransitionAuditEventType_Time
    \value ProgramTransitionAuditEventType_ReceiveTime
    \value ProgramTransitionAuditEventType_LocalTime
    \value ProgramTransitionAuditEventType_Message
    \value ProgramTransitionAuditEventType_Severity
    \value ProgramTransitionAuditEventType_ActionTimeStamp
    \value ProgramTransitionAuditEventType_Status
    \value ProgramTransitionAuditEventType_ServerId
    \value ProgramTransitionAuditEventType_ClientAuditEntryId
    \value ProgramTransitionAuditEventType_ClientUserId
    \value ProgramTransitionAuditEventType_MethodId
    \value ProgramTransitionAuditEventType_InputArguments
    \value ProgramTransitionAuditEventType_OldStateId
    \value ProgramTransitionAuditEventType_NewStateId
    \value ProgramTransitionAuditEventType_Transition
    \value ProgramTransitionAuditEventType_Transition_Id
    \value ProgramTransitionAuditEventType_Transition_Name
    \value ProgramTransitionAuditEventType_Transition_Number
    \value ProgramTransitionAuditEventType_Transition_TransitionTime
    \value ProgramStateMachineType_CurrentState
    \value ProgramStateMachineType_CurrentState_Id
    \value ProgramStateMachineType_CurrentState_Name
    \value ProgramStateMachineType_CurrentState_Number
    \value ProgramStateMachineType_CurrentState_EffectiveDisplayName
    \value ProgramStateMachineType_LastTransition
    \value ProgramStateMachineType_LastTransition_Id
    \value ProgramStateMachineType_LastTransition_Name
    \value ProgramStateMachineType_LastTransition_Number
    \value ProgramStateMachineType_LastTransition_TransitionTime
    \value ProgramStateMachineType_ProgramDiagnostic_CreateSessionId
    \value ProgramStateMachineType_ProgramDiagnostic_CreateClientName
    \value ProgramStateMachineType_ProgramDiagnostic_InvocationCreationTime
    \value ProgramStateMachineType_ProgramDiagnostic_LastTransitionTime
    \value ProgramStateMachineType_ProgramDiagnostic_LastMethodCall
    \value ProgramStateMachineType_ProgramDiagnostic_LastMethodSessionId
    \value ProgramStateMachineType_ProgramDiagnostic_LastMethodInputArguments
    \value ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputArguments
    \value ProgramStateMachineType_ProgramDiagnostic_LastMethodCallTime
    \value ProgramStateMachineType_ProgramDiagnostic_LastMethodReturnStatus
    \value ProgramStateMachineType_FinalResultData
    \value AddCommentMethodType
    \value AddCommentMethodType_InputArguments
    \value ConditionType_EventId
    \value ConditionType_EventType
    \value ConditionType_SourceNode
    \value ConditionType_SourceName
    \value ConditionType_Time
    \value ConditionType_ReceiveTime
    \value ConditionType_LocalTime
    \value ConditionType_Message
    \value ConditionType_Severity
    \value ConditionType_Retain
    \value ConditionType_ConditionRefresh
    \value ConditionType_ConditionRefresh_InputArguments
    \value RefreshStartEventType_EventId
    \value RefreshStartEventType_EventType
    \value RefreshStartEventType_SourceNode
    \value RefreshStartEventType_SourceName
    \value RefreshStartEventType_Time
    \value RefreshStartEventType_ReceiveTime
    \value RefreshStartEventType_LocalTime
    \value RefreshStartEventType_Message
    \value RefreshStartEventType_Severity
    \value RefreshEndEventType_EventId
    \value RefreshEndEventType_EventType
    \value RefreshEndEventType_SourceNode
    \value RefreshEndEventType_SourceName
    \value RefreshEndEventType_Time
    \value RefreshEndEventType_ReceiveTime
    \value RefreshEndEventType_LocalTime
    \value RefreshEndEventType_Message
    \value RefreshEndEventType_Severity
    \value RefreshRequiredEventType_EventId
    \value RefreshRequiredEventType_EventType
    \value RefreshRequiredEventType_SourceNode
    \value RefreshRequiredEventType_SourceName
    \value RefreshRequiredEventType_Time
    \value RefreshRequiredEventType_ReceiveTime
    \value RefreshRequiredEventType_LocalTime
    \value RefreshRequiredEventType_Message
    \value RefreshRequiredEventType_Severity
    \value AuditConditionEventType_EventId
    \value AuditConditionEventType_EventType
    \value AuditConditionEventType_SourceNode
    \value AuditConditionEventType_SourceName
    \value AuditConditionEventType_Time
    \value AuditConditionEventType_ReceiveTime
    \value AuditConditionEventType_LocalTime
    \value AuditConditionEventType_Message
    \value AuditConditionEventType_Severity
    \value AuditConditionEventType_ActionTimeStamp
    \value AuditConditionEventType_Status
    \value AuditConditionEventType_ServerId
    \value AuditConditionEventType_ClientAuditEntryId
    \value AuditConditionEventType_ClientUserId
    \value AuditConditionEventType_MethodId
    \value AuditConditionEventType_InputArguments
    \value AuditConditionEnableEventType_EventId
    \value AuditConditionEnableEventType_EventType
    \value AuditConditionEnableEventType_SourceNode
    \value AuditConditionEnableEventType_SourceName
    \value AuditConditionEnableEventType_Time
    \value AuditConditionEnableEventType_ReceiveTime
    \value AuditConditionEnableEventType_LocalTime
    \value AuditConditionEnableEventType_Message
    \value AuditConditionEnableEventType_Severity
    \value AuditConditionEnableEventType_ActionTimeStamp
    \value AuditConditionEnableEventType_Status
    \value AuditConditionEnableEventType_ServerId
    \value AuditConditionEnableEventType_ClientAuditEntryId
    \value AuditConditionEnableEventType_ClientUserId
    \value AuditConditionEnableEventType_MethodId
    \value AuditConditionEnableEventType_InputArguments
    \value AuditConditionCommentEventType_EventId
    \value AuditConditionCommentEventType_EventType
    \value AuditConditionCommentEventType_SourceNode
    \value AuditConditionCommentEventType_SourceName
    \value AuditConditionCommentEventType_Time
    \value AuditConditionCommentEventType_ReceiveTime
    \value AuditConditionCommentEventType_LocalTime
    \value AuditConditionCommentEventType_Message
    \value AuditConditionCommentEventType_Severity
    \value AuditConditionCommentEventType_ActionTimeStamp
    \value AuditConditionCommentEventType_Status
    \value AuditConditionCommentEventType_ServerId
    \value AuditConditionCommentEventType_ClientAuditEntryId
    \value AuditConditionCommentEventType_ClientUserId
    \value AuditConditionCommentEventType_MethodId
    \value AuditConditionCommentEventType_InputArguments
    \value DialogConditionType_EventId
    \value DialogConditionType_EventType
    \value DialogConditionType_SourceNode
    \value DialogConditionType_SourceName
    \value DialogConditionType_Time
    \value DialogConditionType_ReceiveTime
    \value DialogConditionType_LocalTime
    \value DialogConditionType_Message
    \value DialogConditionType_Severity
    \value DialogConditionType_Retain
    \value DialogConditionType_ConditionRefresh
    \value DialogConditionType_ConditionRefresh_InputArguments
    \value AcknowledgeableConditionType_EventId
    \value AcknowledgeableConditionType_EventType
    \value AcknowledgeableConditionType_SourceNode
    \value AcknowledgeableConditionType_SourceName
    \value AcknowledgeableConditionType_Time
    \value AcknowledgeableConditionType_ReceiveTime
    \value AcknowledgeableConditionType_LocalTime
    \value AcknowledgeableConditionType_Message
    \value AcknowledgeableConditionType_Severity
    \value AcknowledgeableConditionType_Retain
    \value AcknowledgeableConditionType_ConditionRefresh
    \value AcknowledgeableConditionType_ConditionRefresh_InputArguments
    \value AlarmConditionType_EventId
    \value AlarmConditionType_EventType
    \value AlarmConditionType_SourceNode
    \value AlarmConditionType_SourceName
    \value AlarmConditionType_Time
    \value AlarmConditionType_ReceiveTime
    \value AlarmConditionType_LocalTime
    \value AlarmConditionType_Message
    \value AlarmConditionType_Severity
    \value AlarmConditionType_Retain
    \value AlarmConditionType_ConditionRefresh
    \value AlarmConditionType_ConditionRefresh_InputArguments
    \value ShelvedStateMachineType_CurrentState
    \value ShelvedStateMachineType_CurrentState_Id
    \value ShelvedStateMachineType_CurrentState_Name
    \value ShelvedStateMachineType_CurrentState_Number
    \value ShelvedStateMachineType_CurrentState_EffectiveDisplayName
    \value ShelvedStateMachineType_LastTransition
    \value ShelvedStateMachineType_LastTransition_Id
    \value ShelvedStateMachineType_LastTransition_Name
    \value ShelvedStateMachineType_LastTransition_Number
    \value ShelvedStateMachineType_LastTransition_TransitionTime
    \value ShelvedStateMachineType_Unshelved_StateNumber
    \value ShelvedStateMachineType_TimedShelved_StateNumber
    \value ShelvedStateMachineType_OneShotShelved_StateNumber
    \value TimedShelveMethodType
    \value TimedShelveMethodType_InputArguments
    \value LimitAlarmType_EventId
    \value LimitAlarmType_EventType
    \value LimitAlarmType_SourceNode
    \value LimitAlarmType_SourceName
    \value LimitAlarmType_Time
    \value LimitAlarmType_ReceiveTime
    \value LimitAlarmType_LocalTime
    \value LimitAlarmType_Message
    \value LimitAlarmType_Severity
    \value LimitAlarmType_Retain
    \value LimitAlarmType_ConditionRefresh
    \value LimitAlarmType_ConditionRefresh_InputArguments
    \value IdType_EnumStrings
    \value EnumValueType
    \value MessageSecurityMode_EnumStrings
    \value UserTokenType_EnumStrings
    \value ApplicationType_EnumStrings
    \value SecurityTokenRequestType_EnumStrings
    \value BrowseDirection_EnumStrings
    \value FilterOperator_EnumStrings
    \value TimestampsToReturn_EnumStrings
    \value MonitoringMode_EnumStrings
    \value DataChangeTrigger_EnumStrings
    \value DeadbandType_EnumStrings
    \value RedundancySupport_EnumStrings
    \value ServerState_EnumStrings
    \value ExceptionDeviationFormat_EnumStrings
    \value EnumValueType_Encoding_DefaultXml
    \value OpcUa_BinarySchema
    \value OpcUa_BinarySchema_DataTypeVersion
    \value OpcUa_BinarySchema_NamespaceUri
    \value OpcUa_BinarySchema_Argument
    \value OpcUa_BinarySchema_Argument_DataTypeVersion
    \value OpcUa_BinarySchema_Argument_DictionaryFragment
    \value OpcUa_BinarySchema_EnumValueType
    \value OpcUa_BinarySchema_EnumValueType_DataTypeVersion
    \value OpcUa_BinarySchema_EnumValueType_DictionaryFragment
    \value OpcUa_BinarySchema_StatusResult
    \value OpcUa_BinarySchema_StatusResult_DataTypeVersion
    \value OpcUa_BinarySchema_StatusResult_DictionaryFragment
    \value OpcUa_BinarySchema_UserTokenPolicy
    \value OpcUa_BinarySchema_UserTokenPolicy_DataTypeVersion
    \value OpcUa_BinarySchema_UserTokenPolicy_DictionaryFragment
    \value OpcUa_BinarySchema_ApplicationDescription
    \value OpcUa_BinarySchema_ApplicationDescription_DataTypeVersion
    \value OpcUa_BinarySchema_ApplicationDescription_DictionaryFragment
    \value OpcUa_BinarySchema_EndpointDescription
    \value OpcUa_BinarySchema_EndpointDescription_DataTypeVersion
    \value OpcUa_BinarySchema_EndpointDescription_DictionaryFragment
    \value OpcUa_BinarySchema_UserIdentityToken
    \value OpcUa_BinarySchema_UserIdentityToken_DataTypeVersion
    \value OpcUa_BinarySchema_UserIdentityToken_DictionaryFragment
    \value OpcUa_BinarySchema_AnonymousIdentityToken
    \value OpcUa_BinarySchema_AnonymousIdentityToken_DataTypeVersion
    \value OpcUa_BinarySchema_AnonymousIdentityToken_DictionaryFragment
    \value OpcUa_BinarySchema_UserNameIdentityToken
    \value OpcUa_BinarySchema_UserNameIdentityToken_DataTypeVersion
    \value OpcUa_BinarySchema_UserNameIdentityToken_DictionaryFragment
    \value OpcUa_BinarySchema_X509IdentityToken
    \value OpcUa_BinarySchema_X509IdentityToken_DataTypeVersion
    \value OpcUa_BinarySchema_X509IdentityToken_DictionaryFragment
    \value OpcUa_BinarySchema_IssuedIdentityToken
    \value OpcUa_BinarySchema_IssuedIdentityToken_DataTypeVersion
    \value OpcUa_BinarySchema_IssuedIdentityToken_DictionaryFragment
    \value OpcUa_BinarySchema_EndpointConfiguration
    \value OpcUa_BinarySchema_EndpointConfiguration_DataTypeVersion
    \value OpcUa_BinarySchema_EndpointConfiguration_DictionaryFragment
    \value OpcUa_BinarySchema_BuildInfo
    \value OpcUa_BinarySchema_BuildInfo_DataTypeVersion
    \value OpcUa_BinarySchema_BuildInfo_DictionaryFragment
    \value OpcUa_BinarySchema_SignedSoftwareCertificate
    \value OpcUa_BinarySchema_SignedSoftwareCertificate_DataTypeVersion
    \value OpcUa_BinarySchema_SignedSoftwareCertificate_DictionaryFragment
    \value OpcUa_BinarySchema_AddNodesItem
    \value OpcUa_BinarySchema_AddNodesItem_DataTypeVersion
    \value OpcUa_BinarySchema_AddNodesItem_DictionaryFragment
    \value OpcUa_BinarySchema_AddReferencesItem
    \value OpcUa_BinarySchema_AddReferencesItem_DataTypeVersion
    \value OpcUa_BinarySchema_AddReferencesItem_DictionaryFragment
    \value OpcUa_BinarySchema_DeleteNodesItem
    \value OpcUa_BinarySchema_DeleteNodesItem_DataTypeVersion
    \value OpcUa_BinarySchema_DeleteNodesItem_DictionaryFragment
    \value OpcUa_BinarySchema_DeleteReferencesItem
    \value OpcUa_BinarySchema_DeleteReferencesItem_DataTypeVersion
    \value OpcUa_BinarySchema_DeleteReferencesItem_DictionaryFragment
    \value OpcUa_BinarySchema_RegisteredServer
    \value OpcUa_BinarySchema_RegisteredServer_DataTypeVersion
    \value OpcUa_BinarySchema_RegisteredServer_DictionaryFragment
    \value OpcUa_BinarySchema_ContentFilterElement
    \value OpcUa_BinarySchema_ContentFilterElement_DataTypeVersion
    \value OpcUa_BinarySchema_ContentFilterElement_DictionaryFragment
    \value OpcUa_BinarySchema_ContentFilter
    \value OpcUa_BinarySchema_ContentFilter_DataTypeVersion
    \value OpcUa_BinarySchema_ContentFilter_DictionaryFragment
    \value OpcUa_BinarySchema_FilterOperand
    \value OpcUa_BinarySchema_FilterOperand_DataTypeVersion
    \value OpcUa_BinarySchema_FilterOperand_DictionaryFragment
    \value OpcUa_BinarySchema_ElementOperand
    \value OpcUa_BinarySchema_ElementOperand_DataTypeVersion
    \value OpcUa_BinarySchema_ElementOperand_DictionaryFragment
    \value OpcUa_BinarySchema_LiteralOperand
    \value OpcUa_BinarySchema_LiteralOperand_DataTypeVersion
    \value OpcUa_BinarySchema_LiteralOperand_DictionaryFragment
    \value OpcUa_BinarySchema_AttributeOperand
    \value OpcUa_BinarySchema_AttributeOperand_DataTypeVersion
    \value OpcUa_BinarySchema_AttributeOperand_DictionaryFragment
    \value OpcUa_BinarySchema_SimpleAttributeOperand
    \value OpcUa_BinarySchema_SimpleAttributeOperand_DataTypeVersion
    \value OpcUa_BinarySchema_SimpleAttributeOperand_DictionaryFragment
    \value OpcUa_BinarySchema_HistoryEvent
    \value OpcUa_BinarySchema_HistoryEvent_DataTypeVersion
    \value OpcUa_BinarySchema_HistoryEvent_DictionaryFragment
    \value OpcUa_BinarySchema_MonitoringFilter
    \value OpcUa_BinarySchema_MonitoringFilter_DataTypeVersion
    \value OpcUa_BinarySchema_MonitoringFilter_DictionaryFragment
    \value OpcUa_BinarySchema_EventFilter
    \value OpcUa_BinarySchema_EventFilter_DataTypeVersion
    \value OpcUa_BinarySchema_EventFilter_DictionaryFragment
    \value OpcUa_BinarySchema_AggregateConfiguration
    \value OpcUa_BinarySchema_AggregateConfiguration_DataTypeVersion
    \value OpcUa_BinarySchema_AggregateConfiguration_DictionaryFragment
    \value OpcUa_BinarySchema_HistoryEventFieldList
    \value OpcUa_BinarySchema_HistoryEventFieldList_DataTypeVersion
    \value OpcUa_BinarySchema_HistoryEventFieldList_DictionaryFragment
    \value OpcUa_BinarySchema_RedundantServerDataType
    \value OpcUa_BinarySchema_RedundantServerDataType_DataTypeVersion
    \value OpcUa_BinarySchema_RedundantServerDataType_DictionaryFragment
    \value OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType
    \value OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion
    \value OpcUa_BinarySchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment
    \value OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType
    \value OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ServerDiagnosticsSummaryDataType_DictionaryFragment
    \value OpcUa_BinarySchema_ServerStatusDataType
    \value OpcUa_BinarySchema_ServerStatusDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ServerStatusDataType_DictionaryFragment
    \value OpcUa_BinarySchema_SessionDiagnosticsDataType
    \value OpcUa_BinarySchema_SessionDiagnosticsDataType_DataTypeVersion
    \value OpcUa_BinarySchema_SessionDiagnosticsDataType_DictionaryFragment
    \value OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType
    \value OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DataTypeVersion
    \value OpcUa_BinarySchema_SessionSecurityDiagnosticsDataType_DictionaryFragment
    \value OpcUa_BinarySchema_ServiceCounterDataType
    \value OpcUa_BinarySchema_ServiceCounterDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ServiceCounterDataType_DictionaryFragment
    \value OpcUa_BinarySchema_SubscriptionDiagnosticsDataType
    \value OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DataTypeVersion
    \value OpcUa_BinarySchema_SubscriptionDiagnosticsDataType_DictionaryFragment
    \value OpcUa_BinarySchema_ModelChangeStructureDataType
    \value OpcUa_BinarySchema_ModelChangeStructureDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ModelChangeStructureDataType_DictionaryFragment
    \value OpcUa_BinarySchema_SemanticChangeStructureDataType
    \value OpcUa_BinarySchema_SemanticChangeStructureDataType_DataTypeVersion
    \value OpcUa_BinarySchema_SemanticChangeStructureDataType_DictionaryFragment
    \value OpcUa_BinarySchema_Range
    \value OpcUa_BinarySchema_Range_DataTypeVersion
    \value OpcUa_BinarySchema_Range_DictionaryFragment
    \value OpcUa_BinarySchema_EUInformation
    \value OpcUa_BinarySchema_EUInformation_DataTypeVersion
    \value OpcUa_BinarySchema_EUInformation_DictionaryFragment
    \value OpcUa_BinarySchema_Annotation
    \value OpcUa_BinarySchema_Annotation_DataTypeVersion
    \value OpcUa_BinarySchema_Annotation_DictionaryFragment
    \value OpcUa_BinarySchema_ProgramDiagnosticDataType
    \value OpcUa_BinarySchema_ProgramDiagnosticDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ProgramDiagnosticDataType_DictionaryFragment
    \value EnumValueType_Encoding_DefaultBinary
    \value OpcUa_XmlSchema
    \value OpcUa_XmlSchema_DataTypeVersion
    \value OpcUa_XmlSchema_NamespaceUri
    \value OpcUa_XmlSchema_Argument
    \value OpcUa_XmlSchema_Argument_DataTypeVersion
    \value OpcUa_XmlSchema_Argument_DictionaryFragment
    \value OpcUa_XmlSchema_EnumValueType
    \value OpcUa_XmlSchema_EnumValueType_DataTypeVersion
    \value OpcUa_XmlSchema_EnumValueType_DictionaryFragment
    \value OpcUa_XmlSchema_StatusResult
    \value OpcUa_XmlSchema_StatusResult_DataTypeVersion
    \value OpcUa_XmlSchema_StatusResult_DictionaryFragment
    \value OpcUa_XmlSchema_UserTokenPolicy
    \value OpcUa_XmlSchema_UserTokenPolicy_DataTypeVersion
    \value OpcUa_XmlSchema_UserTokenPolicy_DictionaryFragment
    \value OpcUa_XmlSchema_ApplicationDescription
    \value OpcUa_XmlSchema_ApplicationDescription_DataTypeVersion
    \value OpcUa_XmlSchema_ApplicationDescription_DictionaryFragment
    \value OpcUa_XmlSchema_EndpointDescription
    \value OpcUa_XmlSchema_EndpointDescription_DataTypeVersion
    \value OpcUa_XmlSchema_EndpointDescription_DictionaryFragment
    \value OpcUa_XmlSchema_UserIdentityToken
    \value OpcUa_XmlSchema_UserIdentityToken_DataTypeVersion
    \value OpcUa_XmlSchema_UserIdentityToken_DictionaryFragment
    \value OpcUa_XmlSchema_AnonymousIdentityToken
    \value OpcUa_XmlSchema_AnonymousIdentityToken_DataTypeVersion
    \value OpcUa_XmlSchema_AnonymousIdentityToken_DictionaryFragment
    \value OpcUa_XmlSchema_UserNameIdentityToken
    \value OpcUa_XmlSchema_UserNameIdentityToken_DataTypeVersion
    \value OpcUa_XmlSchema_UserNameIdentityToken_DictionaryFragment
    \value OpcUa_XmlSchema_X509IdentityToken
    \value OpcUa_XmlSchema_X509IdentityToken_DataTypeVersion
    \value OpcUa_XmlSchema_X509IdentityToken_DictionaryFragment
    \value OpcUa_XmlSchema_IssuedIdentityToken
    \value OpcUa_XmlSchema_IssuedIdentityToken_DataTypeVersion
    \value OpcUa_XmlSchema_IssuedIdentityToken_DictionaryFragment
    \value OpcUa_XmlSchema_EndpointConfiguration
    \value OpcUa_XmlSchema_EndpointConfiguration_DataTypeVersion
    \value OpcUa_XmlSchema_EndpointConfiguration_DictionaryFragment
    \value OpcUa_XmlSchema_BuildInfo
    \value OpcUa_XmlSchema_BuildInfo_DataTypeVersion
    \value OpcUa_XmlSchema_BuildInfo_DictionaryFragment
    \value OpcUa_XmlSchema_SignedSoftwareCertificate
    \value OpcUa_XmlSchema_SignedSoftwareCertificate_DataTypeVersion
    \value OpcUa_XmlSchema_SignedSoftwareCertificate_DictionaryFragment
    \value OpcUa_XmlSchema_AddNodesItem
    \value OpcUa_XmlSchema_AddNodesItem_DataTypeVersion
    \value OpcUa_XmlSchema_AddNodesItem_DictionaryFragment
    \value OpcUa_XmlSchema_AddReferencesItem
    \value OpcUa_XmlSchema_AddReferencesItem_DataTypeVersion
    \value OpcUa_XmlSchema_AddReferencesItem_DictionaryFragment
    \value OpcUa_XmlSchema_DeleteNodesItem
    \value OpcUa_XmlSchema_DeleteNodesItem_DataTypeVersion
    \value OpcUa_XmlSchema_DeleteNodesItem_DictionaryFragment
    \value OpcUa_XmlSchema_DeleteReferencesItem
    \value OpcUa_XmlSchema_DeleteReferencesItem_DataTypeVersion
    \value OpcUa_XmlSchema_DeleteReferencesItem_DictionaryFragment
    \value OpcUa_XmlSchema_RegisteredServer
    \value OpcUa_XmlSchema_RegisteredServer_DataTypeVersion
    \value OpcUa_XmlSchema_RegisteredServer_DictionaryFragment
    \value OpcUa_XmlSchema_ContentFilterElement
    \value OpcUa_XmlSchema_ContentFilterElement_DataTypeVersion
    \value OpcUa_XmlSchema_ContentFilterElement_DictionaryFragment
    \value OpcUa_XmlSchema_ContentFilter
    \value OpcUa_XmlSchema_ContentFilter_DataTypeVersion
    \value OpcUa_XmlSchema_ContentFilter_DictionaryFragment
    \value OpcUa_XmlSchema_FilterOperand
    \value OpcUa_XmlSchema_FilterOperand_DataTypeVersion
    \value OpcUa_XmlSchema_FilterOperand_DictionaryFragment
    \value OpcUa_XmlSchema_ElementOperand
    \value OpcUa_XmlSchema_ElementOperand_DataTypeVersion
    \value OpcUa_XmlSchema_ElementOperand_DictionaryFragment
    \value OpcUa_XmlSchema_LiteralOperand
    \value OpcUa_XmlSchema_LiteralOperand_DataTypeVersion
    \value OpcUa_XmlSchema_LiteralOperand_DictionaryFragment
    \value OpcUa_XmlSchema_AttributeOperand
    \value OpcUa_XmlSchema_AttributeOperand_DataTypeVersion
    \value OpcUa_XmlSchema_AttributeOperand_DictionaryFragment
    \value OpcUa_XmlSchema_SimpleAttributeOperand
    \value OpcUa_XmlSchema_SimpleAttributeOperand_DataTypeVersion
    \value OpcUa_XmlSchema_SimpleAttributeOperand_DictionaryFragment
    \value OpcUa_XmlSchema_HistoryEvent
    \value OpcUa_XmlSchema_HistoryEvent_DataTypeVersion
    \value OpcUa_XmlSchema_HistoryEvent_DictionaryFragment
    \value OpcUa_XmlSchema_MonitoringFilter
    \value OpcUa_XmlSchema_MonitoringFilter_DataTypeVersion
    \value OpcUa_XmlSchema_MonitoringFilter_DictionaryFragment
    \value OpcUa_XmlSchema_EventFilter
    \value OpcUa_XmlSchema_EventFilter_DataTypeVersion
    \value OpcUa_XmlSchema_EventFilter_DictionaryFragment
    \value OpcUa_XmlSchema_AggregateConfiguration
    \value OpcUa_XmlSchema_AggregateConfiguration_DataTypeVersion
    \value OpcUa_XmlSchema_AggregateConfiguration_DictionaryFragment
    \value OpcUa_XmlSchema_HistoryEventFieldList
    \value OpcUa_XmlSchema_HistoryEventFieldList_DataTypeVersion
    \value OpcUa_XmlSchema_HistoryEventFieldList_DictionaryFragment
    \value OpcUa_XmlSchema_RedundantServerDataType
    \value OpcUa_XmlSchema_RedundantServerDataType_DataTypeVersion
    \value OpcUa_XmlSchema_RedundantServerDataType_DictionaryFragment
    \value OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType
    \value OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DataTypeVersion
    \value OpcUa_XmlSchema_SamplingIntervalDiagnosticsDataType_DictionaryFragment
    \value OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType
    \value OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ServerDiagnosticsSummaryDataType_DictionaryFragment
    \value OpcUa_XmlSchema_ServerStatusDataType
    \value OpcUa_XmlSchema_ServerStatusDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ServerStatusDataType_DictionaryFragment
    \value OpcUa_XmlSchema_SessionDiagnosticsDataType
    \value OpcUa_XmlSchema_SessionDiagnosticsDataType_DataTypeVersion
    \value OpcUa_XmlSchema_SessionDiagnosticsDataType_DictionaryFragment
    \value OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType
    \value OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DataTypeVersion
    \value OpcUa_XmlSchema_SessionSecurityDiagnosticsDataType_DictionaryFragment
    \value OpcUa_XmlSchema_ServiceCounterDataType
    \value OpcUa_XmlSchema_ServiceCounterDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ServiceCounterDataType_DictionaryFragment
    \value OpcUa_XmlSchema_SubscriptionDiagnosticsDataType
    \value OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DataTypeVersion
    \value OpcUa_XmlSchema_SubscriptionDiagnosticsDataType_DictionaryFragment
    \value OpcUa_XmlSchema_ModelChangeStructureDataType
    \value OpcUa_XmlSchema_ModelChangeStructureDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ModelChangeStructureDataType_DictionaryFragment
    \value OpcUa_XmlSchema_SemanticChangeStructureDataType
    \value OpcUa_XmlSchema_SemanticChangeStructureDataType_DataTypeVersion
    \value OpcUa_XmlSchema_SemanticChangeStructureDataType_DictionaryFragment
    \value OpcUa_XmlSchema_Range
    \value OpcUa_XmlSchema_Range_DataTypeVersion
    \value OpcUa_XmlSchema_Range_DictionaryFragment
    \value OpcUa_XmlSchema_EUInformation
    \value OpcUa_XmlSchema_EUInformation_DataTypeVersion
    \value OpcUa_XmlSchema_EUInformation_DictionaryFragment
    \value OpcUa_XmlSchema_Annotation
    \value OpcUa_XmlSchema_Annotation_DataTypeVersion
    \value OpcUa_XmlSchema_Annotation_DictionaryFragment
    \value OpcUa_XmlSchema_ProgramDiagnosticDataType
    \value OpcUa_XmlSchema_ProgramDiagnosticDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ProgramDiagnosticDataType_DictionaryFragment
    \value SubscriptionDiagnosticsType_MaxLifetimeCount
    \value SubscriptionDiagnosticsType_LatePublishRequestCount
    \value SubscriptionDiagnosticsType_CurrentKeepAliveCount
    \value SubscriptionDiagnosticsType_CurrentLifetimeCount
    \value SubscriptionDiagnosticsType_UnacknowledgedMessageCount
    \value SubscriptionDiagnosticsType_DiscardedMessageCount
    \value SubscriptionDiagnosticsType_MonitoredItemCount
    \value SubscriptionDiagnosticsType_DisabledMonitoredItemCount
    \value SubscriptionDiagnosticsType_MonitoringQueueOverflowCount
    \value SubscriptionDiagnosticsType_NextSequenceNumber
    \value SessionDiagnosticsObjectType_SessionDiagnostics_TotalRequestCount
    \value SessionDiagnosticsVariableType_TotalRequestCount
    \value SubscriptionDiagnosticsType_EventQueueOverflowCount
    \value TimeZoneDataType
    \value TimeZoneDataType_Encoding_DefaultXml
    \value OpcUa_BinarySchema_TimeZoneDataType
    \value OpcUa_BinarySchema_TimeZoneDataType_DataTypeVersion
    \value OpcUa_BinarySchema_TimeZoneDataType_DictionaryFragment
    \value TimeZoneDataType_Encoding_DefaultBinary
    \value OpcUa_XmlSchema_TimeZoneDataType
    \value OpcUa_XmlSchema_TimeZoneDataType_DataTypeVersion
    \value OpcUa_XmlSchema_TimeZoneDataType_DictionaryFragment
    \value AuditConditionRespondEventType
    \value AuditConditionRespondEventType_EventId
    \value AuditConditionRespondEventType_EventType
    \value AuditConditionRespondEventType_SourceNode
    \value AuditConditionRespondEventType_SourceName
    \value AuditConditionRespondEventType_Time
    \value AuditConditionRespondEventType_ReceiveTime
    \value AuditConditionRespondEventType_LocalTime
    \value AuditConditionRespondEventType_Message
    \value AuditConditionRespondEventType_Severity
    \value AuditConditionRespondEventType_ActionTimeStamp
    \value AuditConditionRespondEventType_Status
    \value AuditConditionRespondEventType_ServerId
    \value AuditConditionRespondEventType_ClientAuditEntryId
    \value AuditConditionRespondEventType_ClientUserId
    \value AuditConditionRespondEventType_MethodId
    \value AuditConditionRespondEventType_InputArguments
    \value AuditConditionAcknowledgeEventType
    \value AuditConditionAcknowledgeEventType_EventId
    \value AuditConditionAcknowledgeEventType_EventType
    \value AuditConditionAcknowledgeEventType_SourceNode
    \value AuditConditionAcknowledgeEventType_SourceName
    \value AuditConditionAcknowledgeEventType_Time
    \value AuditConditionAcknowledgeEventType_ReceiveTime
    \value AuditConditionAcknowledgeEventType_LocalTime
    \value AuditConditionAcknowledgeEventType_Message
    \value AuditConditionAcknowledgeEventType_Severity
    \value AuditConditionAcknowledgeEventType_ActionTimeStamp
    \value AuditConditionAcknowledgeEventType_Status
    \value AuditConditionAcknowledgeEventType_ServerId
    \value AuditConditionAcknowledgeEventType_ClientAuditEntryId
    \value AuditConditionAcknowledgeEventType_ClientUserId
    \value AuditConditionAcknowledgeEventType_MethodId
    \value AuditConditionAcknowledgeEventType_InputArguments
    \value AuditConditionConfirmEventType
    \value AuditConditionConfirmEventType_EventId
    \value AuditConditionConfirmEventType_EventType
    \value AuditConditionConfirmEventType_SourceNode
    \value AuditConditionConfirmEventType_SourceName
    \value AuditConditionConfirmEventType_Time
    \value AuditConditionConfirmEventType_ReceiveTime
    \value AuditConditionConfirmEventType_LocalTime
    \value AuditConditionConfirmEventType_Message
    \value AuditConditionConfirmEventType_Severity
    \value AuditConditionConfirmEventType_ActionTimeStamp
    \value AuditConditionConfirmEventType_Status
    \value AuditConditionConfirmEventType_ServerId
    \value AuditConditionConfirmEventType_ClientAuditEntryId
    \value AuditConditionConfirmEventType_ClientUserId
    \value AuditConditionConfirmEventType_MethodId
    \value AuditConditionConfirmEventType_InputArguments
    \value TwoStateVariableType
    \value TwoStateVariableType_Id
    \value TwoStateVariableType_Name
    \value TwoStateVariableType_Number
    \value TwoStateVariableType_EffectiveDisplayName
    \value TwoStateVariableType_TransitionTime
    \value TwoStateVariableType_EffectiveTransitionTime
    \value ConditionVariableType
    \value ConditionVariableType_SourceTimestamp
    \value HasTrueSubState
    \value HasFalseSubState
    \value HasCondition
    \value ConditionRefreshMethodType
    \value ConditionRefreshMethodType_InputArguments
    \value ConditionType_ConditionName
    \value ConditionType_BranchId
    \value ConditionType_EnabledState
    \value ConditionType_EnabledState_Id
    \value ConditionType_EnabledState_Name
    \value ConditionType_EnabledState_Number
    \value ConditionType_EnabledState_EffectiveDisplayName
    \value ConditionType_EnabledState_TransitionTime
    \value ConditionType_EnabledState_EffectiveTransitionTime
    \value ConditionType_EnabledState_TrueState
    \value ConditionType_EnabledState_FalseState
    \value ConditionType_Quality
    \value ConditionType_Quality_SourceTimestamp
    \value ConditionType_LastSeverity
    \value ConditionType_LastSeverity_SourceTimestamp
    \value ConditionType_Comment
    \value ConditionType_Comment_SourceTimestamp
    \value ConditionType_ClientUserId
    \value ConditionType_Enable
    \value ConditionType_Disable
    \value ConditionType_AddComment
    \value ConditionType_AddComment_InputArguments
    \value DialogResponseMethodType
    \value DialogResponseMethodType_InputArguments
    \value DialogConditionType_ConditionName
    \value DialogConditionType_BranchId
    \value DialogConditionType_EnabledState
    \value DialogConditionType_EnabledState_Id
    \value DialogConditionType_EnabledState_Name
    \value DialogConditionType_EnabledState_Number
    \value DialogConditionType_EnabledState_EffectiveDisplayName
    \value DialogConditionType_EnabledState_TransitionTime
    \value DialogConditionType_EnabledState_EffectiveTransitionTime
    \value DialogConditionType_EnabledState_TrueState
    \value DialogConditionType_EnabledState_FalseState
    \value DialogConditionType_Quality
    \value DialogConditionType_Quality_SourceTimestamp
    \value DialogConditionType_LastSeverity
    \value DialogConditionType_LastSeverity_SourceTimestamp
    \value DialogConditionType_Comment
    \value DialogConditionType_Comment_SourceTimestamp
    \value DialogConditionType_ClientUserId
    \value DialogConditionType_Enable
    \value DialogConditionType_Disable
    \value DialogConditionType_AddComment
    \value DialogConditionType_AddComment_InputArguments
    \value DialogConditionType_DialogState
    \value DialogConditionType_DialogState_Id
    \value DialogConditionType_DialogState_Name
    \value DialogConditionType_DialogState_Number
    \value DialogConditionType_DialogState_EffectiveDisplayName
    \value DialogConditionType_DialogState_TransitionTime
    \value DialogConditionType_DialogState_EffectiveTransitionTime
    \value DialogConditionType_DialogState_TrueState
    \value DialogConditionType_DialogState_FalseState
    \value DialogConditionType_ResponseOptionSet
    \value DialogConditionType_DefaultResponse
    \value DialogConditionType_OkResponse
    \value DialogConditionType_CancelResponse
    \value DialogConditionType_LastResponse
    \value DialogConditionType_Respond
    \value DialogConditionType_Respond_InputArguments
    \value AcknowledgeableConditionType_ConditionName
    \value AcknowledgeableConditionType_BranchId
    \value AcknowledgeableConditionType_EnabledState
    \value AcknowledgeableConditionType_EnabledState_Id
    \value AcknowledgeableConditionType_EnabledState_Name
    \value AcknowledgeableConditionType_EnabledState_Number
    \value AcknowledgeableConditionType_EnabledState_EffectiveDisplayName
    \value AcknowledgeableConditionType_EnabledState_TransitionTime
    \value AcknowledgeableConditionType_EnabledState_EffectiveTransitionTime
    \value AcknowledgeableConditionType_EnabledState_TrueState
    \value AcknowledgeableConditionType_EnabledState_FalseState
    \value AcknowledgeableConditionType_Quality
    \value AcknowledgeableConditionType_Quality_SourceTimestamp
    \value AcknowledgeableConditionType_LastSeverity
    \value AcknowledgeableConditionType_LastSeverity_SourceTimestamp
    \value AcknowledgeableConditionType_Comment
    \value AcknowledgeableConditionType_Comment_SourceTimestamp
    \value AcknowledgeableConditionType_ClientUserId
    \value AcknowledgeableConditionType_Enable
    \value AcknowledgeableConditionType_Disable
    \value AcknowledgeableConditionType_AddComment
    \value AcknowledgeableConditionType_AddComment_InputArguments
    \value AcknowledgeableConditionType_AckedState
    \value AcknowledgeableConditionType_AckedState_Id
    \value AcknowledgeableConditionType_AckedState_Name
    \value AcknowledgeableConditionType_AckedState_Number
    \value AcknowledgeableConditionType_AckedState_EffectiveDisplayName
    \value AcknowledgeableConditionType_AckedState_TransitionTime
    \value AcknowledgeableConditionType_AckedState_EffectiveTransitionTime
    \value AcknowledgeableConditionType_AckedState_TrueState
    \value AcknowledgeableConditionType_AckedState_FalseState
    \value AcknowledgeableConditionType_ConfirmedState
    \value AcknowledgeableConditionType_ConfirmedState_Id
    \value AcknowledgeableConditionType_ConfirmedState_Name
    \value AcknowledgeableConditionType_ConfirmedState_Number
    \value AcknowledgeableConditionType_ConfirmedState_EffectiveDisplayName
    \value AcknowledgeableConditionType_ConfirmedState_TransitionTime
    \value AcknowledgeableConditionType_ConfirmedState_EffectiveTransitionTime
    \value AcknowledgeableConditionType_ConfirmedState_TrueState
    \value AcknowledgeableConditionType_ConfirmedState_FalseState
    \value AcknowledgeableConditionType_Acknowledge
    \value AcknowledgeableConditionType_Acknowledge_InputArguments
    \value AcknowledgeableConditionType_Confirm
    \value AcknowledgeableConditionType_Confirm_InputArguments
    \value ShelvedStateMachineType_UnshelveTime
    \value AlarmConditionType_ConditionName
    \value AlarmConditionType_BranchId
    \value AlarmConditionType_EnabledState
    \value AlarmConditionType_EnabledState_Id
    \value AlarmConditionType_EnabledState_Name
    \value AlarmConditionType_EnabledState_Number
    \value AlarmConditionType_EnabledState_EffectiveDisplayName
    \value AlarmConditionType_EnabledState_TransitionTime
    \value AlarmConditionType_EnabledState_EffectiveTransitionTime
    \value AlarmConditionType_EnabledState_TrueState
    \value AlarmConditionType_EnabledState_FalseState
    \value AlarmConditionType_Quality
    \value AlarmConditionType_Quality_SourceTimestamp
    \value AlarmConditionType_LastSeverity
    \value AlarmConditionType_LastSeverity_SourceTimestamp
    \value AlarmConditionType_Comment
    \value AlarmConditionType_Comment_SourceTimestamp
    \value AlarmConditionType_ClientUserId
    \value AlarmConditionType_Enable
    \value AlarmConditionType_Disable
    \value AlarmConditionType_AddComment
    \value AlarmConditionType_AddComment_InputArguments
    \value AlarmConditionType_AckedState
    \value AlarmConditionType_AckedState_Id
    \value AlarmConditionType_AckedState_Name
    \value AlarmConditionType_AckedState_Number
    \value AlarmConditionType_AckedState_EffectiveDisplayName
    \value AlarmConditionType_AckedState_TransitionTime
    \value AlarmConditionType_AckedState_EffectiveTransitionTime
    \value AlarmConditionType_AckedState_TrueState
    \value AlarmConditionType_AckedState_FalseState
    \value AlarmConditionType_ConfirmedState
    \value AlarmConditionType_ConfirmedState_Id
    \value AlarmConditionType_ConfirmedState_Name
    \value AlarmConditionType_ConfirmedState_Number
    \value AlarmConditionType_ConfirmedState_EffectiveDisplayName
    \value AlarmConditionType_ConfirmedState_TransitionTime
    \value AlarmConditionType_ConfirmedState_EffectiveTransitionTime
    \value AlarmConditionType_ConfirmedState_TrueState
    \value AlarmConditionType_ConfirmedState_FalseState
    \value AlarmConditionType_Acknowledge
    \value AlarmConditionType_Acknowledge_InputArguments
    \value AlarmConditionType_Confirm
    \value AlarmConditionType_Confirm_InputArguments
    \value AlarmConditionType_ActiveState
    \value AlarmConditionType_ActiveState_Id
    \value AlarmConditionType_ActiveState_Name
    \value AlarmConditionType_ActiveState_Number
    \value AlarmConditionType_ActiveState_EffectiveDisplayName
    \value AlarmConditionType_ActiveState_TransitionTime
    \value AlarmConditionType_ActiveState_EffectiveTransitionTime
    \value AlarmConditionType_ActiveState_TrueState
    \value AlarmConditionType_ActiveState_FalseState
    \value AlarmConditionType_SuppressedState
    \value AlarmConditionType_SuppressedState_Id
    \value AlarmConditionType_SuppressedState_Name
    \value AlarmConditionType_SuppressedState_Number
    \value AlarmConditionType_SuppressedState_EffectiveDisplayName
    \value AlarmConditionType_SuppressedState_TransitionTime
    \value AlarmConditionType_SuppressedState_EffectiveTransitionTime
    \value AlarmConditionType_SuppressedState_TrueState
    \value AlarmConditionType_SuppressedState_FalseState
    \value AlarmConditionType_ShelvingState
    \value AlarmConditionType_ShelvingState_CurrentState
    \value AlarmConditionType_ShelvingState_CurrentState_Id
    \value AlarmConditionType_ShelvingState_CurrentState_Name
    \value AlarmConditionType_ShelvingState_CurrentState_Number
    \value AlarmConditionType_ShelvingState_CurrentState_EffectiveDisplayName
    \value AlarmConditionType_ShelvingState_LastTransition
    \value AlarmConditionType_ShelvingState_LastTransition_Id
    \value AlarmConditionType_ShelvingState_LastTransition_Name
    \value AlarmConditionType_ShelvingState_LastTransition_Number
    \value AlarmConditionType_ShelvingState_LastTransition_TransitionTime
    \value AlarmConditionType_ShelvingState_UnshelveTime
    \value AlarmConditionType_ShelvingState_Unshelve
    \value AlarmConditionType_ShelvingState_OneShotShelve
    \value AlarmConditionType_ShelvingState_TimedShelve
    \value AlarmConditionType_ShelvingState_TimedShelve_InputArguments
    \value AlarmConditionType_SuppressedOrShelved
    \value AlarmConditionType_MaxTimeShelved
    \value LimitAlarmType_ConditionName
    \value LimitAlarmType_BranchId
    \value LimitAlarmType_EnabledState
    \value LimitAlarmType_EnabledState_Id
    \value LimitAlarmType_EnabledState_Name
    \value LimitAlarmType_EnabledState_Number
    \value LimitAlarmType_EnabledState_EffectiveDisplayName
    \value LimitAlarmType_EnabledState_TransitionTime
    \value LimitAlarmType_EnabledState_EffectiveTransitionTime
    \value LimitAlarmType_EnabledState_TrueState
    \value LimitAlarmType_EnabledState_FalseState
    \value LimitAlarmType_Quality
    \value LimitAlarmType_Quality_SourceTimestamp
    \value LimitAlarmType_LastSeverity
    \value LimitAlarmType_LastSeverity_SourceTimestamp
    \value LimitAlarmType_Comment
    \value LimitAlarmType_Comment_SourceTimestamp
    \value LimitAlarmType_ClientUserId
    \value LimitAlarmType_Enable
    \value LimitAlarmType_Disable
    \value LimitAlarmType_AddComment
    \value LimitAlarmType_AddComment_InputArguments
    \value LimitAlarmType_AckedState
    \value LimitAlarmType_AckedState_Id
    \value LimitAlarmType_AckedState_Name
    \value LimitAlarmType_AckedState_Number
    \value LimitAlarmType_AckedState_EffectiveDisplayName
    \value LimitAlarmType_AckedState_TransitionTime
    \value LimitAlarmType_AckedState_EffectiveTransitionTime
    \value LimitAlarmType_AckedState_TrueState
    \value LimitAlarmType_AckedState_FalseState
    \value LimitAlarmType_ConfirmedState
    \value LimitAlarmType_ConfirmedState_Id
    \value LimitAlarmType_ConfirmedState_Name
    \value LimitAlarmType_ConfirmedState_Number
    \value LimitAlarmType_ConfirmedState_EffectiveDisplayName
    \value LimitAlarmType_ConfirmedState_TransitionTime
    \value LimitAlarmType_ConfirmedState_EffectiveTransitionTime
    \value LimitAlarmType_ConfirmedState_TrueState
    \value LimitAlarmType_ConfirmedState_FalseState
    \value LimitAlarmType_Acknowledge
    \value LimitAlarmType_Acknowledge_InputArguments
    \value LimitAlarmType_Confirm
    \value LimitAlarmType_Confirm_InputArguments
    \value LimitAlarmType_ActiveState
    \value LimitAlarmType_ActiveState_Id
    \value LimitAlarmType_ActiveState_Name
    \value LimitAlarmType_ActiveState_Number
    \value LimitAlarmType_ActiveState_EffectiveDisplayName
    \value LimitAlarmType_ActiveState_TransitionTime
    \value LimitAlarmType_ActiveState_EffectiveTransitionTime
    \value LimitAlarmType_ActiveState_TrueState
    \value LimitAlarmType_ActiveState_FalseState
    \value LimitAlarmType_SuppressedState
    \value LimitAlarmType_SuppressedState_Id
    \value LimitAlarmType_SuppressedState_Name
    \value LimitAlarmType_SuppressedState_Number
    \value LimitAlarmType_SuppressedState_EffectiveDisplayName
    \value LimitAlarmType_SuppressedState_TransitionTime
    \value LimitAlarmType_SuppressedState_EffectiveTransitionTime
    \value LimitAlarmType_SuppressedState_TrueState
    \value LimitAlarmType_SuppressedState_FalseState
    \value LimitAlarmType_ShelvingState
    \value LimitAlarmType_ShelvingState_CurrentState
    \value LimitAlarmType_ShelvingState_CurrentState_Id
    \value LimitAlarmType_ShelvingState_CurrentState_Name
    \value LimitAlarmType_ShelvingState_CurrentState_Number
    \value LimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value LimitAlarmType_ShelvingState_LastTransition
    \value LimitAlarmType_ShelvingState_LastTransition_Id
    \value LimitAlarmType_ShelvingState_LastTransition_Name
    \value LimitAlarmType_ShelvingState_LastTransition_Number
    \value LimitAlarmType_ShelvingState_LastTransition_TransitionTime
    \value LimitAlarmType_ShelvingState_UnshelveTime
    \value LimitAlarmType_ShelvingState_Unshelve
    \value LimitAlarmType_ShelvingState_OneShotShelve
    \value LimitAlarmType_ShelvingState_TimedShelve
    \value LimitAlarmType_ShelvingState_TimedShelve_InputArguments
    \value LimitAlarmType_SuppressedOrShelved
    \value LimitAlarmType_MaxTimeShelved
    \value ExclusiveLimitStateMachineType
    \value ExclusiveLimitStateMachineType_CurrentState
    \value ExclusiveLimitStateMachineType_CurrentState_Id
    \value ExclusiveLimitStateMachineType_CurrentState_Name
    \value ExclusiveLimitStateMachineType_CurrentState_Number
    \value ExclusiveLimitStateMachineType_CurrentState_EffectiveDisplayName
    \value ExclusiveLimitStateMachineType_LastTransition
    \value ExclusiveLimitStateMachineType_LastTransition_Id
    \value ExclusiveLimitStateMachineType_LastTransition_Name
    \value ExclusiveLimitStateMachineType_LastTransition_Number
    \value ExclusiveLimitStateMachineType_LastTransition_TransitionTime
    \value ExclusiveLimitStateMachineType_HighHigh
    \value ExclusiveLimitStateMachineType_HighHigh_StateNumber
    \value ExclusiveLimitStateMachineType_High
    \value ExclusiveLimitStateMachineType_High_StateNumber
    \value ExclusiveLimitStateMachineType_Low
    \value ExclusiveLimitStateMachineType_Low_StateNumber
    \value ExclusiveLimitStateMachineType_LowLow
    \value ExclusiveLimitStateMachineType_LowLow_StateNumber
    \value ExclusiveLimitStateMachineType_LowLowToLow
    \value ExclusiveLimitStateMachineType_LowToLowLow
    \value ExclusiveLimitStateMachineType_HighHighToHigh
    \value ExclusiveLimitStateMachineType_HighToHighHigh
    \value ExclusiveLimitAlarmType
    \value ExclusiveLimitAlarmType_EventId
    \value ExclusiveLimitAlarmType_EventType
    \value ExclusiveLimitAlarmType_SourceNode
    \value ExclusiveLimitAlarmType_SourceName
    \value ExclusiveLimitAlarmType_Time
    \value ExclusiveLimitAlarmType_ReceiveTime
    \value ExclusiveLimitAlarmType_LocalTime
    \value ExclusiveLimitAlarmType_Message
    \value ExclusiveLimitAlarmType_Severity
    \value ExclusiveLimitAlarmType_ConditionName
    \value ExclusiveLimitAlarmType_BranchId
    \value ExclusiveLimitAlarmType_Retain
    \value ExclusiveLimitAlarmType_EnabledState
    \value ExclusiveLimitAlarmType_EnabledState_Id
    \value ExclusiveLimitAlarmType_EnabledState_Name
    \value ExclusiveLimitAlarmType_EnabledState_Number
    \value ExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_EnabledState_TransitionTime
    \value ExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_EnabledState_TrueState
    \value ExclusiveLimitAlarmType_EnabledState_FalseState
    \value ExclusiveLimitAlarmType_Quality
    \value ExclusiveLimitAlarmType_Quality_SourceTimestamp
    \value ExclusiveLimitAlarmType_LastSeverity
    \value ExclusiveLimitAlarmType_LastSeverity_SourceTimestamp
    \value ExclusiveLimitAlarmType_Comment
    \value ExclusiveLimitAlarmType_Comment_SourceTimestamp
    \value ExclusiveLimitAlarmType_ClientUserId
    \value ExclusiveLimitAlarmType_Enable
    \value ExclusiveLimitAlarmType_Disable
    \value ExclusiveLimitAlarmType_AddComment
    \value ExclusiveLimitAlarmType_AddComment_InputArguments
    \value ExclusiveLimitAlarmType_ConditionRefresh
    \value ExclusiveLimitAlarmType_ConditionRefresh_InputArguments
    \value ExclusiveLimitAlarmType_AckedState
    \value ExclusiveLimitAlarmType_AckedState_Id
    \value ExclusiveLimitAlarmType_AckedState_Name
    \value ExclusiveLimitAlarmType_AckedState_Number
    \value ExclusiveLimitAlarmType_AckedState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_AckedState_TransitionTime
    \value ExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_AckedState_TrueState
    \value ExclusiveLimitAlarmType_AckedState_FalseState
    \value ExclusiveLimitAlarmType_ConfirmedState
    \value ExclusiveLimitAlarmType_ConfirmedState_Id
    \value ExclusiveLimitAlarmType_ConfirmedState_Name
    \value ExclusiveLimitAlarmType_ConfirmedState_Number
    \value ExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_ConfirmedState_TransitionTime
    \value ExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_ConfirmedState_TrueState
    \value ExclusiveLimitAlarmType_ConfirmedState_FalseState
    \value ExclusiveLimitAlarmType_Acknowledge
    \value ExclusiveLimitAlarmType_Acknowledge_InputArguments
    \value ExclusiveLimitAlarmType_Confirm
    \value ExclusiveLimitAlarmType_Confirm_InputArguments
    \value ExclusiveLimitAlarmType_ActiveState
    \value ExclusiveLimitAlarmType_ActiveState_Id
    \value ExclusiveLimitAlarmType_ActiveState_Name
    \value ExclusiveLimitAlarmType_ActiveState_Number
    \value ExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_ActiveState_TransitionTime
    \value ExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_ActiveState_TrueState
    \value ExclusiveLimitAlarmType_ActiveState_FalseState
    \value ExclusiveLimitAlarmType_SuppressedState
    \value ExclusiveLimitAlarmType_SuppressedState_Id
    \value ExclusiveLimitAlarmType_SuppressedState_Name
    \value ExclusiveLimitAlarmType_SuppressedState_Number
    \value ExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_SuppressedState_TransitionTime
    \value ExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_SuppressedState_TrueState
    \value ExclusiveLimitAlarmType_SuppressedState_FalseState
    \value ExclusiveLimitAlarmType_ShelvingState
    \value ExclusiveLimitAlarmType_ShelvingState_CurrentState
    \value ExclusiveLimitAlarmType_ShelvingState_CurrentState_Id
    \value ExclusiveLimitAlarmType_ShelvingState_CurrentState_Name
    \value ExclusiveLimitAlarmType_ShelvingState_CurrentState_Number
    \value ExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_ShelvingState_LastTransition
    \value ExclusiveLimitAlarmType_ShelvingState_LastTransition_Id
    \value ExclusiveLimitAlarmType_ShelvingState_LastTransition_Name
    \value ExclusiveLimitAlarmType_ShelvingState_LastTransition_Number
    \value ExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime
    \value ExclusiveLimitAlarmType_ShelvingState_UnshelveTime
    \value ExclusiveLimitAlarmType_ShelvingState_Unshelve
    \value ExclusiveLimitAlarmType_ShelvingState_OneShotShelve
    \value ExclusiveLimitAlarmType_ShelvingState_TimedShelve
    \value ExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments
    \value ExclusiveLimitAlarmType_SuppressedOrShelved
    \value ExclusiveLimitAlarmType_MaxTimeShelved
    \value ExclusiveLimitAlarmType_LimitState
    \value ExclusiveLimitAlarmType_LimitState_CurrentState
    \value ExclusiveLimitAlarmType_LimitState_CurrentState_Id
    \value ExclusiveLimitAlarmType_LimitState_CurrentState_Name
    \value ExclusiveLimitAlarmType_LimitState_CurrentState_Number
    \value ExclusiveLimitAlarmType_LimitState_CurrentState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_LimitState_LastTransition
    \value ExclusiveLimitAlarmType_LimitState_LastTransition_Id
    \value ExclusiveLimitAlarmType_LimitState_LastTransition_Name
    \value ExclusiveLimitAlarmType_LimitState_LastTransition_Number
    \value ExclusiveLimitAlarmType_LimitState_LastTransition_TransitionTime
    \value ExclusiveLimitAlarmType_HighHighLimit
    \value ExclusiveLimitAlarmType_HighLimit
    \value ExclusiveLimitAlarmType_LowLimit
    \value ExclusiveLimitAlarmType_LowLowLimit
    \value ExclusiveLevelAlarmType
    \value ExclusiveLevelAlarmType_EventId
    \value ExclusiveLevelAlarmType_EventType
    \value ExclusiveLevelAlarmType_SourceNode
    \value ExclusiveLevelAlarmType_SourceName
    \value ExclusiveLevelAlarmType_Time
    \value ExclusiveLevelAlarmType_ReceiveTime
    \value ExclusiveLevelAlarmType_LocalTime
    \value ExclusiveLevelAlarmType_Message
    \value ExclusiveLevelAlarmType_Severity
    \value ExclusiveLevelAlarmType_ConditionName
    \value ExclusiveLevelAlarmType_BranchId
    \value ExclusiveLevelAlarmType_Retain
    \value ExclusiveLevelAlarmType_EnabledState
    \value ExclusiveLevelAlarmType_EnabledState_Id
    \value ExclusiveLevelAlarmType_EnabledState_Name
    \value ExclusiveLevelAlarmType_EnabledState_Number
    \value ExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_EnabledState_TransitionTime
    \value ExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_EnabledState_TrueState
    \value ExclusiveLevelAlarmType_EnabledState_FalseState
    \value ExclusiveLevelAlarmType_Quality
    \value ExclusiveLevelAlarmType_Quality_SourceTimestamp
    \value ExclusiveLevelAlarmType_LastSeverity
    \value ExclusiveLevelAlarmType_LastSeverity_SourceTimestamp
    \value ExclusiveLevelAlarmType_Comment
    \value ExclusiveLevelAlarmType_Comment_SourceTimestamp
    \value ExclusiveLevelAlarmType_ClientUserId
    \value ExclusiveLevelAlarmType_Enable
    \value ExclusiveLevelAlarmType_Disable
    \value ExclusiveLevelAlarmType_AddComment
    \value ExclusiveLevelAlarmType_AddComment_InputArguments
    \value ExclusiveLevelAlarmType_ConditionRefresh
    \value ExclusiveLevelAlarmType_ConditionRefresh_InputArguments
    \value ExclusiveLevelAlarmType_AckedState
    \value ExclusiveLevelAlarmType_AckedState_Id
    \value ExclusiveLevelAlarmType_AckedState_Name
    \value ExclusiveLevelAlarmType_AckedState_Number
    \value ExclusiveLevelAlarmType_AckedState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_AckedState_TransitionTime
    \value ExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_AckedState_TrueState
    \value ExclusiveLevelAlarmType_AckedState_FalseState
    \value ExclusiveLevelAlarmType_ConfirmedState
    \value ExclusiveLevelAlarmType_ConfirmedState_Id
    \value ExclusiveLevelAlarmType_ConfirmedState_Name
    \value ExclusiveLevelAlarmType_ConfirmedState_Number
    \value ExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_ConfirmedState_TransitionTime
    \value ExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_ConfirmedState_TrueState
    \value ExclusiveLevelAlarmType_ConfirmedState_FalseState
    \value ExclusiveLevelAlarmType_Acknowledge
    \value ExclusiveLevelAlarmType_Acknowledge_InputArguments
    \value ExclusiveLevelAlarmType_Confirm
    \value ExclusiveLevelAlarmType_Confirm_InputArguments
    \value ExclusiveLevelAlarmType_ActiveState
    \value ExclusiveLevelAlarmType_ActiveState_Id
    \value ExclusiveLevelAlarmType_ActiveState_Name
    \value ExclusiveLevelAlarmType_ActiveState_Number
    \value ExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_ActiveState_TransitionTime
    \value ExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_ActiveState_TrueState
    \value ExclusiveLevelAlarmType_ActiveState_FalseState
    \value ExclusiveLevelAlarmType_SuppressedState
    \value ExclusiveLevelAlarmType_SuppressedState_Id
    \value ExclusiveLevelAlarmType_SuppressedState_Name
    \value ExclusiveLevelAlarmType_SuppressedState_Number
    \value ExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_SuppressedState_TransitionTime
    \value ExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_SuppressedState_TrueState
    \value ExclusiveLevelAlarmType_SuppressedState_FalseState
    \value ExclusiveLevelAlarmType_ShelvingState
    \value ExclusiveLevelAlarmType_ShelvingState_CurrentState
    \value ExclusiveLevelAlarmType_ShelvingState_CurrentState_Id
    \value ExclusiveLevelAlarmType_ShelvingState_CurrentState_Name
    \value ExclusiveLevelAlarmType_ShelvingState_CurrentState_Number
    \value ExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_ShelvingState_LastTransition
    \value ExclusiveLevelAlarmType_ShelvingState_LastTransition_Id
    \value ExclusiveLevelAlarmType_ShelvingState_LastTransition_Name
    \value ExclusiveLevelAlarmType_ShelvingState_LastTransition_Number
    \value ExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime
    \value ExclusiveLevelAlarmType_ShelvingState_UnshelveTime
    \value ExclusiveLevelAlarmType_ShelvingState_Unshelve
    \value ExclusiveLevelAlarmType_ShelvingState_OneShotShelve
    \value ExclusiveLevelAlarmType_ShelvingState_TimedShelve
    \value ExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments
    \value ExclusiveLevelAlarmType_SuppressedOrShelved
    \value ExclusiveLevelAlarmType_MaxTimeShelved
    \value ExclusiveLevelAlarmType_LimitState
    \value ExclusiveLevelAlarmType_LimitState_CurrentState
    \value ExclusiveLevelAlarmType_LimitState_CurrentState_Id
    \value ExclusiveLevelAlarmType_LimitState_CurrentState_Name
    \value ExclusiveLevelAlarmType_LimitState_CurrentState_Number
    \value ExclusiveLevelAlarmType_LimitState_CurrentState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_LimitState_LastTransition
    \value ExclusiveLevelAlarmType_LimitState_LastTransition_Id
    \value ExclusiveLevelAlarmType_LimitState_LastTransition_Name
    \value ExclusiveLevelAlarmType_LimitState_LastTransition_Number
    \value ExclusiveLevelAlarmType_LimitState_LastTransition_TransitionTime
    \value ExclusiveLevelAlarmType_HighHighLimit
    \value ExclusiveLevelAlarmType_HighLimit
    \value ExclusiveLevelAlarmType_LowLimit
    \value ExclusiveLevelAlarmType_LowLowLimit
    \value ExclusiveRateOfChangeAlarmType
    \value ExclusiveRateOfChangeAlarmType_EventId
    \value ExclusiveRateOfChangeAlarmType_EventType
    \value ExclusiveRateOfChangeAlarmType_SourceNode
    \value ExclusiveRateOfChangeAlarmType_SourceName
    \value ExclusiveRateOfChangeAlarmType_Time
    \value ExclusiveRateOfChangeAlarmType_ReceiveTime
    \value ExclusiveRateOfChangeAlarmType_LocalTime
    \value ExclusiveRateOfChangeAlarmType_Message
    \value ExclusiveRateOfChangeAlarmType_Severity
    \value ExclusiveRateOfChangeAlarmType_ConditionName
    \value ExclusiveRateOfChangeAlarmType_BranchId
    \value ExclusiveRateOfChangeAlarmType_Retain
    \value ExclusiveRateOfChangeAlarmType_EnabledState
    \value ExclusiveRateOfChangeAlarmType_EnabledState_Id
    \value ExclusiveRateOfChangeAlarmType_EnabledState_Name
    \value ExclusiveRateOfChangeAlarmType_EnabledState_Number
    \value ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_EnabledState_TrueState
    \value ExclusiveRateOfChangeAlarmType_EnabledState_FalseState
    \value ExclusiveRateOfChangeAlarmType_Quality
    \value ExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp
    \value ExclusiveRateOfChangeAlarmType_LastSeverity
    \value ExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp
    \value ExclusiveRateOfChangeAlarmType_Comment
    \value ExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp
    \value ExclusiveRateOfChangeAlarmType_ClientUserId
    \value ExclusiveRateOfChangeAlarmType_Enable
    \value ExclusiveRateOfChangeAlarmType_Disable
    \value ExclusiveRateOfChangeAlarmType_AddComment
    \value ExclusiveRateOfChangeAlarmType_AddComment_InputArguments
    \value ExclusiveRateOfChangeAlarmType_ConditionRefresh
    \value ExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments
    \value ExclusiveRateOfChangeAlarmType_AckedState
    \value ExclusiveRateOfChangeAlarmType_AckedState_Id
    \value ExclusiveRateOfChangeAlarmType_AckedState_Name
    \value ExclusiveRateOfChangeAlarmType_AckedState_Number
    \value ExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_AckedState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_AckedState_TrueState
    \value ExclusiveRateOfChangeAlarmType_AckedState_FalseState
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_Id
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_Name
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_Number
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState
    \value ExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState
    \value ExclusiveRateOfChangeAlarmType_Acknowledge
    \value ExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments
    \value ExclusiveRateOfChangeAlarmType_Confirm
    \value ExclusiveRateOfChangeAlarmType_Confirm_InputArguments
    \value ExclusiveRateOfChangeAlarmType_ActiveState
    \value ExclusiveRateOfChangeAlarmType_ActiveState_Id
    \value ExclusiveRateOfChangeAlarmType_ActiveState_Name
    \value ExclusiveRateOfChangeAlarmType_ActiveState_Number
    \value ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_ActiveState_TrueState
    \value ExclusiveRateOfChangeAlarmType_ActiveState_FalseState
    \value ExclusiveRateOfChangeAlarmType_SuppressedState
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_Id
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_Name
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_Number
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_TrueState
    \value ExclusiveRateOfChangeAlarmType_SuppressedState_FalseState
    \value ExclusiveRateOfChangeAlarmType_ShelvingState
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments
    \value ExclusiveRateOfChangeAlarmType_SuppressedOrShelved
    \value ExclusiveRateOfChangeAlarmType_MaxTimeShelved
    \value ExclusiveRateOfChangeAlarmType_LimitState
    \value ExclusiveRateOfChangeAlarmType_LimitState_CurrentState
    \value ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Id
    \value ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Name
    \value ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_Number
    \value ExclusiveRateOfChangeAlarmType_LimitState_CurrentState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_LimitState_LastTransition
    \value ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Id
    \value ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Name
    \value ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_Number
    \value ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_HighHighLimit
    \value ExclusiveRateOfChangeAlarmType_HighLimit
    \value ExclusiveRateOfChangeAlarmType_LowLimit
    \value ExclusiveRateOfChangeAlarmType_LowLowLimit
    \value ExclusiveDeviationAlarmType
    \value ExclusiveDeviationAlarmType_EventId
    \value ExclusiveDeviationAlarmType_EventType
    \value ExclusiveDeviationAlarmType_SourceNode
    \value ExclusiveDeviationAlarmType_SourceName
    \value ExclusiveDeviationAlarmType_Time
    \value ExclusiveDeviationAlarmType_ReceiveTime
    \value ExclusiveDeviationAlarmType_LocalTime
    \value ExclusiveDeviationAlarmType_Message
    \value ExclusiveDeviationAlarmType_Severity
    \value ExclusiveDeviationAlarmType_ConditionName
    \value ExclusiveDeviationAlarmType_BranchId
    \value ExclusiveDeviationAlarmType_Retain
    \value ExclusiveDeviationAlarmType_EnabledState
    \value ExclusiveDeviationAlarmType_EnabledState_Id
    \value ExclusiveDeviationAlarmType_EnabledState_Name
    \value ExclusiveDeviationAlarmType_EnabledState_Number
    \value ExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_EnabledState_TransitionTime
    \value ExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_EnabledState_TrueState
    \value ExclusiveDeviationAlarmType_EnabledState_FalseState
    \value ExclusiveDeviationAlarmType_Quality
    \value ExclusiveDeviationAlarmType_Quality_SourceTimestamp
    \value ExclusiveDeviationAlarmType_LastSeverity
    \value ExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp
    \value ExclusiveDeviationAlarmType_Comment
    \value ExclusiveDeviationAlarmType_Comment_SourceTimestamp
    \value ExclusiveDeviationAlarmType_ClientUserId
    \value ExclusiveDeviationAlarmType_Enable
    \value ExclusiveDeviationAlarmType_Disable
    \value ExclusiveDeviationAlarmType_AddComment
    \value ExclusiveDeviationAlarmType_AddComment_InputArguments
    \value ExclusiveDeviationAlarmType_ConditionRefresh
    \value ExclusiveDeviationAlarmType_ConditionRefresh_InputArguments
    \value ExclusiveDeviationAlarmType_AckedState
    \value ExclusiveDeviationAlarmType_AckedState_Id
    \value ExclusiveDeviationAlarmType_AckedState_Name
    \value ExclusiveDeviationAlarmType_AckedState_Number
    \value ExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_AckedState_TransitionTime
    \value ExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_AckedState_TrueState
    \value ExclusiveDeviationAlarmType_AckedState_FalseState
    \value ExclusiveDeviationAlarmType_ConfirmedState
    \value ExclusiveDeviationAlarmType_ConfirmedState_Id
    \value ExclusiveDeviationAlarmType_ConfirmedState_Name
    \value ExclusiveDeviationAlarmType_ConfirmedState_Number
    \value ExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_ConfirmedState_TransitionTime
    \value ExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_ConfirmedState_TrueState
    \value ExclusiveDeviationAlarmType_ConfirmedState_FalseState
    \value ExclusiveDeviationAlarmType_Acknowledge
    \value ExclusiveDeviationAlarmType_Acknowledge_InputArguments
    \value ExclusiveDeviationAlarmType_Confirm
    \value ExclusiveDeviationAlarmType_Confirm_InputArguments
    \value ExclusiveDeviationAlarmType_ActiveState
    \value ExclusiveDeviationAlarmType_ActiveState_Id
    \value ExclusiveDeviationAlarmType_ActiveState_Name
    \value ExclusiveDeviationAlarmType_ActiveState_Number
    \value ExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_ActiveState_TransitionTime
    \value ExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_ActiveState_TrueState
    \value ExclusiveDeviationAlarmType_ActiveState_FalseState
    \value ExclusiveDeviationAlarmType_SuppressedState
    \value ExclusiveDeviationAlarmType_SuppressedState_Id
    \value ExclusiveDeviationAlarmType_SuppressedState_Name
    \value ExclusiveDeviationAlarmType_SuppressedState_Number
    \value ExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_SuppressedState_TransitionTime
    \value ExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_SuppressedState_TrueState
    \value ExclusiveDeviationAlarmType_SuppressedState_FalseState
    \value ExclusiveDeviationAlarmType_ShelvingState
    \value ExclusiveDeviationAlarmType_ShelvingState_CurrentState
    \value ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id
    \value ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name
    \value ExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number
    \value ExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_ShelvingState_LastTransition
    \value ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id
    \value ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name
    \value ExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number
    \value ExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime
    \value ExclusiveDeviationAlarmType_ShelvingState_UnshelveTime
    \value ExclusiveDeviationAlarmType_ShelvingState_Unshelve
    \value ExclusiveDeviationAlarmType_ShelvingState_OneShotShelve
    \value ExclusiveDeviationAlarmType_ShelvingState_TimedShelve
    \value ExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments
    \value ExclusiveDeviationAlarmType_SuppressedOrShelved
    \value ExclusiveDeviationAlarmType_MaxTimeShelved
    \value ExclusiveDeviationAlarmType_LimitState
    \value ExclusiveDeviationAlarmType_LimitState_CurrentState
    \value ExclusiveDeviationAlarmType_LimitState_CurrentState_Id
    \value ExclusiveDeviationAlarmType_LimitState_CurrentState_Name
    \value ExclusiveDeviationAlarmType_LimitState_CurrentState_Number
    \value ExclusiveDeviationAlarmType_LimitState_CurrentState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_LimitState_LastTransition
    \value ExclusiveDeviationAlarmType_LimitState_LastTransition_Id
    \value ExclusiveDeviationAlarmType_LimitState_LastTransition_Name
    \value ExclusiveDeviationAlarmType_LimitState_LastTransition_Number
    \value ExclusiveDeviationAlarmType_LimitState_LastTransition_TransitionTime
    \value ExclusiveDeviationAlarmType_HighHighLimit
    \value ExclusiveDeviationAlarmType_HighLimit
    \value ExclusiveDeviationAlarmType_LowLimit
    \value ExclusiveDeviationAlarmType_LowLowLimit
    \value ExclusiveDeviationAlarmType_SetpointNode
    \value NonExclusiveLimitAlarmType
    \value NonExclusiveLimitAlarmType_EventId
    \value NonExclusiveLimitAlarmType_EventType
    \value NonExclusiveLimitAlarmType_SourceNode
    \value NonExclusiveLimitAlarmType_SourceName
    \value NonExclusiveLimitAlarmType_Time
    \value NonExclusiveLimitAlarmType_ReceiveTime
    \value NonExclusiveLimitAlarmType_LocalTime
    \value NonExclusiveLimitAlarmType_Message
    \value NonExclusiveLimitAlarmType_Severity
    \value NonExclusiveLimitAlarmType_ConditionName
    \value NonExclusiveLimitAlarmType_BranchId
    \value NonExclusiveLimitAlarmType_Retain
    \value NonExclusiveLimitAlarmType_EnabledState
    \value NonExclusiveLimitAlarmType_EnabledState_Id
    \value NonExclusiveLimitAlarmType_EnabledState_Name
    \value NonExclusiveLimitAlarmType_EnabledState_Number
    \value NonExclusiveLimitAlarmType_EnabledState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_EnabledState_TransitionTime
    \value NonExclusiveLimitAlarmType_EnabledState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_EnabledState_TrueState
    \value NonExclusiveLimitAlarmType_EnabledState_FalseState
    \value NonExclusiveLimitAlarmType_Quality
    \value NonExclusiveLimitAlarmType_Quality_SourceTimestamp
    \value NonExclusiveLimitAlarmType_LastSeverity
    \value NonExclusiveLimitAlarmType_LastSeverity_SourceTimestamp
    \value NonExclusiveLimitAlarmType_Comment
    \value NonExclusiveLimitAlarmType_Comment_SourceTimestamp
    \value NonExclusiveLimitAlarmType_ClientUserId
    \value NonExclusiveLimitAlarmType_Enable
    \value NonExclusiveLimitAlarmType_Disable
    \value NonExclusiveLimitAlarmType_AddComment
    \value NonExclusiveLimitAlarmType_AddComment_InputArguments
    \value NonExclusiveLimitAlarmType_ConditionRefresh
    \value NonExclusiveLimitAlarmType_ConditionRefresh_InputArguments
    \value NonExclusiveLimitAlarmType_AckedState
    \value NonExclusiveLimitAlarmType_AckedState_Id
    \value NonExclusiveLimitAlarmType_AckedState_Name
    \value NonExclusiveLimitAlarmType_AckedState_Number
    \value NonExclusiveLimitAlarmType_AckedState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_AckedState_TransitionTime
    \value NonExclusiveLimitAlarmType_AckedState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_AckedState_TrueState
    \value NonExclusiveLimitAlarmType_AckedState_FalseState
    \value NonExclusiveLimitAlarmType_ConfirmedState
    \value NonExclusiveLimitAlarmType_ConfirmedState_Id
    \value NonExclusiveLimitAlarmType_ConfirmedState_Name
    \value NonExclusiveLimitAlarmType_ConfirmedState_Number
    \value NonExclusiveLimitAlarmType_ConfirmedState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_ConfirmedState_TransitionTime
    \value NonExclusiveLimitAlarmType_ConfirmedState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_ConfirmedState_TrueState
    \value NonExclusiveLimitAlarmType_ConfirmedState_FalseState
    \value NonExclusiveLimitAlarmType_Acknowledge
    \value NonExclusiveLimitAlarmType_Acknowledge_InputArguments
    \value NonExclusiveLimitAlarmType_Confirm
    \value NonExclusiveLimitAlarmType_Confirm_InputArguments
    \value NonExclusiveLimitAlarmType_ActiveState
    \value NonExclusiveLimitAlarmType_ActiveState_Id
    \value NonExclusiveLimitAlarmType_ActiveState_Name
    \value NonExclusiveLimitAlarmType_ActiveState_Number
    \value NonExclusiveLimitAlarmType_ActiveState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_ActiveState_TransitionTime
    \value NonExclusiveLimitAlarmType_ActiveState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_ActiveState_TrueState
    \value NonExclusiveLimitAlarmType_ActiveState_FalseState
    \value NonExclusiveLimitAlarmType_SuppressedState
    \value NonExclusiveLimitAlarmType_SuppressedState_Id
    \value NonExclusiveLimitAlarmType_SuppressedState_Name
    \value NonExclusiveLimitAlarmType_SuppressedState_Number
    \value NonExclusiveLimitAlarmType_SuppressedState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_SuppressedState_TransitionTime
    \value NonExclusiveLimitAlarmType_SuppressedState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_SuppressedState_TrueState
    \value NonExclusiveLimitAlarmType_SuppressedState_FalseState
    \value NonExclusiveLimitAlarmType_ShelvingState
    \value NonExclusiveLimitAlarmType_ShelvingState_CurrentState
    \value NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Id
    \value NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Name
    \value NonExclusiveLimitAlarmType_ShelvingState_CurrentState_Number
    \value NonExclusiveLimitAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_ShelvingState_LastTransition
    \value NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Id
    \value NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Name
    \value NonExclusiveLimitAlarmType_ShelvingState_LastTransition_Number
    \value NonExclusiveLimitAlarmType_ShelvingState_LastTransition_TransitionTime
    \value NonExclusiveLimitAlarmType_ShelvingState_UnshelveTime
    \value NonExclusiveLimitAlarmType_ShelvingState_Unshelve
    \value NonExclusiveLimitAlarmType_ShelvingState_OneShotShelve
    \value NonExclusiveLimitAlarmType_ShelvingState_TimedShelve
    \value NonExclusiveLimitAlarmType_ShelvingState_TimedShelve_InputArguments
    \value NonExclusiveLimitAlarmType_SuppressedOrShelved
    \value NonExclusiveLimitAlarmType_MaxTimeShelved
    \value NonExclusiveLimitAlarmType_HighHighState
    \value NonExclusiveLimitAlarmType_HighHighState_Id
    \value NonExclusiveLimitAlarmType_HighHighState_Name
    \value NonExclusiveLimitAlarmType_HighHighState_Number
    \value NonExclusiveLimitAlarmType_HighHighState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_HighHighState_TransitionTime
    \value NonExclusiveLimitAlarmType_HighHighState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_HighHighState_TrueState
    \value NonExclusiveLimitAlarmType_HighHighState_FalseState
    \value NonExclusiveLimitAlarmType_HighState
    \value NonExclusiveLimitAlarmType_HighState_Id
    \value NonExclusiveLimitAlarmType_HighState_Name
    \value NonExclusiveLimitAlarmType_HighState_Number
    \value NonExclusiveLimitAlarmType_HighState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_HighState_TransitionTime
    \value NonExclusiveLimitAlarmType_HighState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_HighState_TrueState
    \value NonExclusiveLimitAlarmType_HighState_FalseState
    \value NonExclusiveLimitAlarmType_LowState
    \value NonExclusiveLimitAlarmType_LowState_Id
    \value NonExclusiveLimitAlarmType_LowState_Name
    \value NonExclusiveLimitAlarmType_LowState_Number
    \value NonExclusiveLimitAlarmType_LowState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_LowState_TransitionTime
    \value NonExclusiveLimitAlarmType_LowState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_LowState_TrueState
    \value NonExclusiveLimitAlarmType_LowState_FalseState
    \value NonExclusiveLimitAlarmType_LowLowState
    \value NonExclusiveLimitAlarmType_LowLowState_Id
    \value NonExclusiveLimitAlarmType_LowLowState_Name
    \value NonExclusiveLimitAlarmType_LowLowState_Number
    \value NonExclusiveLimitAlarmType_LowLowState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_LowLowState_TransitionTime
    \value NonExclusiveLimitAlarmType_LowLowState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_LowLowState_TrueState
    \value NonExclusiveLimitAlarmType_LowLowState_FalseState
    \value NonExclusiveLimitAlarmType_HighHighLimit
    \value NonExclusiveLimitAlarmType_HighLimit
    \value NonExclusiveLimitAlarmType_LowLimit
    \value NonExclusiveLimitAlarmType_LowLowLimit
    \value NonExclusiveLevelAlarmType
    \value NonExclusiveLevelAlarmType_EventId
    \value NonExclusiveLevelAlarmType_EventType
    \value NonExclusiveLevelAlarmType_SourceNode
    \value NonExclusiveLevelAlarmType_SourceName
    \value NonExclusiveLevelAlarmType_Time
    \value NonExclusiveLevelAlarmType_ReceiveTime
    \value NonExclusiveLevelAlarmType_LocalTime
    \value NonExclusiveLevelAlarmType_Message
    \value NonExclusiveLevelAlarmType_Severity
    \value NonExclusiveLevelAlarmType_ConditionName
    \value NonExclusiveLevelAlarmType_BranchId
    \value NonExclusiveLevelAlarmType_Retain
    \value NonExclusiveLevelAlarmType_EnabledState
    \value NonExclusiveLevelAlarmType_EnabledState_Id
    \value NonExclusiveLevelAlarmType_EnabledState_Name
    \value NonExclusiveLevelAlarmType_EnabledState_Number
    \value NonExclusiveLevelAlarmType_EnabledState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_EnabledState_TransitionTime
    \value NonExclusiveLevelAlarmType_EnabledState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_EnabledState_TrueState
    \value NonExclusiveLevelAlarmType_EnabledState_FalseState
    \value NonExclusiveLevelAlarmType_Quality
    \value NonExclusiveLevelAlarmType_Quality_SourceTimestamp
    \value NonExclusiveLevelAlarmType_LastSeverity
    \value NonExclusiveLevelAlarmType_LastSeverity_SourceTimestamp
    \value NonExclusiveLevelAlarmType_Comment
    \value NonExclusiveLevelAlarmType_Comment_SourceTimestamp
    \value NonExclusiveLevelAlarmType_ClientUserId
    \value NonExclusiveLevelAlarmType_Enable
    \value NonExclusiveLevelAlarmType_Disable
    \value NonExclusiveLevelAlarmType_AddComment
    \value NonExclusiveLevelAlarmType_AddComment_InputArguments
    \value NonExclusiveLevelAlarmType_ConditionRefresh
    \value NonExclusiveLevelAlarmType_ConditionRefresh_InputArguments
    \value NonExclusiveLevelAlarmType_AckedState
    \value NonExclusiveLevelAlarmType_AckedState_Id
    \value NonExclusiveLevelAlarmType_AckedState_Name
    \value NonExclusiveLevelAlarmType_AckedState_Number
    \value NonExclusiveLevelAlarmType_AckedState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_AckedState_TransitionTime
    \value NonExclusiveLevelAlarmType_AckedState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_AckedState_TrueState
    \value NonExclusiveLevelAlarmType_AckedState_FalseState
    \value NonExclusiveLevelAlarmType_ConfirmedState
    \value NonExclusiveLevelAlarmType_ConfirmedState_Id
    \value NonExclusiveLevelAlarmType_ConfirmedState_Name
    \value NonExclusiveLevelAlarmType_ConfirmedState_Number
    \value NonExclusiveLevelAlarmType_ConfirmedState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_ConfirmedState_TransitionTime
    \value NonExclusiveLevelAlarmType_ConfirmedState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_ConfirmedState_TrueState
    \value NonExclusiveLevelAlarmType_ConfirmedState_FalseState
    \value NonExclusiveLevelAlarmType_Acknowledge
    \value NonExclusiveLevelAlarmType_Acknowledge_InputArguments
    \value NonExclusiveLevelAlarmType_Confirm
    \value NonExclusiveLevelAlarmType_Confirm_InputArguments
    \value NonExclusiveLevelAlarmType_ActiveState
    \value NonExclusiveLevelAlarmType_ActiveState_Id
    \value NonExclusiveLevelAlarmType_ActiveState_Name
    \value NonExclusiveLevelAlarmType_ActiveState_Number
    \value NonExclusiveLevelAlarmType_ActiveState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_ActiveState_TransitionTime
    \value NonExclusiveLevelAlarmType_ActiveState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_ActiveState_TrueState
    \value NonExclusiveLevelAlarmType_ActiveState_FalseState
    \value NonExclusiveLevelAlarmType_SuppressedState
    \value NonExclusiveLevelAlarmType_SuppressedState_Id
    \value NonExclusiveLevelAlarmType_SuppressedState_Name
    \value NonExclusiveLevelAlarmType_SuppressedState_Number
    \value NonExclusiveLevelAlarmType_SuppressedState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_SuppressedState_TransitionTime
    \value NonExclusiveLevelAlarmType_SuppressedState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_SuppressedState_TrueState
    \value NonExclusiveLevelAlarmType_SuppressedState_FalseState
    \value NonExclusiveLevelAlarmType_ShelvingState
    \value NonExclusiveLevelAlarmType_ShelvingState_CurrentState
    \value NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Id
    \value NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Name
    \value NonExclusiveLevelAlarmType_ShelvingState_CurrentState_Number
    \value NonExclusiveLevelAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_ShelvingState_LastTransition
    \value NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Id
    \value NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Name
    \value NonExclusiveLevelAlarmType_ShelvingState_LastTransition_Number
    \value NonExclusiveLevelAlarmType_ShelvingState_LastTransition_TransitionTime
    \value NonExclusiveLevelAlarmType_ShelvingState_UnshelveTime
    \value NonExclusiveLevelAlarmType_ShelvingState_Unshelve
    \value NonExclusiveLevelAlarmType_ShelvingState_OneShotShelve
    \value NonExclusiveLevelAlarmType_ShelvingState_TimedShelve
    \value NonExclusiveLevelAlarmType_ShelvingState_TimedShelve_InputArguments
    \value NonExclusiveLevelAlarmType_SuppressedOrShelved
    \value NonExclusiveLevelAlarmType_MaxTimeShelved
    \value NonExclusiveLevelAlarmType_HighHighState
    \value NonExclusiveLevelAlarmType_HighHighState_Id
    \value NonExclusiveLevelAlarmType_HighHighState_Name
    \value NonExclusiveLevelAlarmType_HighHighState_Number
    \value NonExclusiveLevelAlarmType_HighHighState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_HighHighState_TransitionTime
    \value NonExclusiveLevelAlarmType_HighHighState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_HighHighState_TrueState
    \value NonExclusiveLevelAlarmType_HighHighState_FalseState
    \value NonExclusiveLevelAlarmType_HighState
    \value NonExclusiveLevelAlarmType_HighState_Id
    \value NonExclusiveLevelAlarmType_HighState_Name
    \value NonExclusiveLevelAlarmType_HighState_Number
    \value NonExclusiveLevelAlarmType_HighState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_HighState_TransitionTime
    \value NonExclusiveLevelAlarmType_HighState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_HighState_TrueState
    \value NonExclusiveLevelAlarmType_HighState_FalseState
    \value NonExclusiveLevelAlarmType_LowState
    \value NonExclusiveLevelAlarmType_LowState_Id
    \value NonExclusiveLevelAlarmType_LowState_Name
    \value NonExclusiveLevelAlarmType_LowState_Number
    \value NonExclusiveLevelAlarmType_LowState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_LowState_TransitionTime
    \value NonExclusiveLevelAlarmType_LowState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_LowState_TrueState
    \value NonExclusiveLevelAlarmType_LowState_FalseState
    \value NonExclusiveLevelAlarmType_LowLowState
    \value NonExclusiveLevelAlarmType_LowLowState_Id
    \value NonExclusiveLevelAlarmType_LowLowState_Name
    \value NonExclusiveLevelAlarmType_LowLowState_Number
    \value NonExclusiveLevelAlarmType_LowLowState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_LowLowState_TransitionTime
    \value NonExclusiveLevelAlarmType_LowLowState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_LowLowState_TrueState
    \value NonExclusiveLevelAlarmType_LowLowState_FalseState
    \value NonExclusiveLevelAlarmType_HighHighLimit
    \value NonExclusiveLevelAlarmType_HighLimit
    \value NonExclusiveLevelAlarmType_LowLimit
    \value NonExclusiveLevelAlarmType_LowLowLimit
    \value NonExclusiveRateOfChangeAlarmType
    \value NonExclusiveRateOfChangeAlarmType_EventId
    \value NonExclusiveRateOfChangeAlarmType_EventType
    \value NonExclusiveRateOfChangeAlarmType_SourceNode
    \value NonExclusiveRateOfChangeAlarmType_SourceName
    \value NonExclusiveRateOfChangeAlarmType_Time
    \value NonExclusiveRateOfChangeAlarmType_ReceiveTime
    \value NonExclusiveRateOfChangeAlarmType_LocalTime
    \value NonExclusiveRateOfChangeAlarmType_Message
    \value NonExclusiveRateOfChangeAlarmType_Severity
    \value NonExclusiveRateOfChangeAlarmType_ConditionName
    \value NonExclusiveRateOfChangeAlarmType_BranchId
    \value NonExclusiveRateOfChangeAlarmType_Retain
    \value NonExclusiveRateOfChangeAlarmType_EnabledState
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_Id
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_Name
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_Number
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_EnabledState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_Quality
    \value NonExclusiveRateOfChangeAlarmType_Quality_SourceTimestamp
    \value NonExclusiveRateOfChangeAlarmType_LastSeverity
    \value NonExclusiveRateOfChangeAlarmType_LastSeverity_SourceTimestamp
    \value NonExclusiveRateOfChangeAlarmType_Comment
    \value NonExclusiveRateOfChangeAlarmType_Comment_SourceTimestamp
    \value NonExclusiveRateOfChangeAlarmType_ClientUserId
    \value NonExclusiveRateOfChangeAlarmType_Enable
    \value NonExclusiveRateOfChangeAlarmType_Disable
    \value NonExclusiveRateOfChangeAlarmType_AddComment
    \value NonExclusiveRateOfChangeAlarmType_AddComment_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_ConditionRefresh
    \value NonExclusiveRateOfChangeAlarmType_ConditionRefresh_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_AckedState
    \value NonExclusiveRateOfChangeAlarmType_AckedState_Id
    \value NonExclusiveRateOfChangeAlarmType_AckedState_Name
    \value NonExclusiveRateOfChangeAlarmType_AckedState_Number
    \value NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_AckedState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_AckedState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_AckedState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_AckedState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_Id
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_Name
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_Number
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_ConfirmedState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_Acknowledge
    \value NonExclusiveRateOfChangeAlarmType_Acknowledge_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_Confirm
    \value NonExclusiveRateOfChangeAlarmType_Confirm_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_ActiveState
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_Id
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_Name
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_Number
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_ActiveState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_Id
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_Name
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_Number
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_SuppressedState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Id
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Name
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_Number
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Id
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Name
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_Number
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_UnshelveTime
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_Unshelve
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_OneShotShelve
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_TimedShelve_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_SuppressedOrShelved
    \value NonExclusiveRateOfChangeAlarmType_MaxTimeShelved
    \value NonExclusiveRateOfChangeAlarmType_HighHighState
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_Id
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_Name
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_Number
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_HighHighState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_HighState
    \value NonExclusiveRateOfChangeAlarmType_HighState_Id
    \value NonExclusiveRateOfChangeAlarmType_HighState_Name
    \value NonExclusiveRateOfChangeAlarmType_HighState_Number
    \value NonExclusiveRateOfChangeAlarmType_HighState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_HighState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_HighState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_HighState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_HighState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_LowState
    \value NonExclusiveRateOfChangeAlarmType_LowState_Id
    \value NonExclusiveRateOfChangeAlarmType_LowState_Name
    \value NonExclusiveRateOfChangeAlarmType_LowState_Number
    \value NonExclusiveRateOfChangeAlarmType_LowState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_LowState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_LowState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_LowState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_LowState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_LowLowState
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_Id
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_Name
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_Number
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_LowLowState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_HighHighLimit
    \value NonExclusiveRateOfChangeAlarmType_HighLimit
    \value NonExclusiveRateOfChangeAlarmType_LowLimit
    \value NonExclusiveRateOfChangeAlarmType_LowLowLimit
    \value NonExclusiveDeviationAlarmType
    \value NonExclusiveDeviationAlarmType_EventId
    \value NonExclusiveDeviationAlarmType_EventType
    \value NonExclusiveDeviationAlarmType_SourceNode
    \value NonExclusiveDeviationAlarmType_SourceName
    \value NonExclusiveDeviationAlarmType_Time
    \value NonExclusiveDeviationAlarmType_ReceiveTime
    \value NonExclusiveDeviationAlarmType_LocalTime
    \value NonExclusiveDeviationAlarmType_Message
    \value NonExclusiveDeviationAlarmType_Severity
    \value NonExclusiveDeviationAlarmType_ConditionName
    \value NonExclusiveDeviationAlarmType_BranchId
    \value NonExclusiveDeviationAlarmType_Retain
    \value NonExclusiveDeviationAlarmType_EnabledState
    \value NonExclusiveDeviationAlarmType_EnabledState_Id
    \value NonExclusiveDeviationAlarmType_EnabledState_Name
    \value NonExclusiveDeviationAlarmType_EnabledState_Number
    \value NonExclusiveDeviationAlarmType_EnabledState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_EnabledState_TransitionTime
    \value NonExclusiveDeviationAlarmType_EnabledState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_EnabledState_TrueState
    \value NonExclusiveDeviationAlarmType_EnabledState_FalseState
    \value NonExclusiveDeviationAlarmType_Quality
    \value NonExclusiveDeviationAlarmType_Quality_SourceTimestamp
    \value NonExclusiveDeviationAlarmType_LastSeverity
    \value NonExclusiveDeviationAlarmType_LastSeverity_SourceTimestamp
    \value NonExclusiveDeviationAlarmType_Comment
    \value NonExclusiveDeviationAlarmType_Comment_SourceTimestamp
    \value NonExclusiveDeviationAlarmType_ClientUserId
    \value NonExclusiveDeviationAlarmType_Enable
    \value NonExclusiveDeviationAlarmType_Disable
    \value NonExclusiveDeviationAlarmType_AddComment
    \value NonExclusiveDeviationAlarmType_AddComment_InputArguments
    \value NonExclusiveDeviationAlarmType_ConditionRefresh
    \value NonExclusiveDeviationAlarmType_ConditionRefresh_InputArguments
    \value NonExclusiveDeviationAlarmType_AckedState
    \value NonExclusiveDeviationAlarmType_AckedState_Id
    \value NonExclusiveDeviationAlarmType_AckedState_Name
    \value NonExclusiveDeviationAlarmType_AckedState_Number
    \value NonExclusiveDeviationAlarmType_AckedState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_AckedState_TransitionTime
    \value NonExclusiveDeviationAlarmType_AckedState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_AckedState_TrueState
    \value NonExclusiveDeviationAlarmType_AckedState_FalseState
    \value NonExclusiveDeviationAlarmType_ConfirmedState
    \value NonExclusiveDeviationAlarmType_ConfirmedState_Id
    \value NonExclusiveDeviationAlarmType_ConfirmedState_Name
    \value NonExclusiveDeviationAlarmType_ConfirmedState_Number
    \value NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_ConfirmedState_TransitionTime
    \value NonExclusiveDeviationAlarmType_ConfirmedState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_ConfirmedState_TrueState
    \value NonExclusiveDeviationAlarmType_ConfirmedState_FalseState
    \value NonExclusiveDeviationAlarmType_Acknowledge
    \value NonExclusiveDeviationAlarmType_Acknowledge_InputArguments
    \value NonExclusiveDeviationAlarmType_Confirm
    \value NonExclusiveDeviationAlarmType_Confirm_InputArguments
    \value NonExclusiveDeviationAlarmType_ActiveState
    \value NonExclusiveDeviationAlarmType_ActiveState_Id
    \value NonExclusiveDeviationAlarmType_ActiveState_Name
    \value NonExclusiveDeviationAlarmType_ActiveState_Number
    \value NonExclusiveDeviationAlarmType_ActiveState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_ActiveState_TransitionTime
    \value NonExclusiveDeviationAlarmType_ActiveState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_ActiveState_TrueState
    \value NonExclusiveDeviationAlarmType_ActiveState_FalseState
    \value NonExclusiveDeviationAlarmType_SuppressedState
    \value NonExclusiveDeviationAlarmType_SuppressedState_Id
    \value NonExclusiveDeviationAlarmType_SuppressedState_Name
    \value NonExclusiveDeviationAlarmType_SuppressedState_Number
    \value NonExclusiveDeviationAlarmType_SuppressedState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_SuppressedState_TransitionTime
    \value NonExclusiveDeviationAlarmType_SuppressedState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_SuppressedState_TrueState
    \value NonExclusiveDeviationAlarmType_SuppressedState_FalseState
    \value NonExclusiveDeviationAlarmType_ShelvingState
    \value NonExclusiveDeviationAlarmType_ShelvingState_CurrentState
    \value NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Id
    \value NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Name
    \value NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_Number
    \value NonExclusiveDeviationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_ShelvingState_LastTransition
    \value NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Id
    \value NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Name
    \value NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_Number
    \value NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_TransitionTime
    \value NonExclusiveDeviationAlarmType_ShelvingState_UnshelveTime
    \value NonExclusiveDeviationAlarmType_ShelvingState_Unshelve
    \value NonExclusiveDeviationAlarmType_ShelvingState_OneShotShelve
    \value NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve
    \value NonExclusiveDeviationAlarmType_ShelvingState_TimedShelve_InputArguments
    \value NonExclusiveDeviationAlarmType_SuppressedOrShelved
    \value NonExclusiveDeviationAlarmType_MaxTimeShelved
    \value NonExclusiveDeviationAlarmType_HighHighState
    \value NonExclusiveDeviationAlarmType_HighHighState_Id
    \value NonExclusiveDeviationAlarmType_HighHighState_Name
    \value NonExclusiveDeviationAlarmType_HighHighState_Number
    \value NonExclusiveDeviationAlarmType_HighHighState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_HighHighState_TransitionTime
    \value NonExclusiveDeviationAlarmType_HighHighState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_HighHighState_TrueState
    \value NonExclusiveDeviationAlarmType_HighHighState_FalseState
    \value NonExclusiveDeviationAlarmType_HighState
    \value NonExclusiveDeviationAlarmType_HighState_Id
    \value NonExclusiveDeviationAlarmType_HighState_Name
    \value NonExclusiveDeviationAlarmType_HighState_Number
    \value NonExclusiveDeviationAlarmType_HighState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_HighState_TransitionTime
    \value NonExclusiveDeviationAlarmType_HighState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_HighState_TrueState
    \value NonExclusiveDeviationAlarmType_HighState_FalseState
    \value NonExclusiveDeviationAlarmType_LowState
    \value NonExclusiveDeviationAlarmType_LowState_Id
    \value NonExclusiveDeviationAlarmType_LowState_Name
    \value NonExclusiveDeviationAlarmType_LowState_Number
    \value NonExclusiveDeviationAlarmType_LowState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_LowState_TransitionTime
    \value NonExclusiveDeviationAlarmType_LowState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_LowState_TrueState
    \value NonExclusiveDeviationAlarmType_LowState_FalseState
    \value NonExclusiveDeviationAlarmType_LowLowState
    \value NonExclusiveDeviationAlarmType_LowLowState_Id
    \value NonExclusiveDeviationAlarmType_LowLowState_Name
    \value NonExclusiveDeviationAlarmType_LowLowState_Number
    \value NonExclusiveDeviationAlarmType_LowLowState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_LowLowState_TransitionTime
    \value NonExclusiveDeviationAlarmType_LowLowState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_LowLowState_TrueState
    \value NonExclusiveDeviationAlarmType_LowLowState_FalseState
    \value NonExclusiveDeviationAlarmType_HighHighLimit
    \value NonExclusiveDeviationAlarmType_HighLimit
    \value NonExclusiveDeviationAlarmType_LowLimit
    \value NonExclusiveDeviationAlarmType_LowLowLimit
    \value NonExclusiveDeviationAlarmType_SetpointNode
    \value DiscreteAlarmType
    \value DiscreteAlarmType_EventId
    \value DiscreteAlarmType_EventType
    \value DiscreteAlarmType_SourceNode
    \value DiscreteAlarmType_SourceName
    \value DiscreteAlarmType_Time
    \value DiscreteAlarmType_ReceiveTime
    \value DiscreteAlarmType_LocalTime
    \value DiscreteAlarmType_Message
    \value DiscreteAlarmType_Severity
    \value DiscreteAlarmType_ConditionName
    \value DiscreteAlarmType_BranchId
    \value DiscreteAlarmType_Retain
    \value DiscreteAlarmType_EnabledState
    \value DiscreteAlarmType_EnabledState_Id
    \value DiscreteAlarmType_EnabledState_Name
    \value DiscreteAlarmType_EnabledState_Number
    \value DiscreteAlarmType_EnabledState_EffectiveDisplayName
    \value DiscreteAlarmType_EnabledState_TransitionTime
    \value DiscreteAlarmType_EnabledState_EffectiveTransitionTime
    \value DiscreteAlarmType_EnabledState_TrueState
    \value DiscreteAlarmType_EnabledState_FalseState
    \value DiscreteAlarmType_Quality
    \value DiscreteAlarmType_Quality_SourceTimestamp
    \value DiscreteAlarmType_LastSeverity
    \value DiscreteAlarmType_LastSeverity_SourceTimestamp
    \value DiscreteAlarmType_Comment
    \value DiscreteAlarmType_Comment_SourceTimestamp
    \value DiscreteAlarmType_ClientUserId
    \value DiscreteAlarmType_Enable
    \value DiscreteAlarmType_Disable
    \value DiscreteAlarmType_AddComment
    \value DiscreteAlarmType_AddComment_InputArguments
    \value DiscreteAlarmType_ConditionRefresh
    \value DiscreteAlarmType_ConditionRefresh_InputArguments
    \value DiscreteAlarmType_AckedState
    \value DiscreteAlarmType_AckedState_Id
    \value DiscreteAlarmType_AckedState_Name
    \value DiscreteAlarmType_AckedState_Number
    \value DiscreteAlarmType_AckedState_EffectiveDisplayName
    \value DiscreteAlarmType_AckedState_TransitionTime
    \value DiscreteAlarmType_AckedState_EffectiveTransitionTime
    \value DiscreteAlarmType_AckedState_TrueState
    \value DiscreteAlarmType_AckedState_FalseState
    \value DiscreteAlarmType_ConfirmedState
    \value DiscreteAlarmType_ConfirmedState_Id
    \value DiscreteAlarmType_ConfirmedState_Name
    \value DiscreteAlarmType_ConfirmedState_Number
    \value DiscreteAlarmType_ConfirmedState_EffectiveDisplayName
    \value DiscreteAlarmType_ConfirmedState_TransitionTime
    \value DiscreteAlarmType_ConfirmedState_EffectiveTransitionTime
    \value DiscreteAlarmType_ConfirmedState_TrueState
    \value DiscreteAlarmType_ConfirmedState_FalseState
    \value DiscreteAlarmType_Acknowledge
    \value DiscreteAlarmType_Acknowledge_InputArguments
    \value DiscreteAlarmType_Confirm
    \value DiscreteAlarmType_Confirm_InputArguments
    \value DiscreteAlarmType_ActiveState
    \value DiscreteAlarmType_ActiveState_Id
    \value DiscreteAlarmType_ActiveState_Name
    \value DiscreteAlarmType_ActiveState_Number
    \value DiscreteAlarmType_ActiveState_EffectiveDisplayName
    \value DiscreteAlarmType_ActiveState_TransitionTime
    \value DiscreteAlarmType_ActiveState_EffectiveTransitionTime
    \value DiscreteAlarmType_ActiveState_TrueState
    \value DiscreteAlarmType_ActiveState_FalseState
    \value DiscreteAlarmType_SuppressedState
    \value DiscreteAlarmType_SuppressedState_Id
    \value DiscreteAlarmType_SuppressedState_Name
    \value DiscreteAlarmType_SuppressedState_Number
    \value DiscreteAlarmType_SuppressedState_EffectiveDisplayName
    \value DiscreteAlarmType_SuppressedState_TransitionTime
    \value DiscreteAlarmType_SuppressedState_EffectiveTransitionTime
    \value DiscreteAlarmType_SuppressedState_TrueState
    \value DiscreteAlarmType_SuppressedState_FalseState
    \value DiscreteAlarmType_ShelvingState
    \value DiscreteAlarmType_ShelvingState_CurrentState
    \value DiscreteAlarmType_ShelvingState_CurrentState_Id
    \value DiscreteAlarmType_ShelvingState_CurrentState_Name
    \value DiscreteAlarmType_ShelvingState_CurrentState_Number
    \value DiscreteAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value DiscreteAlarmType_ShelvingState_LastTransition
    \value DiscreteAlarmType_ShelvingState_LastTransition_Id
    \value DiscreteAlarmType_ShelvingState_LastTransition_Name
    \value DiscreteAlarmType_ShelvingState_LastTransition_Number
    \value DiscreteAlarmType_ShelvingState_LastTransition_TransitionTime
    \value DiscreteAlarmType_ShelvingState_UnshelveTime
    \value DiscreteAlarmType_ShelvingState_Unshelve
    \value DiscreteAlarmType_ShelvingState_OneShotShelve
    \value DiscreteAlarmType_ShelvingState_TimedShelve
    \value DiscreteAlarmType_ShelvingState_TimedShelve_InputArguments
    \value DiscreteAlarmType_SuppressedOrShelved
    \value DiscreteAlarmType_MaxTimeShelved
    \value OffNormalAlarmType
    \value OffNormalAlarmType_EventId
    \value OffNormalAlarmType_EventType
    \value OffNormalAlarmType_SourceNode
    \value OffNormalAlarmType_SourceName
    \value OffNormalAlarmType_Time
    \value OffNormalAlarmType_ReceiveTime
    \value OffNormalAlarmType_LocalTime
    \value OffNormalAlarmType_Message
    \value OffNormalAlarmType_Severity
    \value OffNormalAlarmType_ConditionName
    \value OffNormalAlarmType_BranchId
    \value OffNormalAlarmType_Retain
    \value OffNormalAlarmType_EnabledState
    \value OffNormalAlarmType_EnabledState_Id
    \value OffNormalAlarmType_EnabledState_Name
    \value OffNormalAlarmType_EnabledState_Number
    \value OffNormalAlarmType_EnabledState_EffectiveDisplayName
    \value OffNormalAlarmType_EnabledState_TransitionTime
    \value OffNormalAlarmType_EnabledState_EffectiveTransitionTime
    \value OffNormalAlarmType_EnabledState_TrueState
    \value OffNormalAlarmType_EnabledState_FalseState
    \value OffNormalAlarmType_Quality
    \value OffNormalAlarmType_Quality_SourceTimestamp
    \value OffNormalAlarmType_LastSeverity
    \value OffNormalAlarmType_LastSeverity_SourceTimestamp
    \value OffNormalAlarmType_Comment
    \value OffNormalAlarmType_Comment_SourceTimestamp
    \value OffNormalAlarmType_ClientUserId
    \value OffNormalAlarmType_Enable
    \value OffNormalAlarmType_Disable
    \value OffNormalAlarmType_AddComment
    \value OffNormalAlarmType_AddComment_InputArguments
    \value OffNormalAlarmType_ConditionRefresh
    \value OffNormalAlarmType_ConditionRefresh_InputArguments
    \value OffNormalAlarmType_AckedState
    \value OffNormalAlarmType_AckedState_Id
    \value OffNormalAlarmType_AckedState_Name
    \value OffNormalAlarmType_AckedState_Number
    \value OffNormalAlarmType_AckedState_EffectiveDisplayName
    \value OffNormalAlarmType_AckedState_TransitionTime
    \value OffNormalAlarmType_AckedState_EffectiveTransitionTime
    \value OffNormalAlarmType_AckedState_TrueState
    \value OffNormalAlarmType_AckedState_FalseState
    \value OffNormalAlarmType_ConfirmedState
    \value OffNormalAlarmType_ConfirmedState_Id
    \value OffNormalAlarmType_ConfirmedState_Name
    \value OffNormalAlarmType_ConfirmedState_Number
    \value OffNormalAlarmType_ConfirmedState_EffectiveDisplayName
    \value OffNormalAlarmType_ConfirmedState_TransitionTime
    \value OffNormalAlarmType_ConfirmedState_EffectiveTransitionTime
    \value OffNormalAlarmType_ConfirmedState_TrueState
    \value OffNormalAlarmType_ConfirmedState_FalseState
    \value OffNormalAlarmType_Acknowledge
    \value OffNormalAlarmType_Acknowledge_InputArguments
    \value OffNormalAlarmType_Confirm
    \value OffNormalAlarmType_Confirm_InputArguments
    \value OffNormalAlarmType_ActiveState
    \value OffNormalAlarmType_ActiveState_Id
    \value OffNormalAlarmType_ActiveState_Name
    \value OffNormalAlarmType_ActiveState_Number
    \value OffNormalAlarmType_ActiveState_EffectiveDisplayName
    \value OffNormalAlarmType_ActiveState_TransitionTime
    \value OffNormalAlarmType_ActiveState_EffectiveTransitionTime
    \value OffNormalAlarmType_ActiveState_TrueState
    \value OffNormalAlarmType_ActiveState_FalseState
    \value OffNormalAlarmType_SuppressedState
    \value OffNormalAlarmType_SuppressedState_Id
    \value OffNormalAlarmType_SuppressedState_Name
    \value OffNormalAlarmType_SuppressedState_Number
    \value OffNormalAlarmType_SuppressedState_EffectiveDisplayName
    \value OffNormalAlarmType_SuppressedState_TransitionTime
    \value OffNormalAlarmType_SuppressedState_EffectiveTransitionTime
    \value OffNormalAlarmType_SuppressedState_TrueState
    \value OffNormalAlarmType_SuppressedState_FalseState
    \value OffNormalAlarmType_ShelvingState
    \value OffNormalAlarmType_ShelvingState_CurrentState
    \value OffNormalAlarmType_ShelvingState_CurrentState_Id
    \value OffNormalAlarmType_ShelvingState_CurrentState_Name
    \value OffNormalAlarmType_ShelvingState_CurrentState_Number
    \value OffNormalAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value OffNormalAlarmType_ShelvingState_LastTransition
    \value OffNormalAlarmType_ShelvingState_LastTransition_Id
    \value OffNormalAlarmType_ShelvingState_LastTransition_Name
    \value OffNormalAlarmType_ShelvingState_LastTransition_Number
    \value OffNormalAlarmType_ShelvingState_LastTransition_TransitionTime
    \value OffNormalAlarmType_ShelvingState_UnshelveTime
    \value OffNormalAlarmType_ShelvingState_Unshelve
    \value OffNormalAlarmType_ShelvingState_OneShotShelve
    \value OffNormalAlarmType_ShelvingState_TimedShelve
    \value OffNormalAlarmType_ShelvingState_TimedShelve_InputArguments
    \value OffNormalAlarmType_SuppressedOrShelved
    \value OffNormalAlarmType_MaxTimeShelved
    \value TripAlarmType
    \value TripAlarmType_EventId
    \value TripAlarmType_EventType
    \value TripAlarmType_SourceNode
    \value TripAlarmType_SourceName
    \value TripAlarmType_Time
    \value TripAlarmType_ReceiveTime
    \value TripAlarmType_LocalTime
    \value TripAlarmType_Message
    \value TripAlarmType_Severity
    \value TripAlarmType_ConditionName
    \value TripAlarmType_BranchId
    \value TripAlarmType_Retain
    \value TripAlarmType_EnabledState
    \value TripAlarmType_EnabledState_Id
    \value TripAlarmType_EnabledState_Name
    \value TripAlarmType_EnabledState_Number
    \value TripAlarmType_EnabledState_EffectiveDisplayName
    \value TripAlarmType_EnabledState_TransitionTime
    \value TripAlarmType_EnabledState_EffectiveTransitionTime
    \value TripAlarmType_EnabledState_TrueState
    \value TripAlarmType_EnabledState_FalseState
    \value TripAlarmType_Quality
    \value TripAlarmType_Quality_SourceTimestamp
    \value TripAlarmType_LastSeverity
    \value TripAlarmType_LastSeverity_SourceTimestamp
    \value TripAlarmType_Comment
    \value TripAlarmType_Comment_SourceTimestamp
    \value TripAlarmType_ClientUserId
    \value TripAlarmType_Enable
    \value TripAlarmType_Disable
    \value TripAlarmType_AddComment
    \value TripAlarmType_AddComment_InputArguments
    \value TripAlarmType_ConditionRefresh
    \value TripAlarmType_ConditionRefresh_InputArguments
    \value TripAlarmType_AckedState
    \value TripAlarmType_AckedState_Id
    \value TripAlarmType_AckedState_Name
    \value TripAlarmType_AckedState_Number
    \value TripAlarmType_AckedState_EffectiveDisplayName
    \value TripAlarmType_AckedState_TransitionTime
    \value TripAlarmType_AckedState_EffectiveTransitionTime
    \value TripAlarmType_AckedState_TrueState
    \value TripAlarmType_AckedState_FalseState
    \value TripAlarmType_ConfirmedState
    \value TripAlarmType_ConfirmedState_Id
    \value TripAlarmType_ConfirmedState_Name
    \value TripAlarmType_ConfirmedState_Number
    \value TripAlarmType_ConfirmedState_EffectiveDisplayName
    \value TripAlarmType_ConfirmedState_TransitionTime
    \value TripAlarmType_ConfirmedState_EffectiveTransitionTime
    \value TripAlarmType_ConfirmedState_TrueState
    \value TripAlarmType_ConfirmedState_FalseState
    \value TripAlarmType_Acknowledge
    \value TripAlarmType_Acknowledge_InputArguments
    \value TripAlarmType_Confirm
    \value TripAlarmType_Confirm_InputArguments
    \value TripAlarmType_ActiveState
    \value TripAlarmType_ActiveState_Id
    \value TripAlarmType_ActiveState_Name
    \value TripAlarmType_ActiveState_Number
    \value TripAlarmType_ActiveState_EffectiveDisplayName
    \value TripAlarmType_ActiveState_TransitionTime
    \value TripAlarmType_ActiveState_EffectiveTransitionTime
    \value TripAlarmType_ActiveState_TrueState
    \value TripAlarmType_ActiveState_FalseState
    \value TripAlarmType_SuppressedState
    \value TripAlarmType_SuppressedState_Id
    \value TripAlarmType_SuppressedState_Name
    \value TripAlarmType_SuppressedState_Number
    \value TripAlarmType_SuppressedState_EffectiveDisplayName
    \value TripAlarmType_SuppressedState_TransitionTime
    \value TripAlarmType_SuppressedState_EffectiveTransitionTime
    \value TripAlarmType_SuppressedState_TrueState
    \value TripAlarmType_SuppressedState_FalseState
    \value TripAlarmType_ShelvingState
    \value TripAlarmType_ShelvingState_CurrentState
    \value TripAlarmType_ShelvingState_CurrentState_Id
    \value TripAlarmType_ShelvingState_CurrentState_Name
    \value TripAlarmType_ShelvingState_CurrentState_Number
    \value TripAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value TripAlarmType_ShelvingState_LastTransition
    \value TripAlarmType_ShelvingState_LastTransition_Id
    \value TripAlarmType_ShelvingState_LastTransition_Name
    \value TripAlarmType_ShelvingState_LastTransition_Number
    \value TripAlarmType_ShelvingState_LastTransition_TransitionTime
    \value TripAlarmType_ShelvingState_UnshelveTime
    \value TripAlarmType_ShelvingState_Unshelve
    \value TripAlarmType_ShelvingState_OneShotShelve
    \value TripAlarmType_ShelvingState_TimedShelve
    \value TripAlarmType_ShelvingState_TimedShelve_InputArguments
    \value TripAlarmType_SuppressedOrShelved
    \value TripAlarmType_MaxTimeShelved
    \value AuditConditionShelvingEventType
    \value AuditConditionShelvingEventType_EventId
    \value AuditConditionShelvingEventType_EventType
    \value AuditConditionShelvingEventType_SourceNode
    \value AuditConditionShelvingEventType_SourceName
    \value AuditConditionShelvingEventType_Time
    \value AuditConditionShelvingEventType_ReceiveTime
    \value AuditConditionShelvingEventType_LocalTime
    \value AuditConditionShelvingEventType_Message
    \value AuditConditionShelvingEventType_Severity
    \value AuditConditionShelvingEventType_ActionTimeStamp
    \value AuditConditionShelvingEventType_Status
    \value AuditConditionShelvingEventType_ServerId
    \value AuditConditionShelvingEventType_ClientAuditEntryId
    \value AuditConditionShelvingEventType_ClientUserId
    \value AuditConditionShelvingEventType_MethodId
    \value AuditConditionShelvingEventType_InputArguments
    \value TwoStateVariableType_TrueState
    \value TwoStateVariableType_FalseState
    \value ConditionType_ConditionClassId
    \value ConditionType_ConditionClassName
    \value DialogConditionType_ConditionClassId
    \value DialogConditionType_ConditionClassName
    \value AcknowledgeableConditionType_ConditionClassId
    \value AcknowledgeableConditionType_ConditionClassName
    \value AlarmConditionType_ConditionClassId
    \value AlarmConditionType_ConditionClassName
    \value AlarmConditionType_InputNode
    \value LimitAlarmType_ConditionClassId
    \value LimitAlarmType_ConditionClassName
    \value LimitAlarmType_InputNode
    \value LimitAlarmType_HighHighLimit
    \value LimitAlarmType_HighLimit
    \value LimitAlarmType_LowLimit
    \value LimitAlarmType_LowLowLimit
    \value ExclusiveLimitAlarmType_ConditionClassId
    \value ExclusiveLimitAlarmType_ConditionClassName
    \value ExclusiveLimitAlarmType_InputNode
    \value ExclusiveLevelAlarmType_ConditionClassId
    \value ExclusiveLevelAlarmType_ConditionClassName
    \value ExclusiveLevelAlarmType_InputNode
    \value ExclusiveRateOfChangeAlarmType_ConditionClassId
    \value ExclusiveRateOfChangeAlarmType_ConditionClassName
    \value ExclusiveRateOfChangeAlarmType_InputNode
    \value ExclusiveDeviationAlarmType_ConditionClassId
    \value ExclusiveDeviationAlarmType_ConditionClassName
    \value ExclusiveDeviationAlarmType_InputNode
    \value NonExclusiveLimitAlarmType_ConditionClassId
    \value NonExclusiveLimitAlarmType_ConditionClassName
    \value NonExclusiveLimitAlarmType_InputNode
    \value NonExclusiveLevelAlarmType_ConditionClassId
    \value NonExclusiveLevelAlarmType_ConditionClassName
    \value NonExclusiveLevelAlarmType_InputNode
    \value NonExclusiveRateOfChangeAlarmType_ConditionClassId
    \value NonExclusiveRateOfChangeAlarmType_ConditionClassName
    \value NonExclusiveRateOfChangeAlarmType_InputNode
    \value NonExclusiveDeviationAlarmType_ConditionClassId
    \value NonExclusiveDeviationAlarmType_ConditionClassName
    \value NonExclusiveDeviationAlarmType_InputNode
    \value DiscreteAlarmType_ConditionClassId
    \value DiscreteAlarmType_ConditionClassName
    \value DiscreteAlarmType_InputNode
    \value OffNormalAlarmType_ConditionClassId
    \value OffNormalAlarmType_ConditionClassName
    \value OffNormalAlarmType_InputNode
    \value OffNormalAlarmType_NormalState
    \value TripAlarmType_ConditionClassId
    \value TripAlarmType_ConditionClassName
    \value TripAlarmType_InputNode
    \value TripAlarmType_NormalState
    \value BaseConditionClassType
    \value ProcessConditionClassType
    \value MaintenanceConditionClassType
    \value SystemConditionClassType
    \value HistoricalDataConfigurationType_AggregateConfiguration_TreatUncertainAsBad
    \value HistoricalDataConfigurationType_AggregateConfiguration_PercentDataBad
    \value HistoricalDataConfigurationType_AggregateConfiguration_PercentDataGood
    \value HistoricalDataConfigurationType_AggregateConfiguration_UseSlopedExtrapolation
    \value HistoryServerCapabilitiesType_AggregateFunctions
    \value AggregateConfigurationType
    \value AggregateConfigurationType_TreatUncertainAsBad
    \value AggregateConfigurationType_PercentDataBad
    \value AggregateConfigurationType_PercentDataGood
    \value AggregateConfigurationType_UseSlopedExtrapolation
    \value HistoryServerCapabilities
    \value HistoryServerCapabilities_AccessHistoryDataCapability
    \value HistoryServerCapabilities_InsertDataCapability
    \value HistoryServerCapabilities_ReplaceDataCapability
    \value HistoryServerCapabilities_UpdateDataCapability
    \value HistoryServerCapabilities_DeleteRawCapability
    \value HistoryServerCapabilities_DeleteAtTimeCapability
    \value HistoryServerCapabilities_AggregateFunctions
    \value HAConfiguration
    \value HAConfiguration_AggregateConfiguration
    \value HAConfiguration_AggregateConfiguration_TreatUncertainAsBad
    \value HAConfiguration_AggregateConfiguration_PercentDataBad
    \value HAConfiguration_AggregateConfiguration_PercentDataGood
    \value HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation
    \value HAConfiguration_Stepped
    \value HAConfiguration_Definition
    \value HAConfiguration_MaxTimeInterval
    \value HAConfiguration_MinTimeInterval
    \value HAConfiguration_ExceptionDeviation
    \value HAConfiguration_ExceptionDeviationFormat
    \value Annotations
    \value HistoricalEventFilter
    \value ModificationInfo
    \value HistoryModifiedData
    \value ModificationInfo_Encoding_DefaultXml
    \value HistoryModifiedData_Encoding_DefaultXml
    \value ModificationInfo_Encoding_DefaultBinary
    \value HistoryModifiedData_Encoding_DefaultBinary
    \value HistoryUpdateType
    \value MultiStateValueDiscreteType
    \value MultiStateValueDiscreteType_Definition
    \value MultiStateValueDiscreteType_ValuePrecision
    \value MultiStateValueDiscreteType_EnumValues
    \value HistoryServerCapabilities_AccessHistoryEventsCapability
    \value HistoryServerCapabilitiesType_MaxReturnDataValues
    \value HistoryServerCapabilitiesType_MaxReturnEventValues
    \value HistoryServerCapabilitiesType_InsertAnnotationCapability
    \value HistoryServerCapabilities_MaxReturnDataValues
    \value HistoryServerCapabilities_MaxReturnEventValues
    \value HistoryServerCapabilities_InsertAnnotationCapability
    \value HistoryServerCapabilitiesType_InsertEventCapability
    \value HistoryServerCapabilitiesType_ReplaceEventCapability
    \value HistoryServerCapabilitiesType_UpdateEventCapability
    \value HistoryServerCapabilities_InsertEventCapability
    \value HistoryServerCapabilities_ReplaceEventCapability
    \value HistoryServerCapabilities_UpdateEventCapability
    \value AggregateFunction_TimeAverage2
    \value AggregateFunction_Minimum2
    \value AggregateFunction_Maximum2
    \value AggregateFunction_Range2
    \value AggregateFunction_WorstQuality2
    \value PerformUpdateType
    \value UpdateStructureDataDetails
    \value UpdateStructureDataDetails_Encoding_DefaultXml
    \value UpdateStructureDataDetails_Encoding_DefaultBinary
    \value AggregateFunction_Total2
    \value AggregateFunction_MinimumActualTime2
    \value AggregateFunction_MaximumActualTime2
    \value AggregateFunction_DurationInStateZero
    \value AggregateFunction_DurationInStateNonZero
    \value Server_ServerRedundancy_CurrentServerId
    \value Server_ServerRedundancy_RedundantServerArray
    \value Server_ServerRedundancy_ServerUriArray
    \value ShelvedStateMachineType_UnshelvedToTimedShelved_TransitionNumber
    \value ShelvedStateMachineType_UnshelvedToOneShotShelved_TransitionNumber
    \value ShelvedStateMachineType_TimedShelvedToUnshelved_TransitionNumber
    \value ShelvedStateMachineType_TimedShelvedToOneShotShelved_TransitionNumber
    \value ShelvedStateMachineType_OneShotShelvedToUnshelved_TransitionNumber
    \value ShelvedStateMachineType_OneShotShelvedToTimedShelved_TransitionNumber
    \value ExclusiveLimitStateMachineType_LowLowToLow_TransitionNumber
    \value ExclusiveLimitStateMachineType_LowToLowLow_TransitionNumber
    \value ExclusiveLimitStateMachineType_HighHighToHigh_TransitionNumber
    \value ExclusiveLimitStateMachineType_HighToHighHigh_TransitionNumber
    \value AggregateFunction_StandardDeviationSample
    \value AggregateFunction_StandardDeviationPopulation
    \value AggregateFunction_VarianceSample
    \value AggregateFunction_VariancePopulation
    \value EnumStrings
    \value ValueAsText
    \value ProgressEventType
    \value ProgressEventType_EventId
    \value ProgressEventType_EventType
    \value ProgressEventType_SourceNode
    \value ProgressEventType_SourceName
    \value ProgressEventType_Time
    \value ProgressEventType_ReceiveTime
    \value ProgressEventType_LocalTime
    \value ProgressEventType_Message
    \value ProgressEventType_Severity
    \value SystemStatusChangeEventType
    \value SystemStatusChangeEventType_EventId
    \value SystemStatusChangeEventType_EventType
    \value SystemStatusChangeEventType_SourceNode
    \value SystemStatusChangeEventType_SourceName
    \value SystemStatusChangeEventType_Time
    \value SystemStatusChangeEventType_ReceiveTime
    \value SystemStatusChangeEventType_LocalTime
    \value SystemStatusChangeEventType_Message
    \value SystemStatusChangeEventType_Severity
    \value TransitionVariableType_EffectiveTransitionTime
    \value FiniteTransitionVariableType_EffectiveTransitionTime
    \value StateMachineType_LastTransition_EffectiveTransitionTime
    \value FiniteStateMachineType_LastTransition_EffectiveTransitionTime
    \value TransitionEventType_Transition_EffectiveTransitionTime
    \value MultiStateValueDiscreteType_ValueAsText
    \value ProgramTransitionEventType_Transition_EffectiveTransitionTime
    \value ProgramTransitionAuditEventType_Transition_EffectiveTransitionTime
    \value ProgramStateMachineType_LastTransition_EffectiveTransitionTime
    \value ShelvedStateMachineType_LastTransition_EffectiveTransitionTime
    \value AlarmConditionType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value LimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ExclusiveLimitStateMachineType_LastTransition_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_LimitState_LastTransition_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_LimitState_LastTransition_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_LimitState_LastTransition_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_LimitState_LastTransition_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value DiscreteAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value OffNormalAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value TripAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value AuditActivateSessionEventType_SecureChannelId
    \value OptionSetType
    \value OptionSetType_OptionSetValues
    \value ServerType_GetMonitoredItems
    \value ServerType_GetMonitoredItems_InputArguments
    \value ServerType_GetMonitoredItems_OutputArguments
    \value Server_GetMonitoredItems
    \value Server_GetMonitoredItems_InputArguments
    \value Server_GetMonitoredItems_OutputArguments
    \value GetMonitoredItemsMethodType
    \value GetMonitoredItemsMethodType_InputArguments
    \value GetMonitoredItemsMethodType_OutputArguments
    \value MaxStringLength
    \value HistoricalDataConfigurationType_StartOfArchive
    \value HistoricalDataConfigurationType_StartOfOnlineArchive
    \value HistoryServerCapabilitiesType_DeleteEventCapability
    \value HistoryServerCapabilities_DeleteEventCapability
    \value HAConfiguration_StartOfArchive
    \value HAConfiguration_StartOfOnlineArchive
    \value AggregateFunction_StartBound
    \value AggregateFunction_EndBound
    \value AggregateFunction_DeltaBounds
    \value ModellingRule_OptionalPlaceholder
    \value ModellingRule_MandatoryPlaceholder
    \value MaxArrayLength
    \value EngineeringUnits
    \value ServerType_ServerCapabilities_MaxArrayLength
    \value ServerType_ServerCapabilities_MaxStringLength
    \value ServerType_ServerCapabilities_OperationLimits
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerRead
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerWrite
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerBrowse
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement
    \value ServerType_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall
    \value ServerType_Namespaces
    \value ServerCapabilitiesType_MaxArrayLength
    \value ServerCapabilitiesType_MaxStringLength
    \value ServerCapabilitiesType_OperationLimits
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerRead
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerWrite
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerMethodCall
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerBrowse
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerRegisterNodes
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerNodeManagement
    \value ServerCapabilitiesType_OperationLimits_MaxMonitoredItemsPerCall
    \value ServerCapabilitiesType_VendorCapability_Placeholder
    \value OperationLimitsType
    \value OperationLimitsType_MaxNodesPerRead
    \value OperationLimitsType_MaxNodesPerWrite
    \value OperationLimitsType_MaxNodesPerMethodCall
    \value OperationLimitsType_MaxNodesPerBrowse
    \value OperationLimitsType_MaxNodesPerRegisterNodes
    \value OperationLimitsType_MaxNodesPerTranslateBrowsePathsToNodeIds
    \value OperationLimitsType_MaxNodesPerNodeManagement
    \value OperationLimitsType_MaxMonitoredItemsPerCall
    \value FileType
    \value FileType_Size
    \value FileType_OpenCount
    \value FileType_Open
    \value FileType_Open_InputArguments
    \value FileType_Open_OutputArguments
    \value FileType_Close
    \value FileType_Close_InputArguments
    \value FileType_Read
    \value FileType_Read_InputArguments
    \value FileType_Read_OutputArguments
    \value FileType_Write
    \value FileType_Write_InputArguments
    \value FileType_GetPosition
    \value FileType_GetPosition_InputArguments
    \value FileType_GetPosition_OutputArguments
    \value FileType_SetPosition
    \value FileType_SetPosition_InputArguments
    \value AddressSpaceFileType
    \value AddressSpaceFileType_Size
    \value AddressSpaceFileType_OpenCount
    \value AddressSpaceFileType_Open
    \value AddressSpaceFileType_Open_InputArguments
    \value AddressSpaceFileType_Open_OutputArguments
    \value AddressSpaceFileType_Close
    \value AddressSpaceFileType_Close_InputArguments
    \value AddressSpaceFileType_Read
    \value AddressSpaceFileType_Read_InputArguments
    \value AddressSpaceFileType_Read_OutputArguments
    \value AddressSpaceFileType_Write
    \value AddressSpaceFileType_Write_InputArguments
    \value AddressSpaceFileType_GetPosition
    \value AddressSpaceFileType_GetPosition_InputArguments
    \value AddressSpaceFileType_GetPosition_OutputArguments
    \value AddressSpaceFileType_SetPosition
    \value AddressSpaceFileType_SetPosition_InputArguments
    \value AddressSpaceFileType_ExportNamespace
    \value NamespaceMetadataType
    \value NamespaceMetadataType_NamespaceUri
    \value NamespaceMetadataType_NamespaceVersion
    \value NamespaceMetadataType_NamespacePublicationDate
    \value NamespaceMetadataType_IsNamespaceSubset
    \value NamespaceMetadataType_StaticNodeIdTypes
    \value NamespaceMetadataType_StaticNumericNodeIdRange
    \value NamespaceMetadataType_StaticStringNodeIdPattern
    \value NamespaceMetadataType_NamespaceFile
    \value NamespaceMetadataType_NamespaceFile_Size
    \value NamespaceMetadataType_NamespaceFile_OpenCount
    \value NamespaceMetadataType_NamespaceFile_Open
    \value NamespaceMetadataType_NamespaceFile_Open_InputArguments
    \value NamespaceMetadataType_NamespaceFile_Open_OutputArguments
    \value NamespaceMetadataType_NamespaceFile_Close
    \value NamespaceMetadataType_NamespaceFile_Close_InputArguments
    \value NamespaceMetadataType_NamespaceFile_Read
    \value NamespaceMetadataType_NamespaceFile_Read_InputArguments
    \value NamespaceMetadataType_NamespaceFile_Read_OutputArguments
    \value NamespaceMetadataType_NamespaceFile_Write
    \value NamespaceMetadataType_NamespaceFile_Write_InputArguments
    \value NamespaceMetadataType_NamespaceFile_GetPosition
    \value NamespaceMetadataType_NamespaceFile_GetPosition_InputArguments
    \value NamespaceMetadataType_NamespaceFile_GetPosition_OutputArguments
    \value NamespaceMetadataType_NamespaceFile_SetPosition
    \value NamespaceMetadataType_NamespaceFile_SetPosition_InputArguments
    \value NamespaceMetadataType_NamespaceFile_ExportNamespace
    \value NamespacesType
    \value NamespacesType_NamespaceIdentifier_Placeholder
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceUri
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceVersion
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespacePublicationDate
    \value NamespacesType_NamespaceIdentifier_Placeholder_IsNamespaceSubset
    \value NamespacesType_NamespaceIdentifier_Placeholder_StaticNodeIdTypes
    \value NamespacesType_NamespaceIdentifier_Placeholder_StaticNumericNodeIdRange
    \value NamespacesType_NamespaceIdentifier_Placeholder_StaticStringNodeIdPattern
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Size
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_OpenCount
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open_InputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open_OutputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close_InputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read_InputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read_OutputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write_InputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition_InputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition_OutputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition_InputArguments
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace
    \value SystemStatusChangeEventType_SystemState
    \value SamplingIntervalDiagnosticsType_SampledMonitoredItemsCount
    \value SamplingIntervalDiagnosticsType_MaxSampledMonitoredItemsCount
    \value SamplingIntervalDiagnosticsType_DisabledMonitoredItemsSamplingCount
    \value OptionSetType_BitMask
    \value Server_ServerCapabilities_MaxArrayLength
    \value Server_ServerCapabilities_MaxStringLength
    \value Server_ServerCapabilities_OperationLimits
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerRead
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement
    \value Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall
    \value Server_Namespaces
    \value BitFieldMaskDataType
    \value OpenMethodType
    \value OpenMethodType_InputArguments
    \value OpenMethodType_OutputArguments
    \value CloseMethodType
    \value CloseMethodType_InputArguments
    \value ReadMethodType
    \value ReadMethodType_InputArguments
    \value ReadMethodType_OutputArguments
    \value WriteMethodType
    \value WriteMethodType_InputArguments
    \value GetPositionMethodType
    \value GetPositionMethodType_InputArguments
    \value GetPositionMethodType_OutputArguments
    \value SetPositionMethodType
    \value SetPositionMethodType_InputArguments
    \value SystemOffNormalAlarmType
    \value SystemOffNormalAlarmType_EventId
    \value SystemOffNormalAlarmType_EventType
    \value SystemOffNormalAlarmType_SourceNode
    \value SystemOffNormalAlarmType_SourceName
    \value SystemOffNormalAlarmType_Time
    \value SystemOffNormalAlarmType_ReceiveTime
    \value SystemOffNormalAlarmType_LocalTime
    \value SystemOffNormalAlarmType_Message
    \value SystemOffNormalAlarmType_Severity
    \value SystemOffNormalAlarmType_ConditionClassId
    \value SystemOffNormalAlarmType_ConditionClassName
    \value SystemOffNormalAlarmType_ConditionName
    \value SystemOffNormalAlarmType_BranchId
    \value SystemOffNormalAlarmType_Retain
    \value SystemOffNormalAlarmType_EnabledState
    \value SystemOffNormalAlarmType_EnabledState_Id
    \value SystemOffNormalAlarmType_EnabledState_Name
    \value SystemOffNormalAlarmType_EnabledState_Number
    \value SystemOffNormalAlarmType_EnabledState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_EnabledState_TransitionTime
    \value SystemOffNormalAlarmType_EnabledState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_EnabledState_TrueState
    \value SystemOffNormalAlarmType_EnabledState_FalseState
    \value SystemOffNormalAlarmType_Quality
    \value SystemOffNormalAlarmType_Quality_SourceTimestamp
    \value SystemOffNormalAlarmType_LastSeverity
    \value SystemOffNormalAlarmType_LastSeverity_SourceTimestamp
    \value SystemOffNormalAlarmType_Comment
    \value SystemOffNormalAlarmType_Comment_SourceTimestamp
    \value SystemOffNormalAlarmType_ClientUserId
    \value SystemOffNormalAlarmType_Disable
    \value SystemOffNormalAlarmType_Enable
    \value SystemOffNormalAlarmType_AddComment
    \value SystemOffNormalAlarmType_AddComment_InputArguments
    \value SystemOffNormalAlarmType_ConditionRefresh
    \value SystemOffNormalAlarmType_ConditionRefresh_InputArguments
    \value SystemOffNormalAlarmType_AckedState
    \value SystemOffNormalAlarmType_AckedState_Id
    \value SystemOffNormalAlarmType_AckedState_Name
    \value SystemOffNormalAlarmType_AckedState_Number
    \value SystemOffNormalAlarmType_AckedState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_AckedState_TransitionTime
    \value SystemOffNormalAlarmType_AckedState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_AckedState_TrueState
    \value SystemOffNormalAlarmType_AckedState_FalseState
    \value SystemOffNormalAlarmType_ConfirmedState
    \value SystemOffNormalAlarmType_ConfirmedState_Id
    \value SystemOffNormalAlarmType_ConfirmedState_Name
    \value SystemOffNormalAlarmType_ConfirmedState_Number
    \value SystemOffNormalAlarmType_ConfirmedState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_ConfirmedState_TransitionTime
    \value SystemOffNormalAlarmType_ConfirmedState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_ConfirmedState_TrueState
    \value SystemOffNormalAlarmType_ConfirmedState_FalseState
    \value SystemOffNormalAlarmType_Acknowledge
    \value SystemOffNormalAlarmType_Acknowledge_InputArguments
    \value SystemOffNormalAlarmType_Confirm
    \value SystemOffNormalAlarmType_Confirm_InputArguments
    \value SystemOffNormalAlarmType_ActiveState
    \value SystemOffNormalAlarmType_ActiveState_Id
    \value SystemOffNormalAlarmType_ActiveState_Name
    \value SystemOffNormalAlarmType_ActiveState_Number
    \value SystemOffNormalAlarmType_ActiveState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_ActiveState_TransitionTime
    \value SystemOffNormalAlarmType_ActiveState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_ActiveState_TrueState
    \value SystemOffNormalAlarmType_ActiveState_FalseState
    \value SystemOffNormalAlarmType_InputNode
    \value SystemOffNormalAlarmType_SuppressedState
    \value SystemOffNormalAlarmType_SuppressedState_Id
    \value SystemOffNormalAlarmType_SuppressedState_Name
    \value SystemOffNormalAlarmType_SuppressedState_Number
    \value SystemOffNormalAlarmType_SuppressedState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_SuppressedState_TransitionTime
    \value SystemOffNormalAlarmType_SuppressedState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_SuppressedState_TrueState
    \value SystemOffNormalAlarmType_SuppressedState_FalseState
    \value SystemOffNormalAlarmType_ShelvingState
    \value SystemOffNormalAlarmType_ShelvingState_CurrentState
    \value SystemOffNormalAlarmType_ShelvingState_CurrentState_Id
    \value SystemOffNormalAlarmType_ShelvingState_CurrentState_Name
    \value SystemOffNormalAlarmType_ShelvingState_CurrentState_Number
    \value SystemOffNormalAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_ShelvingState_LastTransition
    \value SystemOffNormalAlarmType_ShelvingState_LastTransition_Id
    \value SystemOffNormalAlarmType_ShelvingState_LastTransition_Name
    \value SystemOffNormalAlarmType_ShelvingState_LastTransition_Number
    \value SystemOffNormalAlarmType_ShelvingState_LastTransition_TransitionTime
    \value SystemOffNormalAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_ShelvingState_UnshelveTime
    \value SystemOffNormalAlarmType_ShelvingState_Unshelve
    \value SystemOffNormalAlarmType_ShelvingState_OneShotShelve
    \value SystemOffNormalAlarmType_ShelvingState_TimedShelve
    \value SystemOffNormalAlarmType_ShelvingState_TimedShelve_InputArguments
    \value SystemOffNormalAlarmType_SuppressedOrShelved
    \value SystemOffNormalAlarmType_MaxTimeShelved
    \value SystemOffNormalAlarmType_NormalState
    \value AuditConditionCommentEventType_Comment
    \value AuditConditionRespondEventType_SelectedResponse
    \value AuditConditionAcknowledgeEventType_Comment
    \value AuditConditionConfirmEventType_Comment
    \value AuditConditionShelvingEventType_ShelvingTime
    \value AuditProgramTransitionEventType
    \value AuditProgramTransitionEventType_EventId
    \value AuditProgramTransitionEventType_EventType
    \value AuditProgramTransitionEventType_SourceNode
    \value AuditProgramTransitionEventType_SourceName
    \value AuditProgramTransitionEventType_Time
    \value AuditProgramTransitionEventType_ReceiveTime
    \value AuditProgramTransitionEventType_LocalTime
    \value AuditProgramTransitionEventType_Message
    \value AuditProgramTransitionEventType_Severity
    \value AuditProgramTransitionEventType_ActionTimeStamp
    \value AuditProgramTransitionEventType_Status
    \value AuditProgramTransitionEventType_ServerId
    \value AuditProgramTransitionEventType_ClientAuditEntryId
    \value AuditProgramTransitionEventType_ClientUserId
    \value AuditProgramTransitionEventType_MethodId
    \value AuditProgramTransitionEventType_InputArguments
    \value AuditProgramTransitionEventType_OldStateId
    \value AuditProgramTransitionEventType_NewStateId
    \value AuditProgramTransitionEventType_TransitionNumber
    \value HistoricalDataConfigurationType_AggregateFunctions
    \value HAConfiguration_AggregateFunctions
    \value NodeClass_EnumValues
    \value InstanceNode
    \value TypeNode
    \value NodeAttributesMask_EnumValues
    \value BrowseResultMask_EnumValues
    \value HistoryUpdateType_EnumValues
    \value PerformUpdateType_EnumValues
    \value InstanceNode_Encoding_DefaultXml
    \value TypeNode_Encoding_DefaultXml
    \value InstanceNode_Encoding_DefaultBinary
    \value TypeNode_Encoding_DefaultBinary
    \value SessionDiagnosticsObjectType_SessionDiagnostics_UnauthorizedRequestCount
    \value SessionDiagnosticsVariableType_UnauthorizedRequestCount
    \value OpenFileMode
    \value OpenFileMode_EnumValues
    \value ModelChangeStructureVerbMask
    \value ModelChangeStructureVerbMask_EnumValues
    \value EndpointUrlListDataType
    \value NetworkGroupDataType
    \value NonTransparentNetworkRedundancyType
    \value NonTransparentNetworkRedundancyType_RedundancySupport
    \value NonTransparentNetworkRedundancyType_ServerUriArray
    \value NonTransparentNetworkRedundancyType_ServerNetworkGroups
    \value EndpointUrlListDataType_Encoding_DefaultXml
    \value NetworkGroupDataType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_EndpointUrlListDataType
    \value OpcUa_XmlSchema_EndpointUrlListDataType_DataTypeVersion
    \value OpcUa_XmlSchema_EndpointUrlListDataType_DictionaryFragment
    \value OpcUa_XmlSchema_NetworkGroupDataType
    \value OpcUa_XmlSchema_NetworkGroupDataType_DataTypeVersion
    \value OpcUa_XmlSchema_NetworkGroupDataType_DictionaryFragment
    \value EndpointUrlListDataType_Encoding_DefaultBinary
    \value NetworkGroupDataType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_EndpointUrlListDataType
    \value OpcUa_BinarySchema_EndpointUrlListDataType_DataTypeVersion
    \value OpcUa_BinarySchema_EndpointUrlListDataType_DictionaryFragment
    \value OpcUa_BinarySchema_NetworkGroupDataType
    \value OpcUa_BinarySchema_NetworkGroupDataType_DataTypeVersion
    \value OpcUa_BinarySchema_NetworkGroupDataType_DictionaryFragment
    \value ArrayItemType
    \value ArrayItemType_Definition
    \value ArrayItemType_ValuePrecision
    \value ArrayItemType_InstrumentRange
    \value ArrayItemType_EURange
    \value ArrayItemType_EngineeringUnits
    \value ArrayItemType_Title
    \value ArrayItemType_AxisScaleType
    \value YArrayItemType
    \value YArrayItemType_Definition
    \value YArrayItemType_ValuePrecision
    \value YArrayItemType_InstrumentRange
    \value YArrayItemType_EURange
    \value YArrayItemType_EngineeringUnits
    \value YArrayItemType_Title
    \value YArrayItemType_AxisScaleType
    \value YArrayItemType_XAxisDefinition
    \value XYArrayItemType
    \value XYArrayItemType_Definition
    \value XYArrayItemType_ValuePrecision
    \value XYArrayItemType_InstrumentRange
    \value XYArrayItemType_EURange
    \value XYArrayItemType_EngineeringUnits
    \value XYArrayItemType_Title
    \value XYArrayItemType_AxisScaleType
    \value XYArrayItemType_XAxisDefinition
    \value ImageItemType
    \value ImageItemType_Definition
    \value ImageItemType_ValuePrecision
    \value ImageItemType_InstrumentRange
    \value ImageItemType_EURange
    \value ImageItemType_EngineeringUnits
    \value ImageItemType_Title
    \value ImageItemType_AxisScaleType
    \value ImageItemType_XAxisDefinition
    \value ImageItemType_YAxisDefinition
    \value CubeItemType
    \value CubeItemType_Definition
    \value CubeItemType_ValuePrecision
    \value CubeItemType_InstrumentRange
    \value CubeItemType_EURange
    \value CubeItemType_EngineeringUnits
    \value CubeItemType_Title
    \value CubeItemType_AxisScaleType
    \value CubeItemType_XAxisDefinition
    \value CubeItemType_YAxisDefinition
    \value CubeItemType_ZAxisDefinition
    \value NDimensionArrayItemType
    \value NDimensionArrayItemType_Definition
    \value NDimensionArrayItemType_ValuePrecision
    \value NDimensionArrayItemType_InstrumentRange
    \value NDimensionArrayItemType_EURange
    \value NDimensionArrayItemType_EngineeringUnits
    \value NDimensionArrayItemType_Title
    \value NDimensionArrayItemType_AxisScaleType
    \value NDimensionArrayItemType_AxisDefinition
    \value AxisScaleEnumeration
    \value AxisScaleEnumeration_EnumStrings
    \value AxisInformation
    \value XVType
    \value AxisInformation_Encoding_DefaultXml
    \value XVType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_AxisInformation
    \value OpcUa_XmlSchema_AxisInformation_DataTypeVersion
    \value OpcUa_XmlSchema_AxisInformation_DictionaryFragment
    \value OpcUa_XmlSchema_XVType
    \value OpcUa_XmlSchema_XVType_DataTypeVersion
    \value OpcUa_XmlSchema_XVType_DictionaryFragment
    \value AxisInformation_Encoding_DefaultBinary
    \value XVType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_AxisInformation
    \value OpcUa_BinarySchema_AxisInformation_DataTypeVersion
    \value OpcUa_BinarySchema_AxisInformation_DictionaryFragment
    \value OpcUa_BinarySchema_XVType
    \value OpcUa_BinarySchema_XVType_DataTypeVersion
    \value OpcUa_BinarySchema_XVType_DictionaryFragment
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate
    \value SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData
    \value ServerType_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryReadData
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryReadEvents
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryUpdateData
    \value ServerCapabilitiesType_OperationLimits_MaxNodesPerHistoryUpdateEvents
    \value OperationLimitsType_MaxNodesPerHistoryReadData
    \value OperationLimitsType_MaxNodesPerHistoryReadEvents
    \value OperationLimitsType_MaxNodesPerHistoryUpdateData
    \value OperationLimitsType_MaxNodesPerHistoryUpdateEvents
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData
    \value Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents
    \value NamingRuleType_EnumValues
    \value ViewVersion
    \value ComplexNumberType
    \value DoubleComplexNumberType
    \value ComplexNumberType_Encoding_DefaultXml
    \value DoubleComplexNumberType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_ComplexNumberType
    \value OpcUa_XmlSchema_ComplexNumberType_DataTypeVersion
    \value OpcUa_XmlSchema_ComplexNumberType_DictionaryFragment
    \value OpcUa_XmlSchema_DoubleComplexNumberType
    \value OpcUa_XmlSchema_DoubleComplexNumberType_DataTypeVersion
    \value OpcUa_XmlSchema_DoubleComplexNumberType_DictionaryFragment
    \value ComplexNumberType_Encoding_DefaultBinary
    \value DoubleComplexNumberType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_ComplexNumberType
    \value OpcUa_BinarySchema_ComplexNumberType_DataTypeVersion
    \value OpcUa_BinarySchema_ComplexNumberType_DictionaryFragment
    \value OpcUa_BinarySchema_DoubleComplexNumberType
    \value OpcUa_BinarySchema_DoubleComplexNumberType_DataTypeVersion
    \value OpcUa_BinarySchema_DoubleComplexNumberType_DictionaryFragment
    \value ServerOnNetwork
    \value FindServersOnNetworkRequest
    \value FindServersOnNetworkResponse
    \value RegisterServer2Request
    \value RegisterServer2Response
    \value ServerOnNetwork_Encoding_DefaultXml
    \value FindServersOnNetworkRequest_Encoding_DefaultXml
    \value FindServersOnNetworkResponse_Encoding_DefaultXml
    \value RegisterServer2Request_Encoding_DefaultXml
    \value RegisterServer2Response_Encoding_DefaultXml
    \value OpcUa_XmlSchema_ServerOnNetwork
    \value OpcUa_XmlSchema_ServerOnNetwork_DataTypeVersion
    \value OpcUa_XmlSchema_ServerOnNetwork_DictionaryFragment
    \value ServerOnNetwork_Encoding_DefaultBinary
    \value FindServersOnNetworkRequest_Encoding_DefaultBinary
    \value FindServersOnNetworkResponse_Encoding_DefaultBinary
    \value RegisterServer2Request_Encoding_DefaultBinary
    \value RegisterServer2Response_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_ServerOnNetwork
    \value OpcUa_BinarySchema_ServerOnNetwork_DataTypeVersion
    \value OpcUa_BinarySchema_ServerOnNetwork_DictionaryFragment
    \value ProgressEventType_Context
    \value ProgressEventType_Progress
    \value OpenWithMasksMethodType
    \value OpenWithMasksMethodType_InputArguments
    \value OpenWithMasksMethodType_OutputArguments
    \value CloseAndUpdateMethodType
    \value CloseAndUpdateMethodType_OutputArguments
    \value AddCertificateMethodType
    \value AddCertificateMethodType_InputArguments
    \value RemoveCertificateMethodType
    \value RemoveCertificateMethodType_InputArguments
    \value TrustListType
    \value TrustListType_Size
    \value TrustListType_OpenCount
    \value TrustListType_Open
    \value TrustListType_Open_InputArguments
    \value TrustListType_Open_OutputArguments
    \value TrustListType_Close
    \value TrustListType_Close_InputArguments
    \value TrustListType_Read
    \value TrustListType_Read_InputArguments
    \value TrustListType_Read_OutputArguments
    \value TrustListType_Write
    \value TrustListType_Write_InputArguments
    \value TrustListType_GetPosition
    \value TrustListType_GetPosition_InputArguments
    \value TrustListType_GetPosition_OutputArguments
    \value TrustListType_SetPosition
    \value TrustListType_SetPosition_InputArguments
    \value TrustListType_LastUpdateTime
    \value TrustListType_OpenWithMasks
    \value TrustListType_OpenWithMasks_InputArguments
    \value TrustListType_OpenWithMasks_OutputArguments
    \value TrustListType_CloseAndUpdate
    \value TrustListType_CloseAndUpdate_OutputArguments
    \value TrustListType_AddCertificate
    \value TrustListType_AddCertificate_InputArguments
    \value TrustListType_RemoveCertificate
    \value TrustListType_RemoveCertificate_InputArguments
    \value TrustListMasks
    \value TrustListMasks_EnumValues
    \value TrustListDataType
    \value CertificateGroupType
    \value CertificateType
    \value ApplicationCertificateType
    \value HttpsCertificateType
    \value RsaMinApplicationCertificateType
    \value RsaSha256ApplicationCertificateType
    \value TrustListUpdatedAuditEventType
    \value TrustListUpdatedAuditEventType_EventId
    \value TrustListUpdatedAuditEventType_EventType
    \value TrustListUpdatedAuditEventType_SourceNode
    \value TrustListUpdatedAuditEventType_SourceName
    \value TrustListUpdatedAuditEventType_Time
    \value TrustListUpdatedAuditEventType_ReceiveTime
    \value TrustListUpdatedAuditEventType_LocalTime
    \value TrustListUpdatedAuditEventType_Message
    \value TrustListUpdatedAuditEventType_Severity
    \value TrustListUpdatedAuditEventType_ActionTimeStamp
    \value TrustListUpdatedAuditEventType_Status
    \value TrustListUpdatedAuditEventType_ServerId
    \value TrustListUpdatedAuditEventType_ClientAuditEntryId
    \value TrustListUpdatedAuditEventType_ClientUserId
    \value TrustListUpdatedAuditEventType_MethodId
    \value TrustListUpdatedAuditEventType_InputArguments
    \value UpdateCertificateMethodType
    \value UpdateCertificateMethodType_InputArguments
    \value UpdateCertificateMethodType_OutputArguments
    \value ServerConfigurationType
    \value ServerConfigurationType_SupportedPrivateKeyFormats
    \value ServerConfigurationType_MaxTrustListSize
    \value ServerConfigurationType_MulticastDnsEnabled
    \value ServerConfigurationType_UpdateCertificate
    \value ServerConfigurationType_UpdateCertificate_InputArguments
    \value ServerConfigurationType_UpdateCertificate_OutputArguments
    \value CertificateUpdatedAuditEventType
    \value CertificateUpdatedAuditEventType_EventId
    \value CertificateUpdatedAuditEventType_EventType
    \value CertificateUpdatedAuditEventType_SourceNode
    \value CertificateUpdatedAuditEventType_SourceName
    \value CertificateUpdatedAuditEventType_Time
    \value CertificateUpdatedAuditEventType_ReceiveTime
    \value CertificateUpdatedAuditEventType_LocalTime
    \value CertificateUpdatedAuditEventType_Message
    \value CertificateUpdatedAuditEventType_Severity
    \value CertificateUpdatedAuditEventType_ActionTimeStamp
    \value CertificateUpdatedAuditEventType_Status
    \value CertificateUpdatedAuditEventType_ServerId
    \value CertificateUpdatedAuditEventType_ClientAuditEntryId
    \value CertificateUpdatedAuditEventType_ClientUserId
    \value CertificateUpdatedAuditEventType_MethodId
    \value CertificateUpdatedAuditEventType_InputArguments
    \value ServerConfiguration
    \value ServerConfiguration_SupportedPrivateKeyFormats
    \value ServerConfiguration_MaxTrustListSize
    \value ServerConfiguration_MulticastDnsEnabled
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Size
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments
    \value TrustListDataType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_TrustListDataType
    \value OpcUa_XmlSchema_TrustListDataType_DataTypeVersion
    \value OpcUa_XmlSchema_TrustListDataType_DictionaryFragment
    \value TrustListDataType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_TrustListDataType
    \value OpcUa_BinarySchema_TrustListDataType_DataTypeVersion
    \value OpcUa_BinarySchema_TrustListDataType_DictionaryFragment
    \value FileType_Writable
    \value FileType_UserWritable
    \value AddressSpaceFileType_Writable
    \value AddressSpaceFileType_UserWritable
    \value NamespaceMetadataType_NamespaceFile_Writable
    \value NamespaceMetadataType_NamespaceFile_UserWritable
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Writable
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_UserWritable
    \value TrustListType_Writable
    \value TrustListType_UserWritable
    \value CloseAndUpdateMethodType_InputArguments
    \value TrustListType_CloseAndUpdate_InputArguments
    \value ServerConfigurationType_ServerCapabilities
    \value ServerConfiguration_ServerCapabilities
    \value OpcUa_XmlSchema_RelativePathElement
    \value OpcUa_XmlSchema_RelativePathElement_DataTypeVersion
    \value OpcUa_XmlSchema_RelativePathElement_DictionaryFragment
    \value OpcUa_XmlSchema_RelativePath
    \value OpcUa_XmlSchema_RelativePath_DataTypeVersion
    \value OpcUa_XmlSchema_RelativePath_DictionaryFragment
    \value OpcUa_BinarySchema_RelativePathElement
    \value OpcUa_BinarySchema_RelativePathElement_DataTypeVersion
    \value OpcUa_BinarySchema_RelativePathElement_DictionaryFragment
    \value OpcUa_BinarySchema_RelativePath
    \value OpcUa_BinarySchema_RelativePath_DataTypeVersion
    \value OpcUa_BinarySchema_RelativePath_DictionaryFragment
    \value ServerConfigurationType_CreateSigningRequest
    \value ServerConfigurationType_CreateSigningRequest_InputArguments
    \value ServerConfigurationType_CreateSigningRequest_OutputArguments
    \value ServerConfigurationType_ApplyChanges
    \value ServerConfiguration_CreateSigningRequest
    \value ServerConfiguration_CreateSigningRequest_InputArguments
    \value ServerConfiguration_CreateSigningRequest_OutputArguments
    \value ServerConfiguration_ApplyChanges
    \value CreateSigningRequestMethodType
    \value CreateSigningRequestMethodType_InputArguments
    \value CreateSigningRequestMethodType_OutputArguments
    \value OptionSetValues
    \value ServerType_SetSubscriptionDurable
    \value ServerType_SetSubscriptionDurable_InputArguments
    \value ServerType_SetSubscriptionDurable_OutputArguments
    \value Server_SetSubscriptionDurable
    \value Server_SetSubscriptionDurable_InputArguments
    \value Server_SetSubscriptionDurable_OutputArguments
    \value SetSubscriptionDurableMethodType
    \value SetSubscriptionDurableMethodType_InputArguments
    \value SetSubscriptionDurableMethodType_OutputArguments
    \value OptionSet
    \value Union
    \value OptionSet_Encoding_DefaultXml
    \value Union_Encoding_DefaultXml
    \value OpcUa_XmlSchema_OptionSet
    \value OpcUa_XmlSchema_OptionSet_DataTypeVersion
    \value OpcUa_XmlSchema_OptionSet_DictionaryFragment
    \value OpcUa_XmlSchema_Union
    \value OpcUa_XmlSchema_Union_DataTypeVersion
    \value OpcUa_XmlSchema_Union_DictionaryFragment
    \value OptionSet_Encoding_DefaultBinary
    \value Union_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_OptionSet
    \value OpcUa_BinarySchema_OptionSet_DataTypeVersion
    \value OpcUa_BinarySchema_OptionSet_DictionaryFragment
    \value OpcUa_BinarySchema_Union
    \value OpcUa_BinarySchema_Union_DataTypeVersion
    \value OpcUa_BinarySchema_Union_DictionaryFragment
    \value GetRejectedListMethodType
    \value GetRejectedListMethodType_OutputArguments
    \value ServerConfigurationType_GetRejectedList
    \value ServerConfigurationType_GetRejectedList_OutputArguments
    \value ServerConfiguration_GetRejectedList
    \value ServerConfiguration_GetRejectedList_OutputArguments
    \value SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics
    \value SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SamplingInterval
    \value SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_SampledMonitoredItemsCount
    \value SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_MaxSampledMonitoredItemsCount
    \value SamplingIntervalDiagnosticsArrayType_SamplingIntervalDiagnostics_DisabledMonitoredItemsSamplingCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SessionId
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_SubscriptionId
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_Priority
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingInterval
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxKeepAliveCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxLifetimeCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MaxNotificationsPerPublish
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishingEnabled
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_ModifyCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EnableCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisableCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishRequestCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageRequestCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_RepublishMessageCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferRequestCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToAltClientCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_TransferredToSameClientCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_PublishRequestCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DataChangeNotificationsCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventNotificationsCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NotificationsCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_LatePublishRequestCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentKeepAliveCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_CurrentLifetimeCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_UnacknowledgedMessageCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DiscardedMessageCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoredItemCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_DisabledMonitoredItemCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_MonitoringQueueOverflowCount
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_NextSequenceNumber
    \value SubscriptionDiagnosticsArrayType_SubscriptionDiagnostics_EventQueueOverflowCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics
    \value SessionDiagnosticsArrayType_SessionDiagnostics_SessionId
    \value SessionDiagnosticsArrayType_SessionDiagnostics_SessionName
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ClientDescription
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ServerUri
    \value SessionDiagnosticsArrayType_SessionDiagnostics_EndpointUrl
    \value SessionDiagnosticsArrayType_SessionDiagnostics_LocaleIds
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ActualSessionTimeout
    \value SessionDiagnosticsArrayType_SessionDiagnostics_MaxResponseMessageSize
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ClientConnectionTime
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ClientLastContactTime
    \value SessionDiagnosticsArrayType_SessionDiagnostics_CurrentSubscriptionsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_CurrentMonitoredItemsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_CurrentPublishRequestsInQueue
    \value SessionDiagnosticsArrayType_SessionDiagnostics_TotalRequestCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_UnauthorizedRequestCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ReadCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_HistoryReadCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_WriteCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_HistoryUpdateCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_CallCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_CreateMonitoredItemsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ModifyMonitoredItemsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_SetMonitoringModeCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_SetTriggeringCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_DeleteMonitoredItemsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_CreateSubscriptionCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_ModifySubscriptionCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_SetPublishingModeCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_PublishCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_RepublishCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_TransferSubscriptionsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_DeleteSubscriptionsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_AddNodesCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_AddReferencesCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_DeleteNodesCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_DeleteReferencesCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_BrowseCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_BrowseNextCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_QueryFirstCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_QueryNextCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_RegisterNodesCount
    \value SessionDiagnosticsArrayType_SessionDiagnostics_UnregisterNodesCount
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SessionId
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdOfSession
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientUserIdHistory
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_AuthenticationMechanism
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_Encoding
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_TransportProtocol
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityMode
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_SecurityPolicyUri
    \value SessionSecurityDiagnosticsArrayType_SessionSecurityDiagnostics_ClientCertificate
    \value ServerType_ResendData
    \value ServerType_ResendData_InputArguments
    \value Server_ResendData
    \value Server_ResendData_InputArguments
    \value ResendDataMethodType
    \value ResendDataMethodType_InputArguments
    \value NormalizedString
    \value DecimalString
    \value DurationString
    \value TimeString
    \value DateString
    \value ServerType_EstimatedReturnTime
    \value ServerType_RequestServerStateChange
    \value ServerType_RequestServerStateChange_InputArguments
    \value Server_EstimatedReturnTime
    \value Server_RequestServerStateChange
    \value Server_RequestServerStateChange_InputArguments
    \value RequestServerStateChangeMethodType
    \value RequestServerStateChangeMethodType_InputArguments
    \value DiscoveryConfiguration
    \value MdnsDiscoveryConfiguration
    \value DiscoveryConfiguration_Encoding_DefaultXml
    \value MdnsDiscoveryConfiguration_Encoding_DefaultXml
    \value OpcUa_XmlSchema_DiscoveryConfiguration
    \value OpcUa_XmlSchema_DiscoveryConfiguration_DataTypeVersion
    \value OpcUa_XmlSchema_DiscoveryConfiguration_DictionaryFragment
    \value OpcUa_XmlSchema_MdnsDiscoveryConfiguration
    \value OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DataTypeVersion
    \value OpcUa_XmlSchema_MdnsDiscoveryConfiguration_DictionaryFragment
    \value DiscoveryConfiguration_Encoding_DefaultBinary
    \value MdnsDiscoveryConfiguration_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_DiscoveryConfiguration
    \value OpcUa_BinarySchema_DiscoveryConfiguration_DataTypeVersion
    \value OpcUa_BinarySchema_DiscoveryConfiguration_DictionaryFragment
    \value OpcUa_BinarySchema_MdnsDiscoveryConfiguration
    \value OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DataTypeVersion
    \value OpcUa_BinarySchema_MdnsDiscoveryConfiguration_DictionaryFragment
    \value MaxByteStringLength
    \value ServerType_ServerCapabilities_MaxByteStringLength
    \value ServerCapabilitiesType_MaxByteStringLength
    \value Server_ServerCapabilities_MaxByteStringLength
    \value ConditionType_ConditionRefresh2
    \value ConditionType_ConditionRefresh2_InputArguments
    \value ConditionRefresh2MethodType
    \value ConditionRefresh2MethodType_InputArguments
    \value DialogConditionType_ConditionRefresh2
    \value DialogConditionType_ConditionRefresh2_InputArguments
    \value AcknowledgeableConditionType_ConditionRefresh2
    \value AcknowledgeableConditionType_ConditionRefresh2_InputArguments
    \value AlarmConditionType_ConditionRefresh2
    \value AlarmConditionType_ConditionRefresh2_InputArguments
    \value LimitAlarmType_ConditionRefresh2
    \value LimitAlarmType_ConditionRefresh2_InputArguments
    \value ExclusiveLimitAlarmType_ConditionRefresh2
    \value ExclusiveLimitAlarmType_ConditionRefresh2_InputArguments
    \value NonExclusiveLimitAlarmType_ConditionRefresh2
    \value NonExclusiveLimitAlarmType_ConditionRefresh2_InputArguments
    \value NonExclusiveLevelAlarmType_ConditionRefresh2
    \value NonExclusiveLevelAlarmType_ConditionRefresh2_InputArguments
    \value ExclusiveLevelAlarmType_ConditionRefresh2
    \value ExclusiveLevelAlarmType_ConditionRefresh2_InputArguments
    \value NonExclusiveDeviationAlarmType_ConditionRefresh2
    \value NonExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments
    \value ExclusiveDeviationAlarmType_ConditionRefresh2
    \value ExclusiveDeviationAlarmType_ConditionRefresh2_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_ConditionRefresh2
    \value NonExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments
    \value ExclusiveRateOfChangeAlarmType_ConditionRefresh2
    \value ExclusiveRateOfChangeAlarmType_ConditionRefresh2_InputArguments
    \value DiscreteAlarmType_ConditionRefresh2
    \value DiscreteAlarmType_ConditionRefresh2_InputArguments
    \value OffNormalAlarmType_ConditionRefresh2
    \value OffNormalAlarmType_ConditionRefresh2_InputArguments
    \value SystemOffNormalAlarmType_ConditionRefresh2
    \value SystemOffNormalAlarmType_ConditionRefresh2_InputArguments
    \value TripAlarmType_ConditionRefresh2
    \value TripAlarmType_ConditionRefresh2_InputArguments
    \value CertificateExpirationAlarmType
    \value CertificateExpirationAlarmType_EventId
    \value CertificateExpirationAlarmType_EventType
    \value CertificateExpirationAlarmType_SourceNode
    \value CertificateExpirationAlarmType_SourceName
    \value CertificateExpirationAlarmType_Time
    \value CertificateExpirationAlarmType_ReceiveTime
    \value CertificateExpirationAlarmType_LocalTime
    \value CertificateExpirationAlarmType_Message
    \value CertificateExpirationAlarmType_Severity
    \value CertificateExpirationAlarmType_ConditionClassId
    \value CertificateExpirationAlarmType_ConditionClassName
    \value CertificateExpirationAlarmType_ConditionName
    \value CertificateExpirationAlarmType_BranchId
    \value CertificateExpirationAlarmType_Retain
    \value CertificateExpirationAlarmType_EnabledState
    \value CertificateExpirationAlarmType_EnabledState_Id
    \value CertificateExpirationAlarmType_EnabledState_Name
    \value CertificateExpirationAlarmType_EnabledState_Number
    \value CertificateExpirationAlarmType_EnabledState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_EnabledState_TransitionTime
    \value CertificateExpirationAlarmType_EnabledState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_EnabledState_TrueState
    \value CertificateExpirationAlarmType_EnabledState_FalseState
    \value CertificateExpirationAlarmType_Quality
    \value CertificateExpirationAlarmType_Quality_SourceTimestamp
    \value CertificateExpirationAlarmType_LastSeverity
    \value CertificateExpirationAlarmType_LastSeverity_SourceTimestamp
    \value CertificateExpirationAlarmType_Comment
    \value CertificateExpirationAlarmType_Comment_SourceTimestamp
    \value CertificateExpirationAlarmType_ClientUserId
    \value CertificateExpirationAlarmType_Disable
    \value CertificateExpirationAlarmType_Enable
    \value CertificateExpirationAlarmType_AddComment
    \value CertificateExpirationAlarmType_AddComment_InputArguments
    \value CertificateExpirationAlarmType_ConditionRefresh
    \value CertificateExpirationAlarmType_ConditionRefresh_InputArguments
    \value CertificateExpirationAlarmType_ConditionRefresh2
    \value CertificateExpirationAlarmType_ConditionRefresh2_InputArguments
    \value CertificateExpirationAlarmType_AckedState
    \value CertificateExpirationAlarmType_AckedState_Id
    \value CertificateExpirationAlarmType_AckedState_Name
    \value CertificateExpirationAlarmType_AckedState_Number
    \value CertificateExpirationAlarmType_AckedState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_AckedState_TransitionTime
    \value CertificateExpirationAlarmType_AckedState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_AckedState_TrueState
    \value CertificateExpirationAlarmType_AckedState_FalseState
    \value CertificateExpirationAlarmType_ConfirmedState
    \value CertificateExpirationAlarmType_ConfirmedState_Id
    \value CertificateExpirationAlarmType_ConfirmedState_Name
    \value CertificateExpirationAlarmType_ConfirmedState_Number
    \value CertificateExpirationAlarmType_ConfirmedState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_ConfirmedState_TransitionTime
    \value CertificateExpirationAlarmType_ConfirmedState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_ConfirmedState_TrueState
    \value CertificateExpirationAlarmType_ConfirmedState_FalseState
    \value CertificateExpirationAlarmType_Acknowledge
    \value CertificateExpirationAlarmType_Acknowledge_InputArguments
    \value CertificateExpirationAlarmType_Confirm
    \value CertificateExpirationAlarmType_Confirm_InputArguments
    \value CertificateExpirationAlarmType_ActiveState
    \value CertificateExpirationAlarmType_ActiveState_Id
    \value CertificateExpirationAlarmType_ActiveState_Name
    \value CertificateExpirationAlarmType_ActiveState_Number
    \value CertificateExpirationAlarmType_ActiveState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_ActiveState_TransitionTime
    \value CertificateExpirationAlarmType_ActiveState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_ActiveState_TrueState
    \value CertificateExpirationAlarmType_ActiveState_FalseState
    \value CertificateExpirationAlarmType_InputNode
    \value CertificateExpirationAlarmType_SuppressedState
    \value CertificateExpirationAlarmType_SuppressedState_Id
    \value CertificateExpirationAlarmType_SuppressedState_Name
    \value CertificateExpirationAlarmType_SuppressedState_Number
    \value CertificateExpirationAlarmType_SuppressedState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_SuppressedState_TransitionTime
    \value CertificateExpirationAlarmType_SuppressedState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_SuppressedState_TrueState
    \value CertificateExpirationAlarmType_SuppressedState_FalseState
    \value CertificateExpirationAlarmType_ShelvingState
    \value CertificateExpirationAlarmType_ShelvingState_CurrentState
    \value CertificateExpirationAlarmType_ShelvingState_CurrentState_Id
    \value CertificateExpirationAlarmType_ShelvingState_CurrentState_Name
    \value CertificateExpirationAlarmType_ShelvingState_CurrentState_Number
    \value CertificateExpirationAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_ShelvingState_LastTransition
    \value CertificateExpirationAlarmType_ShelvingState_LastTransition_Id
    \value CertificateExpirationAlarmType_ShelvingState_LastTransition_Name
    \value CertificateExpirationAlarmType_ShelvingState_LastTransition_Number
    \value CertificateExpirationAlarmType_ShelvingState_LastTransition_TransitionTime
    \value CertificateExpirationAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_ShelvingState_UnshelveTime
    \value CertificateExpirationAlarmType_ShelvingState_Unshelve
    \value CertificateExpirationAlarmType_ShelvingState_OneShotShelve
    \value CertificateExpirationAlarmType_ShelvingState_TimedShelve
    \value CertificateExpirationAlarmType_ShelvingState_TimedShelve_InputArguments
    \value CertificateExpirationAlarmType_SuppressedOrShelved
    \value CertificateExpirationAlarmType_MaxTimeShelved
    \value CertificateExpirationAlarmType_NormalState
    \value CertificateExpirationAlarmType_ExpirationDate
    \value CertificateExpirationAlarmType_CertificateType
    \value CertificateExpirationAlarmType_Certificate
    \value FileType_MimeType
    \value CreateDirectoryMethodType
    \value CreateDirectoryMethodType_InputArguments
    \value CreateDirectoryMethodType_OutputArguments
    \value CreateFileMethodType
    \value CreateFileMethodType_InputArguments
    \value CreateFileMethodType_OutputArguments
    \value DeleteFileMethodType
    \value DeleteFileMethodType_InputArguments
    \value MoveOrCopyMethodType
    \value MoveOrCopyMethodType_InputArguments
    \value MoveOrCopyMethodType_OutputArguments
    \value FileDirectoryType
    \value FileDirectoryType_FileDirectoryName_Placeholder
    \value FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory
    \value FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_InputArguments
    \value FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments
    \value FileDirectoryType_FileDirectoryName_Placeholder_CreateFile
    \value FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_InputArguments
    \value FileDirectoryType_FileDirectoryName_Placeholder_CreateFile_OutputArguments
    \value FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy
    \value FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments
    \value FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments
    \value FileDirectoryType_FileName_Placeholder
    \value FileDirectoryType_FileName_Placeholder_Size
    \value FileDirectoryType_FileName_Placeholder_Writable
    \value FileDirectoryType_FileName_Placeholder_UserWritable
    \value FileDirectoryType_FileName_Placeholder_OpenCount
    \value FileDirectoryType_FileName_Placeholder_MimeType
    \value FileDirectoryType_FileName_Placeholder_Open
    \value FileDirectoryType_FileName_Placeholder_Open_InputArguments
    \value FileDirectoryType_FileName_Placeholder_Open_OutputArguments
    \value FileDirectoryType_FileName_Placeholder_Close
    \value FileDirectoryType_FileName_Placeholder_Close_InputArguments
    \value FileDirectoryType_FileName_Placeholder_Read
    \value FileDirectoryType_FileName_Placeholder_Read_InputArguments
    \value FileDirectoryType_FileName_Placeholder_Read_OutputArguments
    \value FileDirectoryType_FileName_Placeholder_Write
    \value FileDirectoryType_FileName_Placeholder_Write_InputArguments
    \value FileDirectoryType_FileName_Placeholder_GetPosition
    \value FileDirectoryType_FileName_Placeholder_GetPosition_InputArguments
    \value FileDirectoryType_FileName_Placeholder_GetPosition_OutputArguments
    \value FileDirectoryType_FileName_Placeholder_SetPosition
    \value FileDirectoryType_FileName_Placeholder_SetPosition_InputArguments
    \value FileDirectoryType_CreateDirectory
    \value FileDirectoryType_CreateDirectory_InputArguments
    \value FileDirectoryType_CreateDirectory_OutputArguments
    \value FileDirectoryType_CreateFile
    \value FileDirectoryType_CreateFile_InputArguments
    \value FileDirectoryType_CreateFile_OutputArguments
    \value FileDirectoryType_DeleteFileSystemObject
    \value FileDirectoryType_DeleteFileSystemObject_InputArguments
    \value FileDirectoryType_MoveOrCopy
    \value FileDirectoryType_MoveOrCopy_InputArguments
    \value FileDirectoryType_MoveOrCopy_OutputArguments
    \value AddressSpaceFileType_MimeType
    \value NamespaceMetadataType_NamespaceFile_MimeType
    \value NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_MimeType
    \value TrustListType_MimeType
    \value CertificateGroupType_TrustList
    \value CertificateGroupType_TrustList_Size
    \value CertificateGroupType_TrustList_Writable
    \value CertificateGroupType_TrustList_UserWritable
    \value CertificateGroupType_TrustList_OpenCount
    \value CertificateGroupType_TrustList_MimeType
    \value CertificateGroupType_TrustList_Open
    \value CertificateGroupType_TrustList_Open_InputArguments
    \value CertificateGroupType_TrustList_Open_OutputArguments
    \value CertificateGroupType_TrustList_Close
    \value CertificateGroupType_TrustList_Close_InputArguments
    \value CertificateGroupType_TrustList_Read
    \value CertificateGroupType_TrustList_Read_InputArguments
    \value CertificateGroupType_TrustList_Read_OutputArguments
    \value CertificateGroupType_TrustList_Write
    \value CertificateGroupType_TrustList_Write_InputArguments
    \value CertificateGroupType_TrustList_GetPosition
    \value CertificateGroupType_TrustList_GetPosition_InputArguments
    \value CertificateGroupType_TrustList_GetPosition_OutputArguments
    \value CertificateGroupType_TrustList_SetPosition
    \value CertificateGroupType_TrustList_SetPosition_InputArguments
    \value CertificateGroupType_TrustList_LastUpdateTime
    \value CertificateGroupType_TrustList_OpenWithMasks
    \value CertificateGroupType_TrustList_OpenWithMasks_InputArguments
    \value CertificateGroupType_TrustList_OpenWithMasks_OutputArguments
    \value CertificateGroupType_TrustList_CloseAndUpdate
    \value CertificateGroupType_TrustList_CloseAndUpdate_InputArguments
    \value CertificateGroupType_TrustList_CloseAndUpdate_OutputArguments
    \value CertificateGroupType_TrustList_AddCertificate
    \value CertificateGroupType_TrustList_AddCertificate_InputArguments
    \value CertificateGroupType_TrustList_RemoveCertificate
    \value CertificateGroupType_TrustList_RemoveCertificate_InputArguments
    \value CertificateGroupType_CertificateTypes
    \value CertificateUpdatedAuditEventType_CertificateGroup
    \value CertificateUpdatedAuditEventType_CertificateType
    \value ServerConfiguration_UpdateCertificate
    \value ServerConfiguration_UpdateCertificate_InputArguments
    \value ServerConfiguration_UpdateCertificate_OutputArguments
    \value CertificateGroupFolderType
    \value CertificateGroupFolderType_DefaultApplicationGroup
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Size
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Writable
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UserWritable
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenCount
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_MimeType
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open_OutputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read_OutputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_LastUpdateTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateTypes
    \value CertificateGroupFolderType_DefaultHttpsGroup
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Size
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Writable
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UserWritable
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenCount
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_MimeType
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open_OutputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read_OutputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_LastUpdateTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateTypes
    \value CertificateGroupFolderType_DefaultUserTokenGroup
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Size
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Writable
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UserWritable
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenCount
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_MimeType
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open_OutputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read_OutputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_LastUpdateTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateTypes
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Size
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Writable
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UserWritable
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenCount
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_MimeType
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open_OutputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read_OutputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition_OutputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_LastUpdateTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks_OutputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate_OutputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateTypes
    \value ServerConfigurationType_CertificateGroups
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Size
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Writable
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateTypes
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Size
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Writable
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateTypes
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Size
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateTypes
    \value ServerConfiguration_CertificateGroups
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Size
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Writable
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateTypes
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Size
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateTypes
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Writable
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateTypes
    \value RemoveConnectionMethodType
    \value RemoveConnectionMethodType_InputArguments
    \value PubSubConnectionType
    \value PubSubConnectionType_Address
    \value PubSubConnectionType_RemoveGroup
    \value PubSubConnectionType_RemoveGroup_InputArguments
    \value PubSubGroupType
    \value PublishedVariableDataType
    \value PublishedVariableDataType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_PublishedVariableDataType
    \value OpcUa_XmlSchema_PublishedVariableDataType_DataTypeVersion
    \value OpcUa_XmlSchema_PublishedVariableDataType_DictionaryFragment
    \value PublishedVariableDataType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_PublishedVariableDataType
    \value OpcUa_BinarySchema_PublishedVariableDataType_DataTypeVersion
    \value OpcUa_BinarySchema_PublishedVariableDataType_DictionaryFragment
    \value AuditCreateSessionEventType_SessionId
    \value AuditUrlMismatchEventType_SessionId
    \value Server_ServerRedundancy_ServerNetworkGroups
    \value PublishSubscribeType
    \value PublishSubscribeType_ConnectionName_Placeholder
    \value PublishSubscribeType_ConnectionName_Placeholder_PublisherId
    \value PublishSubscribeType_ConnectionName_Placeholder_Status
    \value PublishSubscribeType_ConnectionName_Placeholder_Status_State
    \value PublishSubscribeType_ConnectionName_Placeholder_Status_Enable
    \value PublishSubscribeType_ConnectionName_Placeholder_Status_Disable
    \value PublishSubscribeType_ConnectionName_Placeholder_Address
    \value PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup
    \value PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup_InputArguments
    \value PublishSubscribeType_RemoveConnection
    \value PublishSubscribeType_RemoveConnection_InputArguments
    \value PublishSubscribeType_PublishedDataSets
    \value PublishSubscribeType_PublishedDataSets_AddPublishedDataItems
    \value PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_InputArguments
    \value PublishSubscribeType_PublishedDataSets_AddPublishedDataItems_OutputArguments
    \value PublishSubscribeType_PublishedDataSets_AddPublishedEvents
    \value PublishSubscribeType_PublishedDataSets_AddPublishedEvents_InputArguments
    \value PublishSubscribeType_PublishedDataSets_AddPublishedEvents_OutputArguments
    \value PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet
    \value PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet_InputArguments
    \value PublishSubscribe
    \value HasPubSubConnection
    \value DataSetFolderType
    \value DataSetFolderType_DataSetFolderName_Placeholder
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems_InputArguments
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems_OutputArguments
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents_InputArguments
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents_OutputArguments
    \value DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet
    \value DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet_InputArguments
    \value DataSetFolderType_PublishedDataSetName_Placeholder
    \value DataSetFolderType_PublishedDataSetName_Placeholder_ConfigurationVersion
    \value DataSetFolderType_AddPublishedDataItems
    \value DataSetFolderType_AddPublishedDataItems_InputArguments
    \value DataSetFolderType_AddPublishedDataItems_OutputArguments
    \value DataSetFolderType_AddPublishedEvents
    \value DataSetFolderType_AddPublishedEvents_InputArguments
    \value DataSetFolderType_AddPublishedEvents_OutputArguments
    \value DataSetFolderType_RemovePublishedDataSet
    \value DataSetFolderType_RemovePublishedDataSet_InputArguments
    \value AddPublishedDataItemsMethodType
    \value AddPublishedDataItemsMethodType_InputArguments
    \value AddPublishedDataItemsMethodType_OutputArguments
    \value AddPublishedEventsMethodType
    \value AddPublishedEventsMethodType_InputArguments
    \value AddPublishedEventsMethodType_OutputArguments
    \value RemovePublishedDataSetMethodType
    \value RemovePublishedDataSetMethodType_InputArguments
    \value PublishedDataSetType
    \value PublishedDataSetType_ConfigurationVersion
    \value DataSetMetaDataType
    \value FieldMetaData
    \value DataTypeDescription
    \value StructureType_EnumStrings
    \value KeyValuePair
    \value PublishedDataItemsType
    \value PublishedDataItemsType_ConfigurationVersion
    \value PublishedDataItemsType_PublishedData
    \value PublishedDataItemsType_AddVariables
    \value PublishedDataItemsType_AddVariables_InputArguments
    \value PublishedDataItemsType_AddVariables_OutputArguments
    \value PublishedDataItemsType_RemoveVariables
    \value PublishedDataItemsType_RemoveVariables_InputArguments
    \value PublishedDataItemsType_RemoveVariables_OutputArguments
    \value PublishedDataItemsAddVariablesMethodType
    \value PublishedDataItemsAddVariablesMethodType_InputArguments
    \value PublishedDataItemsAddVariablesMethodType_OutputArguments
    \value PublishedDataItemsRemoveVariablesMethodType
    \value PublishedDataItemsRemoveVariablesMethodType_InputArguments
    \value PublishedDataItemsRemoveVariablesMethodType_OutputArguments
    \value PublishedEventsType
    \value PublishedEventsType_ConfigurationVersion
    \value PublishedEventsType_PubSubEventNotifier
    \value PublishedEventsType_SelectedFields
    \value PublishedEventsType_Filter
    \value ConfigurationVersionDataType
    \value PubSubConnectionType_PublisherId
    \value PubSubConnectionType_Status
    \value PubSubConnectionType_Status_State
    \value PubSubConnectionType_Status_Enable
    \value PubSubConnectionType_Status_Disable
    \value PubSubConnectionTypeRemoveGroupMethodType
    \value PubSubConnectionTypeRemoveGroupMethodType_InputArguments
    \value PubSubGroupTypeRemoveWriterMethodType
    \value PubSubGroupTypeRemoveWriterMethodType_InputArguments
    \value PubSubGroupTypeRemoveReaderMethodType
    \value PubSubGroupTypeRemoveReaderMethodType_InputArguments
    \value PubSubStatusType
    \value PubSubStatusType_State
    \value PubSubStatusType_Enable
    \value PubSubStatusType_Disable
    \value PubSubState
    \value PubSubState_EnumStrings
    \value FieldTargetDataType
    \value DataSetMetaDataType_Encoding_DefaultXml
    \value FieldMetaData_Encoding_DefaultXml
    \value DataTypeDescription_Encoding_DefaultXml
    \value DataTypeDefinition_Encoding_DefaultXml
    \value StructureDefinition_Encoding_DefaultXml
    \value EnumDefinition_Encoding_DefaultXml
    \value StructureField_Encoding_DefaultXml
    \value EnumField_Encoding_DefaultXml
    \value KeyValuePair_Encoding_DefaultXml
    \value ConfigurationVersionDataType_Encoding_DefaultXml
    \value FieldTargetDataType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_DataSetMetaDataType
    \value OpcUa_XmlSchema_DataSetMetaDataType_DataTypeVersion
    \value OpcUa_XmlSchema_DataSetMetaDataType_DictionaryFragment
    \value OpcUa_XmlSchema_FieldMetaData
    \value OpcUa_XmlSchema_FieldMetaData_DataTypeVersion
    \value OpcUa_XmlSchema_FieldMetaData_DictionaryFragment
    \value OpcUa_XmlSchema_DataTypeDescription
    \value OpcUa_XmlSchema_DataTypeDescription_DataTypeVersion
    \value OpcUa_XmlSchema_DataTypeDescription_DictionaryFragment
    \value OpcUa_XmlSchema_EnumField
    \value OpcUa_XmlSchema_EnumField_DataTypeVersion
    \value OpcUa_XmlSchema_EnumField_DictionaryFragment
    \value OpcUa_XmlSchema_KeyValuePair
    \value OpcUa_XmlSchema_KeyValuePair_DataTypeVersion
    \value OpcUa_XmlSchema_KeyValuePair_DictionaryFragment
    \value OpcUa_XmlSchema_ConfigurationVersionDataType
    \value OpcUa_XmlSchema_ConfigurationVersionDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ConfigurationVersionDataType_DictionaryFragment
    \value OpcUa_XmlSchema_FieldTargetDataType
    \value OpcUa_XmlSchema_FieldTargetDataType_DataTypeVersion
    \value OpcUa_XmlSchema_FieldTargetDataType_DictionaryFragment
    \value FieldMetaData_Encoding_DefaultBinary
    \value StructureField_Encoding_DefaultBinary
    \value EnumField_Encoding_DefaultBinary
    \value KeyValuePair_Encoding_DefaultBinary
    \value ConfigurationVersionDataType_Encoding_DefaultBinary
    \value FieldTargetDataType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_DataSetMetaDataType
    \value OpcUa_BinarySchema_DataSetMetaDataType_DataTypeVersion
    \value OpcUa_BinarySchema_DataSetMetaDataType_DictionaryFragment
    \value OpcUa_BinarySchema_FieldMetaData
    \value OpcUa_BinarySchema_FieldMetaData_DataTypeVersion
    \value OpcUa_BinarySchema_FieldMetaData_DictionaryFragment
    \value OpcUa_BinarySchema_DataTypeDescription
    \value OpcUa_BinarySchema_DataTypeDescription_DataTypeVersion
    \value OpcUa_BinarySchema_DataTypeDescription_DictionaryFragment
    \value OpcUa_BinarySchema_EnumField
    \value OpcUa_BinarySchema_EnumField_DataTypeVersion
    \value OpcUa_BinarySchema_EnumField_DictionaryFragment
    \value OpcUa_BinarySchema_KeyValuePair
    \value OpcUa_BinarySchema_KeyValuePair_DataTypeVersion
    \value OpcUa_BinarySchema_KeyValuePair_DictionaryFragment
    \value OpcUa_BinarySchema_ConfigurationVersionDataType
    \value OpcUa_BinarySchema_ConfigurationVersionDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ConfigurationVersionDataType_DictionaryFragment
    \value OpcUa_BinarySchema_FieldTargetDataType_DataTypeVersion
    \value OpcUa_BinarySchema_FieldTargetDataType_DictionaryFragment
    \value CertificateExpirationAlarmType_ExpirationLimit
    \value DataSetToWriter
    \value DataTypeDictionaryType_Deprecated
    \value MaxCharacters
    \value ServerType_UrisVersion
    \value Server_UrisVersion
    \value SimpleTypeDescription
    \value UABinaryFileDataType
    \value BrokerConnectionTransportDataType
    \value BrokerTransportQualityOfService
    \value BrokerTransportQualityOfService_EnumStrings
    \value SecurityGroupFolderType_SecurityGroupName_Placeholder_KeyLifetime
    \value SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityPolicyUri
    \value SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxFutureKeyCount
    \value AuditConditionResetEventType
    \value AuditConditionResetEventType_EventId
    \value AuditConditionResetEventType_EventType
    \value AuditConditionResetEventType_SourceNode
    \value AuditConditionResetEventType_SourceName
    \value AuditConditionResetEventType_Time
    \value AuditConditionResetEventType_ReceiveTime
    \value AuditConditionResetEventType_LocalTime
    \value AuditConditionResetEventType_Message
    \value AuditConditionResetEventType_Severity
    \value AuditConditionResetEventType_ActionTimeStamp
    \value AuditConditionResetEventType_Status
    \value AuditConditionResetEventType_ServerId
    \value AuditConditionResetEventType_ClientAuditEntryId
    \value AuditConditionResetEventType_ClientUserId
    \value AuditConditionResetEventType_MethodId
    \value AuditConditionResetEventType_InputArguments
    \value PermissionType_OptionSetValues
    \value AccessLevelType
    \value AccessLevelType_OptionSetValues
    \value EventNotifierType
    \value EventNotifierType_OptionSetValues
    \value AccessRestrictionType_OptionSetValues
    \value AttributeWriteMask_OptionSetValues
    \value OpcUa_BinarySchema_Deprecated
    \value ProgramStateMachineType_ProgramDiagnostic_LastMethodInputValues
    \value OpcUa_XmlSchema_Deprecated
    \value ProgramStateMachineType_ProgramDiagnostic_LastMethodOutputValues
    \value KeyValuePair_Encoding_DefaultJson
    \value IdentityMappingRuleType_Encoding_DefaultJson
    \value SecurityGroupFolderType_SecurityGroupName_Placeholder_MaxPastKeyCount
    \value TrustListDataType_Encoding_DefaultJson
    \value DecimalDataType_Encoding_DefaultJson
    \value SecurityGroupType_KeyLifetime
    \value SecurityGroupType_SecurityPolicyUri
    \value SecurityGroupType_MaxFutureKeyCount
    \value ConfigurationVersionDataType_Encoding_DefaultJson
    \value DataSetMetaDataType_Encoding_DefaultJson
    \value FieldMetaData_Encoding_DefaultJson
    \value PublishedEventsType_ModifyFieldSelection
    \value PublishedEventsType_ModifyFieldSelection_InputArguments
    \value PublishedEventsTypeModifyFieldSelectionMethodType
    \value PublishedEventsTypeModifyFieldSelectionMethodType_InputArguments
    \value SecurityGroupType_MaxPastKeyCount
    \value DataTypeDescription_Encoding_DefaultJson
    \value StructureDescription_Encoding_DefaultJson
    \value EnumDescription_Encoding_DefaultJson
    \value PublishedVariableDataType_Encoding_DefaultJson
    \value FieldTargetDataType_Encoding_DefaultJson
    \value RolePermissionType_Encoding_DefaultJson
    \value DataTypeDefinition_Encoding_DefaultJson
    \value DatagramConnectionTransportType
    \value StructureField_Encoding_DefaultJson
    \value StructureDefinition_Encoding_DefaultJson
    \value EnumDefinition_Encoding_DefaultJson
    \value Node_Encoding_DefaultJson
    \value InstanceNode_Encoding_DefaultJson
    \value TypeNode_Encoding_DefaultJson
    \value ObjectNode_Encoding_DefaultJson
    \value DatagramConnectionTransportType_DiscoveryAddress
    \value ObjectTypeNode_Encoding_DefaultJson
    \value VariableNode_Encoding_DefaultJson
    \value VariableTypeNode_Encoding_DefaultJson
    \value ReferenceTypeNode_Encoding_DefaultJson
    \value MethodNode_Encoding_DefaultJson
    \value ViewNode_Encoding_DefaultJson
    \value DataTypeNode_Encoding_DefaultJson
    \value ReferenceNode_Encoding_DefaultJson
    \value Argument_Encoding_DefaultJson
    \value EnumValueType_Encoding_DefaultJson
    \value EnumField_Encoding_DefaultJson
    \value OptionSet_Encoding_DefaultJson
    \value Union_Encoding_DefaultJson
    \value TimeZoneDataType_Encoding_DefaultJson
    \value ApplicationDescription_Encoding_DefaultJson
    \value RequestHeader_Encoding_DefaultJson
    \value ResponseHeader_Encoding_DefaultJson
    \value ServiceFault_Encoding_DefaultJson
    \value SessionlessInvokeRequestType_Encoding_DefaultJson
    \value SessionlessInvokeResponseType_Encoding_DefaultJson
    \value FindServersRequest_Encoding_DefaultJson
    \value FindServersResponse_Encoding_DefaultJson
    \value ServerOnNetwork_Encoding_DefaultJson
    \value FindServersOnNetworkRequest_Encoding_DefaultJson
    \value FindServersOnNetworkResponse_Encoding_DefaultJson
    \value UserTokenPolicy_Encoding_DefaultJson
    \value EndpointDescription_Encoding_DefaultJson
    \value GetEndpointsRequest_Encoding_DefaultJson
    \value GetEndpointsResponse_Encoding_DefaultJson
    \value RegisteredServer_Encoding_DefaultJson
    \value RegisterServerRequest_Encoding_DefaultJson
    \value RegisterServerResponse_Encoding_DefaultJson
    \value DiscoveryConfiguration_Encoding_DefaultJson
    \value MdnsDiscoveryConfiguration_Encoding_DefaultJson
    \value RegisterServer2Request_Encoding_DefaultJson
    \value SubscribedDataSetType
    \value ChoiceStateType
    \value ChoiceStateType_StateNumber
    \value TargetVariablesType
    \value HasGuard
    \value GuardVariableType
    \value TargetVariablesType_TargetVariables
    \value TargetVariablesType_AddTargetVariables
    \value TargetVariablesType_AddTargetVariables_InputArguments
    \value TargetVariablesType_AddTargetVariables_OutputArguments
    \value TargetVariablesType_RemoveTargetVariables
    \value TargetVariablesType_RemoveTargetVariables_InputArguments
    \value TargetVariablesType_RemoveTargetVariables_OutputArguments
    \value TargetVariablesTypeAddTargetVariablesMethodType
    \value TargetVariablesTypeAddTargetVariablesMethodType_InputArguments
    \value TargetVariablesTypeAddTargetVariablesMethodType_OutputArguments
    \value TargetVariablesTypeRemoveTargetVariablesMethodType
    \value TargetVariablesTypeRemoveTargetVariablesMethodType_InputArguments
    \value TargetVariablesTypeRemoveTargetVariablesMethodType_OutputArguments
    \value SubscribedDataSetMirrorType
    \value ExpressionGuardVariableType
    \value ExpressionGuardVariableType_Expression
    \value RegisterServer2Response_Encoding_DefaultJson
    \value ChannelSecurityToken_Encoding_DefaultJson
    \value OpenSecureChannelRequest_Encoding_DefaultJson
    \value OpenSecureChannelResponse_Encoding_DefaultJson
    \value CloseSecureChannelRequest_Encoding_DefaultJson
    \value CloseSecureChannelResponse_Encoding_DefaultJson
    \value SignedSoftwareCertificate_Encoding_DefaultJson
    \value SignatureData_Encoding_DefaultJson
    \value CreateSessionRequest_Encoding_DefaultJson
    \value CreateSessionResponse_Encoding_DefaultJson
    \value UserIdentityToken_Encoding_DefaultJson
    \value AnonymousIdentityToken_Encoding_DefaultJson
    \value UserNameIdentityToken_Encoding_DefaultJson
    \value X509IdentityToken_Encoding_DefaultJson
    \value IssuedIdentityToken_Encoding_DefaultJson
    \value ActivateSessionRequest_Encoding_DefaultJson
    \value ActivateSessionResponse_Encoding_DefaultJson
    \value CloseSessionRequest_Encoding_DefaultJson
    \value CloseSessionResponse_Encoding_DefaultJson
    \value CancelRequest_Encoding_DefaultJson
    \value CancelResponse_Encoding_DefaultJson
    \value NodeAttributes_Encoding_DefaultJson
    \value ObjectAttributes_Encoding_DefaultJson
    \value VariableAttributes_Encoding_DefaultJson
    \value DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface
    \value BrokerConnectionTransportType
    \value BrokerConnectionTransportType_ResourceUri
    \value MethodAttributes_Encoding_DefaultJson
    \value ObjectTypeAttributes_Encoding_DefaultJson
    \value VariableTypeAttributes_Encoding_DefaultJson
    \value ReferenceTypeAttributes_Encoding_DefaultJson
    \value DataTypeAttributes_Encoding_DefaultJson
    \value ViewAttributes_Encoding_DefaultJson
    \value GenericAttributeValue_Encoding_DefaultJson
    \value GenericAttributes_Encoding_DefaultJson
    \value AddNodesItem_Encoding_DefaultJson
    \value AddNodesResult_Encoding_DefaultJson
    \value AddNodesRequest_Encoding_DefaultJson
    \value AddNodesResponse_Encoding_DefaultJson
    \value AddReferencesItem_Encoding_DefaultJson
    \value AddReferencesRequest_Encoding_DefaultJson
    \value AddReferencesResponse_Encoding_DefaultJson
    \value DeleteNodesItem_Encoding_DefaultJson
    \value DeleteNodesRequest_Encoding_DefaultJson
    \value DeleteNodesResponse_Encoding_DefaultJson
    \value DeleteReferencesItem_Encoding_DefaultJson
    \value DeleteReferencesRequest_Encoding_DefaultJson
    \value DeleteReferencesResponse_Encoding_DefaultJson
    \value BrokerConnectionTransportType_AuthenticationProfileUri
    \value ViewDescription_Encoding_DefaultJson
    \value BrowseDescription_Encoding_DefaultJson
    \value UserCredentialCertificateType
    \value ReferenceDescription_Encoding_DefaultJson
    \value BrowseResult_Encoding_DefaultJson
    \value BrowseRequest_Encoding_DefaultJson
    \value BrowseResponse_Encoding_DefaultJson
    \value BrowseNextRequest_Encoding_DefaultJson
    \value BrowseNextResponse_Encoding_DefaultJson
    \value RelativePathElement_Encoding_DefaultJson
    \value RelativePath_Encoding_DefaultJson
    \value BrowsePath_Encoding_DefaultJson
    \value BrowsePathTarget_Encoding_DefaultJson
    \value BrowsePathResult_Encoding_DefaultJson
    \value TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultJson
    \value TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultJson
    \value RegisterNodesRequest_Encoding_DefaultJson
    \value RegisterNodesResponse_Encoding_DefaultJson
    \value UnregisterNodesRequest_Encoding_DefaultJson
    \value UnregisterNodesResponse_Encoding_DefaultJson
    \value EndpointConfiguration_Encoding_DefaultJson
    \value QueryDataDescription_Encoding_DefaultJson
    \value NodeTypeDescription_Encoding_DefaultJson
    \value QueryDataSet_Encoding_DefaultJson
    \value NodeReference_Encoding_DefaultJson
    \value ContentFilterElement_Encoding_DefaultJson
    \value ContentFilter_Encoding_DefaultJson
    \value FilterOperand_Encoding_DefaultJson
    \value ElementOperand_Encoding_DefaultJson
    \value LiteralOperand_Encoding_DefaultJson
    \value AttributeOperand_Encoding_DefaultJson
    \value SimpleAttributeOperand_Encoding_DefaultJson
    \value ContentFilterElementResult_Encoding_DefaultJson
    \value PublishSubscribeType_GetSecurityKeys
    \value PublishSubscribeType_GetSecurityKeys_InputArguments
    \value PublishSubscribeType_GetSecurityKeys_OutputArguments
    \value PublishSubscribe_GetSecurityKeys
    \value PublishSubscribe_GetSecurityKeys_InputArguments
    \value PublishSubscribe_GetSecurityKeys_OutputArguments
    \value GetSecurityKeysMethodType
    \value GetSecurityKeysMethodType_InputArguments
    \value GetSecurityKeysMethodType_OutputArguments
    \value DataSetFolderType_PublishedDataSetName_Placeholder_DataSetMetaData
    \value PublishedDataSetType_DataSetWriterName_Placeholder
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Status
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Status_State
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Status_Enable
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Status_Disable
    \value PublishedDataSetType_DataSetWriterName_Placeholder_TransportSettings
    \value ContentFilterResult_Encoding_DefaultJson
    \value PublishedDataSetType_DataSetMetaData
    \value PublishedDataItemsType_DataSetWriterName_Placeholder
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Status
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Status_State
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Status_Enable
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Status_Disable
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_TransportSettings
    \value ParsingResult_Encoding_DefaultJson
    \value PublishedDataItemsType_DataSetMetaData
    \value PublishedEventsType_DataSetWriterName_Placeholder
    \value PublishedEventsType_DataSetWriterName_Placeholder_Status
    \value PublishedEventsType_DataSetWriterName_Placeholder_Status_State
    \value PublishedEventsType_DataSetWriterName_Placeholder_Status_Enable
    \value PublishedEventsType_DataSetWriterName_Placeholder_Status_Disable
    \value PublishedEventsType_DataSetWriterName_Placeholder_TransportSettings
    \value QueryFirstRequest_Encoding_DefaultJson
    \value PublishedEventsType_DataSetMetaData
    \value BrokerWriterGroupTransportType_ResourceUri
    \value BrokerWriterGroupTransportType_AuthenticationProfileUri
    \value CreateCredentialMethodType
    \value BrokerWriterGroupTransportType_RequestedDeliveryGuarantee
    \value BrokerDataSetWriterTransportType_ResourceUri
    \value BrokerDataSetWriterTransportType_AuthenticationProfileUri
    \value QueryFirstResponse_Encoding_DefaultJson
    \value CreateCredentialMethodType_InputArguments
    \value QueryNextRequest_Encoding_DefaultJson
    \value QueryNextResponse_Encoding_DefaultJson
    \value ReadValueId_Encoding_DefaultJson
    \value ReadRequest_Encoding_DefaultJson
    \value ReadResponse_Encoding_DefaultJson
    \value HistoryReadValueId_Encoding_DefaultJson
    \value HistoryReadResult_Encoding_DefaultJson
    \value HistoryReadDetails_Encoding_DefaultJson
    \value ReadEventDetails_Encoding_DefaultJson
    \value ReadRawModifiedDetails_Encoding_DefaultJson
    \value ReadProcessedDetails_Encoding_DefaultJson
    \value PubSubGroupType_Status
    \value PubSubGroupType_Status_State
    \value PubSubGroupType_Status_Enable
    \value PubSubGroupType_Status_Disable
    \value ReadAtTimeDetails_Encoding_DefaultJson
    \value HistoryData_Encoding_DefaultJson
    \value ModificationInfo_Encoding_DefaultJson
    \value HistoryModifiedData_Encoding_DefaultJson
    \value HistoryEvent_Encoding_DefaultJson
    \value HistoryReadRequest_Encoding_DefaultJson
    \value HistoryReadResponse_Encoding_DefaultJson
    \value WriteValue_Encoding_DefaultJson
    \value WriteRequest_Encoding_DefaultJson
    \value WriteResponse_Encoding_DefaultJson
    \value HistoryUpdateDetails_Encoding_DefaultJson
    \value UpdateDataDetails_Encoding_DefaultJson
    \value UpdateStructureDataDetails_Encoding_DefaultJson
    \value UpdateEventDetails_Encoding_DefaultJson
    \value DeleteRawModifiedDetails_Encoding_DefaultJson
    \value DeleteAtTimeDetails_Encoding_DefaultJson
    \value DeleteEventDetails_Encoding_DefaultJson
    \value HistoryUpdateResult_Encoding_DefaultJson
    \value HistoryUpdateRequest_Encoding_DefaultJson
    \value HistoryUpdateResponse_Encoding_DefaultJson
    \value CallMethodRequest_Encoding_DefaultJson
    \value CallMethodResult_Encoding_DefaultJson
    \value CallRequest_Encoding_DefaultJson
    \value CallResponse_Encoding_DefaultJson
    \value MonitoringFilter_Encoding_DefaultJson
    \value DataChangeFilter_Encoding_DefaultJson
    \value EventFilter_Encoding_DefaultJson
    \value HasDataSetWriter
    \value HasDataSetReader
    \value DataSetWriterType
    \value DataSetWriterType_Status
    \value DataSetWriterType_Status_State
    \value DataSetWriterType_Status_Enable
    \value DataSetWriterType_Status_Disable
    \value DataSetWriterType_TransportSettings
    \value AggregateConfiguration_Encoding_DefaultJson
    \value DataSetWriterTransportType
    \value DataSetReaderType
    \value DataSetReaderType_Status
    \value DataSetReaderType_Status_State
    \value DataSetReaderType_Status_Enable
    \value DataSetReaderType_Status_Disable
    \value DataSetReaderType_TransportSettings
    \value AggregateFilter_Encoding_DefaultJson
    \value MonitoringFilterResult_Encoding_DefaultJson
    \value EventFilterResult_Encoding_DefaultJson
    \value AggregateFilterResult_Encoding_DefaultJson
    \value DataSetReaderType_SubscribedDataSet
    \value ElseGuardVariableType
    \value BaseAnalogType
    \value DataSetReaderTransportType
    \value MonitoringParameters_Encoding_DefaultJson
    \value MonitoredItemCreateRequest_Encoding_DefaultJson
    \value MonitoredItemCreateResult_Encoding_DefaultJson
    \value CreateMonitoredItemsRequest_Encoding_DefaultJson
    \value CreateMonitoredItemsResponse_Encoding_DefaultJson
    \value MonitoredItemModifyRequest_Encoding_DefaultJson
    \value MonitoredItemModifyResult_Encoding_DefaultJson
    \value ModifyMonitoredItemsRequest_Encoding_DefaultJson
    \value ModifyMonitoredItemsResponse_Encoding_DefaultJson
    \value SetMonitoringModeRequest_Encoding_DefaultJson
    \value BrokerDataSetWriterTransportType_RequestedDeliveryGuarantee
    \value SetMonitoringModeResponse_Encoding_DefaultJson
    \value SetTriggeringRequest_Encoding_DefaultJson
    \value SetTriggeringResponse_Encoding_DefaultJson
    \value BrokerDataSetReaderTransportType_ResourceUri
    \value DeleteMonitoredItemsRequest_Encoding_DefaultJson
    \value DeleteMonitoredItemsResponse_Encoding_DefaultJson
    \value CreateSubscriptionRequest_Encoding_DefaultJson
    \value CreateSubscriptionResponse_Encoding_DefaultJson
    \value ModifySubscriptionRequest_Encoding_DefaultJson
    \value ModifySubscriptionResponse_Encoding_DefaultJson
    \value SetPublishingModeRequest_Encoding_DefaultJson
    \value SetPublishingModeResponse_Encoding_DefaultJson
    \value NotificationMessage_Encoding_DefaultJson
    \value NotificationData_Encoding_DefaultJson
    \value DataChangeNotification_Encoding_DefaultJson
    \value MonitoredItemNotification_Encoding_DefaultJson
    \value EventNotificationList_Encoding_DefaultJson
    \value EventFieldList_Encoding_DefaultJson
    \value HistoryEventFieldList_Encoding_DefaultJson
    \value StatusChangeNotification_Encoding_DefaultJson
    \value SubscriptionAcknowledgement_Encoding_DefaultJson
    \value PublishRequest_Encoding_DefaultJson
    \value PublishResponse_Encoding_DefaultJson
    \value RepublishRequest_Encoding_DefaultJson
    \value RepublishResponse_Encoding_DefaultJson
    \value TransferResult_Encoding_DefaultJson
    \value TransferSubscriptionsRequest_Encoding_DefaultJson
    \value TransferSubscriptionsResponse_Encoding_DefaultJson
    \value DeleteSubscriptionsRequest_Encoding_DefaultJson
    \value DeleteSubscriptionsResponse_Encoding_DefaultJson
    \value BuildInfo_Encoding_DefaultJson
    \value RedundantServerDataType_Encoding_DefaultJson
    \value EndpointUrlListDataType_Encoding_DefaultJson
    \value NetworkGroupDataType_Encoding_DefaultJson
    \value SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson
    \value ServerDiagnosticsSummaryDataType_Encoding_DefaultJson
    \value ServerStatusDataType_Encoding_DefaultJson
    \value SessionDiagnosticsDataType_Encoding_DefaultJson
    \value SessionSecurityDiagnosticsDataType_Encoding_DefaultJson
    \value ServiceCounterDataType_Encoding_DefaultJson
    \value StatusResult_Encoding_DefaultJson
    \value SubscriptionDiagnosticsDataType_Encoding_DefaultJson
    \value ModelChangeStructureDataType_Encoding_DefaultJson
    \value SemanticChangeStructureDataType_Encoding_DefaultJson
    \value Range_Encoding_DefaultJson
    \value EUInformation_Encoding_DefaultJson
    \value ComplexNumberType_Encoding_DefaultJson
    \value DoubleComplexNumberType_Encoding_DefaultJson
    \value AxisInformation_Encoding_DefaultJson
    \value XVType_Encoding_DefaultJson
    \value ProgramDiagnosticDataType_Encoding_DefaultJson
    \value Annotation_Encoding_DefaultJson
    \value ProgramDiagnostic2Type
    \value ProgramDiagnostic2Type_CreateSessionId
    \value ProgramDiagnostic2Type_CreateClientName
    \value ProgramDiagnostic2Type_InvocationCreationTime
    \value ProgramDiagnostic2Type_LastTransitionTime
    \value ProgramDiagnostic2Type_LastMethodCall
    \value ProgramDiagnostic2Type_LastMethodSessionId
    \value ProgramDiagnostic2Type_LastMethodInputArguments
    \value ProgramDiagnostic2Type_LastMethodOutputArguments
    \value ProgramDiagnostic2Type_LastMethodInputValues
    \value ProgramDiagnostic2Type_LastMethodOutputValues
    \value ProgramDiagnostic2Type_LastMethodCallTime
    \value ProgramDiagnostic2Type_LastMethodReturnStatus
    \value AccessLevelExType
    \value AccessLevelExType_OptionSetValues
    \value RoleSetType_RoleName_Placeholder_ApplicationsExclude
    \value RoleSetType_RoleName_Placeholder_EndpointsExclude
    \value RoleType_ApplicationsExclude
    \value RoleType_EndpointsExclude
    \value WellKnownRole_Anonymous_ApplicationsExclude
    \value WellKnownRole_Anonymous_EndpointsExclude
    \value WellKnownRole_AuthenticatedUser_ApplicationsExclude
    \value WellKnownRole_AuthenticatedUser_EndpointsExclude
    \value WellKnownRole_Observer_ApplicationsExclude
    \value WellKnownRole_Observer_EndpointsExclude
    \value WellKnownRole_Operator_ApplicationsExclude
    \value BrokerDataSetReaderTransportType_AuthenticationProfileUri
    \value BrokerDataSetReaderTransportType_RequestedDeliveryGuarantee
    \value SimpleTypeDescription_Encoding_DefaultBinary
    \value UABinaryFileDataType_Encoding_DefaultBinary
    \value WellKnownRole_Operator_EndpointsExclude
    \value WellKnownRole_Engineer_ApplicationsExclude
    \value WellKnownRole_Engineer_EndpointsExclude
    \value WellKnownRole_Supervisor_ApplicationsExclude
    \value WellKnownRole_Supervisor_EndpointsExclude
    \value WellKnownRole_ConfigureAdmin_ApplicationsExclude
    \value WellKnownRole_ConfigureAdmin_EndpointsExclude
    \value WellKnownRole_SecurityAdmin_ApplicationsExclude
    \value PublishSubscribeType_GetSecurityGroup
    \value PublishSubscribeType_GetSecurityGroup_InputArguments
    \value PublishSubscribeType_GetSecurityGroup_OutputArguments
    \value PublishSubscribeType_SecurityGroups
    \value PublishSubscribeType_SecurityGroups_AddSecurityGroup
    \value PublishSubscribeType_SecurityGroups_AddSecurityGroup_InputArguments
    \value PublishSubscribeType_SecurityGroups_AddSecurityGroup_OutputArguments
    \value PublishSubscribeType_SecurityGroups_RemoveSecurityGroup
    \value PublishSubscribeType_SecurityGroups_RemoveSecurityGroup_InputArguments
    \value PublishSubscribe_GetSecurityGroup
    \value PublishSubscribe_GetSecurityGroup_InputArguments
    \value PublishSubscribe_GetSecurityGroup_OutputArguments
    \value PublishSubscribe_SecurityGroups
    \value PublishSubscribe_SecurityGroups_AddSecurityGroup
    \value PublishSubscribe_SecurityGroups_AddSecurityGroup_InputArguments
    \value PublishSubscribe_SecurityGroups_AddSecurityGroup_OutputArguments
    \value PublishSubscribe_SecurityGroups_RemoveSecurityGroup
    \value PublishSubscribe_SecurityGroups_RemoveSecurityGroup_InputArguments
    \value GetSecurityGroupMethodType
    \value GetSecurityGroupMethodType_InputArguments
    \value GetSecurityGroupMethodType_OutputArguments
    \value SecurityGroupFolderType
    \value SecurityGroupFolderType_SecurityGroupFolderName_Placeholder
    \value SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup
    \value SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_InputArguments
    \value SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup_OutputArguments
    \value SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup
    \value SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup_InputArguments
    \value SecurityGroupFolderType_SecurityGroupName_Placeholder
    \value SecurityGroupFolderType_SecurityGroupName_Placeholder_SecurityGroupId
    \value SecurityGroupFolderType_AddSecurityGroup
    \value SecurityGroupFolderType_AddSecurityGroup_InputArguments
    \value SecurityGroupFolderType_AddSecurityGroup_OutputArguments
    \value SecurityGroupFolderType_RemoveSecurityGroup
    \value SecurityGroupFolderType_RemoveSecurityGroup_InputArguments
    \value AddSecurityGroupMethodType
    \value AddSecurityGroupMethodType_InputArguments
    \value AddSecurityGroupMethodType_OutputArguments
    \value RemoveSecurityGroupMethodType
    \value RemoveSecurityGroupMethodType_InputArguments
    \value SecurityGroupType
    \value SecurityGroupType_SecurityGroupId
    \value DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields
    \value DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField
    \value DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField_InputArguments
    \value DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField_OutputArguments
    \value DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField
    \value DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField_InputArguments
    \value BrokerConnectionTransportDataType_Encoding_DefaultBinary
    \value WriterGroupDataType
    \value PublishedDataSetType_ExtensionFields
    \value PublishedDataSetType_ExtensionFields_AddExtensionField
    \value PublishedDataSetType_ExtensionFields_AddExtensionField_InputArguments
    \value PublishedDataSetType_ExtensionFields_AddExtensionField_OutputArguments
    \value PublishedDataSetType_ExtensionFields_RemoveExtensionField
    \value PublishedDataSetType_ExtensionFields_RemoveExtensionField_InputArguments
    \value StructureDescription
    \value EnumDescription
    \value ExtensionFieldsType
    \value ExtensionFieldsType_ExtensionFieldName_Placeholder
    \value ExtensionFieldsType_AddExtensionField
    \value ExtensionFieldsType_AddExtensionField_InputArguments
    \value ExtensionFieldsType_AddExtensionField_OutputArguments
    \value ExtensionFieldsType_RemoveExtensionField
    \value ExtensionFieldsType_RemoveExtensionField_InputArguments
    \value AddExtensionFieldMethodType
    \value AddExtensionFieldMethodType_InputArguments
    \value AddExtensionFieldMethodType_OutputArguments
    \value RemoveExtensionFieldMethodType
    \value RemoveExtensionFieldMethodType_InputArguments
    \value OpcUa_BinarySchema_SimpleTypeDescription
    \value NetworkAddressDataType
    \value PublishedDataItemsType_ExtensionFields
    \value PublishedDataItemsType_ExtensionFields_AddExtensionField
    \value PublishedDataItemsType_ExtensionFields_AddExtensionField_InputArguments
    \value PublishedDataItemsType_ExtensionFields_AddExtensionField_OutputArguments
    \value PublishedDataItemsType_ExtensionFields_RemoveExtensionField
    \value PublishedDataItemsType_ExtensionFields_RemoveExtensionField_InputArguments
    \value OpcUa_BinarySchema_SimpleTypeDescription_DataTypeVersion
    \value NetworkAddressUrlDataType
    \value PublishedEventsType_ExtensionFields
    \value PublishedEventsType_ExtensionFields_AddExtensionField
    \value PublishedEventsType_ExtensionFields_AddExtensionField_InputArguments
    \value PublishedEventsType_ExtensionFields_AddExtensionField_OutputArguments
    \value PublishedEventsType_ExtensionFields_RemoveExtensionField
    \value PublishedEventsType_ExtensionFields_RemoveExtensionField_InputArguments
    \value PublishedEventsType_ModifyFieldSelection_OutputArguments
    \value PublishedEventsTypeModifyFieldSelectionMethodType_OutputArguments
    \value OpcUa_BinarySchema_SimpleTypeDescription_DictionaryFragment
    \value ReaderGroupDataType
    \value OpcUa_BinarySchema_UABinaryFileDataType
    \value OpcUa_BinarySchema_UABinaryFileDataType_DataTypeVersion
    \value OpcUa_BinarySchema_UABinaryFileDataType_DictionaryFragment
    \value OpcUa_BinarySchema_BrokerConnectionTransportDataType
    \value OpcUa_BinarySchema_BrokerConnectionTransportDataType_DataTypeVersion
    \value OpcUa_BinarySchema_BrokerConnectionTransportDataType_DictionaryFragment
    \value WellKnownRole_SecurityAdmin_EndpointsExclude
    \value EndpointType
    \value SimpleTypeDescription_Encoding_DefaultXml
    \value PubSubConfigurationDataType
    \value UABinaryFileDataType_Encoding_DefaultXml
    \value DatagramWriterGroupTransportDataType
    \value PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface
    \value DataTypeSchemaHeader
    \value PubSubStatusEventType
    \value PubSubStatusEventType_EventId
    \value PubSubStatusEventType_EventType
    \value PubSubStatusEventType_SourceNode
    \value PubSubStatusEventType_SourceName
    \value PubSubStatusEventType_Time
    \value PubSubStatusEventType_ReceiveTime
    \value PubSubStatusEventType_LocalTime
    \value PubSubStatusEventType_Message
    \value PubSubStatusEventType_Severity
    \value PubSubStatusEventType_ConnectionId
    \value PubSubStatusEventType_GroupId
    \value PubSubStatusEventType_State
    \value PubSubTransportLimitsExceedEventType
    \value PubSubTransportLimitsExceedEventType_EventId
    \value PubSubTransportLimitsExceedEventType_EventType
    \value PubSubTransportLimitsExceedEventType_SourceNode
    \value PubSubTransportLimitsExceedEventType_SourceName
    \value PubSubTransportLimitsExceedEventType_Time
    \value PubSubTransportLimitsExceedEventType_ReceiveTime
    \value PubSubTransportLimitsExceedEventType_LocalTime
    \value PubSubTransportLimitsExceedEventType_Message
    \value PubSubTransportLimitsExceedEventType_Severity
    \value PubSubTransportLimitsExceedEventType_ConnectionId
    \value PubSubTransportLimitsExceedEventType_GroupId
    \value PubSubTransportLimitsExceedEventType_State
    \value PubSubTransportLimitsExceedEventType_Actual
    \value PubSubTransportLimitsExceedEventType_Maximum
    \value PubSubCommunicationFailureEventType
    \value PubSubCommunicationFailureEventType_EventId
    \value PubSubCommunicationFailureEventType_EventType
    \value PubSubCommunicationFailureEventType_SourceNode
    \value PubSubCommunicationFailureEventType_SourceName
    \value PubSubCommunicationFailureEventType_Time
    \value PubSubCommunicationFailureEventType_ReceiveTime
    \value PubSubCommunicationFailureEventType_LocalTime
    \value PubSubCommunicationFailureEventType_Message
    \value PubSubCommunicationFailureEventType_Severity
    \value PubSubCommunicationFailureEventType_ConnectionId
    \value PubSubCommunicationFailureEventType_GroupId
    \value PubSubCommunicationFailureEventType_State
    \value PubSubCommunicationFailureEventType_Error
    \value DataSetFieldFlags_OptionSetValues
    \value PublishedDataSetDataType
    \value BrokerConnectionTransportDataType_Encoding_DefaultXml
    \value PublishedDataSetSourceDataType
    \value PublishedDataItemsDataType
    \value PublishedEventsDataType
    \value DataSetFieldContentMask
    \value DataSetFieldContentMask_OptionSetValues
    \value OpcUa_XmlSchema_SimpleTypeDescription
    \value OpcUa_XmlSchema_SimpleTypeDescription_DataTypeVersion
    \value OpcUa_XmlSchema_SimpleTypeDescription_DictionaryFragment
    \value OpcUa_XmlSchema_UABinaryFileDataType
    \value StructureDescription_Encoding_DefaultXml
    \value EnumDescription_Encoding_DefaultXml
    \value OpcUa_XmlSchema_StructureDescription
    \value OpcUa_XmlSchema_StructureDescription_DataTypeVersion
    \value OpcUa_XmlSchema_StructureDescription_DictionaryFragment
    \value OpcUa_XmlSchema_EnumDescription
    \value OpcUa_XmlSchema_EnumDescription_DataTypeVersion
    \value OpcUa_XmlSchema_EnumDescription_DictionaryFragment
    \value DataSetWriterDataType
    \value DataSetWriterTransportDataType
    \value OpcUa_BinarySchema_StructureDescription
    \value OpcUa_BinarySchema_StructureDescription_DataTypeVersion
    \value OpcUa_BinarySchema_StructureDescription_DictionaryFragment
    \value OpcUa_BinarySchema_EnumDescription
    \value OpcUa_BinarySchema_EnumDescription_DataTypeVersion
    \value OpcUa_BinarySchema_EnumDescription_DictionaryFragment
    \value DataSetWriterMessageDataType
    \value Server_ServerCapabilities_RoleSet
    \value RoleSetType
    \value RoleSetType_RoleName_Placeholder
    \value PubSubGroupDataType
    \value OpcUa_XmlSchema_UABinaryFileDataType_DataTypeVersion
    \value WriterGroupTransportDataType
    \value RoleSetType_RoleName_Placeholder_AddIdentity
    \value RoleSetType_RoleName_Placeholder_AddIdentity_InputArguments
    \value RoleSetType_RoleName_Placeholder_RemoveIdentity
    \value RoleSetType_RoleName_Placeholder_RemoveIdentity_InputArguments
    \value WriterGroupMessageDataType
    \value PubSubConnectionDataType
    \value ConnectionTransportDataType
    \value OpcUa_XmlSchema_UABinaryFileDataType_DictionaryFragment
    \value RoleType
    \value ReaderGroupTransportDataType
    \value ReaderGroupMessageDataType
    \value DataSetReaderDataType
    \value RoleType_AddIdentity
    \value RoleType_AddIdentity_InputArguments
    \value RoleType_RemoveIdentity
    \value RoleType_RemoveIdentity_InputArguments
    \value DataSetReaderTransportDataType
    \value DataSetReaderMessageDataType
    \value SubscribedDataSetDataType
    \value TargetVariablesDataType
    \value IdentityCriteriaType
    \value IdentityCriteriaType_EnumValues
    \value IdentityMappingRuleType
    \value SubscribedDataSetMirrorDataType
    \value AddIdentityMethodType
    \value AddIdentityMethodType_InputArguments
    \value RemoveIdentityMethodType
    \value RemoveIdentityMethodType_InputArguments
    \value OpcUa_XmlSchema_BrokerConnectionTransportDataType
    \value DataSetOrderingType_EnumStrings
    \value UadpNetworkMessageContentMask
    \value UadpNetworkMessageContentMask_OptionSetValues
    \value WellKnownRole_Anonymous
    \value UadpWriterGroupMessageDataType
    \value UadpDataSetMessageContentMask
    \value UadpDataSetMessageContentMask_OptionSetValues
    \value WellKnownRole_Anonymous_AddIdentity
    \value WellKnownRole_Anonymous_AddIdentity_InputArguments
    \value WellKnownRole_Anonymous_RemoveIdentity
    \value WellKnownRole_Anonymous_RemoveIdentity_InputArguments
    \value UadpDataSetWriterMessageDataType
    \value UadpDataSetReaderMessageDataType
    \value JsonNetworkMessageContentMask
    \value JsonNetworkMessageContentMask_OptionSetValues
    \value WellKnownRole_AuthenticatedUser
    \value JsonWriterGroupMessageDataType
    \value JsonDataSetMessageContentMask
    \value JsonDataSetMessageContentMask_OptionSetValues
    \value WellKnownRole_AuthenticatedUser_AddIdentity
    \value WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments
    \value WellKnownRole_AuthenticatedUser_RemoveIdentity
    \value WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments
    \value JsonDataSetWriterMessageDataType
    \value JsonDataSetReaderMessageDataType
    \value OpcUa_XmlSchema_BrokerConnectionTransportDataType_DataTypeVersion
    \value BrokerWriterGroupTransportDataType
    \value WellKnownRole_Observer
    \value BrokerDataSetWriterTransportDataType
    \value BrokerDataSetReaderTransportDataType
    \value EndpointType_Encoding_DefaultBinary
    \value WellKnownRole_Observer_AddIdentity
    \value WellKnownRole_Observer_AddIdentity_InputArguments
    \value WellKnownRole_Observer_RemoveIdentity
    \value WellKnownRole_Observer_RemoveIdentity_InputArguments
    \value DataTypeSchemaHeader_Encoding_DefaultBinary
    \value PublishedDataSetDataType_Encoding_DefaultBinary
    \value PublishedDataSetSourceDataType_Encoding_DefaultBinary
    \value PublishedDataItemsDataType_Encoding_DefaultBinary
    \value WellKnownRole_Operator
    \value PublishedEventsDataType_Encoding_DefaultBinary
    \value DataSetWriterDataType_Encoding_DefaultBinary
    \value DataSetWriterTransportDataType_Encoding_DefaultBinary
    \value WellKnownRole_Operator_AddIdentity
    \value WellKnownRole_Operator_AddIdentity_InputArguments
    \value WellKnownRole_Operator_RemoveIdentity
    \value WellKnownRole_Operator_RemoveIdentity_InputArguments
    \value DataSetWriterMessageDataType_Encoding_DefaultBinary
    \value PubSubGroupDataType_Encoding_DefaultBinary
    \value OpcUa_XmlSchema_BrokerConnectionTransportDataType_DictionaryFragment
    \value WriterGroupTransportDataType_Encoding_DefaultBinary
    \value WellKnownRole_Supervisor
    \value WriterGroupMessageDataType_Encoding_DefaultBinary
    \value PubSubConnectionDataType_Encoding_DefaultBinary
    \value ConnectionTransportDataType_Encoding_DefaultBinary
    \value WellKnownRole_Supervisor_AddIdentity
    \value WellKnownRole_Supervisor_AddIdentity_InputArguments
    \value WellKnownRole_Supervisor_RemoveIdentity
    \value WellKnownRole_Supervisor_RemoveIdentity_InputArguments
    \value SimpleTypeDescription_Encoding_DefaultJson
    \value ReaderGroupTransportDataType_Encoding_DefaultBinary
    \value ReaderGroupMessageDataType_Encoding_DefaultBinary
    \value DataSetReaderDataType_Encoding_DefaultBinary
    \value WellKnownRole_SecurityAdmin
    \value DataSetReaderTransportDataType_Encoding_DefaultBinary
    \value DataSetReaderMessageDataType_Encoding_DefaultBinary
    \value SubscribedDataSetDataType_Encoding_DefaultBinary
    \value WellKnownRole_SecurityAdmin_AddIdentity
    \value WellKnownRole_SecurityAdmin_AddIdentity_InputArguments
    \value WellKnownRole_SecurityAdmin_RemoveIdentity
    \value WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments
    \value TargetVariablesDataType_Encoding_DefaultBinary
    \value SubscribedDataSetMirrorDataType_Encoding_DefaultBinary
    \value UABinaryFileDataType_Encoding_DefaultJson
    \value UadpWriterGroupMessageDataType_Encoding_DefaultBinary
    \value WellKnownRole_ConfigureAdmin
    \value UadpDataSetWriterMessageDataType_Encoding_DefaultBinary
    \value UadpDataSetReaderMessageDataType_Encoding_DefaultBinary
    \value JsonWriterGroupMessageDataType_Encoding_DefaultBinary
    \value WellKnownRole_ConfigureAdmin_AddIdentity
    \value WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments
    \value WellKnownRole_ConfigureAdmin_RemoveIdentity
    \value WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments
    \value JsonDataSetWriterMessageDataType_Encoding_DefaultBinary
    \value JsonDataSetReaderMessageDataType_Encoding_DefaultBinary
    \value BrokerConnectionTransportDataType_Encoding_DefaultJson
    \value BrokerWriterGroupTransportDataType_Encoding_DefaultBinary
    \value IdentityMappingRuleType_Encoding_DefaultXml
    \value BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary
    \value OpcUa_XmlSchema_IdentityMappingRuleType
    \value OpcUa_XmlSchema_IdentityMappingRuleType_DataTypeVersion
    \value OpcUa_XmlSchema_IdentityMappingRuleType_DictionaryFragment
    \value BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_EndpointType
    \value OpcUa_BinarySchema_EndpointType_DataTypeVersion
    \value IdentityMappingRuleType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_EndpointType_DictionaryFragment
    \value OpcUa_BinarySchema_IdentityMappingRuleType
    \value OpcUa_BinarySchema_IdentityMappingRuleType_DataTypeVersion
    \value OpcUa_BinarySchema_IdentityMappingRuleType_DictionaryFragment
    \value OpcUa_BinarySchema_DataTypeSchemaHeader
    \value OpcUa_BinarySchema_DataTypeSchemaHeader_DataTypeVersion
    \value OpcUa_BinarySchema_DataTypeSchemaHeader_DictionaryFragment
    \value TemporaryFileTransferType
    \value TemporaryFileTransferType_ClientProcessingTimeout
    \value TemporaryFileTransferType_GenerateFileForRead
    \value TemporaryFileTransferType_GenerateFileForRead_InputArguments
    \value TemporaryFileTransferType_GenerateFileForRead_OutputArguments
    \value TemporaryFileTransferType_GenerateFileForWrite
    \value TemporaryFileTransferType_GenerateFileForWrite_OutputArguments
    \value TemporaryFileTransferType_CloseAndCommit
    \value TemporaryFileTransferType_CloseAndCommit_InputArguments
    \value TemporaryFileTransferType_CloseAndCommit_OutputArguments
    \value TemporaryFileTransferType_TransferState_Placeholder
    \value TemporaryFileTransferType_TransferState_Placeholder_CurrentState
    \value TemporaryFileTransferType_TransferState_Placeholder_CurrentState_Id
    \value TemporaryFileTransferType_TransferState_Placeholder_CurrentState_Name
    \value TemporaryFileTransferType_TransferState_Placeholder_CurrentState_Number
    \value TemporaryFileTransferType_TransferState_Placeholder_CurrentState_EffectiveDisplayName
    \value TemporaryFileTransferType_TransferState_Placeholder_LastTransition
    \value TemporaryFileTransferType_TransferState_Placeholder_LastTransition_Id
    \value TemporaryFileTransferType_TransferState_Placeholder_LastTransition_Name
    \value TemporaryFileTransferType_TransferState_Placeholder_LastTransition_Number
    \value TemporaryFileTransferType_TransferState_Placeholder_LastTransition_TransitionTime
    \value TemporaryFileTransferType_TransferState_Placeholder_LastTransition_EffectiveTransitionTime
    \value OpcUa_BinarySchema_PublishedDataSetDataType
    \value OpcUa_BinarySchema_PublishedDataSetDataType_DataTypeVersion
    \value OpcUa_BinarySchema_PublishedDataSetDataType_DictionaryFragment
    \value OpcUa_BinarySchema_PublishedDataSetSourceDataType
    \value OpcUa_BinarySchema_PublishedDataSetSourceDataType_DataTypeVersion
    \value OpcUa_BinarySchema_PublishedDataSetSourceDataType_DictionaryFragment
    \value OpcUa_BinarySchema_PublishedDataItemsDataType
    \value OpcUa_BinarySchema_PublishedDataItemsDataType_DataTypeVersion
    \value OpcUa_BinarySchema_PublishedDataItemsDataType_DictionaryFragment
    \value OpcUa_BinarySchema_PublishedEventsDataType
    \value OpcUa_BinarySchema_PublishedEventsDataType_DataTypeVersion
    \value OpcUa_BinarySchema_PublishedEventsDataType_DictionaryFragment
    \value OpcUa_BinarySchema_DataSetWriterDataType
    \value OpcUa_BinarySchema_DataSetWriterDataType_DataTypeVersion
    \value OpcUa_BinarySchema_DataSetWriterDataType_DictionaryFragment
    \value OpcUa_BinarySchema_DataSetWriterTransportDataType
    \value OpcUa_BinarySchema_DataSetWriterTransportDataType_DataTypeVersion
    \value OpcUa_BinarySchema_DataSetWriterTransportDataType_DictionaryFragment
    \value OpcUa_BinarySchema_DataSetWriterMessageDataType
    \value OpcUa_BinarySchema_DataSetWriterMessageDataType_DataTypeVersion
    \value OpcUa_BinarySchema_DataSetWriterMessageDataType_DictionaryFragment
    \value OpcUa_BinarySchema_PubSubGroupDataType
    \value OpcUa_BinarySchema_PubSubGroupDataType_DataTypeVersion
    \value OpcUa_BinarySchema_PubSubGroupDataType_DictionaryFragment
    \value PublishSubscribe_ConnectionName_Placeholder
    \value PublishSubscribe_ConnectionName_Placeholder_PublisherId
    \value PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri
    \value OpcUa_BinarySchema_WriterGroupTransportDataType
    \value TemporaryFileTransferType_TransferState_Placeholder_Reset
    \value GenerateFileForReadMethodType
    \value GenerateFileForReadMethodType_InputArguments
    \value GenerateFileForReadMethodType_OutputArguments
    \value GenerateFileForWriteMethodType
    \value GenerateFileForWriteMethodType_OutputArguments
    \value CloseAndCommitMethodType
    \value CloseAndCommitMethodType_InputArguments
    \value CloseAndCommitMethodType_OutputArguments
    \value FileTransferStateMachineType
    \value FileTransferStateMachineType_CurrentState
    \value FileTransferStateMachineType_CurrentState_Id
    \value FileTransferStateMachineType_CurrentState_Name
    \value FileTransferStateMachineType_CurrentState_Number
    \value FileTransferStateMachineType_CurrentState_EffectiveDisplayName
    \value FileTransferStateMachineType_LastTransition
    \value FileTransferStateMachineType_LastTransition_Id
    \value FileTransferStateMachineType_LastTransition_Name
    \value FileTransferStateMachineType_LastTransition_Number
    \value FileTransferStateMachineType_LastTransition_TransitionTime
    \value FileTransferStateMachineType_LastTransition_EffectiveTransitionTime
    \value FileTransferStateMachineType_Idle
    \value FileTransferStateMachineType_Idle_StateNumber
    \value FileTransferStateMachineType_ReadPrepare
    \value FileTransferStateMachineType_ReadPrepare_StateNumber
    \value FileTransferStateMachineType_ReadTransfer
    \value FileTransferStateMachineType_ReadTransfer_StateNumber
    \value FileTransferStateMachineType_ApplyWrite
    \value FileTransferStateMachineType_ApplyWrite_StateNumber
    \value FileTransferStateMachineType_Error
    \value FileTransferStateMachineType_Error_StateNumber
    \value FileTransferStateMachineType_IdleToReadPrepare
    \value FileTransferStateMachineType_IdleToReadPrepare_TransitionNumber
    \value FileTransferStateMachineType_ReadPrepareToReadTransfer
    \value FileTransferStateMachineType_ReadPrepareToReadTransfer_TransitionNumber
    \value FileTransferStateMachineType_ReadTransferToIdle
    \value FileTransferStateMachineType_ReadTransferToIdle_TransitionNumber
    \value FileTransferStateMachineType_IdleToApplyWrite
    \value FileTransferStateMachineType_IdleToApplyWrite_TransitionNumber
    \value FileTransferStateMachineType_ApplyWriteToIdle
    \value FileTransferStateMachineType_ApplyWriteToIdle_TransitionNumber
    \value FileTransferStateMachineType_ReadPrepareToError
    \value FileTransferStateMachineType_ReadPrepareToError_TransitionNumber
    \value FileTransferStateMachineType_ReadTransferToError
    \value FileTransferStateMachineType_ReadTransferToError_TransitionNumber
    \value FileTransferStateMachineType_ApplyWriteToError
    \value FileTransferStateMachineType_ApplyWriteToError_TransitionNumber
    \value FileTransferStateMachineType_ErrorToIdle
    \value FileTransferStateMachineType_ErrorToIdle_TransitionNumber
    \value FileTransferStateMachineType_Reset
    \value PublishSubscribeType_Status
    \value PublishSubscribeType_Status_State
    \value PublishSubscribeType_Status_Enable
    \value PublishSubscribeType_Status_Disable
    \value PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_Selections
    \value PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions
    \value PublishSubscribe_ConnectionName_Placeholder_TransportProfileUri_RestrictToList
    \value PublishSubscribe_ConnectionName_Placeholder_Address
    \value OpcUa_BinarySchema_WriterGroupTransportDataType_DataTypeVersion
    \value OpcUa_BinarySchema_WriterGroupTransportDataType_DictionaryFragment
    \value OpcUa_BinarySchema_WriterGroupMessageDataType
    \value OpcUa_BinarySchema_WriterGroupMessageDataType_DataTypeVersion
    \value OpcUa_BinarySchema_WriterGroupMessageDataType_DictionaryFragment
    \value OpcUa_BinarySchema_PubSubConnectionDataType
    \value OpcUa_BinarySchema_PubSubConnectionDataType_DataTypeVersion
    \value OpcUa_BinarySchema_PubSubConnectionDataType_DictionaryFragment
    \value OpcUa_BinarySchema_ConnectionTransportDataType
    \value OpcUa_BinarySchema_ConnectionTransportDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ConnectionTransportDataType_DictionaryFragment
    \value PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface
    \value PublishSubscribe_ConnectionName_Placeholder_TransportSettings
    \value PublishSubscribe_ConnectionName_Placeholder_Status
    \value OpcUa_BinarySchema_ReaderGroupTransportDataType
    \value OpcUa_BinarySchema_ReaderGroupTransportDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ReaderGroupTransportDataType_DictionaryFragment
    \value OpcUa_BinarySchema_ReaderGroupMessageDataType
    \value OpcUa_BinarySchema_ReaderGroupMessageDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ReaderGroupMessageDataType_DictionaryFragment
    \value OpcUa_BinarySchema_DataSetReaderDataType
    \value OpcUa_BinarySchema_DataSetReaderDataType_DataTypeVersion
    \value OverrideValueHandling
    \value OverrideValueHandling_EnumStrings
    \value OpcUa_BinarySchema_DataSetReaderDataType_DictionaryFragment
    \value OpcUa_BinarySchema_DataSetReaderTransportDataType
    \value OpcUa_BinarySchema_DataSetReaderTransportDataType_DataTypeVersion
    \value OpcUa_BinarySchema_DataSetReaderTransportDataType_DictionaryFragment
    \value OpcUa_BinarySchema_DataSetReaderMessageDataType
    \value OpcUa_BinarySchema_DataSetReaderMessageDataType_DataTypeVersion
    \value OpcUa_BinarySchema_DataSetReaderMessageDataType_DictionaryFragment
    \value OpcUa_BinarySchema_SubscribedDataSetDataType
    \value OpcUa_BinarySchema_SubscribedDataSetDataType_DataTypeVersion
    \value OpcUa_BinarySchema_SubscribedDataSetDataType_DictionaryFragment
    \value OpcUa_BinarySchema_TargetVariablesDataType
    \value OpcUa_BinarySchema_TargetVariablesDataType_DataTypeVersion
    \value OpcUa_BinarySchema_TargetVariablesDataType_DictionaryFragment
    \value OpcUa_BinarySchema_SubscribedDataSetMirrorDataType
    \value OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DataTypeVersion
    \value OpcUa_BinarySchema_SubscribedDataSetMirrorDataType_DictionaryFragment
    \value PublishSubscribe_ConnectionName_Placeholder_Status_State
    \value PublishSubscribe_ConnectionName_Placeholder_Status_Enable
    \value PublishSubscribe_ConnectionName_Placeholder_Status_Disable
    \value OpcUa_BinarySchema_UadpWriterGroupMessageDataType
    \value OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DataTypeVersion
    \value OpcUa_BinarySchema_UadpWriterGroupMessageDataType_DictionaryFragment
    \value OpcUa_BinarySchema_UadpDataSetWriterMessageDataType
    \value OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DataTypeVersion
    \value OpcUa_BinarySchema_UadpDataSetWriterMessageDataType_DictionaryFragment
    \value SessionlessInvokeRequestType
    \value SessionlessInvokeRequestType_Encoding_DefaultXml
    \value SessionlessInvokeRequestType_Encoding_DefaultBinary
    \value DataSetFieldFlags
    \value PublishSubscribeType_ConnectionName_Placeholder_TransportSettings
    \value PubSubKeyServiceType
    \value PubSubKeyServiceType_GetSecurityKeys
    \value PubSubKeyServiceType_GetSecurityKeys_InputArguments
    \value PubSubKeyServiceType_GetSecurityKeys_OutputArguments
    \value PubSubKeyServiceType_GetSecurityGroup
    \value PubSubKeyServiceType_GetSecurityGroup_InputArguments
    \value PubSubKeyServiceType_GetSecurityGroup_OutputArguments
    \value PubSubKeyServiceType_SecurityGroups
    \value PubSubKeyServiceType_SecurityGroups_AddSecurityGroup
    \value PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_InputArguments
    \value PubSubKeyServiceType_SecurityGroups_AddSecurityGroup_OutputArguments
    \value PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup
    \value PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup_InputArguments
    \value OpcUa_BinarySchema_UadpDataSetReaderMessageDataType
    \value OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DataTypeVersion
    \value OpcUa_BinarySchema_UadpDataSetReaderMessageDataType_DictionaryFragment
    \value OpcUa_BinarySchema_JsonWriterGroupMessageDataType
    \value OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DataTypeVersion
    \value OpcUa_BinarySchema_JsonWriterGroupMessageDataType_DictionaryFragment
    \value OpcUa_BinarySchema_JsonDataSetWriterMessageDataType
    \value PubSubGroupType_SecurityMode
    \value PubSubGroupType_SecurityGroupId
    \value PubSubGroupType_SecurityKeyServices
    \value OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DataTypeVersion
    \value OpcUa_BinarySchema_JsonDataSetWriterMessageDataType_DictionaryFragment
    \value OpcUa_BinarySchema_JsonDataSetReaderMessageDataType
    \value DataSetReaderType_SecurityMode
    \value DataSetReaderType_SecurityGroupId
    \value DataSetReaderType_SecurityKeyServices
    \value OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DataTypeVersion
    \value OpcUa_BinarySchema_JsonDataSetReaderMessageDataType_DictionaryFragment
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation
    \value OpcUa_BinarySchema_BrokerWriterGroupTransportDataType
    \value OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DataTypeVersion
    \value OpcUa_BinarySchema_BrokerWriterGroupTransportDataType_DictionaryFragment
    \value OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType
    \value OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DataTypeVersion
    \value OpcUa_BinarySchema_BrokerDataSetWriterTransportDataType_DictionaryFragment
    \value OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType
    \value OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DataTypeVersion
    \value OpcUa_BinarySchema_BrokerDataSetReaderTransportDataType_DictionaryFragment
    \value EndpointType_Encoding_DefaultXml
    \value DataTypeSchemaHeader_Encoding_DefaultXml
    \value PublishedDataSetDataType_Encoding_DefaultXml
    \value PublishedDataSetSourceDataType_Encoding_DefaultXml
    \value PublishedDataItemsDataType_Encoding_DefaultXml
    \value PublishedEventsDataType_Encoding_DefaultXml
    \value DataSetWriterDataType_Encoding_DefaultXml
    \value DataSetWriterTransportDataType_Encoding_DefaultXml
    \value OPCUANamespaceMetadata
    \value OPCUANamespaceMetadata_NamespaceUri
    \value OPCUANamespaceMetadata_NamespaceVersion
    \value OPCUANamespaceMetadata_NamespacePublicationDate
    \value OPCUANamespaceMetadata_IsNamespaceSubset
    \value OPCUANamespaceMetadata_StaticNodeIdTypes
    \value OPCUANamespaceMetadata_StaticNumericNodeIdRange
    \value OPCUANamespaceMetadata_StaticStringNodeIdPattern
    \value OPCUANamespaceMetadata_NamespaceFile
    \value OPCUANamespaceMetadata_NamespaceFile_Size
    \value OPCUANamespaceMetadata_NamespaceFile_Writable
    \value OPCUANamespaceMetadata_NamespaceFile_UserWritable
    \value OPCUANamespaceMetadata_NamespaceFile_OpenCount
    \value OPCUANamespaceMetadata_NamespaceFile_MimeType
    \value OPCUANamespaceMetadata_NamespaceFile_Open
    \value OPCUANamespaceMetadata_NamespaceFile_Open_InputArguments
    \value OPCUANamespaceMetadata_NamespaceFile_Open_OutputArguments
    \value OPCUANamespaceMetadata_NamespaceFile_Close
    \value OPCUANamespaceMetadata_NamespaceFile_Close_InputArguments
    \value OPCUANamespaceMetadata_NamespaceFile_Read
    \value OPCUANamespaceMetadata_NamespaceFile_Read_InputArguments
    \value OPCUANamespaceMetadata_NamespaceFile_Read_OutputArguments
    \value OPCUANamespaceMetadata_NamespaceFile_Write
    \value OPCUANamespaceMetadata_NamespaceFile_Write_InputArguments
    \value OPCUANamespaceMetadata_NamespaceFile_GetPosition
    \value OPCUANamespaceMetadata_NamespaceFile_GetPosition_InputArguments
    \value OPCUANamespaceMetadata_NamespaceFile_GetPosition_OutputArguments
    \value OPCUANamespaceMetadata_NamespaceFile_SetPosition
    \value OPCUANamespaceMetadata_NamespaceFile_SetPosition_InputArguments
    \value OPCUANamespaceMetadata_NamespaceFile_ExportNamespace
    \value DataSetWriterMessageDataType_Encoding_DefaultXml
    \value PubSubGroupDataType_Encoding_DefaultXml
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active
    \value WriterGroupTransportDataType_Encoding_DefaultXml
    \value WriterGroupMessageDataType_Encoding_DefaultXml
    \value PubSubConnectionDataType_Encoding_DefaultXml
    \value ConnectionTransportDataType_Encoding_DefaultXml
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification
    \value ReaderGroupTransportDataType_Encoding_DefaultXml
    \value ReaderGroupMessageDataType_Encoding_DefaultXml
    \value RoleSetType_AddRole
    \value RoleSetType_AddRole_InputArguments
    \value RoleSetType_AddRole_OutputArguments
    \value RoleSetType_RemoveRole
    \value RoleSetType_RemoveRole_InputArguments
    \value AddRoleMethodType
    \value AddRoleMethodType_InputArguments
    \value AddRoleMethodType_OutputArguments
    \value RemoveRoleMethodType
    \value RemoveRoleMethodType_InputArguments
    \value DataSetReaderDataType_Encoding_DefaultXml
    \value DataSetReaderTransportDataType_Encoding_DefaultXml
    \value DataSetReaderMessageDataType_Encoding_DefaultXml
    \value SubscribedDataSetDataType_Encoding_DefaultXml
    \value TargetVariablesDataType_Encoding_DefaultXml
    \value SubscribedDataSetMirrorDataType_Encoding_DefaultXml
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel
    \value UadpWriterGroupMessageDataType_Encoding_DefaultXml
    \value UadpDataSetWriterMessageDataType_Encoding_DefaultXml
    \value UadpDataSetReaderMessageDataType_Encoding_DefaultXml
    \value JsonWriterGroupMessageDataType_Encoding_DefaultXml
    \value JsonDataSetWriterMessageDataType_Encoding_DefaultXml
    \value JsonDataSetReaderMessageDataType_Encoding_DefaultXml
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange
    \value BrokerWriterGroupTransportDataType_Encoding_DefaultXml
    \value BrokerDataSetWriterTransportDataType_Encoding_DefaultXml
    \value BrokerDataSetReaderTransportDataType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_EndpointType
    \value OpcUa_XmlSchema_EndpointType_DataTypeVersion
    \value OpcUa_XmlSchema_EndpointType_DictionaryFragment
    \value OpcUa_XmlSchema_DataTypeSchemaHeader
    \value OpcUa_XmlSchema_DataTypeSchemaHeader_DataTypeVersion
    \value OpcUa_XmlSchema_DataTypeSchemaHeader_DictionaryFragment
    \value OpcUa_XmlSchema_PublishedDataSetDataType
    \value OpcUa_XmlSchema_PublishedDataSetDataType_DataTypeVersion
    \value OpcUa_XmlSchema_PublishedDataSetDataType_DictionaryFragment
    \value OpcUa_XmlSchema_PublishedDataSetSourceDataType
    \value OpcUa_XmlSchema_PublishedDataSetSourceDataType_DataTypeVersion
    \value OpcUa_XmlSchema_PublishedDataSetSourceDataType_DictionaryFragment
    \value WellKnownRole_Engineer
    \value OpcUa_XmlSchema_PublishedDataItemsDataType
    \value OpcUa_XmlSchema_PublishedDataItemsDataType_DataTypeVersion
    \value OpcUa_XmlSchema_PublishedDataItemsDataType_DictionaryFragment
    \value OpcUa_XmlSchema_PublishedEventsDataType
    \value WellKnownRole_Engineer_AddIdentity
    \value WellKnownRole_Engineer_AddIdentity_InputArguments
    \value WellKnownRole_Engineer_RemoveIdentity
    \value WellKnownRole_Engineer_RemoveIdentity_InputArguments
    \value OpcUa_XmlSchema_PublishedEventsDataType_DataTypeVersion
    \value OpcUa_XmlSchema_PublishedEventsDataType_DictionaryFragment
    \value OpcUa_XmlSchema_DataSetWriterDataType
    \value OpcUa_XmlSchema_DataSetWriterDataType_DataTypeVersion
    \value OpcUa_XmlSchema_DataSetWriterDataType_DictionaryFragment
    \value OpcUa_XmlSchema_DataSetWriterTransportDataType
    \value OpcUa_XmlSchema_DataSetWriterTransportDataType_DataTypeVersion
    \value OpcUa_XmlSchema_DataSetWriterTransportDataType_DictionaryFragment
    \value OpcUa_XmlSchema_DataSetWriterMessageDataType
    \value OpcUa_XmlSchema_DataSetWriterMessageDataType_DataTypeVersion
    \value OpcUa_XmlSchema_DataSetWriterMessageDataType_DictionaryFragment
    \value OpcUa_XmlSchema_PubSubGroupDataType
    \value OpcUa_XmlSchema_PubSubGroupDataType_DataTypeVersion
    \value OpcUa_XmlSchema_PubSubGroupDataType_DictionaryFragment
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Active
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_Classification
    \value OpcUa_XmlSchema_WriterGroupTransportDataType
    \value OpcUa_XmlSchema_WriterGroupTransportDataType_DataTypeVersion
    \value OpcUa_XmlSchema_WriterGroupTransportDataType_DictionaryFragment
    \value OpcUa_XmlSchema_WriterGroupMessageDataType
    \value OpcUa_XmlSchema_WriterGroupMessageDataType_DataTypeVersion
    \value OpcUa_XmlSchema_WriterGroupMessageDataType_DictionaryFragment
    \value OpcUa_XmlSchema_PubSubConnectionDataType
    \value OpcUa_XmlSchema_PubSubConnectionDataType_DataTypeVersion
    \value OpcUa_XmlSchema_PubSubConnectionDataType_DictionaryFragment
    \value OpcUa_XmlSchema_ConnectionTransportDataType
    \value OpcUa_XmlSchema_ConnectionTransportDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ConnectionTransportDataType_DictionaryFragment
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Reset
    \value OpcUa_XmlSchema_ReaderGroupTransportDataType
    \value OpcUa_XmlSchema_ReaderGroupTransportDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ReaderGroupTransportDataType_DictionaryFragment
    \value OpcUa_XmlSchema_ReaderGroupMessageDataType
    \value OpcUa_XmlSchema_ReaderGroupMessageDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ReaderGroupMessageDataType_DictionaryFragment
    \value OpcUa_XmlSchema_DataSetReaderDataType
    \value OpcUa_XmlSchema_DataSetReaderDataType_DataTypeVersion
    \value OpcUa_XmlSchema_DataSetReaderDataType_DictionaryFragment
    \value OpcUa_XmlSchema_DataSetReaderTransportDataType
    \value OpcUa_XmlSchema_DataSetReaderTransportDataType_DataTypeVersion
    \value OpcUa_XmlSchema_DataSetReaderTransportDataType_DictionaryFragment
    \value OpcUa_XmlSchema_DataSetReaderMessageDataType
    \value OpcUa_XmlSchema_DataSetReaderMessageDataType_DataTypeVersion
    \value OpcUa_XmlSchema_DataSetReaderMessageDataType_DictionaryFragment
    \value OpcUa_XmlSchema_SubscribedDataSetDataType
    \value OpcUa_XmlSchema_SubscribedDataSetDataType_DataTypeVersion
    \value OpcUa_XmlSchema_SubscribedDataSetDataType_DictionaryFragment
    \value OpcUa_XmlSchema_TargetVariablesDataType
    \value OpcUa_XmlSchema_TargetVariablesDataType_DataTypeVersion
    \value OpcUa_XmlSchema_TargetVariablesDataType_DictionaryFragment
    \value OpcUa_XmlSchema_SubscribedDataSetMirrorDataType
    \value OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DataTypeVersion
    \value OpcUa_XmlSchema_SubscribedDataSetMirrorDataType_DictionaryFragment
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_SubError
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError
    \value OpcUa_XmlSchema_UadpWriterGroupMessageDataType
    \value OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DataTypeVersion
    \value OpcUa_XmlSchema_UadpWriterGroupMessageDataType_DictionaryFragment
    \value OpcUa_XmlSchema_UadpDataSetWriterMessageDataType
    \value OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DataTypeVersion
    \value OpcUa_XmlSchema_UadpDataSetWriterMessageDataType_DictionaryFragment
    \value OpcUa_XmlSchema_UadpDataSetReaderMessageDataType
    \value OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DataTypeVersion
    \value OpcUa_XmlSchema_UadpDataSetReaderMessageDataType_DictionaryFragment
    \value OpcUa_XmlSchema_JsonWriterGroupMessageDataType
    \value OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DataTypeVersion
    \value OpcUa_XmlSchema_JsonWriterGroupMessageDataType_DictionaryFragment
    \value OpcUa_XmlSchema_JsonDataSetWriterMessageDataType
    \value OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DataTypeVersion
    \value OpcUa_XmlSchema_JsonDataSetWriterMessageDataType_DictionaryFragment
    \value OpcUa_XmlSchema_JsonDataSetReaderMessageDataType
    \value OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DataTypeVersion
    \value OpcUa_XmlSchema_JsonDataSetReaderMessageDataType_DictionaryFragment
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value OpcUa_XmlSchema_BrokerWriterGroupTransportDataType
    \value RolePermissionType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_RolePermissionType
    \value OpcUa_XmlSchema_RolePermissionType_DataTypeVersion
    \value OpcUa_XmlSchema_RolePermissionType_DictionaryFragment
    \value OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DataTypeVersion
    \value OpcUa_BinarySchema_RolePermissionType
    \value OpcUa_BinarySchema_RolePermissionType_DataTypeVersion
    \value OpcUa_BinarySchema_RolePermissionType_DictionaryFragment
    \value OPCUANamespaceMetadata_DefaultRolePermissions
    \value OPCUANamespaceMetadata_DefaultUserRolePermissions
    \value OPCUANamespaceMetadata_DefaultAccessRestrictions
    \value NamespaceMetadataType_DefaultRolePermissions
    \value NamespaceMetadataType_DefaultUserRolePermissions
    \value NamespaceMetadataType_DefaultAccessRestrictions
    \value NamespacesType_NamespaceIdentifier_Placeholder_DefaultRolePermissions
    \value NamespacesType_NamespaceIdentifier_Placeholder_DefaultUserRolePermissions
    \value NamespacesType_NamespaceIdentifier_Placeholder_DefaultAccessRestrictions
    \value OpcUa_XmlSchema_BrokerWriterGroupTransportDataType_DictionaryFragment
    \value OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType
    \value OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DataTypeVersion
    \value OpcUa_XmlSchema_BrokerDataSetWriterTransportDataType_DictionaryFragment
    \value OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType
    \value OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DataTypeVersion
    \value OpcUa_XmlSchema_BrokerDataSetReaderTransportDataType_DictionaryFragment
    \value EndpointType_Encoding_DefaultJson
    \value DataTypeSchemaHeader_Encoding_DefaultJson
    \value PublishedDataSetDataType_Encoding_DefaultJson
    \value PublishedDataSetSourceDataType_Encoding_DefaultJson
    \value PublishedDataItemsDataType_Encoding_DefaultJson
    \value PublishedEventsDataType_Encoding_DefaultJson
    \value DataSetWriterDataType_Encoding_DefaultJson
    \value DataSetWriterTransportDataType_Encoding_DefaultJson
    \value DataSetWriterMessageDataType_Encoding_DefaultJson
    \value PubSubGroupDataType_Encoding_DefaultJson
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange
    \value WriterGroupTransportDataType_Encoding_DefaultJson
    \value RoleSetType_RoleName_Placeholder_Identities
    \value RoleSetType_RoleName_Placeholder_Applications
    \value RoleSetType_RoleName_Placeholder_Endpoints
    \value RoleSetType_RoleName_Placeholder_AddApplication
    \value RoleSetType_RoleName_Placeholder_AddApplication_InputArguments
    \value RoleSetType_RoleName_Placeholder_RemoveApplication
    \value RoleSetType_RoleName_Placeholder_RemoveApplication_InputArguments
    \value RoleSetType_RoleName_Placeholder_AddEndpoint
    \value RoleSetType_RoleName_Placeholder_AddEndpoint_InputArguments
    \value RoleSetType_RoleName_Placeholder_RemoveEndpoint
    \value RoleSetType_RoleName_Placeholder_RemoveEndpoint_InputArguments
    \value RoleType_Identities
    \value RoleType_Applications
    \value RoleType_Endpoints
    \value RoleType_AddApplication
    \value RoleType_AddApplication_InputArguments
    \value RoleType_RemoveApplication
    \value RoleType_RemoveApplication_InputArguments
    \value RoleType_AddEndpoint
    \value RoleType_AddEndpoint_InputArguments
    \value RoleType_RemoveEndpoint
    \value RoleType_RemoveEndpoint_InputArguments
    \value AddApplicationMethodType
    \value AddApplicationMethodType_InputArguments
    \value RemoveApplicationMethodType
    \value RemoveApplicationMethodType_InputArguments
    \value AddEndpointMethodType
    \value AddEndpointMethodType_InputArguments
    \value RemoveEndpointMethodType
    \value RemoveEndpointMethodType_InputArguments
    \value WellKnownRole_Anonymous_Identities
    \value WellKnownRole_Anonymous_Applications
    \value WellKnownRole_Anonymous_Endpoints
    \value WellKnownRole_Anonymous_AddApplication
    \value WellKnownRole_Anonymous_AddApplication_InputArguments
    \value WellKnownRole_Anonymous_RemoveApplication
    \value WellKnownRole_Anonymous_RemoveApplication_InputArguments
    \value WellKnownRole_Anonymous_AddEndpoint
    \value WellKnownRole_Anonymous_AddEndpoint_InputArguments
    \value WellKnownRole_Anonymous_RemoveEndpoint
    \value WellKnownRole_Anonymous_RemoveEndpoint_InputArguments
    \value WellKnownRole_AuthenticatedUser_Identities
    \value WellKnownRole_AuthenticatedUser_Applications
    \value WellKnownRole_AuthenticatedUser_Endpoints
    \value WellKnownRole_AuthenticatedUser_AddApplication
    \value WellKnownRole_AuthenticatedUser_AddApplication_InputArguments
    \value WellKnownRole_AuthenticatedUser_RemoveApplication
    \value WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments
    \value WellKnownRole_AuthenticatedUser_AddEndpoint
    \value WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments
    \value WellKnownRole_AuthenticatedUser_RemoveEndpoint
    \value WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments
    \value WellKnownRole_Observer_Identities
    \value WellKnownRole_Observer_Applications
    \value WellKnownRole_Observer_Endpoints
    \value WellKnownRole_Observer_AddApplication
    \value WellKnownRole_Observer_AddApplication_InputArguments
    \value WellKnownRole_Observer_RemoveApplication
    \value WellKnownRole_Observer_RemoveApplication_InputArguments
    \value WellKnownRole_Observer_AddEndpoint
    \value WellKnownRole_Observer_AddEndpoint_InputArguments
    \value WellKnownRole_Observer_RemoveEndpoint
    \value WellKnownRole_Observer_RemoveEndpoint_InputArguments
    \value WellKnownRole_Operator_Identities
    \value WellKnownRole_Operator_Applications
    \value WellKnownRole_Operator_Endpoints
    \value WellKnownRole_Operator_AddApplication
    \value WellKnownRole_Operator_AddApplication_InputArguments
    \value WellKnownRole_Operator_RemoveApplication
    \value WellKnownRole_Operator_RemoveApplication_InputArguments
    \value WellKnownRole_Operator_AddEndpoint
    \value WellKnownRole_Operator_AddEndpoint_InputArguments
    \value WellKnownRole_Operator_RemoveEndpoint
    \value WellKnownRole_Operator_RemoveEndpoint_InputArguments
    \value WellKnownRole_Engineer_Identities
    \value WellKnownRole_Engineer_Applications
    \value WellKnownRole_Engineer_Endpoints
    \value WellKnownRole_Engineer_AddApplication
    \value WellKnownRole_Engineer_AddApplication_InputArguments
    \value WellKnownRole_Engineer_RemoveApplication
    \value WellKnownRole_Engineer_RemoveApplication_InputArguments
    \value WellKnownRole_Engineer_AddEndpoint
    \value WellKnownRole_Engineer_AddEndpoint_InputArguments
    \value WellKnownRole_Engineer_RemoveEndpoint
    \value WellKnownRole_Engineer_RemoveEndpoint_InputArguments
    \value WellKnownRole_Supervisor_Identities
    \value WellKnownRole_Supervisor_Applications
    \value WellKnownRole_Supervisor_Endpoints
    \value WellKnownRole_Supervisor_AddApplication
    \value WellKnownRole_Supervisor_AddApplication_InputArguments
    \value WellKnownRole_Supervisor_RemoveApplication
    \value WellKnownRole_Supervisor_RemoveApplication_InputArguments
    \value WellKnownRole_Supervisor_AddEndpoint
    \value WellKnownRole_Supervisor_AddEndpoint_InputArguments
    \value WellKnownRole_Supervisor_RemoveEndpoint
    \value WellKnownRole_Supervisor_RemoveEndpoint_InputArguments
    \value WellKnownRole_SecurityAdmin_Identities
    \value WellKnownRole_SecurityAdmin_Applications
    \value WellKnownRole_SecurityAdmin_Endpoints
    \value WellKnownRole_SecurityAdmin_AddApplication
    \value WellKnownRole_SecurityAdmin_AddApplication_InputArguments
    \value WellKnownRole_SecurityAdmin_RemoveApplication
    \value WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments
    \value WellKnownRole_SecurityAdmin_AddEndpoint
    \value WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments
    \value WellKnownRole_SecurityAdmin_RemoveEndpoint
    \value WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments
    \value WellKnownRole_ConfigureAdmin_Identities
    \value WellKnownRole_ConfigureAdmin_Applications
    \value WellKnownRole_ConfigureAdmin_Endpoints
    \value WellKnownRole_ConfigureAdmin_AddApplication
    \value WellKnownRole_ConfigureAdmin_AddApplication_InputArguments
    \value WellKnownRole_ConfigureAdmin_RemoveApplication
    \value WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments
    \value WellKnownRole_ConfigureAdmin_AddEndpoint
    \value WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments
    \value WellKnownRole_ConfigureAdmin_RemoveEndpoint
    \value WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments
    \value WriterGroupMessageDataType_Encoding_DefaultJson
    \value PubSubConnectionDataType_Encoding_DefaultJson
    \value ConnectionTransportDataType_Encoding_DefaultJson
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod
    \value ReaderGroupTransportDataType_Encoding_DefaultJson
    \value ReaderGroupMessageDataType_Encoding_DefaultJson
    \value DataSetReaderDataType_Encoding_DefaultJson
    \value DataSetReaderTransportDataType_Encoding_DefaultJson
    \value DataSetReaderMessageDataType_Encoding_DefaultJson
    \value ServerType_ServerCapabilities_RoleSet
    \value ServerType_ServerCapabilities_RoleSet_AddRole
    \value ServerType_ServerCapabilities_RoleSet_AddRole_InputArguments
    \value ServerType_ServerCapabilities_RoleSet_AddRole_OutputArguments
    \value ServerType_ServerCapabilities_RoleSet_RemoveRole
    \value ServerType_ServerCapabilities_RoleSet_RemoveRole_InputArguments
    \value ServerCapabilitiesType_RoleSet
    \value ServerCapabilitiesType_RoleSet_AddRole
    \value ServerCapabilitiesType_RoleSet_AddRole_InputArguments
    \value ServerCapabilitiesType_RoleSet_AddRole_OutputArguments
    \value ServerCapabilitiesType_RoleSet_RemoveRole
    \value ServerCapabilitiesType_RoleSet_RemoveRole_InputArguments
    \value Server_ServerCapabilities_RoleSet_AddRole
    \value Server_ServerCapabilities_RoleSet_AddRole_InputArguments
    \value Server_ServerCapabilities_RoleSet_AddRole_OutputArguments
    \value Server_ServerCapabilities_RoleSet_RemoveRole
    \value Server_ServerCapabilities_RoleSet_RemoveRole_InputArguments
    \value AudioDataType
    \value SubscribedDataSetDataType_Encoding_DefaultJson
    \value SelectionListType
    \value TargetVariablesDataType_Encoding_DefaultJson
    \value SubscribedDataSetMirrorDataType_Encoding_DefaultJson
    \value SelectionListType_RestrictToList
    \value AdditionalParametersType
    \value FileSystem
    \value FileSystem_FileDirectoryName_Placeholder
    \value FileSystem_FileDirectoryName_Placeholder_CreateDirectory
    \value FileSystem_FileDirectoryName_Placeholder_CreateDirectory_InputArguments
    \value FileSystem_FileDirectoryName_Placeholder_CreateDirectory_OutputArguments
    \value FileSystem_FileDirectoryName_Placeholder_CreateFile
    \value FileSystem_FileDirectoryName_Placeholder_CreateFile_InputArguments
    \value FileSystem_FileDirectoryName_Placeholder_CreateFile_OutputArguments
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active
    \value UadpWriterGroupMessageDataType_Encoding_DefaultJson
    \value FileSystem_FileDirectoryName_Placeholder_MoveOrCopy
    \value FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_InputArguments
    \value FileSystem_FileDirectoryName_Placeholder_MoveOrCopy_OutputArguments
    \value FileSystem_FileName_Placeholder
    \value FileSystem_FileName_Placeholder_Size
    \value FileSystem_FileName_Placeholder_Writable
    \value FileSystem_FileName_Placeholder_UserWritable
    \value FileSystem_FileName_Placeholder_OpenCount
    \value FileSystem_FileName_Placeholder_MimeType
    \value FileSystem_FileName_Placeholder_Open
    \value FileSystem_FileName_Placeholder_Open_InputArguments
    \value FileSystem_FileName_Placeholder_Open_OutputArguments
    \value FileSystem_FileName_Placeholder_Close
    \value FileSystem_FileName_Placeholder_Close_InputArguments
    \value FileSystem_FileName_Placeholder_Read
    \value FileSystem_FileName_Placeholder_Read_InputArguments
    \value FileSystem_FileName_Placeholder_Read_OutputArguments
    \value FileSystem_FileName_Placeholder_Write
    \value FileSystem_FileName_Placeholder_Write_InputArguments
    \value FileSystem_FileName_Placeholder_GetPosition
    \value FileSystem_FileName_Placeholder_GetPosition_InputArguments
    \value FileSystem_FileName_Placeholder_GetPosition_OutputArguments
    \value FileSystem_FileName_Placeholder_SetPosition
    \value FileSystem_FileName_Placeholder_SetPosition_InputArguments
    \value FileSystem_CreateDirectory
    \value FileSystem_CreateDirectory_InputArguments
    \value FileSystem_CreateDirectory_OutputArguments
    \value FileSystem_CreateFile
    \value FileSystem_CreateFile_InputArguments
    \value FileSystem_CreateFile_OutputArguments
    \value FileSystem_DeleteFileSystemObject
    \value FileSystem_DeleteFileSystemObject_InputArguments
    \value FileSystem_MoveOrCopy
    \value FileSystem_MoveOrCopy_InputArguments
    \value FileSystem_MoveOrCopy_OutputArguments
    \value TemporaryFileTransferType_GenerateFileForWrite_InputArguments
    \value GenerateFileForWriteMethodType_InputArguments
    \value HasAlarmSuppressionGroup
    \value AlarmGroupMember
    \value ConditionType_ConditionSubClassId
    \value ConditionType_ConditionSubClassName
    \value DialogConditionType_ConditionSubClassId
    \value DialogConditionType_ConditionSubClassName
    \value AcknowledgeableConditionType_ConditionSubClassId
    \value AcknowledgeableConditionType_ConditionSubClassName
    \value AlarmConditionType_ConditionSubClassId
    \value AlarmConditionType_ConditionSubClassName
    \value AlarmConditionType_OutOfServiceState
    \value AlarmConditionType_OutOfServiceState_Id
    \value AlarmConditionType_OutOfServiceState_Name
    \value AlarmConditionType_OutOfServiceState_Number
    \value AlarmConditionType_OutOfServiceState_EffectiveDisplayName
    \value AlarmConditionType_OutOfServiceState_TransitionTime
    \value AlarmConditionType_OutOfServiceState_EffectiveTransitionTime
    \value AlarmConditionType_OutOfServiceState_TrueState
    \value AlarmConditionType_OutOfServiceState_FalseState
    \value AlarmConditionType_SilenceState
    \value AlarmConditionType_SilenceState_Id
    \value AlarmConditionType_SilenceState_Name
    \value AlarmConditionType_SilenceState_Number
    \value AlarmConditionType_SilenceState_EffectiveDisplayName
    \value AlarmConditionType_SilenceState_TransitionTime
    \value AlarmConditionType_SilenceState_EffectiveTransitionTime
    \value AlarmConditionType_SilenceState_TrueState
    \value AlarmConditionType_SilenceState_FalseState
    \value AlarmConditionType_AudibleEnabled
    \value AlarmConditionType_AudibleSound
    \value UadpDataSetWriterMessageDataType_Encoding_DefaultJson
    \value UadpDataSetReaderMessageDataType_Encoding_DefaultJson
    \value JsonWriterGroupMessageDataType_Encoding_DefaultJson
    \value JsonDataSetWriterMessageDataType_Encoding_DefaultJson
    \value AlarmConditionType_OnDelay
    \value AlarmConditionType_OffDelay
    \value AlarmConditionType_FirstInGroupFlag
    \value AlarmConditionType_FirstInGroup
    \value AlarmConditionType_AlarmGroup_Placeholder
    \value AlarmConditionType_ReAlarmTime
    \value AlarmConditionType_ReAlarmRepeatCount
    \value AlarmConditionType_Silence
    \value AlarmConditionType_Suppress
    \value JsonDataSetReaderMessageDataType_Encoding_DefaultJson
    \value AlarmGroupType
    \value AlarmGroupType_AlarmConditionInstance_Placeholder
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_EventId
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_EventType
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SourceNode
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SourceName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Time
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ReceiveTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_LocalTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Message
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Severity
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassId
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionSubClassId
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionSubClassName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_BranchId
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Retain
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_Id
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_Name
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_Number
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_EffectiveDisplayName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_TransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_EffectiveTransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_TrueState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_FalseState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Quality
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Quality_SourceTimestamp
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity_SourceTimestamp
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Comment
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Comment_SourceTimestamp
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ClientUserId
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Disable
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Enable
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment_InputArguments
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_Id
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_Name
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_Number
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_EffectiveDisplayName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_TransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_EffectiveTransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_TrueState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_FalseState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Id
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Name
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Number
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_EffectiveDisplayName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_TransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_EffectiveTransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_TrueState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_FalseState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge_InputArguments
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm_InputArguments
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_Id
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_Name
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_Number
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_EffectiveDisplayName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_TransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_EffectiveTransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_TrueState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_FalseState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_InputNode
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Id
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Name
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Number
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_EffectiveDisplayName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_TransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_EffectiveTransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_TrueState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_FalseState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Id
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Name
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Number
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_EffectiveDisplayName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_TransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_EffectiveTransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_TrueState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_FalseState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_Id
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_Name
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_Number
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_EffectiveDisplayName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_TransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_EffectiveTransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_TrueState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_FalseState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Id
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Name
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Number
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_EffectiveDisplayName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Id
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Name
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Number
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_TransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_EffectiveTransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_UnshelveTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve_InputArguments
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedOrShelved
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_MaxTimeShelved
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AudibleEnabled
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AudibleSound
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value BrokerWriterGroupTransportDataType_Encoding_DefaultJson
    \value BrokerDataSetWriterTransportDataType_Encoding_DefaultJson
    \value BrokerDataSetReaderTransportDataType_Encoding_DefaultJson
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_OnDelay
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_OffDelay
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_FirstInGroupFlag
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_FirstInGroup
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ReAlarmTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ReAlarmRepeatCount
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Silence
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress
    \value PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup
    \value LimitAlarmType_ConditionSubClassId
    \value LimitAlarmType_ConditionSubClassName
    \value LimitAlarmType_OutOfServiceState
    \value LimitAlarmType_OutOfServiceState_Id
    \value LimitAlarmType_OutOfServiceState_Name
    \value LimitAlarmType_OutOfServiceState_Number
    \value LimitAlarmType_OutOfServiceState_EffectiveDisplayName
    \value LimitAlarmType_OutOfServiceState_TransitionTime
    \value LimitAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value LimitAlarmType_OutOfServiceState_TrueState
    \value LimitAlarmType_OutOfServiceState_FalseState
    \value LimitAlarmType_SilenceState
    \value LimitAlarmType_SilenceState_Id
    \value LimitAlarmType_SilenceState_Name
    \value LimitAlarmType_SilenceState_Number
    \value LimitAlarmType_SilenceState_EffectiveDisplayName
    \value LimitAlarmType_SilenceState_TransitionTime
    \value LimitAlarmType_SilenceState_EffectiveTransitionTime
    \value LimitAlarmType_SilenceState_TrueState
    \value LimitAlarmType_SilenceState_FalseState
    \value LimitAlarmType_AudibleEnabled
    \value LimitAlarmType_AudibleSound
    \value PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_InputArguments
    \value PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup_OutputArguments
    \value PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup
    \value PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_InputArguments
    \value LimitAlarmType_OnDelay
    \value LimitAlarmType_OffDelay
    \value LimitAlarmType_FirstInGroupFlag
    \value LimitAlarmType_FirstInGroup
    \value LimitAlarmType_AlarmGroup_Placeholder
    \value LimitAlarmType_ReAlarmTime
    \value LimitAlarmType_ReAlarmRepeatCount
    \value LimitAlarmType_Silence
    \value LimitAlarmType_Suppress
    \value PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup_OutputArguments
    \value LimitAlarmType_BaseHighHighLimit
    \value LimitAlarmType_BaseHighLimit
    \value LimitAlarmType_BaseLowLimit
    \value LimitAlarmType_BaseLowLowLimit
    \value ExclusiveLimitAlarmType_ConditionSubClassId
    \value ExclusiveLimitAlarmType_ConditionSubClassName
    \value ExclusiveLimitAlarmType_OutOfServiceState
    \value ExclusiveLimitAlarmType_OutOfServiceState_Id
    \value ExclusiveLimitAlarmType_OutOfServiceState_Name
    \value ExclusiveLimitAlarmType_OutOfServiceState_Number
    \value ExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_OutOfServiceState_TransitionTime
    \value ExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_OutOfServiceState_TrueState
    \value ExclusiveLimitAlarmType_OutOfServiceState_FalseState
    \value ExclusiveLimitAlarmType_SilenceState
    \value ExclusiveLimitAlarmType_SilenceState_Id
    \value ExclusiveLimitAlarmType_SilenceState_Name
    \value ExclusiveLimitAlarmType_SilenceState_Number
    \value ExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_SilenceState_TransitionTime
    \value ExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_SilenceState_TrueState
    \value ExclusiveLimitAlarmType_SilenceState_FalseState
    \value ExclusiveLimitAlarmType_AudibleEnabled
    \value ExclusiveLimitAlarmType_AudibleSound
    \value PublishSubscribeType_AddConnection
    \value PublishSubscribeType_AddConnection_InputArguments
    \value PublishSubscribeType_AddConnection_OutputArguments
    \value PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate
    \value ExclusiveLimitAlarmType_OnDelay
    \value ExclusiveLimitAlarmType_OffDelay
    \value ExclusiveLimitAlarmType_FirstInGroupFlag
    \value ExclusiveLimitAlarmType_FirstInGroup
    \value ExclusiveLimitAlarmType_AlarmGroup_Placeholder
    \value ExclusiveLimitAlarmType_ReAlarmTime
    \value ExclusiveLimitAlarmType_ReAlarmRepeatCount
    \value ExclusiveLimitAlarmType_Silence
    \value ExclusiveLimitAlarmType_Suppress
    \value PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments
    \value ExclusiveLimitAlarmType_BaseHighHighLimit
    \value ExclusiveLimitAlarmType_BaseHighLimit
    \value ExclusiveLimitAlarmType_BaseLowLimit
    \value ExclusiveLimitAlarmType_BaseLowLowLimit
    \value NonExclusiveLimitAlarmType_ConditionSubClassId
    \value NonExclusiveLimitAlarmType_ConditionSubClassName
    \value NonExclusiveLimitAlarmType_OutOfServiceState
    \value NonExclusiveLimitAlarmType_OutOfServiceState_Id
    \value NonExclusiveLimitAlarmType_OutOfServiceState_Name
    \value NonExclusiveLimitAlarmType_OutOfServiceState_Number
    \value NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_OutOfServiceState_TransitionTime
    \value NonExclusiveLimitAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_OutOfServiceState_TrueState
    \value NonExclusiveLimitAlarmType_OutOfServiceState_FalseState
    \value NonExclusiveLimitAlarmType_SilenceState
    \value NonExclusiveLimitAlarmType_SilenceState_Id
    \value NonExclusiveLimitAlarmType_SilenceState_Name
    \value NonExclusiveLimitAlarmType_SilenceState_Number
    \value NonExclusiveLimitAlarmType_SilenceState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_SilenceState_TransitionTime
    \value NonExclusiveLimitAlarmType_SilenceState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_SilenceState_TrueState
    \value NonExclusiveLimitAlarmType_SilenceState_FalseState
    \value NonExclusiveLimitAlarmType_AudibleEnabled
    \value NonExclusiveLimitAlarmType_AudibleSound
    \value PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments
    \value PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate
    \value PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_InputArguments
    \value PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments
    \value NonExclusiveLimitAlarmType_OnDelay
    \value NonExclusiveLimitAlarmType_OffDelay
    \value NonExclusiveLimitAlarmType_FirstInGroupFlag
    \value NonExclusiveLimitAlarmType_FirstInGroup
    \value NonExclusiveLimitAlarmType_AlarmGroup_Placeholder
    \value NonExclusiveLimitAlarmType_ReAlarmTime
    \value NonExclusiveLimitAlarmType_ReAlarmRepeatCount
    \value NonExclusiveLimitAlarmType_Silence
    \value NonExclusiveLimitAlarmType_Suppress
    \value PublishSubscribeType_PublishedDataSets_AddDataSetFolder
    \value NonExclusiveLimitAlarmType_BaseHighHighLimit
    \value NonExclusiveLimitAlarmType_BaseHighLimit
    \value NonExclusiveLimitAlarmType_BaseLowLimit
    \value NonExclusiveLimitAlarmType_BaseLowLowLimit
    \value NonExclusiveLevelAlarmType_ConditionSubClassId
    \value NonExclusiveLevelAlarmType_ConditionSubClassName
    \value NonExclusiveLevelAlarmType_OutOfServiceState
    \value NonExclusiveLevelAlarmType_OutOfServiceState_Id
    \value NonExclusiveLevelAlarmType_OutOfServiceState_Name
    \value NonExclusiveLevelAlarmType_OutOfServiceState_Number
    \value NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_OutOfServiceState_TransitionTime
    \value NonExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_OutOfServiceState_TrueState
    \value NonExclusiveLevelAlarmType_OutOfServiceState_FalseState
    \value NonExclusiveLevelAlarmType_SilenceState
    \value NonExclusiveLevelAlarmType_SilenceState_Id
    \value NonExclusiveLevelAlarmType_SilenceState_Name
    \value NonExclusiveLevelAlarmType_SilenceState_Number
    \value NonExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_SilenceState_TransitionTime
    \value NonExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_SilenceState_TrueState
    \value NonExclusiveLevelAlarmType_SilenceState_FalseState
    \value NonExclusiveLevelAlarmType_AudibleEnabled
    \value NonExclusiveLevelAlarmType_AudibleSound
    \value PublishSubscribeType_PublishedDataSets_AddDataSetFolder_InputArguments
    \value PublishSubscribeType_PublishedDataSets_AddDataSetFolder_OutputArguments
    \value PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder
    \value PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder_InputArguments
    \value NonExclusiveLevelAlarmType_OnDelay
    \value NonExclusiveLevelAlarmType_OffDelay
    \value NonExclusiveLevelAlarmType_FirstInGroupFlag
    \value NonExclusiveLevelAlarmType_FirstInGroup
    \value NonExclusiveLevelAlarmType_AlarmGroup_Placeholder
    \value NonExclusiveLevelAlarmType_ReAlarmTime
    \value NonExclusiveLevelAlarmType_ReAlarmRepeatCount
    \value NonExclusiveLevelAlarmType_Silence
    \value NonExclusiveLevelAlarmType_Suppress
    \value AddConnectionMethodType
    \value NonExclusiveLevelAlarmType_BaseHighHighLimit
    \value NonExclusiveLevelAlarmType_BaseHighLimit
    \value NonExclusiveLevelAlarmType_BaseLowLimit
    \value NonExclusiveLevelAlarmType_BaseLowLowLimit
    \value ExclusiveLevelAlarmType_ConditionSubClassId
    \value ExclusiveLevelAlarmType_ConditionSubClassName
    \value ExclusiveLevelAlarmType_OutOfServiceState
    \value ExclusiveLevelAlarmType_OutOfServiceState_Id
    \value ExclusiveLevelAlarmType_OutOfServiceState_Name
    \value ExclusiveLevelAlarmType_OutOfServiceState_Number
    \value ExclusiveLevelAlarmType_OutOfServiceState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_OutOfServiceState_TransitionTime
    \value ExclusiveLevelAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_OutOfServiceState_TrueState
    \value ExclusiveLevelAlarmType_OutOfServiceState_FalseState
    \value ExclusiveLevelAlarmType_SilenceState
    \value ExclusiveLevelAlarmType_SilenceState_Id
    \value ExclusiveLevelAlarmType_SilenceState_Name
    \value ExclusiveLevelAlarmType_SilenceState_Number
    \value ExclusiveLevelAlarmType_SilenceState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_SilenceState_TransitionTime
    \value ExclusiveLevelAlarmType_SilenceState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_SilenceState_TrueState
    \value ExclusiveLevelAlarmType_SilenceState_FalseState
    \value ExclusiveLevelAlarmType_AudibleEnabled
    \value ExclusiveLevelAlarmType_AudibleSound
    \value AddConnectionMethodType_InputArguments
    \value AddConnectionMethodType_OutputArguments
    \value PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterId
    \value PublishedDataSetType_DataSetWriterName_Placeholder_DataSetFieldContentMask
    \value ExclusiveLevelAlarmType_OnDelay
    \value ExclusiveLevelAlarmType_OffDelay
    \value ExclusiveLevelAlarmType_FirstInGroupFlag
    \value ExclusiveLevelAlarmType_FirstInGroup
    \value ExclusiveLevelAlarmType_AlarmGroup_Placeholder
    \value ExclusiveLevelAlarmType_ReAlarmTime
    \value ExclusiveLevelAlarmType_ReAlarmRepeatCount
    \value ExclusiveLevelAlarmType_Silence
    \value ExclusiveLevelAlarmType_Suppress
    \value PublishedDataSetType_DataSetWriterName_Placeholder_KeyFrameCount
    \value ExclusiveLevelAlarmType_BaseHighHighLimit
    \value ExclusiveLevelAlarmType_BaseHighLimit
    \value ExclusiveLevelAlarmType_BaseLowLimit
    \value ExclusiveLevelAlarmType_BaseLowLowLimit
    \value NonExclusiveDeviationAlarmType_ConditionSubClassId
    \value NonExclusiveDeviationAlarmType_ConditionSubClassName
    \value NonExclusiveDeviationAlarmType_OutOfServiceState
    \value NonExclusiveDeviationAlarmType_OutOfServiceState_Id
    \value NonExclusiveDeviationAlarmType_OutOfServiceState_Name
    \value NonExclusiveDeviationAlarmType_OutOfServiceState_Number
    \value NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime
    \value NonExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_OutOfServiceState_TrueState
    \value NonExclusiveDeviationAlarmType_OutOfServiceState_FalseState
    \value NonExclusiveDeviationAlarmType_SilenceState
    \value NonExclusiveDeviationAlarmType_SilenceState_Id
    \value NonExclusiveDeviationAlarmType_SilenceState_Name
    \value NonExclusiveDeviationAlarmType_SilenceState_Number
    \value NonExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_SilenceState_TransitionTime
    \value NonExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_SilenceState_TrueState
    \value NonExclusiveDeviationAlarmType_SilenceState_FalseState
    \value NonExclusiveDeviationAlarmType_AudibleEnabled
    \value NonExclusiveDeviationAlarmType_AudibleSound
    \value PublishedDataSetType_DataSetWriterName_Placeholder_MessageSettings
    \value PublishedDataSetType_DataSetClassId
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterId
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetFieldContentMask
    \value NonExclusiveDeviationAlarmType_OnDelay
    \value NonExclusiveDeviationAlarmType_OffDelay
    \value NonExclusiveDeviationAlarmType_FirstInGroupFlag
    \value NonExclusiveDeviationAlarmType_FirstInGroup
    \value NonExclusiveDeviationAlarmType_AlarmGroup_Placeholder
    \value NonExclusiveDeviationAlarmType_ReAlarmTime
    \value NonExclusiveDeviationAlarmType_ReAlarmRepeatCount
    \value NonExclusiveDeviationAlarmType_Silence
    \value NonExclusiveDeviationAlarmType_Suppress
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_KeyFrameCount
    \value NonExclusiveDeviationAlarmType_BaseHighHighLimit
    \value NonExclusiveDeviationAlarmType_BaseHighLimit
    \value NonExclusiveDeviationAlarmType_BaseLowLimit
    \value NonExclusiveDeviationAlarmType_BaseLowLowLimit
    \value NonExclusiveDeviationAlarmType_BaseSetpointNode
    \value ExclusiveDeviationAlarmType_ConditionSubClassId
    \value ExclusiveDeviationAlarmType_ConditionSubClassName
    \value ExclusiveDeviationAlarmType_OutOfServiceState
    \value ExclusiveDeviationAlarmType_OutOfServiceState_Id
    \value ExclusiveDeviationAlarmType_OutOfServiceState_Name
    \value ExclusiveDeviationAlarmType_OutOfServiceState_Number
    \value ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_OutOfServiceState_TransitionTime
    \value ExclusiveDeviationAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_OutOfServiceState_TrueState
    \value ExclusiveDeviationAlarmType_OutOfServiceState_FalseState
    \value ExclusiveDeviationAlarmType_SilenceState
    \value ExclusiveDeviationAlarmType_SilenceState_Id
    \value ExclusiveDeviationAlarmType_SilenceState_Name
    \value ExclusiveDeviationAlarmType_SilenceState_Number
    \value ExclusiveDeviationAlarmType_SilenceState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_SilenceState_TransitionTime
    \value ExclusiveDeviationAlarmType_SilenceState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_SilenceState_TrueState
    \value ExclusiveDeviationAlarmType_SilenceState_FalseState
    \value ExclusiveDeviationAlarmType_AudibleEnabled
    \value ExclusiveDeviationAlarmType_AudibleSound
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_MessageSettings
    \value PublishedDataItemsType_DataSetClassId
    \value PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterId
    \value PublishedEventsType_DataSetWriterName_Placeholder_DataSetFieldContentMask
    \value ExclusiveDeviationAlarmType_OnDelay
    \value ExclusiveDeviationAlarmType_OffDelay
    \value ExclusiveDeviationAlarmType_FirstInGroupFlag
    \value ExclusiveDeviationAlarmType_FirstInGroup
    \value ExclusiveDeviationAlarmType_AlarmGroup_Placeholder
    \value ExclusiveDeviationAlarmType_ReAlarmTime
    \value ExclusiveDeviationAlarmType_ReAlarmRepeatCount
    \value ExclusiveDeviationAlarmType_Silence
    \value ExclusiveDeviationAlarmType_Suppress
    \value PublishedEventsType_DataSetWriterName_Placeholder_KeyFrameCount
    \value ExclusiveDeviationAlarmType_BaseHighHighLimit
    \value ExclusiveDeviationAlarmType_BaseHighLimit
    \value ExclusiveDeviationAlarmType_BaseLowLimit
    \value ExclusiveDeviationAlarmType_BaseLowLowLimit
    \value ExclusiveDeviationAlarmType_BaseSetpointNode
    \value NonExclusiveRateOfChangeAlarmType_ConditionSubClassId
    \value NonExclusiveRateOfChangeAlarmType_ConditionSubClassName
    \value NonExclusiveRateOfChangeAlarmType_OutOfServiceState
    \value NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Id
    \value NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Name
    \value NonExclusiveRateOfChangeAlarmType_OutOfServiceState_Number
    \value NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_SilenceState
    \value NonExclusiveRateOfChangeAlarmType_SilenceState_Id
    \value NonExclusiveRateOfChangeAlarmType_SilenceState_Name
    \value NonExclusiveRateOfChangeAlarmType_SilenceState_Number
    \value NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_SilenceState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_SilenceState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_AudibleEnabled
    \value NonExclusiveRateOfChangeAlarmType_AudibleSound
    \value PublishedEventsType_DataSetWriterName_Placeholder_MessageSettings
    \value PublishedEventsType_DataSetClassId
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate_InputArguments
    \value NonExclusiveRateOfChangeAlarmType_OnDelay
    \value NonExclusiveRateOfChangeAlarmType_OffDelay
    \value NonExclusiveRateOfChangeAlarmType_FirstInGroupFlag
    \value NonExclusiveRateOfChangeAlarmType_FirstInGroup
    \value NonExclusiveRateOfChangeAlarmType_AlarmGroup_Placeholder
    \value NonExclusiveRateOfChangeAlarmType_ReAlarmTime
    \value NonExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount
    \value NonExclusiveRateOfChangeAlarmType_Silence
    \value NonExclusiveRateOfChangeAlarmType_Suppress
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate_OutputArguments
    \value NonExclusiveRateOfChangeAlarmType_BaseHighHighLimit
    \value NonExclusiveRateOfChangeAlarmType_BaseHighLimit
    \value NonExclusiveRateOfChangeAlarmType_BaseLowLimit
    \value NonExclusiveRateOfChangeAlarmType_BaseLowLowLimit
    \value NonExclusiveRateOfChangeAlarmType_EngineeringUnits
    \value ExclusiveRateOfChangeAlarmType_ConditionSubClassId
    \value ExclusiveRateOfChangeAlarmType_ConditionSubClassName
    \value ExclusiveRateOfChangeAlarmType_OutOfServiceState
    \value ExclusiveRateOfChangeAlarmType_OutOfServiceState_Id
    \value ExclusiveRateOfChangeAlarmType_OutOfServiceState_Name
    \value ExclusiveRateOfChangeAlarmType_OutOfServiceState_Number
    \value ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_OutOfServiceState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_OutOfServiceState_TrueState
    \value ExclusiveRateOfChangeAlarmType_OutOfServiceState_FalseState
    \value ExclusiveRateOfChangeAlarmType_SilenceState
    \value ExclusiveRateOfChangeAlarmType_SilenceState_Id
    \value ExclusiveRateOfChangeAlarmType_SilenceState_Name
    \value ExclusiveRateOfChangeAlarmType_SilenceState_Number
    \value ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_SilenceState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_SilenceState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_SilenceState_TrueState
    \value ExclusiveRateOfChangeAlarmType_SilenceState_FalseState
    \value ExclusiveRateOfChangeAlarmType_AudibleEnabled
    \value ExclusiveRateOfChangeAlarmType_AudibleSound
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate_InputArguments
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate_OutputArguments
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder
    \value ExclusiveRateOfChangeAlarmType_OnDelay
    \value ExclusiveRateOfChangeAlarmType_OffDelay
    \value ExclusiveRateOfChangeAlarmType_FirstInGroupFlag
    \value ExclusiveRateOfChangeAlarmType_FirstInGroup
    \value ExclusiveRateOfChangeAlarmType_AlarmGroup_Placeholder
    \value ExclusiveRateOfChangeAlarmType_ReAlarmTime
    \value ExclusiveRateOfChangeAlarmType_ReAlarmRepeatCount
    \value ExclusiveRateOfChangeAlarmType_Silence
    \value ExclusiveRateOfChangeAlarmType_Suppress
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder_InputArguments
    \value ExclusiveRateOfChangeAlarmType_BaseHighHighLimit
    \value ExclusiveRateOfChangeAlarmType_BaseHighLimit
    \value ExclusiveRateOfChangeAlarmType_BaseLowLimit
    \value ExclusiveRateOfChangeAlarmType_BaseLowLowLimit
    \value ExclusiveRateOfChangeAlarmType_EngineeringUnits
    \value DiscreteAlarmType_ConditionSubClassId
    \value DiscreteAlarmType_ConditionSubClassName
    \value DiscreteAlarmType_OutOfServiceState
    \value DiscreteAlarmType_OutOfServiceState_Id
    \value DiscreteAlarmType_OutOfServiceState_Name
    \value DiscreteAlarmType_OutOfServiceState_Number
    \value DiscreteAlarmType_OutOfServiceState_EffectiveDisplayName
    \value DiscreteAlarmType_OutOfServiceState_TransitionTime
    \value DiscreteAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value DiscreteAlarmType_OutOfServiceState_TrueState
    \value DiscreteAlarmType_OutOfServiceState_FalseState
    \value DiscreteAlarmType_SilenceState
    \value DiscreteAlarmType_SilenceState_Id
    \value DiscreteAlarmType_SilenceState_Name
    \value DiscreteAlarmType_SilenceState_Number
    \value DiscreteAlarmType_SilenceState_EffectiveDisplayName
    \value DiscreteAlarmType_SilenceState_TransitionTime
    \value DiscreteAlarmType_SilenceState_EffectiveTransitionTime
    \value DiscreteAlarmType_SilenceState_TrueState
    \value DiscreteAlarmType_SilenceState_FalseState
    \value DiscreteAlarmType_AudibleEnabled
    \value DiscreteAlarmType_AudibleSound
    \value DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder_OutputArguments
    \value DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder
    \value DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder_InputArguments
    \value DataSetFolderType_PublishedDataSetName_Placeholder_DataSetClassId
    \value DiscreteAlarmType_OnDelay
    \value DiscreteAlarmType_OffDelay
    \value DiscreteAlarmType_FirstInGroupFlag
    \value DiscreteAlarmType_FirstInGroup
    \value DiscreteAlarmType_AlarmGroup_Placeholder
    \value DiscreteAlarmType_ReAlarmTime
    \value DiscreteAlarmType_ReAlarmRepeatCount
    \value DiscreteAlarmType_Silence
    \value DiscreteAlarmType_Suppress
    \value DataSetFolderType_AddPublishedDataItemsTemplate
    \value OffNormalAlarmType_ConditionSubClassId
    \value OffNormalAlarmType_ConditionSubClassName
    \value OffNormalAlarmType_OutOfServiceState
    \value OffNormalAlarmType_OutOfServiceState_Id
    \value OffNormalAlarmType_OutOfServiceState_Name
    \value OffNormalAlarmType_OutOfServiceState_Number
    \value OffNormalAlarmType_OutOfServiceState_EffectiveDisplayName
    \value OffNormalAlarmType_OutOfServiceState_TransitionTime
    \value OffNormalAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value OffNormalAlarmType_OutOfServiceState_TrueState
    \value OffNormalAlarmType_OutOfServiceState_FalseState
    \value OffNormalAlarmType_SilenceState
    \value OffNormalAlarmType_SilenceState_Id
    \value OffNormalAlarmType_SilenceState_Name
    \value OffNormalAlarmType_SilenceState_Number
    \value OffNormalAlarmType_SilenceState_EffectiveDisplayName
    \value OffNormalAlarmType_SilenceState_TransitionTime
    \value OffNormalAlarmType_SilenceState_EffectiveTransitionTime
    \value OffNormalAlarmType_SilenceState_TrueState
    \value OffNormalAlarmType_SilenceState_FalseState
    \value OffNormalAlarmType_AudibleEnabled
    \value OffNormalAlarmType_AudibleSound
    \value DataSetFolderType_AddPublishedDataItemsTemplate_InputArguments
    \value DataSetFolderType_AddPublishedDataItemsTemplate_OutputArguments
    \value DataSetFolderType_AddPublishedEventsTemplate
    \value DataSetFolderType_AddPublishedEventsTemplate_InputArguments
    \value OffNormalAlarmType_OnDelay
    \value OffNormalAlarmType_OffDelay
    \value OffNormalAlarmType_FirstInGroupFlag
    \value OffNormalAlarmType_FirstInGroup
    \value OffNormalAlarmType_AlarmGroup_Placeholder
    \value OffNormalAlarmType_ReAlarmTime
    \value OffNormalAlarmType_ReAlarmRepeatCount
    \value OffNormalAlarmType_Silence
    \value OffNormalAlarmType_Suppress
    \value DataSetFolderType_AddPublishedEventsTemplate_OutputArguments
    \value SystemOffNormalAlarmType_ConditionSubClassId
    \value SystemOffNormalAlarmType_ConditionSubClassName
    \value SystemOffNormalAlarmType_OutOfServiceState
    \value SystemOffNormalAlarmType_OutOfServiceState_Id
    \value SystemOffNormalAlarmType_OutOfServiceState_Name
    \value SystemOffNormalAlarmType_OutOfServiceState_Number
    \value SystemOffNormalAlarmType_OutOfServiceState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_OutOfServiceState_TransitionTime
    \value SystemOffNormalAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_OutOfServiceState_TrueState
    \value SystemOffNormalAlarmType_OutOfServiceState_FalseState
    \value SystemOffNormalAlarmType_SilenceState
    \value SystemOffNormalAlarmType_SilenceState_Id
    \value SystemOffNormalAlarmType_SilenceState_Name
    \value SystemOffNormalAlarmType_SilenceState_Number
    \value SystemOffNormalAlarmType_SilenceState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_SilenceState_TransitionTime
    \value SystemOffNormalAlarmType_SilenceState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_SilenceState_TrueState
    \value SystemOffNormalAlarmType_SilenceState_FalseState
    \value SystemOffNormalAlarmType_AudibleEnabled
    \value SystemOffNormalAlarmType_AudibleSound
    \value DataSetFolderType_AddDataSetFolder
    \value DataSetFolderType_AddDataSetFolder_InputArguments
    \value DataSetFolderType_AddDataSetFolder_OutputArguments
    \value DataSetFolderType_RemoveDataSetFolder
    \value SystemOffNormalAlarmType_OnDelay
    \value SystemOffNormalAlarmType_OffDelay
    \value SystemOffNormalAlarmType_FirstInGroupFlag
    \value SystemOffNormalAlarmType_FirstInGroup
    \value SystemOffNormalAlarmType_AlarmGroup_Placeholder
    \value SystemOffNormalAlarmType_ReAlarmTime
    \value SystemOffNormalAlarmType_ReAlarmRepeatCount
    \value SystemOffNormalAlarmType_Silence
    \value SystemOffNormalAlarmType_Suppress
    \value DataSetFolderType_RemoveDataSetFolder_InputArguments
    \value TripAlarmType_ConditionSubClassId
    \value TripAlarmType_ConditionSubClassName
    \value TripAlarmType_OutOfServiceState
    \value TripAlarmType_OutOfServiceState_Id
    \value TripAlarmType_OutOfServiceState_Name
    \value TripAlarmType_OutOfServiceState_Number
    \value TripAlarmType_OutOfServiceState_EffectiveDisplayName
    \value TripAlarmType_OutOfServiceState_TransitionTime
    \value TripAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value TripAlarmType_OutOfServiceState_TrueState
    \value TripAlarmType_OutOfServiceState_FalseState
    \value TripAlarmType_SilenceState
    \value TripAlarmType_SilenceState_Id
    \value TripAlarmType_SilenceState_Name
    \value TripAlarmType_SilenceState_Number
    \value TripAlarmType_SilenceState_EffectiveDisplayName
    \value TripAlarmType_SilenceState_TransitionTime
    \value TripAlarmType_SilenceState_EffectiveTransitionTime
    \value TripAlarmType_SilenceState_TrueState
    \value TripAlarmType_SilenceState_FalseState
    \value TripAlarmType_AudibleEnabled
    \value TripAlarmType_AudibleSound
    \value AddPublishedDataItemsTemplateMethodType
    \value AddPublishedDataItemsTemplateMethodType_InputArguments
    \value AddPublishedDataItemsTemplateMethodType_OutputArguments
    \value AddPublishedEventsTemplateMethodType
    \value TripAlarmType_OnDelay
    \value TripAlarmType_OffDelay
    \value TripAlarmType_FirstInGroupFlag
    \value TripAlarmType_FirstInGroup
    \value TripAlarmType_AlarmGroup_Placeholder
    \value TripAlarmType_ReAlarmTime
    \value TripAlarmType_ReAlarmRepeatCount
    \value TripAlarmType_Silence
    \value TripAlarmType_Suppress
    \value AddPublishedEventsTemplateMethodType_InputArguments
    \value CertificateExpirationAlarmType_ConditionSubClassId
    \value CertificateExpirationAlarmType_ConditionSubClassName
    \value CertificateExpirationAlarmType_OutOfServiceState
    \value CertificateExpirationAlarmType_OutOfServiceState_Id
    \value CertificateExpirationAlarmType_OutOfServiceState_Name
    \value CertificateExpirationAlarmType_OutOfServiceState_Number
    \value CertificateExpirationAlarmType_OutOfServiceState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_OutOfServiceState_TransitionTime
    \value CertificateExpirationAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_OutOfServiceState_TrueState
    \value CertificateExpirationAlarmType_OutOfServiceState_FalseState
    \value CertificateExpirationAlarmType_SilenceState
    \value CertificateExpirationAlarmType_SilenceState_Id
    \value CertificateExpirationAlarmType_SilenceState_Name
    \value CertificateExpirationAlarmType_SilenceState_Number
    \value CertificateExpirationAlarmType_SilenceState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_SilenceState_TransitionTime
    \value CertificateExpirationAlarmType_SilenceState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_SilenceState_TrueState
    \value CertificateExpirationAlarmType_SilenceState_FalseState
    \value CertificateExpirationAlarmType_AudibleEnabled
    \value CertificateExpirationAlarmType_AudibleSound
    \value AddPublishedEventsTemplateMethodType_OutputArguments
    \value AddDataSetFolderMethodType
    \value AddDataSetFolderMethodType_InputArguments
    \value AddDataSetFolderMethodType_OutputArguments
    \value CertificateExpirationAlarmType_OnDelay
    \value CertificateExpirationAlarmType_OffDelay
    \value CertificateExpirationAlarmType_FirstInGroupFlag
    \value CertificateExpirationAlarmType_FirstInGroup
    \value CertificateExpirationAlarmType_AlarmGroup_Placeholder
    \value CertificateExpirationAlarmType_ReAlarmTime
    \value CertificateExpirationAlarmType_ReAlarmRepeatCount
    \value CertificateExpirationAlarmType_Silence
    \value CertificateExpirationAlarmType_Suppress
    \value RemoveDataSetFolderMethodType
    \value DiscrepancyAlarmType
    \value DiscrepancyAlarmType_EventId
    \value DiscrepancyAlarmType_EventType
    \value DiscrepancyAlarmType_SourceNode
    \value DiscrepancyAlarmType_SourceName
    \value DiscrepancyAlarmType_Time
    \value DiscrepancyAlarmType_ReceiveTime
    \value DiscrepancyAlarmType_LocalTime
    \value DiscrepancyAlarmType_Message
    \value DiscrepancyAlarmType_Severity
    \value DiscrepancyAlarmType_ConditionClassId
    \value DiscrepancyAlarmType_ConditionClassName
    \value DiscrepancyAlarmType_ConditionSubClassId
    \value DiscrepancyAlarmType_ConditionSubClassName
    \value DiscrepancyAlarmType_ConditionName
    \value DiscrepancyAlarmType_BranchId
    \value DiscrepancyAlarmType_Retain
    \value DiscrepancyAlarmType_EnabledState
    \value DiscrepancyAlarmType_EnabledState_Id
    \value DiscrepancyAlarmType_EnabledState_Name
    \value DiscrepancyAlarmType_EnabledState_Number
    \value DiscrepancyAlarmType_EnabledState_EffectiveDisplayName
    \value DiscrepancyAlarmType_EnabledState_TransitionTime
    \value DiscrepancyAlarmType_EnabledState_EffectiveTransitionTime
    \value DiscrepancyAlarmType_EnabledState_TrueState
    \value DiscrepancyAlarmType_EnabledState_FalseState
    \value DiscrepancyAlarmType_Quality
    \value DiscrepancyAlarmType_Quality_SourceTimestamp
    \value DiscrepancyAlarmType_LastSeverity
    \value DiscrepancyAlarmType_LastSeverity_SourceTimestamp
    \value DiscrepancyAlarmType_Comment
    \value DiscrepancyAlarmType_Comment_SourceTimestamp
    \value DiscrepancyAlarmType_ClientUserId
    \value DiscrepancyAlarmType_Disable
    \value DiscrepancyAlarmType_Enable
    \value DiscrepancyAlarmType_AddComment
    \value DiscrepancyAlarmType_AddComment_InputArguments
    \value DiscrepancyAlarmType_ConditionRefresh
    \value DiscrepancyAlarmType_ConditionRefresh_InputArguments
    \value DiscrepancyAlarmType_ConditionRefresh2
    \value DiscrepancyAlarmType_ConditionRefresh2_InputArguments
    \value DiscrepancyAlarmType_AckedState
    \value DiscrepancyAlarmType_AckedState_Id
    \value DiscrepancyAlarmType_AckedState_Name
    \value DiscrepancyAlarmType_AckedState_Number
    \value DiscrepancyAlarmType_AckedState_EffectiveDisplayName
    \value DiscrepancyAlarmType_AckedState_TransitionTime
    \value DiscrepancyAlarmType_AckedState_EffectiveTransitionTime
    \value DiscrepancyAlarmType_AckedState_TrueState
    \value DiscrepancyAlarmType_AckedState_FalseState
    \value DiscrepancyAlarmType_ConfirmedState
    \value DiscrepancyAlarmType_ConfirmedState_Id
    \value DiscrepancyAlarmType_ConfirmedState_Name
    \value DiscrepancyAlarmType_ConfirmedState_Number
    \value DiscrepancyAlarmType_ConfirmedState_EffectiveDisplayName
    \value DiscrepancyAlarmType_ConfirmedState_TransitionTime
    \value DiscrepancyAlarmType_ConfirmedState_EffectiveTransitionTime
    \value DiscrepancyAlarmType_ConfirmedState_TrueState
    \value DiscrepancyAlarmType_ConfirmedState_FalseState
    \value DiscrepancyAlarmType_Acknowledge
    \value DiscrepancyAlarmType_Acknowledge_InputArguments
    \value DiscrepancyAlarmType_Confirm
    \value DiscrepancyAlarmType_Confirm_InputArguments
    \value DiscrepancyAlarmType_ActiveState
    \value DiscrepancyAlarmType_ActiveState_Id
    \value DiscrepancyAlarmType_ActiveState_Name
    \value DiscrepancyAlarmType_ActiveState_Number
    \value DiscrepancyAlarmType_ActiveState_EffectiveDisplayName
    \value DiscrepancyAlarmType_ActiveState_TransitionTime
    \value DiscrepancyAlarmType_ActiveState_EffectiveTransitionTime
    \value DiscrepancyAlarmType_ActiveState_TrueState
    \value DiscrepancyAlarmType_ActiveState_FalseState
    \value DiscrepancyAlarmType_InputNode
    \value DiscrepancyAlarmType_SuppressedState
    \value DiscrepancyAlarmType_SuppressedState_Id
    \value DiscrepancyAlarmType_SuppressedState_Name
    \value DiscrepancyAlarmType_SuppressedState_Number
    \value DiscrepancyAlarmType_SuppressedState_EffectiveDisplayName
    \value DiscrepancyAlarmType_SuppressedState_TransitionTime
    \value DiscrepancyAlarmType_SuppressedState_EffectiveTransitionTime
    \value DiscrepancyAlarmType_SuppressedState_TrueState
    \value DiscrepancyAlarmType_SuppressedState_FalseState
    \value DiscrepancyAlarmType_OutOfServiceState
    \value DiscrepancyAlarmType_OutOfServiceState_Id
    \value DiscrepancyAlarmType_OutOfServiceState_Name
    \value DiscrepancyAlarmType_OutOfServiceState_Number
    \value DiscrepancyAlarmType_OutOfServiceState_EffectiveDisplayName
    \value DiscrepancyAlarmType_OutOfServiceState_TransitionTime
    \value DiscrepancyAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value DiscrepancyAlarmType_OutOfServiceState_TrueState
    \value DiscrepancyAlarmType_OutOfServiceState_FalseState
    \value DiscrepancyAlarmType_SilenceState
    \value DiscrepancyAlarmType_SilenceState_Id
    \value DiscrepancyAlarmType_SilenceState_Name
    \value DiscrepancyAlarmType_SilenceState_Number
    \value DiscrepancyAlarmType_SilenceState_EffectiveDisplayName
    \value DiscrepancyAlarmType_SilenceState_TransitionTime
    \value DiscrepancyAlarmType_SilenceState_EffectiveTransitionTime
    \value DiscrepancyAlarmType_SilenceState_TrueState
    \value DiscrepancyAlarmType_SilenceState_FalseState
    \value DiscrepancyAlarmType_ShelvingState
    \value DiscrepancyAlarmType_ShelvingState_CurrentState
    \value DiscrepancyAlarmType_ShelvingState_CurrentState_Id
    \value DiscrepancyAlarmType_ShelvingState_CurrentState_Name
    \value DiscrepancyAlarmType_ShelvingState_CurrentState_Number
    \value DiscrepancyAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value DiscrepancyAlarmType_ShelvingState_LastTransition
    \value DiscrepancyAlarmType_ShelvingState_LastTransition_Id
    \value DiscrepancyAlarmType_ShelvingState_LastTransition_Name
    \value DiscrepancyAlarmType_ShelvingState_LastTransition_Number
    \value DiscrepancyAlarmType_ShelvingState_LastTransition_TransitionTime
    \value DiscrepancyAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value DiscrepancyAlarmType_ShelvingState_UnshelveTime
    \value DiscrepancyAlarmType_ShelvingState_Unshelve
    \value DiscrepancyAlarmType_ShelvingState_OneShotShelve
    \value DiscrepancyAlarmType_ShelvingState_TimedShelve
    \value DiscrepancyAlarmType_ShelvingState_TimedShelve_InputArguments
    \value DiscrepancyAlarmType_SuppressedOrShelved
    \value DiscrepancyAlarmType_MaxTimeShelved
    \value DiscrepancyAlarmType_AudibleEnabled
    \value DiscrepancyAlarmType_AudibleSound
    \value RemoveDataSetFolderMethodType_InputArguments
    \value PubSubConnectionType_Address_NetworkInterface
    \value PubSubConnectionType_TransportSettings
    \value PubSubConnectionType_WriterGroupName_Placeholder_MaxNetworkMessageSize
    \value DiscrepancyAlarmType_OnDelay
    \value DiscrepancyAlarmType_OffDelay
    \value DiscrepancyAlarmType_FirstInGroupFlag
    \value DiscrepancyAlarmType_FirstInGroup
    \value DiscrepancyAlarmType_AlarmGroup_Placeholder
    \value DiscrepancyAlarmType_ReAlarmTime
    \value DiscrepancyAlarmType_ReAlarmRepeatCount
    \value DiscrepancyAlarmType_Silence
    \value DiscrepancyAlarmType_Suppress
    \value PubSubConnectionType_WriterGroupName_Placeholder_WriterGroupId
    \value DiscrepancyAlarmType_TargetValueNode
    \value DiscrepancyAlarmType_ExpectedTime
    \value DiscrepancyAlarmType_Tolerance
    \value SafetyConditionClassType
    \value HighlyManagedAlarmConditionClassType
    \value TrainingConditionClassType
    \value TestingConditionClassType
    \value AuditConditionCommentEventType_ConditionEventId
    \value AuditConditionAcknowledgeEventType_ConditionEventId
    \value AuditConditionConfirmEventType_ConditionEventId
    \value AuditConditionSuppressionEventType
    \value AuditConditionSuppressionEventType_EventId
    \value AuditConditionSuppressionEventType_EventType
    \value AuditConditionSuppressionEventType_SourceNode
    \value AuditConditionSuppressionEventType_SourceName
    \value AuditConditionSuppressionEventType_Time
    \value AuditConditionSuppressionEventType_ReceiveTime
    \value AuditConditionSuppressionEventType_LocalTime
    \value AuditConditionSuppressionEventType_Message
    \value AuditConditionSuppressionEventType_Severity
    \value AuditConditionSuppressionEventType_ActionTimeStamp
    \value AuditConditionSuppressionEventType_Status
    \value AuditConditionSuppressionEventType_ServerId
    \value AuditConditionSuppressionEventType_ClientAuditEntryId
    \value AuditConditionSuppressionEventType_ClientUserId
    \value AuditConditionSuppressionEventType_MethodId
    \value AuditConditionSuppressionEventType_InputArguments
    \value AuditConditionSilenceEventType
    \value AuditConditionSilenceEventType_EventId
    \value AuditConditionSilenceEventType_EventType
    \value AuditConditionSilenceEventType_SourceNode
    \value AuditConditionSilenceEventType_SourceName
    \value AuditConditionSilenceEventType_Time
    \value AuditConditionSilenceEventType_ReceiveTime
    \value AuditConditionSilenceEventType_LocalTime
    \value AuditConditionSilenceEventType_Message
    \value AuditConditionSilenceEventType_Severity
    \value AuditConditionSilenceEventType_ActionTimeStamp
    \value AuditConditionSilenceEventType_Status
    \value AuditConditionSilenceEventType_ServerId
    \value AuditConditionSilenceEventType_ClientAuditEntryId
    \value AuditConditionSilenceEventType_ClientUserId
    \value AuditConditionSilenceEventType_MethodId
    \value AuditConditionSilenceEventType_InputArguments
    \value AuditConditionOutOfServiceEventType
    \value AuditConditionOutOfServiceEventType_EventId
    \value AuditConditionOutOfServiceEventType_EventType
    \value AuditConditionOutOfServiceEventType_SourceNode
    \value AuditConditionOutOfServiceEventType_SourceName
    \value AuditConditionOutOfServiceEventType_Time
    \value AuditConditionOutOfServiceEventType_ReceiveTime
    \value AuditConditionOutOfServiceEventType_LocalTime
    \value AuditConditionOutOfServiceEventType_Message
    \value AuditConditionOutOfServiceEventType_Severity
    \value AuditConditionOutOfServiceEventType_ActionTimeStamp
    \value AuditConditionOutOfServiceEventType_Status
    \value AuditConditionOutOfServiceEventType_ServerId
    \value AuditConditionOutOfServiceEventType_ClientAuditEntryId
    \value AuditConditionOutOfServiceEventType_ClientUserId
    \value AuditConditionOutOfServiceEventType_MethodId
    \value AuditConditionOutOfServiceEventType_InputArguments
    \value HasEffectDisable
    \value AlarmRateVariableType
    \value AlarmRateVariableType_Rate
    \value AlarmMetricsType
    \value AlarmMetricsType_AlarmCount
    \value AlarmMetricsType_MaximumActiveState
    \value AlarmMetricsType_MaximumUnAck
    \value AlarmMetricsType_MaximumReAlarmCount
    \value AlarmMetricsType_CurrentAlarmRate
    \value AlarmMetricsType_CurrentAlarmRate_Rate
    \value AlarmMetricsType_MaximumAlarmRate
    \value AlarmMetricsType_MaximumAlarmRate_Rate
    \value AlarmMetricsType_AverageAlarmRate
    \value AlarmMetricsType_AverageAlarmRate_Rate
    \value PubSubConnectionType_WriterGroupName_Placeholder_TransportSettings
    \value PubSubConnectionType_WriterGroupName_Placeholder_MessageSettings
    \value PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri
    \value PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter
    \value PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_InputArguments
    \value PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_RestrictToList
    \value PublishSubscribeType_SetSecurityKeys
    \value PublishSubscribeType_SetSecurityKeys_InputArguments
    \value SetSecurityKeysMethodType
    \value SetSecurityKeysMethodType_InputArguments
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter_OutputArguments
    \value PubSubConnectionType_ReaderGroupName_Placeholder_MaxNetworkMessageSize
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active
    \value PubSubConnectionType_TransportProfileUri
    \value PubSubConnectionType_ReaderGroupName_Placeholder_TransportSettings
    \value PubSubConnectionType_ReaderGroupName_Placeholder_MessageSettings
    \value PubSubConnectionType_TransportProfileUri_RestrictToList
    \value PubSubConnectionType_WriterGroupName_Placeholder
    \value PubSubConnectionType_WriterGroupName_Placeholder_SecurityMode
    \value PubSubConnectionType_WriterGroupName_Placeholder_SecurityGroupId
    \value PubSubConnectionType_WriterGroupName_Placeholder_SecurityKeyServices
    \value PubSubConnectionType_WriterGroupName_Placeholder_Status
    \value PubSubConnectionType_WriterGroupName_Placeholder_Status_State
    \value PubSubConnectionType_WriterGroupName_Placeholder_Status_Enable
    \value PubSubConnectionType_WriterGroupName_Placeholder_Status_Disable
    \value PubSubConnectionType_WriterGroupName_Placeholder_PublishingInterval
    \value PubSubConnectionType_WriterGroupName_Placeholder_KeepAliveTime
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification
    \value PubSubConnectionType_WriterGroupName_Placeholder_Priority
    \value PubSubConnectionType_WriterGroupName_Placeholder_LocaleIds
    \value PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter
    \value PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter_InputArguments
    \value PubSubConnectionType_ReaderGroupName_Placeholder
    \value PubSubConnectionType_ReaderGroupName_Placeholder_SecurityMode
    \value PubSubConnectionType_ReaderGroupName_Placeholder_SecurityGroupId
    \value PubSubConnectionType_ReaderGroupName_Placeholder_SecurityKeyServices
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Status
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Status_State
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Status_Enable
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Status_Disable
    \value PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader
    \value PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader_InputArguments
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress
    \value PublishSubscribe_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader
    \value PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup
    \value PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_InputArguments
    \value PublishSubscribe_ConnectionName_Placeholder_AddWriterGroup_OutputArguments
    \value PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup
    \value PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_InputArguments
    \value PublishSubscribe_ConnectionName_Placeholder_AddReaderGroup_OutputArguments
    \value PublishSubscribe_ConnectionName_Placeholder_RemoveGroup
    \value PublishSubscribe_ConnectionName_Placeholder_RemoveGroup_InputArguments
    \value PublishSubscribe_SetSecurityKeys
    \value PublishSubscribe_SetSecurityKeys_InputArguments
    \value PublishSubscribe_AddConnection
    \value PublishSubscribe_AddConnection_InputArguments
    \value PublishSubscribe_AddConnection_OutputArguments
    \value PublishSubscribe_RemoveConnection
    \value PublishSubscribe_RemoveConnection_InputArguments
    \value PublishSubscribe_PublishedDataSets
    \value PublishSubscribe_PublishedDataSets_AddPublishedDataItems
    \value PublishSubscribe_PublishedDataSets_AddPublishedDataItems_InputArguments
    \value PublishSubscribe_PublishedDataSets_AddPublishedDataItems_OutputArguments
    \value PublishSubscribe_PublishedDataSets_AddPublishedEvents
    \value PublishSubscribe_PublishedDataSets_AddPublishedEvents_InputArguments
    \value PublishSubscribe_PublishedDataSets_AddPublishedEvents_OutputArguments
    \value PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate
    \value PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_InputArguments
    \value PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate_OutputArguments
    \value PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate
    \value PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_InputArguments
    \value PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate_OutputArguments
    \value PublishSubscribe_PublishedDataSets_RemovePublishedDataSet
    \value PublishSubscribe_PublishedDataSets_RemovePublishedDataSet_InputArguments
    \value DataSetReaderType_CreateTargetVariables
    \value DataSetReaderType_CreateTargetVariables_InputArguments
    \value DataSetReaderType_CreateTargetVariables_OutputArguments
    \value DataSetReaderType_CreateDataSetMirror
    \value DataSetReaderType_CreateDataSetMirror_InputArguments
    \value DataSetReaderType_CreateDataSetMirror_OutputArguments
    \value DataSetReaderTypeCreateTargetVariablesMethodType
    \value DataSetReaderTypeCreateTargetVariablesMethodType_InputArguments
    \value DataSetReaderTypeCreateTargetVariablesMethodType_OutputArguments
    \value DataSetReaderTypeCreateDataSetMirrorMethodType
    \value DataSetReaderTypeCreateDataSetMirrorMethodType_InputArguments
    \value DataSetReaderTypeCreateDataSetMirrorMethodType_OutputArguments
    \value PublishSubscribe_PublishedDataSets_AddDataSetFolder
    \value PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_InputArguments
    \value PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader_OutputArguments
    \value PublishSubscribe_PublishedDataSets_AddDataSetFolder_InputArguments
    \value PublishSubscribe_PublishedDataSets_AddDataSetFolder_OutputArguments
    \value PublishSubscribe_PublishedDataSets_RemoveDataSetFolder
    \value PublishSubscribe_PublishedDataSets_RemoveDataSetFolder_InputArguments
    \value PublishSubscribe_Status
    \value PublishSubscribe_Status_State
    \value PublishSubscribe_Status_Enable
    \value PublishSubscribe_Status_Disable
    \value PublishSubscribe_Diagnostics
    \value PublishSubscribe_Diagnostics_DiagnosticsLevel
    \value PublishSubscribe_Diagnostics_TotalInformation
    \value PublishSubscribe_Diagnostics_TotalInformation_Active
    \value PublishSubscribe_Diagnostics_TotalInformation_Classification
    \value PublishSubscribe_Diagnostics_TotalInformation_DiagnosticsLevel
    \value PublishSubscribe_Diagnostics_TotalInformation_TimeFirstChange
    \value PublishSubscribe_Diagnostics_TotalError
    \value PublishSubscribe_Diagnostics_TotalError_Active
    \value PublishSubscribe_Diagnostics_TotalError_Classification
    \value PublishSubscribe_Diagnostics_TotalError_DiagnosticsLevel
    \value PublishSubscribe_Diagnostics_TotalError_TimeFirstChange
    \value PublishSubscribe_Diagnostics_Reset
    \value PublishSubscribe_Diagnostics_SubError
    \value PublishSubscribe_Diagnostics_Counters
    \value PublishSubscribe_Diagnostics_Counters_StateError
    \value PublishSubscribe_Diagnostics_Counters_StateError_Active
    \value PublishSubscribe_Diagnostics_Counters_StateError_Classification
    \value PubSubConnectionType_AddWriterGroup
    \value PubSubConnectionType_AddWriterGroup_InputArguments
    \value PublishSubscribe_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value PublishSubscribe_Diagnostics_Counters_StateError_TimeFirstChange
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Active
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalByParent
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Active
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_Classification
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalFromError
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Active
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_Classification
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PublishSubscribe_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value PublishSubscribe_Diagnostics_Counters_StatePausedByParent
    \value PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Active
    \value PublishSubscribe_Diagnostics_Counters_StatePausedByParent_Classification
    \value PublishSubscribe_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value PublishSubscribe_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod
    \value PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Active
    \value PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PublishSubscribe_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value PubSubConnectionType_AddWriterGroup_OutputArguments
    \value PublishSubscribe_Diagnostics_LiveValues
    \value PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters
    \value PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel
    \value PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders
    \value PublishSubscribe_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel
    \value PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters
    \value PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel
    \value PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders
    \value PubSubConnectionType_AddReaderGroup
    \value PublishSubscribe_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel
    \value DatagramConnectionTransportDataType
    \value DatagramConnectionTransportDataType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_DatagramConnectionTransportDataType
    \value OpcUa_BinarySchema_DatagramConnectionTransportDataType_DataTypeVersion
    \value OpcUa_BinarySchema_DatagramConnectionTransportDataType_DictionaryFragment
    \value DatagramConnectionTransportDataType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_DatagramConnectionTransportDataType
    \value OpcUa_XmlSchema_DatagramConnectionTransportDataType_DataTypeVersion
    \value OpcUa_XmlSchema_DatagramConnectionTransportDataType_DictionaryFragment
    \value DatagramConnectionTransportDataType_Encoding_DefaultJson
    \value UadpDataSetReaderMessageType_DataSetOffset
    \value PublishSubscribeType_ConnectionName_Placeholder_ConnectionProperties
    \value PublishSubscribeType_SupportedTransportProfiles
    \value PublishSubscribe_ConnectionName_Placeholder_ConnectionProperties
    \value PublishSubscribe_SupportedTransportProfiles
    \value PublishedDataSetType_DataSetWriterName_Placeholder_DataSetWriterProperties
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_DataSetWriterProperties
    \value PublishedEventsType_DataSetWriterName_Placeholder_DataSetWriterProperties
    \value PubSubConnectionType_ConnectionProperties
    \value PubSubConnectionType_WriterGroupName_Placeholder_GroupProperties
    \value PubSubConnectionType_ReaderGroupName_Placeholder_GroupProperties
    \value PubSubGroupType_GroupProperties
    \value WriterGroupType_GroupProperties
    \value WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterProperties
    \value ReaderGroupType_GroupProperties
    \value ReaderGroupType_DataSetReaderName_Placeholder_DataSetReaderProperties
    \value DataSetWriterType_DataSetWriterProperties
    \value DataSetReaderType_DataSetReaderProperties
    \value CreateCredentialMethodType_OutputArguments
    \value KeyCredentialConfigurationFolderType
    \value AnalogUnitType
    \value AnalogUnitType_Definition
    \value AnalogUnitType_ValuePrecision
    \value AnalogUnitType_InstrumentRange
    \value AnalogUnitType_EURange
    \value AnalogUnitType_EngineeringUnits
    \value PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_Selections
    \value PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions
    \value PublishSubscribeType_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList
    \value PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_Selections
    \value PubSubConnectionType_AddReaderGroup_InputArguments
    \value PubSubConnectionType_AddReaderGroup_OutputArguments
    \value PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_SelectionDescriptions
    \value PublishSubscribe_ConnectionName_Placeholder_Address_NetworkInterface_RestrictToList
    \value KeyCredentialConfigurationFolderType_ServiceName_Placeholder
    \value KeyCredentialConfigurationFolderType_ServiceName_Placeholder_ResourceUri
    \value KeyCredentialConfigurationFolderType_ServiceName_Placeholder_ProfileUri
    \value KeyCredentialConfigurationFolderType_ServiceName_Placeholder_EndpointUrls
    \value KeyCredentialConfigurationFolderType_ServiceName_Placeholder_ServiceStatus
    \value KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey
    \value KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey_InputArguments
    \value KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey_OutputArguments
    \value KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential
    \value KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential_InputArguments
    \value KeyCredentialConfigurationFolderType_ServiceName_Placeholder_DeleteCredential
    \value KeyCredentialConfigurationFolderType_CreateCredential
    \value KeyCredentialConfigurationFolderType_CreateCredential_InputArguments
    \value KeyCredentialConfigurationFolderType_CreateCredential_OutputArguments
    \value KeyCredentialConfiguration_ServiceName_Placeholder_GetEncryptingKey
    \value KeyCredentialConfiguration_ServiceName_Placeholder_GetEncryptingKey_InputArguments
    \value KeyCredentialConfiguration_ServiceName_Placeholder_GetEncryptingKey_OutputArguments
    \value KeyCredentialConfiguration_CreateCredential
    \value KeyCredentialConfiguration_CreateCredential_InputArguments
    \value KeyCredentialConfiguration_CreateCredential_OutputArguments
    \value GetEncryptingKeyMethodType
    \value GetEncryptingKeyMethodType_InputArguments
    \value GetEncryptingKeyMethodType_OutputArguments
    \value KeyCredentialConfigurationType_GetEncryptingKey
    \value KeyCredentialConfigurationType_GetEncryptingKey_InputArguments
    \value KeyCredentialConfigurationType_GetEncryptingKey_OutputArguments
    \value AdditionalParametersType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_AdditionalParametersType
    \value OpcUa_BinarySchema_AdditionalParametersType_DataTypeVersion
    \value OpcUa_BinarySchema_AdditionalParametersType_DictionaryFragment
    \value AdditionalParametersType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_AdditionalParametersType
    \value OpcUa_XmlSchema_AdditionalParametersType_DataTypeVersion
    \value OpcUa_XmlSchema_AdditionalParametersType_DictionaryFragment
    \value RsaEncryptedSecret
    \value EccEncryptedSecret
    \value AdditionalParametersType_Encoding_DefaultJson
    \value EphemeralKeyType
    \value EphemeralKeyType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_EphemeralKeyType
    \value OpcUa_BinarySchema_EphemeralKeyType_DataTypeVersion
    \value OpcUa_BinarySchema_EphemeralKeyType_DictionaryFragment
    \value EphemeralKeyType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_EphemeralKeyType
    \value OpcUa_XmlSchema_EphemeralKeyType_DataTypeVersion
    \value OpcUa_XmlSchema_EphemeralKeyType_DictionaryFragment
    \value EphemeralKeyType_Encoding_DefaultJson
    \value PubSubConnectionType_WriterGroupName_Placeholder_HeaderLayoutUri
    \value WriterGroupType_HeaderLayoutUri
    \value ReaderGroupType_DataSetReaderName_Placeholder_KeyFrameCount
    \value PubSubConnectionTypeAddWriterGroupMethodType
    \value ReaderGroupType_DataSetReaderName_Placeholder_HeaderLayoutUri
    \value DataSetReaderType_KeyFrameCount
    \value DataSetReaderType_HeaderLayoutUri
    \value BaseAnalogType_Definition
    \value BaseAnalogType_ValuePrecision
    \value BaseAnalogType_InstrumentRange
    \value BaseAnalogType_EURange
    \value BaseAnalogType_EngineeringUnits
    \value AnalogUnitRangeType
    \value AnalogUnitRangeType_Definition
    \value AnalogUnitRangeType_ValuePrecision
    \value AnalogUnitRangeType_InstrumentRange
    \value AnalogUnitRangeType_EURange
    \value AnalogUnitRangeType_EngineeringUnits
    \value PubSubConnectionType_Address_NetworkInterface_Selections
    \value PubSubConnectionType_Address_NetworkInterface_SelectionDescriptions
    \value PubSubConnectionType_Address_NetworkInterface_RestrictToList
    \value DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_Selections
    \value DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_SelectionDescriptions
    \value DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_RestrictToList
    \value NetworkAddressType_NetworkInterface_Selections
    \value NetworkAddressType_NetworkInterface_SelectionDescriptions
    \value NetworkAddressType_NetworkInterface_RestrictToList
    \value NetworkAddressUrlType_NetworkInterface_Selections
    \value NetworkAddressUrlType_NetworkInterface_SelectionDescriptions
    \value NetworkAddressUrlType_NetworkInterface_RestrictToList
    \value Index
    \value DictionaryEntryType
    \value DictionaryEntryType_DictionaryEntryName_Placeholder
    \value DictionaryFolderType
    \value DictionaryFolderType_DictionaryFolderName_Placeholder
    \value DictionaryFolderType_DictionaryEntryName_Placeholder
    \value Dictionaries
    \value Dictionaries_DictionaryFolderName_Placeholder
    \value Dictionaries_DictionaryEntryName_Placeholder
    \value HasDictionaryEntry
    \value IrdiDictionaryEntryType
    \value IrdiDictionaryEntryType_DictionaryEntryName_Placeholder
    \value UriDictionaryEntryType
    \value UriDictionaryEntryType_DictionaryEntryName_Placeholder
    \value BaseInterfaceType
    \value HasInterface
    \value HasAddIn
    \value DefaultInstanceBrowseName
    \value GenericAttributeValue
    \value GenericAttributes
    \value GenericAttributeValue_Encoding_DefaultXml
    \value GenericAttributes_Encoding_DefaultXml
    \value GenericAttributeValue_Encoding_DefaultBinary
    \value GenericAttributes_Encoding_DefaultBinary
    \value ServerType_LocalTime
    \value PubSubConnectionTypeAddWriterGroupMethodType_InputArguments
    \value PubSubConnectionTypeAddWriterGroupMethodType_OutputArguments
    \value AuditSecurityEventType_StatusCodeId
    \value AuditChannelEventType_StatusCodeId
    \value AuditOpenSecureChannelEventType_StatusCodeId
    \value AuditSessionEventType_StatusCodeId
    \value AuditCreateSessionEventType_StatusCodeId
    \value AuditUrlMismatchEventType_StatusCodeId
    \value AuditActivateSessionEventType_StatusCodeId
    \value AuditCancelEventType_StatusCodeId
    \value AuditCertificateEventType_StatusCodeId
    \value AuditCertificateDataMismatchEventType_StatusCodeId
    \value AuditCertificateExpiredEventType_StatusCodeId
    \value AuditCertificateInvalidEventType_StatusCodeId
    \value AuditCertificateUntrustedEventType_StatusCodeId
    \value AuditCertificateRevokedEventType_StatusCodeId
    \value AuditCertificateMismatchEventType_StatusCodeId
    \value PubSubConnectionAddReaderGroupGroupMethodType
    \value PubSubConnectionAddReaderGroupGroupMethodType_InputArguments
    \value SelectionListType_Selections
    \value SelectionListType_SelectionDescriptions
    \value Server_LocalTime
    \value FiniteStateMachineType_AvailableStates
    \value FiniteStateMachineType_AvailableTransitions
    \value TemporaryFileTransferType_TransferState_Placeholder_AvailableStates
    \value TemporaryFileTransferType_TransferState_Placeholder_AvailableTransitions
    \value FileTransferStateMachineType_AvailableStates
    \value FileTransferStateMachineType_AvailableTransitions
    \value RoleMappingRuleChangedAuditEventType
    \value RoleMappingRuleChangedAuditEventType_EventId
    \value RoleMappingRuleChangedAuditEventType_EventType
    \value RoleMappingRuleChangedAuditEventType_SourceNode
    \value RoleMappingRuleChangedAuditEventType_SourceName
    \value RoleMappingRuleChangedAuditEventType_Time
    \value RoleMappingRuleChangedAuditEventType_ReceiveTime
    \value RoleMappingRuleChangedAuditEventType_LocalTime
    \value RoleMappingRuleChangedAuditEventType_Message
    \value RoleMappingRuleChangedAuditEventType_Severity
    \value RoleMappingRuleChangedAuditEventType_ActionTimeStamp
    \value RoleMappingRuleChangedAuditEventType_Status
    \value RoleMappingRuleChangedAuditEventType_ServerId
    \value RoleMappingRuleChangedAuditEventType_ClientAuditEntryId
    \value RoleMappingRuleChangedAuditEventType_ClientUserId
    \value RoleMappingRuleChangedAuditEventType_MethodId
    \value RoleMappingRuleChangedAuditEventType_InputArguments
    \value AlarmConditionType_ShelvingState_AvailableStates
    \value AlarmConditionType_ShelvingState_AvailableTransitions
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_AvailableStates
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_AvailableTransitions
    \value ShelvedStateMachineType_AvailableStates
    \value ShelvedStateMachineType_AvailableTransitions
    \value LimitAlarmType_ShelvingState_AvailableStates
    \value LimitAlarmType_ShelvingState_AvailableTransitions
    \value ExclusiveLimitStateMachineType_AvailableStates
    \value ExclusiveLimitStateMachineType_AvailableTransitions
    \value ExclusiveLimitAlarmType_ShelvingState_AvailableStates
    \value ExclusiveLimitAlarmType_ShelvingState_AvailableTransitions
    \value ExclusiveLimitAlarmType_LimitState_AvailableStates
    \value ExclusiveLimitAlarmType_LimitState_AvailableTransitions
    \value NonExclusiveLimitAlarmType_ShelvingState_AvailableStates
    \value NonExclusiveLimitAlarmType_ShelvingState_AvailableTransitions
    \value NonExclusiveLevelAlarmType_ShelvingState_AvailableStates
    \value NonExclusiveLevelAlarmType_ShelvingState_AvailableTransitions
    \value ExclusiveLevelAlarmType_ShelvingState_AvailableStates
    \value ExclusiveLevelAlarmType_ShelvingState_AvailableTransitions
    \value ExclusiveLevelAlarmType_LimitState_AvailableStates
    \value ExclusiveLevelAlarmType_LimitState_AvailableTransitions
    \value NonExclusiveDeviationAlarmType_ShelvingState_AvailableStates
    \value NonExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions
    \value ExclusiveDeviationAlarmType_ShelvingState_AvailableStates
    \value ExclusiveDeviationAlarmType_ShelvingState_AvailableTransitions
    \value ExclusiveDeviationAlarmType_LimitState_AvailableStates
    \value ExclusiveDeviationAlarmType_LimitState_AvailableTransitions
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates
    \value NonExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableStates
    \value ExclusiveRateOfChangeAlarmType_ShelvingState_AvailableTransitions
    \value ExclusiveRateOfChangeAlarmType_LimitState_AvailableStates
    \value ExclusiveRateOfChangeAlarmType_LimitState_AvailableTransitions
    \value DiscreteAlarmType_ShelvingState_AvailableStates
    \value DiscreteAlarmType_ShelvingState_AvailableTransitions
    \value OffNormalAlarmType_ShelvingState_AvailableStates
    \value OffNormalAlarmType_ShelvingState_AvailableTransitions
    \value SystemOffNormalAlarmType_ShelvingState_AvailableStates
    \value SystemOffNormalAlarmType_ShelvingState_AvailableTransitions
    \value TripAlarmType_ShelvingState_AvailableStates
    \value TripAlarmType_ShelvingState_AvailableTransitions
    \value CertificateExpirationAlarmType_ShelvingState_AvailableStates
    \value CertificateExpirationAlarmType_ShelvingState_AvailableTransitions
    \value DiscrepancyAlarmType_ShelvingState_AvailableStates
    \value DiscrepancyAlarmType_ShelvingState_AvailableTransitions
    \value ProgramStateMachineType_AvailableStates
    \value ProgramStateMachineType_AvailableTransitions
    \value PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_Selections
    \value PublishSubscribeType_ConnectionName_Placeholder_TransportProfileUri_SelectionDescriptions
    \value InterfaceTypes
    \value RationalNumberType
    \value PubSubConnectionType_TransportProfileUri_Selections
    \value PubSubConnectionType_TransportProfileUri_SelectionDescriptions
    \value RationalNumberType_Numerator
    \value RationalNumberType_Denominator
    \value VectorType
    \value VectorType_VectorUnit
    \value ThreeDVectorType
    \value ThreeDVectorType_VectorUnit
    \value FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject
    \value FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments
    \value PubSubConnectionAddReaderGroupGroupMethodType_OutputArguments
    \value ConnectionTransportType
    \value FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject
    \value FileSystem_FileDirectoryName_Placeholder_DeleteFileSystemObject_InputArguments
    \value PubSubGroupType_MaxNetworkMessageSize
    \value WriterGroupType
    \value WriterGroupType_SecurityMode
    \value WriterGroupType_SecurityGroupId
    \value WriterGroupType_SecurityKeyServices
    \value WriterGroupType_MaxNetworkMessageSize
    \value WriterGroupType_Status
    \value WriterGroupType_Status_State
    \value AuthorizationServices
    \value WriterGroupType_Status_Enable
    \value WriterGroupType_Status_Disable
    \value WriterGroupType_WriterGroupId
    \value WriterGroupType_PublishingInterval
    \value WriterGroupType_KeepAliveTime
    \value WriterGroupType_Priority
    \value WriterGroupType_LocaleIds
    \value WriterGroupType_TransportSettings
    \value WriterGroupType_MessageSettings
    \value WriterGroupType_DataSetWriterName_Placeholder
    \value WriterGroupType_DataSetWriterName_Placeholder_DataSetWriterId
    \value WriterGroupType_DataSetWriterName_Placeholder_DataSetFieldContentMask
    \value WriterGroupType_DataSetWriterName_Placeholder_KeyFrameCount
    \value WriterGroupType_DataSetWriterName_Placeholder_TransportSettings
    \value WriterGroupType_DataSetWriterName_Placeholder_MessageSettings
    \value WriterGroupType_DataSetWriterName_Placeholder_Status
    \value WriterGroupType_DataSetWriterName_Placeholder_Status_State
    \value WriterGroupType_DataSetWriterName_Placeholder_Status_Enable
    \value WriterGroupType_DataSetWriterName_Placeholder_Status_Disable
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_SubError
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion
    \value WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel
    \value WriterGroupType_Diagnostics
    \value WriterGroupType_Diagnostics_DiagnosticsLevel
    \value WriterGroupType_Diagnostics_TotalInformation
    \value WriterGroupType_Diagnostics_TotalInformation_Active
    \value WriterGroupType_Diagnostics_TotalInformation_Classification
    \value WriterGroupType_Diagnostics_TotalInformation_DiagnosticsLevel
    \value WriterGroupType_Diagnostics_TotalInformation_TimeFirstChange
    \value WriterGroupType_Diagnostics_TotalError
    \value WriterGroupType_Diagnostics_TotalError_Active
    \value WriterGroupType_Diagnostics_TotalError_Classification
    \value WriterGroupType_Diagnostics_TotalError_DiagnosticsLevel
    \value WriterGroupType_Diagnostics_TotalError_TimeFirstChange
    \value WriterGroupType_Diagnostics_Reset
    \value WriterGroupType_Diagnostics_SubError
    \value WriterGroupType_Diagnostics_Counters
    \value WriterGroupType_Diagnostics_Counters_StateError
    \value WriterGroupType_Diagnostics_Counters_StateError_Active
    \value WriterGroupType_Diagnostics_Counters_StateError_Classification
    \value WriterGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value WriterGroupType_Diagnostics_Counters_StateError_TimeFirstChange
    \value WriterGroupType_Diagnostics_Counters_StateOperationalByMethod
    \value WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Active
    \value WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value WriterGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value WriterGroupType_Diagnostics_Counters_StateOperationalByParent
    \value WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Active
    \value WriterGroupType_Diagnostics_Counters_StateOperationalByParent_Classification
    \value WriterGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value WriterGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value WriterGroupType_Diagnostics_Counters_StateOperationalFromError
    \value WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Active
    \value WriterGroupType_Diagnostics_Counters_StateOperationalFromError_Classification
    \value WriterGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value WriterGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value WriterGroupType_Diagnostics_Counters_StatePausedByParent
    \value WriterGroupType_Diagnostics_Counters_StatePausedByParent_Active
    \value WriterGroupType_Diagnostics_Counters_StatePausedByParent_Classification
    \value WriterGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value WriterGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value AuthorizationServiceConfigurationType
    \value WriterGroupType_Diagnostics_Counters_StateDisabledByMethod
    \value WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Active
    \value WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value WriterGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value WriterGroupType_Diagnostics_LiveValues
    \value WriterGroupType_Diagnostics_Counters_SentNetworkMessages
    \value AuthorizationServiceConfigurationType_ServiceCertificate
    \value DecimalDataType
    \value DecimalDataType_Encoding_DefaultXml
    \value DecimalDataType_Encoding_DefaultBinary
    \value WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Active
    \value AlarmConditionType_AudibleSound_ListId
    \value AlarmConditionType_AudibleSound_AgencyId
    \value AlarmConditionType_AudibleSound_VersionId
    \value AlarmConditionType_Unsuppress
    \value AlarmConditionType_RemoveFromService
    \value AlarmConditionType_PlaceInService
    \value WriterGroupType_Diagnostics_Counters_SentNetworkMessages_Classification
    \value WriterGroupType_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel
    \value WriterGroupType_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange
    \value WriterGroupType_Diagnostics_Counters_FailedTransmissions
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService
    \value WriterGroupType_Diagnostics_Counters_FailedTransmissions_Active
    \value LimitAlarmType_AudibleSound_ListId
    \value LimitAlarmType_AudibleSound_AgencyId
    \value LimitAlarmType_AudibleSound_VersionId
    \value LimitAlarmType_Unsuppress
    \value LimitAlarmType_RemoveFromService
    \value LimitAlarmType_PlaceInService
    \value WriterGroupType_Diagnostics_Counters_FailedTransmissions_Classification
    \value ExclusiveLimitAlarmType_AudibleSound_ListId
    \value ExclusiveLimitAlarmType_AudibleSound_AgencyId
    \value ExclusiveLimitAlarmType_AudibleSound_VersionId
    \value ExclusiveLimitAlarmType_Unsuppress
    \value ExclusiveLimitAlarmType_RemoveFromService
    \value ExclusiveLimitAlarmType_PlaceInService
    \value WriterGroupType_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel
    \value NonExclusiveLimitAlarmType_AudibleSound_ListId
    \value NonExclusiveLimitAlarmType_AudibleSound_AgencyId
    \value NonExclusiveLimitAlarmType_AudibleSound_VersionId
    \value NonExclusiveLimitAlarmType_Unsuppress
    \value NonExclusiveLimitAlarmType_RemoveFromService
    \value NonExclusiveLimitAlarmType_PlaceInService
    \value WriterGroupType_Diagnostics_Counters_FailedTransmissions_TimeFirstChange
    \value WriterGroupType_Diagnostics_Counters_EncryptionErrors
    \value WriterGroupType_Diagnostics_Counters_EncryptionErrors_Active
    \value WriterGroupType_Diagnostics_Counters_EncryptionErrors_Classification
    \value WriterGroupType_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel
    \value NonExclusiveLevelAlarmType_RemoveFromService
    \value NonExclusiveLevelAlarmType_PlaceInService
    \value WriterGroupType_Diagnostics_Counters_EncryptionErrors_TimeFirstChange
    \value ExclusiveLevelAlarmType_AudibleSound_ListId
    \value ExclusiveLevelAlarmType_AudibleSound_AgencyId
    \value ExclusiveLevelAlarmType_AudibleSound_VersionId
    \value ExclusiveLevelAlarmType_Unsuppress
    \value ExclusiveLevelAlarmType_RemoveFromService
    \value ExclusiveLevelAlarmType_PlaceInService
    \value WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters
    \value NonExclusiveDeviationAlarmType_AudibleSound_ListId
    \value NonExclusiveDeviationAlarmType_AudibleSound_AgencyId
    \value NonExclusiveDeviationAlarmType_AudibleSound_VersionId
    \value NonExclusiveDeviationAlarmType_Unsuppress
    \value NonExclusiveDeviationAlarmType_RemoveFromService
    \value NonExclusiveDeviationAlarmType_PlaceInService
    \value WriterGroupType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel
    \value NonExclusiveRateOfChangeAlarmType_AudibleSound_ListId
    \value NonExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId
    \value NonExclusiveRateOfChangeAlarmType_AudibleSound_VersionId
    \value NonExclusiveRateOfChangeAlarmType_Unsuppress
    \value NonExclusiveRateOfChangeAlarmType_RemoveFromService
    \value NonExclusiveRateOfChangeAlarmType_PlaceInService
    \value WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters
    \value ExclusiveDeviationAlarmType_AudibleSound_ListId
    \value ExclusiveDeviationAlarmType_AudibleSound_AgencyId
    \value ExclusiveDeviationAlarmType_AudibleSound_VersionId
    \value ExclusiveDeviationAlarmType_Unsuppress
    \value ExclusiveDeviationAlarmType_RemoveFromService
    \value ExclusiveDeviationAlarmType_PlaceInService
    \value WriterGroupType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel
    \value ExclusiveRateOfChangeAlarmType_AudibleSound_ListId
    \value ExclusiveRateOfChangeAlarmType_AudibleSound_AgencyId
    \value ExclusiveRateOfChangeAlarmType_AudibleSound_VersionId
    \value ExclusiveRateOfChangeAlarmType_Unsuppress
    \value ExclusiveRateOfChangeAlarmType_RemoveFromService
    \value ExclusiveRateOfChangeAlarmType_PlaceInService
    \value WriterGroupType_Diagnostics_LiveValues_SecurityTokenID
    \value DiscreteAlarmType_AudibleSound_ListId
    \value DiscreteAlarmType_AudibleSound_AgencyId
    \value DiscreteAlarmType_AudibleSound_VersionId
    \value DiscreteAlarmType_Unsuppress
    \value DiscreteAlarmType_RemoveFromService
    \value DiscreteAlarmType_PlaceInService
    \value WriterGroupType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel
    \value OffNormalAlarmType_AudibleSound_ListId
    \value OffNormalAlarmType_AudibleSound_AgencyId
    \value OffNormalAlarmType_AudibleSound_VersionId
    \value OffNormalAlarmType_Unsuppress
    \value OffNormalAlarmType_RemoveFromService
    \value OffNormalAlarmType_PlaceInService
    \value WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID
    \value SystemOffNormalAlarmType_AudibleSound_ListId
    \value SystemOffNormalAlarmType_AudibleSound_AgencyId
    \value SystemOffNormalAlarmType_AudibleSound_VersionId
    \value SystemOffNormalAlarmType_Unsuppress
    \value SystemOffNormalAlarmType_RemoveFromService
    \value SystemOffNormalAlarmType_PlaceInService
    \value WriterGroupType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel
    \value TripAlarmType_AudibleSound_ListId
    \value TripAlarmType_AudibleSound_AgencyId
    \value TripAlarmType_AudibleSound_VersionId
    \value TripAlarmType_Unsuppress
    \value TripAlarmType_RemoveFromService
    \value TripAlarmType_PlaceInService
    \value WriterGroupType_AddDataSetWriter
    \value CertificateExpirationAlarmType_AudibleSound_ListId
    \value CertificateExpirationAlarmType_AudibleSound_AgencyId
    \value CertificateExpirationAlarmType_AudibleSound_VersionId
    \value CertificateExpirationAlarmType_Unsuppress
    \value CertificateExpirationAlarmType_RemoveFromService
    \value CertificateExpirationAlarmType_PlaceInService
    \value WriterGroupType_AddDataSetWriter_InputArguments
    \value DiscrepancyAlarmType_AudibleSound_ListId
    \value DiscrepancyAlarmType_AudibleSound_AgencyId
    \value DiscrepancyAlarmType_AudibleSound_VersionId
    \value DiscrepancyAlarmType_Unsuppress
    \value DiscrepancyAlarmType_RemoveFromService
    \value DiscrepancyAlarmType_PlaceInService
    \value HasEffectEnable
    \value HasEffectSuppressed
    \value HasEffectUnsuppressed
    \value AudioVariableType
    \value WriterGroupType_AddDataSetWriter_OutputArguments
    \value AudioVariableType_ListId
    \value AudioVariableType_AgencyId
    \value AudioVariableType_VersionId
    \value AlarmMetricsType_StartTime
    \value WriterGroupType_RemoveDataSetWriter
    \value WriterGroupType_RemoveDataSetWriter_InputArguments
    \value PubSubGroupTypeAddWriterMethodType
    \value PubSubGroupTypeAddWriterMethodType_InputArguments
    \value PubSubGroupTypeAddWriterMethodType_OutputArguments
    \value WriterGroupTransportType
    \value WriterGroupMessageType
    \value ReaderGroupType
    \value ReaderGroupType_SecurityMode
    \value KeyCredentialConfigurationType
    \value ReaderGroupType_SecurityGroupId
    \value ReaderGroupType_SecurityKeyServices
    \value KeyCredentialConfigurationType_EndpointUrls
    \value KeyCredentialConfigurationType_ServiceStatus
    \value KeyCredentialConfigurationType_UpdateCredential
    \value KeyCredentialConfigurationType_UpdateCredential_InputArguments
    \value KeyCredentialConfigurationType_DeleteCredential
    \value KeyCredentialUpdateMethodType
    \value KeyCredentialUpdateMethodType_InputArguments
    \value KeyCredentialAuditEventType
    \value KeyCredentialAuditEventType_EventId
    \value KeyCredentialAuditEventType_EventType
    \value KeyCredentialAuditEventType_SourceNode
    \value KeyCredentialAuditEventType_SourceName
    \value KeyCredentialAuditEventType_Time
    \value KeyCredentialAuditEventType_ReceiveTime
    \value KeyCredentialAuditEventType_LocalTime
    \value KeyCredentialAuditEventType_Message
    \value KeyCredentialAuditEventType_Severity
    \value KeyCredentialAuditEventType_ActionTimeStamp
    \value KeyCredentialAuditEventType_Status
    \value KeyCredentialAuditEventType_ServerId
    \value KeyCredentialAuditEventType_ClientAuditEntryId
    \value KeyCredentialAuditEventType_ClientUserId
    \value KeyCredentialAuditEventType_MethodId
    \value KeyCredentialAuditEventType_InputArguments
    \value KeyCredentialAuditEventType_ResourceUri
    \value KeyCredentialUpdatedAuditEventType
    \value KeyCredentialUpdatedAuditEventType_EventId
    \value KeyCredentialUpdatedAuditEventType_EventType
    \value KeyCredentialUpdatedAuditEventType_SourceNode
    \value KeyCredentialUpdatedAuditEventType_SourceName
    \value KeyCredentialUpdatedAuditEventType_Time
    \value KeyCredentialUpdatedAuditEventType_ReceiveTime
    \value KeyCredentialUpdatedAuditEventType_LocalTime
    \value KeyCredentialUpdatedAuditEventType_Message
    \value KeyCredentialUpdatedAuditEventType_Severity
    \value KeyCredentialUpdatedAuditEventType_ActionTimeStamp
    \value KeyCredentialUpdatedAuditEventType_Status
    \value KeyCredentialUpdatedAuditEventType_ServerId
    \value KeyCredentialUpdatedAuditEventType_ClientAuditEntryId
    \value KeyCredentialUpdatedAuditEventType_ClientUserId
    \value KeyCredentialUpdatedAuditEventType_MethodId
    \value KeyCredentialUpdatedAuditEventType_InputArguments
    \value KeyCredentialUpdatedAuditEventType_ResourceUri
    \value KeyCredentialDeletedAuditEventType
    \value KeyCredentialDeletedAuditEventType_EventId
    \value KeyCredentialDeletedAuditEventType_EventType
    \value KeyCredentialDeletedAuditEventType_SourceNode
    \value KeyCredentialDeletedAuditEventType_SourceName
    \value KeyCredentialDeletedAuditEventType_Time
    \value KeyCredentialDeletedAuditEventType_ReceiveTime
    \value KeyCredentialDeletedAuditEventType_LocalTime
    \value KeyCredentialDeletedAuditEventType_Message
    \value KeyCredentialDeletedAuditEventType_Severity
    \value KeyCredentialDeletedAuditEventType_ActionTimeStamp
    \value KeyCredentialDeletedAuditEventType_Status
    \value KeyCredentialDeletedAuditEventType_ServerId
    \value KeyCredentialDeletedAuditEventType_ClientAuditEntryId
    \value KeyCredentialDeletedAuditEventType_ClientUserId
    \value KeyCredentialDeletedAuditEventType_MethodId
    \value KeyCredentialDeletedAuditEventType_InputArguments
    \value KeyCredentialDeletedAuditEventType_ResourceUri
    \value ReaderGroupType_MaxNetworkMessageSize
    \value ReaderGroupType_Status
    \value ReaderGroupType_Status_State
    \value KeyCredentialConfigurationType_ResourceUri
    \value AuthorizationServiceConfigurationType_ServiceUri
    \value AuthorizationServiceConfigurationType_IssuerEndpointUrl
    \value ReaderGroupType_Status_Enable
    \value ReaderGroupType_Status_Disable
    \value ReaderGroupType_DataSetReaderName_Placeholder
    \value ReaderGroupType_DataSetReaderName_Placeholder_PublisherId
    \value ReaderGroupType_DataSetReaderName_Placeholder_WriterGroupId
    \value ReaderGroupType_DataSetReaderName_Placeholder_DataSetWriterId
    \value ReaderGroupType_DataSetReaderName_Placeholder_DataSetMetaData
    \value ReaderGroupType_DataSetReaderName_Placeholder_DataSetFieldContentMask
    \value ReaderGroupType_DataSetReaderName_Placeholder_MessageReceiveTimeout
    \value ReaderGroupType_DataSetReaderName_Placeholder_SecurityMode
    \value ReaderGroupType_DataSetReaderName_Placeholder_SecurityGroupId
    \value ReaderGroupType_DataSetReaderName_Placeholder_SecurityKeyServices
    \value ReaderGroupType_DataSetReaderName_Placeholder_TransportSettings
    \value ReaderGroupType_DataSetReaderName_Placeholder_MessageSettings
    \value ReaderGroupType_DataSetReaderName_Placeholder_Status
    \value ReaderGroupType_DataSetReaderName_Placeholder_Status_State
    \value ReaderGroupType_DataSetReaderName_Placeholder_Status_Enable
    \value ReaderGroupType_DataSetReaderName_Placeholder_Status_Disable
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Active
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_Classification
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Active
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_Classification
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_TotalError_TimeFirstChange
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_SubError
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Active
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_Classification
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion
    \value KeyCredentialConfiguration
    \value KeyCredentialConfiguration_ServiceName_Placeholder
    \value KeyCredentialConfiguration_ServiceName_Placeholder_ResourceUri
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel
    \value KeyCredentialConfiguration_ServiceName_Placeholder_EndpointUrls
    \value KeyCredentialConfiguration_ServiceName_Placeholder_ServiceStatus
    \value KeyCredentialConfiguration_ServiceName_Placeholder_UpdateCredential
    \value KeyCredentialConfiguration_ServiceName_Placeholder_UpdateCredential_InputArguments
    \value KeyCredentialConfiguration_ServiceName_Placeholder_DeleteCredential
    \value KeyCredentialConfiguration_ServiceName_Placeholder_ProfileUri
    \value KeyCredentialConfigurationType_ProfileUri
    \value OpcUa_XmlSchema_DataTypeDefinition
    \value OpcUa_XmlSchema_DataTypeDefinition_DataTypeVersion
    \value OpcUa_XmlSchema_DataTypeDefinition_DictionaryFragment
    \value OpcUa_XmlSchema_StructureField
    \value OpcUa_XmlSchema_StructureField_DataTypeVersion
    \value OpcUa_XmlSchema_StructureField_DictionaryFragment
    \value OpcUa_XmlSchema_StructureDefinition
    \value OpcUa_XmlSchema_StructureDefinition_DataTypeVersion
    \value OpcUa_XmlSchema_StructureDefinition_DictionaryFragment
    \value OpcUa_XmlSchema_EnumDefinition
    \value OpcUa_XmlSchema_EnumDefinition_DataTypeVersion
    \value OpcUa_XmlSchema_EnumDefinition_DictionaryFragment
    \value OpcUa_BinarySchema_DataTypeDefinition
    \value OpcUa_BinarySchema_DataTypeDefinition_DataTypeVersion
    \value OpcUa_BinarySchema_DataTypeDefinition_DictionaryFragment
    \value OpcUa_BinarySchema_StructureField
    \value OpcUa_BinarySchema_StructureField_DataTypeVersion
    \value OpcUa_BinarySchema_StructureField_DictionaryFragment
    \value OpcUa_BinarySchema_StructureDefinition
    \value OpcUa_BinarySchema_StructureDefinition_DataTypeVersion
    \value OpcUa_BinarySchema_StructureDefinition_DictionaryFragment
    \value OpcUa_BinarySchema_EnumDefinition
    \value OpcUa_BinarySchema_EnumDefinition_DataTypeVersion
    \value OpcUa_BinarySchema_EnumDefinition_DictionaryFragment
    \value AlarmConditionType_LatchedState
    \value AlarmConditionType_LatchedState_Id
    \value AlarmConditionType_LatchedState_Name
    \value AlarmConditionType_LatchedState_Number
    \value AlarmConditionType_LatchedState_EffectiveDisplayName
    \value AlarmConditionType_LatchedState_TransitionTime
    \value AlarmConditionType_LatchedState_EffectiveTransitionTime
    \value AlarmConditionType_LatchedState_TrueState
    \value AlarmConditionType_LatchedState_FalseState
    \value AlarmConditionType_Reset
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AudibleSound_ListId
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AudibleSound_AgencyId
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_AudibleSound_VersionId
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_Id
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_Name
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_Number
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_EffectiveDisplayName
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_TransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_EffectiveTransitionTime
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_TrueState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_FalseState
    \value AlarmGroupType_AlarmConditionInstance_Placeholder_Reset
    \value LimitAlarmType_LatchedState
    \value LimitAlarmType_LatchedState_Id
    \value LimitAlarmType_LatchedState_Name
    \value LimitAlarmType_LatchedState_Number
    \value LimitAlarmType_LatchedState_EffectiveDisplayName
    \value LimitAlarmType_LatchedState_TransitionTime
    \value LimitAlarmType_LatchedState_EffectiveTransitionTime
    \value LimitAlarmType_LatchedState_TrueState
    \value LimitAlarmType_LatchedState_FalseState
    \value LimitAlarmType_Reset
    \value ExclusiveLimitAlarmType_LatchedState
    \value ExclusiveLimitAlarmType_LatchedState_Id
    \value ExclusiveLimitAlarmType_LatchedState_Name
    \value ExclusiveLimitAlarmType_LatchedState_Number
    \value ExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName
    \value ExclusiveLimitAlarmType_LatchedState_TransitionTime
    \value ExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime
    \value ExclusiveLimitAlarmType_LatchedState_TrueState
    \value ExclusiveLimitAlarmType_LatchedState_FalseState
    \value ExclusiveLimitAlarmType_Reset
    \value NonExclusiveLimitAlarmType_LatchedState
    \value NonExclusiveLimitAlarmType_LatchedState_Id
    \value NonExclusiveLimitAlarmType_LatchedState_Name
    \value NonExclusiveLimitAlarmType_LatchedState_Number
    \value NonExclusiveLimitAlarmType_LatchedState_EffectiveDisplayName
    \value NonExclusiveLimitAlarmType_LatchedState_TransitionTime
    \value NonExclusiveLimitAlarmType_LatchedState_EffectiveTransitionTime
    \value NonExclusiveLimitAlarmType_LatchedState_TrueState
    \value NonExclusiveLimitAlarmType_LatchedState_FalseState
    \value NonExclusiveLimitAlarmType_Reset
    \value NonExclusiveLevelAlarmType_AudibleSound_ListId
    \value NonExclusiveLevelAlarmType_AudibleSound_AgencyId
    \value NonExclusiveLevelAlarmType_AudibleSound_VersionId
    \value NonExclusiveLevelAlarmType_LatchedState
    \value NonExclusiveLevelAlarmType_LatchedState_Id
    \value NonExclusiveLevelAlarmType_LatchedState_Name
    \value NonExclusiveLevelAlarmType_LatchedState_Number
    \value NonExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName
    \value NonExclusiveLevelAlarmType_LatchedState_TransitionTime
    \value NonExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime
    \value NonExclusiveLevelAlarmType_LatchedState_TrueState
    \value NonExclusiveLevelAlarmType_LatchedState_FalseState
    \value NonExclusiveLevelAlarmType_Unsuppress
    \value NonExclusiveLevelAlarmType_Reset
    \value ExclusiveLevelAlarmType_LatchedState
    \value ExclusiveLevelAlarmType_LatchedState_Id
    \value ExclusiveLevelAlarmType_LatchedState_Name
    \value ExclusiveLevelAlarmType_LatchedState_Number
    \value ExclusiveLevelAlarmType_LatchedState_EffectiveDisplayName
    \value ExclusiveLevelAlarmType_LatchedState_TransitionTime
    \value ExclusiveLevelAlarmType_LatchedState_EffectiveTransitionTime
    \value ExclusiveLevelAlarmType_LatchedState_TrueState
    \value ExclusiveLevelAlarmType_LatchedState_FalseState
    \value ExclusiveLevelAlarmType_Reset
    \value NonExclusiveDeviationAlarmType_LatchedState
    \value NonExclusiveDeviationAlarmType_LatchedState_Id
    \value NonExclusiveDeviationAlarmType_LatchedState_Name
    \value NonExclusiveDeviationAlarmType_LatchedState_Number
    \value NonExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName
    \value NonExclusiveDeviationAlarmType_LatchedState_TransitionTime
    \value NonExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime
    \value NonExclusiveDeviationAlarmType_LatchedState_TrueState
    \value NonExclusiveDeviationAlarmType_LatchedState_FalseState
    \value NonExclusiveDeviationAlarmType_Reset
    \value NonExclusiveRateOfChangeAlarmType_LatchedState
    \value NonExclusiveRateOfChangeAlarmType_LatchedState_Id
    \value NonExclusiveRateOfChangeAlarmType_LatchedState_Name
    \value NonExclusiveRateOfChangeAlarmType_LatchedState_Number
    \value NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName
    \value NonExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime
    \value NonExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime
    \value NonExclusiveRateOfChangeAlarmType_LatchedState_TrueState
    \value NonExclusiveRateOfChangeAlarmType_LatchedState_FalseState
    \value NonExclusiveRateOfChangeAlarmType_Reset
    \value ExclusiveDeviationAlarmType_LatchedState
    \value ExclusiveDeviationAlarmType_LatchedState_Id
    \value ExclusiveDeviationAlarmType_LatchedState_Name
    \value ExclusiveDeviationAlarmType_LatchedState_Number
    \value ExclusiveDeviationAlarmType_LatchedState_EffectiveDisplayName
    \value ExclusiveDeviationAlarmType_LatchedState_TransitionTime
    \value ExclusiveDeviationAlarmType_LatchedState_EffectiveTransitionTime
    \value ExclusiveDeviationAlarmType_LatchedState_TrueState
    \value ExclusiveDeviationAlarmType_LatchedState_FalseState
    \value ExclusiveDeviationAlarmType_Reset
    \value ExclusiveRateOfChangeAlarmType_LatchedState
    \value ExclusiveRateOfChangeAlarmType_LatchedState_Id
    \value ExclusiveRateOfChangeAlarmType_LatchedState_Name
    \value ExclusiveRateOfChangeAlarmType_LatchedState_Number
    \value ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveDisplayName
    \value ExclusiveRateOfChangeAlarmType_LatchedState_TransitionTime
    \value ExclusiveRateOfChangeAlarmType_LatchedState_EffectiveTransitionTime
    \value ExclusiveRateOfChangeAlarmType_LatchedState_TrueState
    \value ExclusiveRateOfChangeAlarmType_LatchedState_FalseState
    \value ExclusiveRateOfChangeAlarmType_Reset
    \value DiscreteAlarmType_LatchedState
    \value DiscreteAlarmType_LatchedState_Id
    \value DiscreteAlarmType_LatchedState_Name
    \value DiscreteAlarmType_LatchedState_Number
    \value DiscreteAlarmType_LatchedState_EffectiveDisplayName
    \value DiscreteAlarmType_LatchedState_TransitionTime
    \value DiscreteAlarmType_LatchedState_EffectiveTransitionTime
    \value DiscreteAlarmType_LatchedState_TrueState
    \value DiscreteAlarmType_LatchedState_FalseState
    \value DiscreteAlarmType_Reset
    \value OffNormalAlarmType_LatchedState
    \value OffNormalAlarmType_LatchedState_Id
    \value OffNormalAlarmType_LatchedState_Name
    \value OffNormalAlarmType_LatchedState_Number
    \value OffNormalAlarmType_LatchedState_EffectiveDisplayName
    \value OffNormalAlarmType_LatchedState_TransitionTime
    \value OffNormalAlarmType_LatchedState_EffectiveTransitionTime
    \value OffNormalAlarmType_LatchedState_TrueState
    \value OffNormalAlarmType_LatchedState_FalseState
    \value OffNormalAlarmType_Reset
    \value SystemOffNormalAlarmType_LatchedState
    \value SystemOffNormalAlarmType_LatchedState_Id
    \value SystemOffNormalAlarmType_LatchedState_Name
    \value SystemOffNormalAlarmType_LatchedState_Number
    \value SystemOffNormalAlarmType_LatchedState_EffectiveDisplayName
    \value SystemOffNormalAlarmType_LatchedState_TransitionTime
    \value SystemOffNormalAlarmType_LatchedState_EffectiveTransitionTime
    \value SystemOffNormalAlarmType_LatchedState_TrueState
    \value SystemOffNormalAlarmType_LatchedState_FalseState
    \value SystemOffNormalAlarmType_Reset
    \value TripAlarmType_LatchedState
    \value TripAlarmType_LatchedState_Id
    \value TripAlarmType_LatchedState_Name
    \value TripAlarmType_LatchedState_Number
    \value TripAlarmType_LatchedState_EffectiveDisplayName
    \value TripAlarmType_LatchedState_TransitionTime
    \value TripAlarmType_LatchedState_EffectiveTransitionTime
    \value TripAlarmType_LatchedState_TrueState
    \value TripAlarmType_LatchedState_FalseState
    \value TripAlarmType_Reset
    \value InstrumentDiagnosticAlarmType
    \value InstrumentDiagnosticAlarmType_EventId
    \value InstrumentDiagnosticAlarmType_EventType
    \value InstrumentDiagnosticAlarmType_SourceNode
    \value InstrumentDiagnosticAlarmType_SourceName
    \value InstrumentDiagnosticAlarmType_Time
    \value InstrumentDiagnosticAlarmType_ReceiveTime
    \value InstrumentDiagnosticAlarmType_LocalTime
    \value InstrumentDiagnosticAlarmType_Message
    \value InstrumentDiagnosticAlarmType_Severity
    \value InstrumentDiagnosticAlarmType_ConditionClassId
    \value InstrumentDiagnosticAlarmType_ConditionClassName
    \value InstrumentDiagnosticAlarmType_ConditionSubClassId
    \value InstrumentDiagnosticAlarmType_ConditionSubClassName
    \value InstrumentDiagnosticAlarmType_ConditionName
    \value InstrumentDiagnosticAlarmType_BranchId
    \value InstrumentDiagnosticAlarmType_Retain
    \value InstrumentDiagnosticAlarmType_EnabledState
    \value InstrumentDiagnosticAlarmType_EnabledState_Id
    \value InstrumentDiagnosticAlarmType_EnabledState_Name
    \value InstrumentDiagnosticAlarmType_EnabledState_Number
    \value InstrumentDiagnosticAlarmType_EnabledState_EffectiveDisplayName
    \value InstrumentDiagnosticAlarmType_EnabledState_TransitionTime
    \value InstrumentDiagnosticAlarmType_EnabledState_EffectiveTransitionTime
    \value InstrumentDiagnosticAlarmType_EnabledState_TrueState
    \value InstrumentDiagnosticAlarmType_EnabledState_FalseState
    \value InstrumentDiagnosticAlarmType_Quality
    \value InstrumentDiagnosticAlarmType_Quality_SourceTimestamp
    \value InstrumentDiagnosticAlarmType_LastSeverity
    \value InstrumentDiagnosticAlarmType_LastSeverity_SourceTimestamp
    \value InstrumentDiagnosticAlarmType_Comment
    \value InstrumentDiagnosticAlarmType_Comment_SourceTimestamp
    \value InstrumentDiagnosticAlarmType_ClientUserId
    \value InstrumentDiagnosticAlarmType_Disable
    \value InstrumentDiagnosticAlarmType_Enable
    \value InstrumentDiagnosticAlarmType_AddComment
    \value InstrumentDiagnosticAlarmType_AddComment_InputArguments
    \value InstrumentDiagnosticAlarmType_ConditionRefresh
    \value InstrumentDiagnosticAlarmType_ConditionRefresh_InputArguments
    \value InstrumentDiagnosticAlarmType_ConditionRefresh2
    \value InstrumentDiagnosticAlarmType_ConditionRefresh2_InputArguments
    \value InstrumentDiagnosticAlarmType_AckedState
    \value InstrumentDiagnosticAlarmType_AckedState_Id
    \value InstrumentDiagnosticAlarmType_AckedState_Name
    \value InstrumentDiagnosticAlarmType_AckedState_Number
    \value InstrumentDiagnosticAlarmType_AckedState_EffectiveDisplayName
    \value InstrumentDiagnosticAlarmType_AckedState_TransitionTime
    \value InstrumentDiagnosticAlarmType_AckedState_EffectiveTransitionTime
    \value InstrumentDiagnosticAlarmType_AckedState_TrueState
    \value InstrumentDiagnosticAlarmType_AckedState_FalseState
    \value InstrumentDiagnosticAlarmType_ConfirmedState
    \value InstrumentDiagnosticAlarmType_ConfirmedState_Id
    \value InstrumentDiagnosticAlarmType_ConfirmedState_Name
    \value InstrumentDiagnosticAlarmType_ConfirmedState_Number
    \value InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveDisplayName
    \value InstrumentDiagnosticAlarmType_ConfirmedState_TransitionTime
    \value InstrumentDiagnosticAlarmType_ConfirmedState_EffectiveTransitionTime
    \value InstrumentDiagnosticAlarmType_ConfirmedState_TrueState
    \value InstrumentDiagnosticAlarmType_ConfirmedState_FalseState
    \value InstrumentDiagnosticAlarmType_Acknowledge
    \value InstrumentDiagnosticAlarmType_Acknowledge_InputArguments
    \value InstrumentDiagnosticAlarmType_Confirm
    \value InstrumentDiagnosticAlarmType_Confirm_InputArguments
    \value InstrumentDiagnosticAlarmType_ActiveState
    \value InstrumentDiagnosticAlarmType_ActiveState_Id
    \value InstrumentDiagnosticAlarmType_ActiveState_Name
    \value InstrumentDiagnosticAlarmType_ActiveState_Number
    \value InstrumentDiagnosticAlarmType_ActiveState_EffectiveDisplayName
    \value InstrumentDiagnosticAlarmType_ActiveState_TransitionTime
    \value InstrumentDiagnosticAlarmType_ActiveState_EffectiveTransitionTime
    \value InstrumentDiagnosticAlarmType_ActiveState_TrueState
    \value InstrumentDiagnosticAlarmType_ActiveState_FalseState
    \value InstrumentDiagnosticAlarmType_InputNode
    \value InstrumentDiagnosticAlarmType_SuppressedState
    \value InstrumentDiagnosticAlarmType_SuppressedState_Id
    \value InstrumentDiagnosticAlarmType_SuppressedState_Name
    \value InstrumentDiagnosticAlarmType_SuppressedState_Number
    \value InstrumentDiagnosticAlarmType_SuppressedState_EffectiveDisplayName
    \value InstrumentDiagnosticAlarmType_SuppressedState_TransitionTime
    \value InstrumentDiagnosticAlarmType_SuppressedState_EffectiveTransitionTime
    \value InstrumentDiagnosticAlarmType_SuppressedState_TrueState
    \value InstrumentDiagnosticAlarmType_SuppressedState_FalseState
    \value InstrumentDiagnosticAlarmType_OutOfServiceState
    \value InstrumentDiagnosticAlarmType_OutOfServiceState_Id
    \value InstrumentDiagnosticAlarmType_OutOfServiceState_Name
    \value InstrumentDiagnosticAlarmType_OutOfServiceState_Number
    \value InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveDisplayName
    \value InstrumentDiagnosticAlarmType_OutOfServiceState_TransitionTime
    \value InstrumentDiagnosticAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value InstrumentDiagnosticAlarmType_OutOfServiceState_TrueState
    \value InstrumentDiagnosticAlarmType_OutOfServiceState_FalseState
    \value InstrumentDiagnosticAlarmType_ShelvingState
    \value InstrumentDiagnosticAlarmType_ShelvingState_CurrentState
    \value InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Id
    \value InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Name
    \value InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_Number
    \value InstrumentDiagnosticAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value InstrumentDiagnosticAlarmType_ShelvingState_LastTransition
    \value InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Id
    \value InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Name
    \value InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_Number
    \value InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_TransitionTime
    \value InstrumentDiagnosticAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value InstrumentDiagnosticAlarmType_ShelvingState_AvailableStates
    \value InstrumentDiagnosticAlarmType_ShelvingState_AvailableTransitions
    \value InstrumentDiagnosticAlarmType_ShelvingState_UnshelveTime
    \value InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve
    \value InstrumentDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments
    \value InstrumentDiagnosticAlarmType_ShelvingState_Unshelve
    \value InstrumentDiagnosticAlarmType_ShelvingState_OneShotShelve
    \value InstrumentDiagnosticAlarmType_SuppressedOrShelved
    \value InstrumentDiagnosticAlarmType_MaxTimeShelved
    \value InstrumentDiagnosticAlarmType_AudibleEnabled
    \value InstrumentDiagnosticAlarmType_AudibleSound
    \value InstrumentDiagnosticAlarmType_AudibleSound_ListId
    \value InstrumentDiagnosticAlarmType_AudibleSound_AgencyId
    \value InstrumentDiagnosticAlarmType_AudibleSound_VersionId
    \value InstrumentDiagnosticAlarmType_SilenceState
    \value InstrumentDiagnosticAlarmType_SilenceState_Id
    \value InstrumentDiagnosticAlarmType_SilenceState_Name
    \value InstrumentDiagnosticAlarmType_SilenceState_Number
    \value InstrumentDiagnosticAlarmType_SilenceState_EffectiveDisplayName
    \value InstrumentDiagnosticAlarmType_SilenceState_TransitionTime
    \value InstrumentDiagnosticAlarmType_SilenceState_EffectiveTransitionTime
    \value InstrumentDiagnosticAlarmType_SilenceState_TrueState
    \value InstrumentDiagnosticAlarmType_SilenceState_FalseState
    \value InstrumentDiagnosticAlarmType_OnDelay
    \value InstrumentDiagnosticAlarmType_OffDelay
    \value InstrumentDiagnosticAlarmType_FirstInGroupFlag
    \value InstrumentDiagnosticAlarmType_FirstInGroup
    \value InstrumentDiagnosticAlarmType_LatchedState
    \value InstrumentDiagnosticAlarmType_LatchedState_Id
    \value InstrumentDiagnosticAlarmType_LatchedState_Name
    \value InstrumentDiagnosticAlarmType_LatchedState_Number
    \value InstrumentDiagnosticAlarmType_LatchedState_EffectiveDisplayName
    \value InstrumentDiagnosticAlarmType_LatchedState_TransitionTime
    \value InstrumentDiagnosticAlarmType_LatchedState_EffectiveTransitionTime
    \value InstrumentDiagnosticAlarmType_LatchedState_TrueState
    \value InstrumentDiagnosticAlarmType_LatchedState_FalseState
    \value InstrumentDiagnosticAlarmType_AlarmGroup_Placeholder
    \value InstrumentDiagnosticAlarmType_ReAlarmTime
    \value InstrumentDiagnosticAlarmType_ReAlarmRepeatCount
    \value InstrumentDiagnosticAlarmType_Silence
    \value InstrumentDiagnosticAlarmType_Suppress
    \value InstrumentDiagnosticAlarmType_Unsuppress
    \value InstrumentDiagnosticAlarmType_RemoveFromService
    \value InstrumentDiagnosticAlarmType_PlaceInService
    \value InstrumentDiagnosticAlarmType_Reset
    \value InstrumentDiagnosticAlarmType_NormalState
    \value SystemDiagnosticAlarmType
    \value SystemDiagnosticAlarmType_EventId
    \value SystemDiagnosticAlarmType_EventType
    \value SystemDiagnosticAlarmType_SourceNode
    \value SystemDiagnosticAlarmType_SourceName
    \value SystemDiagnosticAlarmType_Time
    \value SystemDiagnosticAlarmType_ReceiveTime
    \value SystemDiagnosticAlarmType_LocalTime
    \value SystemDiagnosticAlarmType_Message
    \value SystemDiagnosticAlarmType_Severity
    \value SystemDiagnosticAlarmType_ConditionClassId
    \value SystemDiagnosticAlarmType_ConditionClassName
    \value SystemDiagnosticAlarmType_ConditionSubClassId
    \value SystemDiagnosticAlarmType_ConditionSubClassName
    \value SystemDiagnosticAlarmType_ConditionName
    \value SystemDiagnosticAlarmType_BranchId
    \value SystemDiagnosticAlarmType_Retain
    \value SystemDiagnosticAlarmType_EnabledState
    \value SystemDiagnosticAlarmType_EnabledState_Id
    \value SystemDiagnosticAlarmType_EnabledState_Name
    \value SystemDiagnosticAlarmType_EnabledState_Number
    \value SystemDiagnosticAlarmType_EnabledState_EffectiveDisplayName
    \value SystemDiagnosticAlarmType_EnabledState_TransitionTime
    \value SystemDiagnosticAlarmType_EnabledState_EffectiveTransitionTime
    \value SystemDiagnosticAlarmType_EnabledState_TrueState
    \value SystemDiagnosticAlarmType_EnabledState_FalseState
    \value SystemDiagnosticAlarmType_Quality
    \value SystemDiagnosticAlarmType_Quality_SourceTimestamp
    \value SystemDiagnosticAlarmType_LastSeverity
    \value SystemDiagnosticAlarmType_LastSeverity_SourceTimestamp
    \value SystemDiagnosticAlarmType_Comment
    \value SystemDiagnosticAlarmType_Comment_SourceTimestamp
    \value SystemDiagnosticAlarmType_ClientUserId
    \value SystemDiagnosticAlarmType_Disable
    \value SystemDiagnosticAlarmType_Enable
    \value SystemDiagnosticAlarmType_AddComment
    \value SystemDiagnosticAlarmType_AddComment_InputArguments
    \value SystemDiagnosticAlarmType_ConditionRefresh
    \value SystemDiagnosticAlarmType_ConditionRefresh_InputArguments
    \value SystemDiagnosticAlarmType_ConditionRefresh2
    \value SystemDiagnosticAlarmType_ConditionRefresh2_InputArguments
    \value SystemDiagnosticAlarmType_AckedState
    \value SystemDiagnosticAlarmType_AckedState_Id
    \value SystemDiagnosticAlarmType_AckedState_Name
    \value SystemDiagnosticAlarmType_AckedState_Number
    \value SystemDiagnosticAlarmType_AckedState_EffectiveDisplayName
    \value SystemDiagnosticAlarmType_AckedState_TransitionTime
    \value SystemDiagnosticAlarmType_AckedState_EffectiveTransitionTime
    \value SystemDiagnosticAlarmType_AckedState_TrueState
    \value SystemDiagnosticAlarmType_AckedState_FalseState
    \value SystemDiagnosticAlarmType_ConfirmedState
    \value SystemDiagnosticAlarmType_ConfirmedState_Id
    \value SystemDiagnosticAlarmType_ConfirmedState_Name
    \value SystemDiagnosticAlarmType_ConfirmedState_Number
    \value SystemDiagnosticAlarmType_ConfirmedState_EffectiveDisplayName
    \value SystemDiagnosticAlarmType_ConfirmedState_TransitionTime
    \value SystemDiagnosticAlarmType_ConfirmedState_EffectiveTransitionTime
    \value SystemDiagnosticAlarmType_ConfirmedState_TrueState
    \value SystemDiagnosticAlarmType_ConfirmedState_FalseState
    \value SystemDiagnosticAlarmType_Acknowledge
    \value SystemDiagnosticAlarmType_Acknowledge_InputArguments
    \value SystemDiagnosticAlarmType_Confirm
    \value SystemDiagnosticAlarmType_Confirm_InputArguments
    \value SystemDiagnosticAlarmType_ActiveState
    \value SystemDiagnosticAlarmType_ActiveState_Id
    \value SystemDiagnosticAlarmType_ActiveState_Name
    \value SystemDiagnosticAlarmType_ActiveState_Number
    \value SystemDiagnosticAlarmType_ActiveState_EffectiveDisplayName
    \value SystemDiagnosticAlarmType_ActiveState_TransitionTime
    \value SystemDiagnosticAlarmType_ActiveState_EffectiveTransitionTime
    \value SystemDiagnosticAlarmType_ActiveState_TrueState
    \value SystemDiagnosticAlarmType_ActiveState_FalseState
    \value SystemDiagnosticAlarmType_InputNode
    \value SystemDiagnosticAlarmType_SuppressedState
    \value SystemDiagnosticAlarmType_SuppressedState_Id
    \value SystemDiagnosticAlarmType_SuppressedState_Name
    \value SystemDiagnosticAlarmType_SuppressedState_Number
    \value SystemDiagnosticAlarmType_SuppressedState_EffectiveDisplayName
    \value SystemDiagnosticAlarmType_SuppressedState_TransitionTime
    \value SystemDiagnosticAlarmType_SuppressedState_EffectiveTransitionTime
    \value SystemDiagnosticAlarmType_SuppressedState_TrueState
    \value SystemDiagnosticAlarmType_SuppressedState_FalseState
    \value SystemDiagnosticAlarmType_OutOfServiceState
    \value SystemDiagnosticAlarmType_OutOfServiceState_Id
    \value SystemDiagnosticAlarmType_OutOfServiceState_Name
    \value SystemDiagnosticAlarmType_OutOfServiceState_Number
    \value SystemDiagnosticAlarmType_OutOfServiceState_EffectiveDisplayName
    \value SystemDiagnosticAlarmType_OutOfServiceState_TransitionTime
    \value SystemDiagnosticAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value SystemDiagnosticAlarmType_OutOfServiceState_TrueState
    \value SystemDiagnosticAlarmType_OutOfServiceState_FalseState
    \value SystemDiagnosticAlarmType_ShelvingState
    \value SystemDiagnosticAlarmType_ShelvingState_CurrentState
    \value SystemDiagnosticAlarmType_ShelvingState_CurrentState_Id
    \value SystemDiagnosticAlarmType_ShelvingState_CurrentState_Name
    \value SystemDiagnosticAlarmType_ShelvingState_CurrentState_Number
    \value SystemDiagnosticAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value SystemDiagnosticAlarmType_ShelvingState_LastTransition
    \value SystemDiagnosticAlarmType_ShelvingState_LastTransition_Id
    \value SystemDiagnosticAlarmType_ShelvingState_LastTransition_Name
    \value SystemDiagnosticAlarmType_ShelvingState_LastTransition_Number
    \value SystemDiagnosticAlarmType_ShelvingState_LastTransition_TransitionTime
    \value SystemDiagnosticAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value SystemDiagnosticAlarmType_ShelvingState_AvailableStates
    \value SystemDiagnosticAlarmType_ShelvingState_AvailableTransitions
    \value SystemDiagnosticAlarmType_ShelvingState_UnshelveTime
    \value SystemDiagnosticAlarmType_ShelvingState_TimedShelve
    \value SystemDiagnosticAlarmType_ShelvingState_TimedShelve_InputArguments
    \value SystemDiagnosticAlarmType_ShelvingState_Unshelve
    \value SystemDiagnosticAlarmType_ShelvingState_OneShotShelve
    \value SystemDiagnosticAlarmType_SuppressedOrShelved
    \value SystemDiagnosticAlarmType_MaxTimeShelved
    \value SystemDiagnosticAlarmType_AudibleEnabled
    \value SystemDiagnosticAlarmType_AudibleSound
    \value SystemDiagnosticAlarmType_AudibleSound_ListId
    \value SystemDiagnosticAlarmType_AudibleSound_AgencyId
    \value SystemDiagnosticAlarmType_AudibleSound_VersionId
    \value SystemDiagnosticAlarmType_SilenceState
    \value SystemDiagnosticAlarmType_SilenceState_Id
    \value SystemDiagnosticAlarmType_SilenceState_Name
    \value SystemDiagnosticAlarmType_SilenceState_Number
    \value SystemDiagnosticAlarmType_SilenceState_EffectiveDisplayName
    \value SystemDiagnosticAlarmType_SilenceState_TransitionTime
    \value SystemDiagnosticAlarmType_SilenceState_EffectiveTransitionTime
    \value SystemDiagnosticAlarmType_SilenceState_TrueState
    \value SystemDiagnosticAlarmType_SilenceState_FalseState
    \value SystemDiagnosticAlarmType_OnDelay
    \value SystemDiagnosticAlarmType_OffDelay
    \value SystemDiagnosticAlarmType_FirstInGroupFlag
    \value SystemDiagnosticAlarmType_FirstInGroup
    \value SystemDiagnosticAlarmType_LatchedState
    \value SystemDiagnosticAlarmType_LatchedState_Id
    \value SystemDiagnosticAlarmType_LatchedState_Name
    \value SystemDiagnosticAlarmType_LatchedState_Number
    \value SystemDiagnosticAlarmType_LatchedState_EffectiveDisplayName
    \value SystemDiagnosticAlarmType_LatchedState_TransitionTime
    \value SystemDiagnosticAlarmType_LatchedState_EffectiveTransitionTime
    \value SystemDiagnosticAlarmType_LatchedState_TrueState
    \value SystemDiagnosticAlarmType_LatchedState_FalseState
    \value SystemDiagnosticAlarmType_AlarmGroup_Placeholder
    \value SystemDiagnosticAlarmType_ReAlarmTime
    \value SystemDiagnosticAlarmType_ReAlarmRepeatCount
    \value SystemDiagnosticAlarmType_Silence
    \value SystemDiagnosticAlarmType_Suppress
    \value SystemDiagnosticAlarmType_Unsuppress
    \value SystemDiagnosticAlarmType_RemoveFromService
    \value SystemDiagnosticAlarmType_PlaceInService
    \value SystemDiagnosticAlarmType_Reset
    \value SystemDiagnosticAlarmType_NormalState
    \value CertificateExpirationAlarmType_LatchedState
    \value CertificateExpirationAlarmType_LatchedState_Id
    \value CertificateExpirationAlarmType_LatchedState_Name
    \value CertificateExpirationAlarmType_LatchedState_Number
    \value CertificateExpirationAlarmType_LatchedState_EffectiveDisplayName
    \value CertificateExpirationAlarmType_LatchedState_TransitionTime
    \value CertificateExpirationAlarmType_LatchedState_EffectiveTransitionTime
    \value CertificateExpirationAlarmType_LatchedState_TrueState
    \value CertificateExpirationAlarmType_LatchedState_FalseState
    \value CertificateExpirationAlarmType_Reset
    \value DiscrepancyAlarmType_LatchedState
    \value DiscrepancyAlarmType_LatchedState_Id
    \value DiscrepancyAlarmType_LatchedState_Name
    \value DiscrepancyAlarmType_LatchedState_Number
    \value DiscrepancyAlarmType_LatchedState_EffectiveDisplayName
    \value DiscrepancyAlarmType_LatchedState_TransitionTime
    \value DiscrepancyAlarmType_LatchedState_EffectiveTransitionTime
    \value DiscrepancyAlarmType_LatchedState_TrueState
    \value DiscrepancyAlarmType_LatchedState_FalseState
    \value DiscrepancyAlarmType_Reset
    \value StatisticalConditionClassType
    \value AlarmMetricsType_Reset
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_DiagnosticsLevel
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Active
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_Classification
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Active
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_Classification
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_TotalError_TimeFirstChange
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_SubError
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Active
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_Classification
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress
    \value PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics
    \value PublishSubscribeType_Diagnostics_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics_TotalInformation
    \value PublishSubscribeType_Diagnostics_TotalInformation_Active
    \value PublishSubscribeType_Diagnostics_TotalInformation_Classification
    \value PublishSubscribeType_Diagnostics_TotalInformation_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics_TotalInformation_TimeFirstChange
    \value PublishSubscribeType_Diagnostics_TotalError
    \value PublishSubscribeType_Diagnostics_TotalError_Active
    \value PublishSubscribeType_Diagnostics_TotalError_Classification
    \value PublishSubscribeType_Diagnostics_TotalError_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics_TotalError_TimeFirstChange
    \value PublishSubscribeType_Diagnostics_Reset
    \value PublishSubscribeType_Diagnostics_SubError
    \value PublishSubscribeType_Diagnostics_Counters
    \value PublishSubscribeType_Diagnostics_Counters_StateError
    \value PublishSubscribeType_Diagnostics_Counters_StateError_Active
    \value PublishSubscribeType_Diagnostics_Counters_StateError_Classification
    \value PublishSubscribeType_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics_Counters_StateError_TimeFirstChange
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Active
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Active
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_Classification
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Active
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_Classification
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value PublishSubscribeType_Diagnostics_Counters_StatePausedByParent
    \value PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Active
    \value PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_Classification
    \value PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod
    \value PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Active
    \value PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value PublishSubscribeType_Diagnostics_LiveValues
    \value PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters
    \value PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders
    \value PublishSubscribeType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters
    \value PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel
    \value PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders
    \value PublishSubscribeType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel
    \value ThreeDVectorType_X
    \value ThreeDVectorType_Y
    \value ThreeDVectorType_Z
    \value CartesianCoordinatesType
    \value CartesianCoordinatesType_LengthUnit
    \value ThreeDCartesianCoordinatesType
    \value ThreeDCartesianCoordinatesType_LengthUnit
    \value ThreeDCartesianCoordinatesType_X
    \value ThreeDCartesianCoordinatesType_Y
    \value ThreeDCartesianCoordinatesType_Z
    \value OrientationType
    \value OrientationType_AngleUnit
    \value ThreeDOrientationType
    \value ThreeDOrientationType_AngleUnit
    \value ThreeDOrientationType_A
    \value ThreeDOrientationType_B
    \value ThreeDOrientationType_C
    \value FrameType
    \value FrameType_Orientation
    \value FrameType_Constant
    \value FrameType_BaseFrame
    \value FrameType_FixedBase
    \value ThreeDFrameType
    \value ThreeDFrameType_Orientation
    \value ThreeDFrameType_Constant
    \value ThreeDFrameType_BaseFrame
    \value ThreeDFrameType_FixedBase
    \value ThreeDFrameType_CartesianCoordinates
    \value ThreeDFrameType_CartesianCoordinates_LengthUnit
    \value ThreeDFrameType_CartesianCoordinates_X
    \value ThreeDFrameType_CartesianCoordinates_Y
    \value ThreeDFrameType_CartesianCoordinates_Z
    \value FrameType_CartesianCoordinates
    \value FrameType_CartesianCoordinates_LengthUnit
    \value FrameType_Orientation_AngleUnit
    \value HasWriterGroup
    \value HasReaderGroup
    \value RationalNumber
    \value Vector
    \value ThreeDVector
    \value CartesianCoordinates
    \value ThreeDCartesianCoordinates
    \value Orientation
    \value ThreeDOrientation
    \value Frame
    \value ThreeDFrame
    \value RationalNumber_Encoding_DefaultBinary
    \value Vector_Encoding_DefaultBinary
    \value ThreeDVector_Encoding_DefaultBinary
    \value CartesianCoordinates_Encoding_DefaultBinary
    \value ThreeDCartesianCoordinates_Encoding_DefaultBinary
    \value Orientation_Encoding_DefaultBinary
    \value ThreeDOrientation_Encoding_DefaultBinary
    \value Frame_Encoding_DefaultBinary
    \value ThreeDFrame_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_RationalNumber
    \value OpcUa_BinarySchema_RationalNumber_DataTypeVersion
    \value OpcUa_BinarySchema_RationalNumber_DictionaryFragment
    \value OpcUa_BinarySchema_Vector
    \value OpcUa_BinarySchema_Vector_DataTypeVersion
    \value OpcUa_BinarySchema_Vector_DictionaryFragment
    \value OpcUa_BinarySchema_ThreeDVector
    \value OpcUa_BinarySchema_ThreeDVector_DataTypeVersion
    \value OpcUa_BinarySchema_ThreeDVector_DictionaryFragment
    \value OpcUa_BinarySchema_CartesianCoordinates
    \value OpcUa_BinarySchema_CartesianCoordinates_DataTypeVersion
    \value OpcUa_BinarySchema_CartesianCoordinates_DictionaryFragment
    \value OpcUa_BinarySchema_ThreeDCartesianCoordinates
    \value OpcUa_BinarySchema_ThreeDCartesianCoordinates_DataTypeVersion
    \value OpcUa_BinarySchema_ThreeDCartesianCoordinates_DictionaryFragment
    \value OpcUa_BinarySchema_Orientation
    \value OpcUa_BinarySchema_Orientation_DataTypeVersion
    \value OpcUa_BinarySchema_Orientation_DictionaryFragment
    \value OpcUa_BinarySchema_ThreeDOrientation
    \value OpcUa_BinarySchema_ThreeDOrientation_DataTypeVersion
    \value OpcUa_BinarySchema_ThreeDOrientation_DictionaryFragment
    \value OpcUa_BinarySchema_Frame
    \value OpcUa_BinarySchema_Frame_DataTypeVersion
    \value OpcUa_BinarySchema_Frame_DictionaryFragment
    \value OpcUa_BinarySchema_ThreeDFrame
    \value OpcUa_BinarySchema_ThreeDFrame_DataTypeVersion
    \value OpcUa_BinarySchema_ThreeDFrame_DictionaryFragment
    \value RationalNumber_Encoding_DefaultXml
    \value Vector_Encoding_DefaultXml
    \value ThreeDVector_Encoding_DefaultXml
    \value CartesianCoordinates_Encoding_DefaultXml
    \value ThreeDCartesianCoordinates_Encoding_DefaultXml
    \value Orientation_Encoding_DefaultXml
    \value ThreeDOrientation_Encoding_DefaultXml
    \value Frame_Encoding_DefaultXml
    \value ThreeDFrame_Encoding_DefaultXml
    \value OpcUa_XmlSchema_RationalNumber
    \value OpcUa_XmlSchema_RationalNumber_DataTypeVersion
    \value OpcUa_XmlSchema_RationalNumber_DictionaryFragment
    \value OpcUa_XmlSchema_Vector
    \value OpcUa_XmlSchema_Vector_DataTypeVersion
    \value OpcUa_XmlSchema_Vector_DictionaryFragment
    \value OpcUa_XmlSchema_ThreeDVector
    \value OpcUa_XmlSchema_ThreeDVector_DataTypeVersion
    \value OpcUa_XmlSchema_ThreeDVector_DictionaryFragment
    \value OpcUa_XmlSchema_CartesianCoordinates
    \value OpcUa_XmlSchema_CartesianCoordinates_DataTypeVersion
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_SubError
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion
    \value PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Reset
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_SubError
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion
    \value PublishedDataItemsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Active
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_Classification
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Active
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_Classification
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_TotalError_TimeFirstChange
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Reset
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_SubError
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Active
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_Classification
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Active
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_Classification
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion
    \value PublishedEventsType_DataSetWriterName_Placeholder_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel
    \value OpcUa_XmlSchema_CartesianCoordinates_DictionaryFragment
    \value OpcUa_XmlSchema_ThreeDCartesianCoordinates
    \value OpcUa_XmlSchema_ThreeDCartesianCoordinates_DataTypeVersion
    \value OpcUa_XmlSchema_ThreeDCartesianCoordinates_DictionaryFragment
    \value OpcUa_XmlSchema_Orientation
    \value OpcUa_XmlSchema_Orientation_DataTypeVersion
    \value OpcUa_XmlSchema_Orientation_DictionaryFragment
    \value OpcUa_XmlSchema_ThreeDOrientation
    \value OpcUa_XmlSchema_ThreeDOrientation_DataTypeVersion
    \value OpcUa_XmlSchema_ThreeDOrientation_DictionaryFragment
    \value OpcUa_XmlSchema_Frame
    \value OpcUa_XmlSchema_Frame_DataTypeVersion
    \value OpcUa_XmlSchema_Frame_DictionaryFragment
    \value OpcUa_XmlSchema_ThreeDFrame
    \value OpcUa_XmlSchema_ThreeDFrame_DataTypeVersion
    \value OpcUa_XmlSchema_ThreeDFrame_DictionaryFragment
    \value RationalNumber_Encoding_DefaultJson
    \value Vector_Encoding_DefaultJson
    \value ThreeDVector_Encoding_DefaultJson
    \value CartesianCoordinates_Encoding_DefaultJson
    \value ThreeDCartesianCoordinates_Encoding_DefaultJson
    \value Orientation_Encoding_DefaultJson
    \value ThreeDOrientation_Encoding_DefaultJson
    \value Frame_Encoding_DefaultJson
    \value ThreeDFrame_Encoding_DefaultJson
    \value ThreeDFrameType_Orientation_AngleUnit
    \value ThreeDFrameType_Orientation_A
    \value ThreeDFrameType_Orientation_B
    \value ThreeDFrameType_Orientation_C
    \value MultiStateDictionaryEntryDiscreteBaseType
    \value MultiStateDictionaryEntryDiscreteBaseType_Definition
    \value MultiStateDictionaryEntryDiscreteBaseType_ValuePrecision
    \value MultiStateDictionaryEntryDiscreteBaseType_EnumValues
    \value MultiStateDictionaryEntryDiscreteBaseType_ValueAsText
    \value MultiStateDictionaryEntryDiscreteBaseType_EnumDictionaryEntries
    \value MultiStateDictionaryEntryDiscreteBaseType_ValueAsDictionaryEntries
    \value MultiStateDictionaryEntryDiscreteType
    \value MultiStateDictionaryEntryDiscreteType_Definition
    \value MultiStateDictionaryEntryDiscreteType_ValuePrecision
    \value MultiStateDictionaryEntryDiscreteType_EnumValues
    \value MultiStateDictionaryEntryDiscreteType_ValueAsText
    \value MultiStateDictionaryEntryDiscreteType_EnumDictionaryEntries
    \value MultiStateDictionaryEntryDiscreteType_ValueAsDictionaryEntries
    \value HistoryServerCapabilities_ServerTimestampSupported
    \value HistoricalDataConfigurationType_ServerTimestampSupported
    \value HAConfiguration_ServerTimestampSupported
    \value HistoryServerCapabilitiesType_ServerTimestampSupported
    \value AuditHistoryAnnotationUpdateEventType
    \value AuditHistoryAnnotationUpdateEventType_EventId
    \value AuditHistoryAnnotationUpdateEventType_EventType
    \value AuditHistoryAnnotationUpdateEventType_SourceNode
    \value AuditHistoryAnnotationUpdateEventType_SourceName
    \value AuditHistoryAnnotationUpdateEventType_Time
    \value AuditHistoryAnnotationUpdateEventType_ReceiveTime
    \value AuditHistoryAnnotationUpdateEventType_LocalTime
    \value AuditHistoryAnnotationUpdateEventType_Message
    \value AuditHistoryAnnotationUpdateEventType_Severity
    \value AuditHistoryAnnotationUpdateEventType_ActionTimeStamp
    \value AuditHistoryAnnotationUpdateEventType_Status
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Active
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_Classification
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Active
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_Classification
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_SubError
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Active
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_Classification
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Active
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_Classification
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_SentNetworkMessages_TimeFirstChange
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Active
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_Classification
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_FailedTransmissions_TimeFirstChange
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Active
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_Classification
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters_EncryptionErrors_TimeFirstChange
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetWriters_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID
    \value PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Active
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_Classification
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalInformation_TimeFirstChange
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Active
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_Classification
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_TotalError_TimeFirstChange
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_SubError
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Active
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_Classification
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateError_TimeFirstChange
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Active
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Active
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_Classification
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Active
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_Classification
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Active
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_Classification
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Active
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Active
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_Classification
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Active
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_Classification
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters_DecryptionErrors_TimeFirstChange
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders
    \value PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel
    \value PubSubConnectionType_Diagnostics
    \value PubSubConnectionType_Diagnostics_DiagnosticsLevel
    \value PubSubConnectionType_Diagnostics_TotalInformation
    \value PubSubConnectionType_Diagnostics_TotalInformation_Active
    \value PubSubConnectionType_Diagnostics_TotalInformation_Classification
    \value PubSubConnectionType_Diagnostics_TotalInformation_DiagnosticsLevel
    \value PubSubConnectionType_Diagnostics_TotalInformation_TimeFirstChange
    \value PubSubConnectionType_Diagnostics_TotalError
    \value PubSubConnectionType_Diagnostics_TotalError_Active
    \value PubSubConnectionType_Diagnostics_TotalError_Classification
    \value PubSubConnectionType_Diagnostics_TotalError_DiagnosticsLevel
    \value PubSubConnectionType_Diagnostics_TotalError_TimeFirstChange
    \value PubSubConnectionType_Diagnostics_Reset
    \value PubSubConnectionType_Diagnostics_SubError
    \value PubSubConnectionType_Diagnostics_Counters
    \value PubSubConnectionType_Diagnostics_Counters_StateError
    \value PubSubConnectionType_Diagnostics_Counters_StateError_Active
    \value PubSubConnectionType_Diagnostics_Counters_StateError_Classification
    \value PubSubConnectionType_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value PubSubConnectionType_Diagnostics_Counters_StateError_TimeFirstChange
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Active
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Active
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_Classification
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Active
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_Classification
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PubSubConnectionType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value PubSubConnectionType_Diagnostics_Counters_StatePausedByParent
    \value PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Active
    \value PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_Classification
    \value PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value PubSubConnectionType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod
    \value PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Active
    \value PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PubSubConnectionType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value PubSubConnectionType_Diagnostics_LiveValues
    \value PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress
    \value PubSubConnectionType_Diagnostics_LiveValues_ResolvedAddress_DiagnosticsLevel
    \value AuditHistoryAnnotationUpdateEventType_ServerId
    \value AuditHistoryAnnotationUpdateEventType_ClientAuditEntryId
    \value AuditHistoryAnnotationUpdateEventType_ClientUserId
    \value AuditHistoryAnnotationUpdateEventType_ParameterDataTypeId
    \value AuditHistoryAnnotationUpdateEventType_PerformInsertReplace
    \value AuditHistoryAnnotationUpdateEventType_NewValues
    \value AuditHistoryAnnotationUpdateEventType_OldValues
    \value TrustListType_UpdateFrequency
    \value TrustListOutOfDateAlarmType
    \value TrustListOutOfDateAlarmType_EventId
    \value TrustListOutOfDateAlarmType_EventType
    \value TrustListOutOfDateAlarmType_SourceNode
    \value TrustListOutOfDateAlarmType_SourceName
    \value TrustListOutOfDateAlarmType_Time
    \value TrustListOutOfDateAlarmType_ReceiveTime
    \value TrustListOutOfDateAlarmType_LocalTime
    \value TrustListOutOfDateAlarmType_Message
    \value TrustListOutOfDateAlarmType_Severity
    \value TrustListOutOfDateAlarmType_ConditionClassId
    \value TrustListOutOfDateAlarmType_ConditionClassName
    \value TrustListOutOfDateAlarmType_ConditionSubClassId
    \value TrustListOutOfDateAlarmType_ConditionSubClassName
    \value TrustListOutOfDateAlarmType_ConditionName
    \value TrustListOutOfDateAlarmType_BranchId
    \value TrustListOutOfDateAlarmType_Retain
    \value TrustListOutOfDateAlarmType_EnabledState
    \value TrustListOutOfDateAlarmType_EnabledState_Id
    \value TrustListOutOfDateAlarmType_EnabledState_Name
    \value TrustListOutOfDateAlarmType_EnabledState_Number
    \value TrustListOutOfDateAlarmType_EnabledState_EffectiveDisplayName
    \value TrustListOutOfDateAlarmType_EnabledState_TransitionTime
    \value TrustListOutOfDateAlarmType_EnabledState_EffectiveTransitionTime
    \value TrustListOutOfDateAlarmType_EnabledState_TrueState
    \value TrustListOutOfDateAlarmType_EnabledState_FalseState
    \value TrustListOutOfDateAlarmType_Quality
    \value TrustListOutOfDateAlarmType_Quality_SourceTimestamp
    \value TrustListOutOfDateAlarmType_LastSeverity
    \value TrustListOutOfDateAlarmType_LastSeverity_SourceTimestamp
    \value TrustListOutOfDateAlarmType_Comment
    \value TrustListOutOfDateAlarmType_Comment_SourceTimestamp
    \value TrustListOutOfDateAlarmType_ClientUserId
    \value TrustListOutOfDateAlarmType_Disable
    \value TrustListOutOfDateAlarmType_Enable
    \value TrustListOutOfDateAlarmType_AddComment
    \value TrustListOutOfDateAlarmType_AddComment_InputArguments
    \value TrustListOutOfDateAlarmType_ConditionRefresh
    \value TrustListOutOfDateAlarmType_ConditionRefresh_InputArguments
    \value TrustListOutOfDateAlarmType_ConditionRefresh2
    \value TrustListOutOfDateAlarmType_ConditionRefresh2_InputArguments
    \value TrustListOutOfDateAlarmType_AckedState
    \value TrustListOutOfDateAlarmType_AckedState_Id
    \value TrustListOutOfDateAlarmType_AckedState_Name
    \value TrustListOutOfDateAlarmType_AckedState_Number
    \value TrustListOutOfDateAlarmType_AckedState_EffectiveDisplayName
    \value TrustListOutOfDateAlarmType_AckedState_TransitionTime
    \value TrustListOutOfDateAlarmType_AckedState_EffectiveTransitionTime
    \value TrustListOutOfDateAlarmType_AckedState_TrueState
    \value TrustListOutOfDateAlarmType_AckedState_FalseState
    \value TrustListOutOfDateAlarmType_ConfirmedState
    \value TrustListOutOfDateAlarmType_ConfirmedState_Id
    \value TrustListOutOfDateAlarmType_ConfirmedState_Name
    \value TrustListOutOfDateAlarmType_ConfirmedState_Number
    \value TrustListOutOfDateAlarmType_ConfirmedState_EffectiveDisplayName
    \value TrustListOutOfDateAlarmType_ConfirmedState_TransitionTime
    \value TrustListOutOfDateAlarmType_ConfirmedState_EffectiveTransitionTime
    \value TrustListOutOfDateAlarmType_ConfirmedState_TrueState
    \value TrustListOutOfDateAlarmType_ConfirmedState_FalseState
    \value TrustListOutOfDateAlarmType_Acknowledge
    \value TrustListOutOfDateAlarmType_Acknowledge_InputArguments
    \value TrustListOutOfDateAlarmType_Confirm
    \value TrustListOutOfDateAlarmType_Confirm_InputArguments
    \value TrustListOutOfDateAlarmType_ActiveState
    \value TrustListOutOfDateAlarmType_ActiveState_Id
    \value TrustListOutOfDateAlarmType_ActiveState_Name
    \value TrustListOutOfDateAlarmType_ActiveState_Number
    \value TrustListOutOfDateAlarmType_ActiveState_EffectiveDisplayName
    \value TrustListOutOfDateAlarmType_ActiveState_TransitionTime
    \value TrustListOutOfDateAlarmType_ActiveState_EffectiveTransitionTime
    \value TrustListOutOfDateAlarmType_ActiveState_TrueState
    \value TrustListOutOfDateAlarmType_ActiveState_FalseState
    \value TrustListOutOfDateAlarmType_InputNode
    \value TrustListOutOfDateAlarmType_SuppressedState
    \value TrustListOutOfDateAlarmType_SuppressedState_Id
    \value TrustListOutOfDateAlarmType_SuppressedState_Name
    \value TrustListOutOfDateAlarmType_SuppressedState_Number
    \value TrustListOutOfDateAlarmType_SuppressedState_EffectiveDisplayName
    \value TrustListOutOfDateAlarmType_SuppressedState_TransitionTime
    \value TrustListOutOfDateAlarmType_SuppressedState_EffectiveTransitionTime
    \value TrustListOutOfDateAlarmType_SuppressedState_TrueState
    \value TrustListOutOfDateAlarmType_SuppressedState_FalseState
    \value TrustListOutOfDateAlarmType_OutOfServiceState
    \value TrustListOutOfDateAlarmType_OutOfServiceState_Id
    \value TrustListOutOfDateAlarmType_OutOfServiceState_Name
    \value TrustListOutOfDateAlarmType_OutOfServiceState_Number
    \value TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveDisplayName
    \value TrustListOutOfDateAlarmType_OutOfServiceState_TransitionTime
    \value TrustListOutOfDateAlarmType_OutOfServiceState_EffectiveTransitionTime
    \value TrustListOutOfDateAlarmType_OutOfServiceState_TrueState
    \value TrustListOutOfDateAlarmType_OutOfServiceState_FalseState
    \value TrustListOutOfDateAlarmType_ShelvingState
    \value TrustListOutOfDateAlarmType_ShelvingState_CurrentState
    \value TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Id
    \value TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Name
    \value TrustListOutOfDateAlarmType_ShelvingState_CurrentState_Number
    \value TrustListOutOfDateAlarmType_ShelvingState_CurrentState_EffectiveDisplayName
    \value TrustListOutOfDateAlarmType_ShelvingState_LastTransition
    \value TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Id
    \value TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Name
    \value TrustListOutOfDateAlarmType_ShelvingState_LastTransition_Number
    \value TrustListOutOfDateAlarmType_ShelvingState_LastTransition_TransitionTime
    \value TrustListOutOfDateAlarmType_ShelvingState_LastTransition_EffectiveTransitionTime
    \value TrustListOutOfDateAlarmType_ShelvingState_AvailableStates
    \value TrustListOutOfDateAlarmType_ShelvingState_AvailableTransitions
    \value TrustListOutOfDateAlarmType_ShelvingState_UnshelveTime
    \value TrustListOutOfDateAlarmType_ShelvingState_TimedShelve
    \value TrustListOutOfDateAlarmType_ShelvingState_TimedShelve_InputArguments
    \value TrustListOutOfDateAlarmType_ShelvingState_Unshelve
    \value TrustListOutOfDateAlarmType_ShelvingState_OneShotShelve
    \value TrustListOutOfDateAlarmType_SuppressedOrShelved
    \value TrustListOutOfDateAlarmType_MaxTimeShelved
    \value TrustListOutOfDateAlarmType_AudibleEnabled
    \value TrustListOutOfDateAlarmType_AudibleSound
    \value TrustListOutOfDateAlarmType_AudibleSound_ListId
    \value TrustListOutOfDateAlarmType_AudibleSound_AgencyId
    \value TrustListOutOfDateAlarmType_AudibleSound_VersionId
    \value TrustListOutOfDateAlarmType_SilenceState
    \value TrustListOutOfDateAlarmType_SilenceState_Id
    \value TrustListOutOfDateAlarmType_SilenceState_Name
    \value TrustListOutOfDateAlarmType_SilenceState_Number
    \value TrustListOutOfDateAlarmType_SilenceState_EffectiveDisplayName
    \value TrustListOutOfDateAlarmType_SilenceState_TransitionTime
    \value TrustListOutOfDateAlarmType_SilenceState_EffectiveTransitionTime
    \value TrustListOutOfDateAlarmType_SilenceState_TrueState
    \value TrustListOutOfDateAlarmType_SilenceState_FalseState
    \value TrustListOutOfDateAlarmType_OnDelay
    \value TrustListOutOfDateAlarmType_OffDelay
    \value TrustListOutOfDateAlarmType_FirstInGroupFlag
    \value TrustListOutOfDateAlarmType_FirstInGroup
    \value TrustListOutOfDateAlarmType_LatchedState
    \value TrustListOutOfDateAlarmType_LatchedState_Id
    \value TrustListOutOfDateAlarmType_LatchedState_Name
    \value TrustListOutOfDateAlarmType_LatchedState_Number
    \value TrustListOutOfDateAlarmType_LatchedState_EffectiveDisplayName
    \value TrustListOutOfDateAlarmType_LatchedState_TransitionTime
    \value TrustListOutOfDateAlarmType_LatchedState_EffectiveTransitionTime
    \value TrustListOutOfDateAlarmType_LatchedState_TrueState
    \value TrustListOutOfDateAlarmType_LatchedState_FalseState
    \value TrustListOutOfDateAlarmType_AlarmGroup_Placeholder
    \value TrustListOutOfDateAlarmType_ReAlarmTime
    \value TrustListOutOfDateAlarmType_ReAlarmRepeatCount
    \value TrustListOutOfDateAlarmType_Silence
    \value TrustListOutOfDateAlarmType_Suppress
    \value TrustListOutOfDateAlarmType_Unsuppress
    \value TrustListOutOfDateAlarmType_RemoveFromService
    \value TrustListOutOfDateAlarmType_PlaceInService
    \value TrustListOutOfDateAlarmType_Reset
    \value TrustListOutOfDateAlarmType_NormalState
    \value TrustListOutOfDateAlarmType_TrustListId
    \value TrustListOutOfDateAlarmType_LastUpdateTime
    \value TrustListOutOfDateAlarmType_UpdateFrequency
    \value CertificateGroupType_TrustList_UpdateFrequency
    \value CertificateGroupType_CertificateExpired
    \value CertificateGroupType_CertificateExpired_EventId
    \value CertificateGroupType_CertificateExpired_EventType
    \value CertificateGroupType_CertificateExpired_SourceNode
    \value CertificateGroupType_CertificateExpired_SourceName
    \value CertificateGroupType_CertificateExpired_Time
    \value CertificateGroupType_CertificateExpired_ReceiveTime
    \value CertificateGroupType_CertificateExpired_LocalTime
    \value CertificateGroupType_CertificateExpired_Message
    \value CertificateGroupType_CertificateExpired_Severity
    \value CertificateGroupType_CertificateExpired_ConditionClassId
    \value CertificateGroupType_CertificateExpired_ConditionClassName
    \value CertificateGroupType_CertificateExpired_ConditionSubClassId
    \value CertificateGroupType_CertificateExpired_ConditionSubClassName
    \value CertificateGroupType_CertificateExpired_ConditionName
    \value CertificateGroupType_CertificateExpired_BranchId
    \value CertificateGroupType_CertificateExpired_Retain
    \value CertificateGroupType_CertificateExpired_EnabledState
    \value CertificateGroupType_CertificateExpired_EnabledState_Id
    \value CertificateGroupType_CertificateExpired_EnabledState_Name
    \value CertificateGroupType_CertificateExpired_EnabledState_Number
    \value CertificateGroupType_CertificateExpired_EnabledState_EffectiveDisplayName
    \value CertificateGroupType_CertificateExpired_EnabledState_TransitionTime
    \value CertificateGroupType_CertificateExpired_EnabledState_EffectiveTransitionTime
    \value CertificateGroupType_CertificateExpired_EnabledState_TrueState
    \value CertificateGroupType_CertificateExpired_EnabledState_FalseState
    \value CertificateGroupType_CertificateExpired_Quality
    \value CertificateGroupType_CertificateExpired_Quality_SourceTimestamp
    \value CertificateGroupType_CertificateExpired_LastSeverity
    \value CertificateGroupType_CertificateExpired_LastSeverity_SourceTimestamp
    \value CertificateGroupType_CertificateExpired_Comment
    \value CertificateGroupType_CertificateExpired_Comment_SourceTimestamp
    \value CertificateGroupType_CertificateExpired_ClientUserId
    \value CertificateGroupType_CertificateExpired_Disable
    \value CertificateGroupType_CertificateExpired_Enable
    \value CertificateGroupType_CertificateExpired_AddComment
    \value CertificateGroupType_CertificateExpired_AddComment_InputArguments
    \value CertificateGroupType_CertificateExpired_AckedState
    \value CertificateGroupType_CertificateExpired_AckedState_Id
    \value CertificateGroupType_CertificateExpired_AckedState_Name
    \value CertificateGroupType_CertificateExpired_AckedState_Number
    \value CertificateGroupType_CertificateExpired_AckedState_EffectiveDisplayName
    \value CertificateGroupType_CertificateExpired_AckedState_TransitionTime
    \value CertificateGroupType_CertificateExpired_AckedState_EffectiveTransitionTime
    \value CertificateGroupType_CertificateExpired_AckedState_TrueState
    \value CertificateGroupType_CertificateExpired_AckedState_FalseState
    \value CertificateGroupType_CertificateExpired_ConfirmedState
    \value CertificateGroupType_CertificateExpired_ConfirmedState_Id
    \value CertificateGroupType_CertificateExpired_ConfirmedState_Name
    \value CertificateGroupType_CertificateExpired_ConfirmedState_Number
    \value CertificateGroupType_CertificateExpired_ConfirmedState_EffectiveDisplayName
    \value CertificateGroupType_CertificateExpired_ConfirmedState_TransitionTime
    \value CertificateGroupType_CertificateExpired_ConfirmedState_EffectiveTransitionTime
    \value CertificateGroupType_CertificateExpired_ConfirmedState_TrueState
    \value CertificateGroupType_CertificateExpired_ConfirmedState_FalseState
    \value CertificateGroupType_CertificateExpired_Acknowledge
    \value CertificateGroupType_CertificateExpired_Acknowledge_InputArguments
    \value CertificateGroupType_CertificateExpired_Confirm
    \value CertificateGroupType_CertificateExpired_Confirm_InputArguments
    \value CertificateGroupType_CertificateExpired_ActiveState
    \value CertificateGroupType_CertificateExpired_ActiveState_Id
    \value CertificateGroupType_CertificateExpired_ActiveState_Name
    \value CertificateGroupType_CertificateExpired_ActiveState_Number
    \value CertificateGroupType_CertificateExpired_ActiveState_EffectiveDisplayName
    \value CertificateGroupType_CertificateExpired_ActiveState_TransitionTime
    \value CertificateGroupType_CertificateExpired_ActiveState_EffectiveTransitionTime
    \value CertificateGroupType_CertificateExpired_ActiveState_TrueState
    \value CertificateGroupType_CertificateExpired_ActiveState_FalseState
    \value CertificateGroupType_CertificateExpired_InputNode
    \value CertificateGroupType_CertificateExpired_SuppressedState
    \value CertificateGroupType_CertificateExpired_SuppressedState_Id
    \value CertificateGroupType_CertificateExpired_SuppressedState_Name
    \value CertificateGroupType_CertificateExpired_SuppressedState_Number
    \value CertificateGroupType_CertificateExpired_SuppressedState_EffectiveDisplayName
    \value CertificateGroupType_CertificateExpired_SuppressedState_TransitionTime
    \value CertificateGroupType_CertificateExpired_SuppressedState_EffectiveTransitionTime
    \value CertificateGroupType_CertificateExpired_SuppressedState_TrueState
    \value CertificateGroupType_CertificateExpired_SuppressedState_FalseState
    \value CertificateGroupType_CertificateExpired_OutOfServiceState
    \value CertificateGroupType_CertificateExpired_OutOfServiceState_Id
    \value CertificateGroupType_CertificateExpired_OutOfServiceState_Name
    \value CertificateGroupType_CertificateExpired_OutOfServiceState_Number
    \value CertificateGroupType_CertificateExpired_OutOfServiceState_EffectiveDisplayName
    \value CertificateGroupType_CertificateExpired_OutOfServiceState_TransitionTime
    \value CertificateGroupType_CertificateExpired_OutOfServiceState_EffectiveTransitionTime
    \value CertificateGroupType_CertificateExpired_OutOfServiceState_TrueState
    \value CertificateGroupType_CertificateExpired_OutOfServiceState_FalseState
    \value CertificateGroupType_CertificateExpired_ShelvingState
    \value CertificateGroupType_CertificateExpired_ShelvingState_CurrentState
    \value CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Id
    \value CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Name
    \value CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_Number
    \value CertificateGroupType_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName
    \value CertificateGroupType_CertificateExpired_ShelvingState_LastTransition
    \value CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Id
    \value CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Name
    \value CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_Number
    \value CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_TransitionTime
    \value CertificateGroupType_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime
    \value CertificateGroupType_CertificateExpired_ShelvingState_AvailableStates
    \value DataSetWriterType_Diagnostics
    \value DataSetWriterType_Diagnostics_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_TotalInformation
    \value DataSetWriterType_Diagnostics_TotalInformation_Active
    \value DataSetWriterType_Diagnostics_TotalInformation_Classification
    \value DataSetWriterType_Diagnostics_TotalInformation_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_TotalInformation_TimeFirstChange
    \value DataSetWriterType_Diagnostics_TotalError
    \value DataSetWriterType_Diagnostics_TotalError_Active
    \value DataSetWriterType_Diagnostics_TotalError_Classification
    \value DataSetWriterType_Diagnostics_TotalError_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_TotalError_TimeFirstChange
    \value DataSetWriterType_Diagnostics_Reset
    \value DataSetWriterType_Diagnostics_SubError
    \value DataSetWriterType_Diagnostics_Counters
    \value DataSetWriterType_Diagnostics_Counters_StateError
    \value DataSetWriterType_Diagnostics_Counters_StateError_Active
    \value DataSetWriterType_Diagnostics_Counters_StateError_Classification
    \value DataSetWriterType_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_Counters_StateError_TimeFirstChange
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod_Active
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalByParent
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalByParent_Active
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalByParent_Classification
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalFromError
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalFromError_Active
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalFromError_Classification
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value DataSetWriterType_Diagnostics_Counters_StatePausedByParent
    \value DataSetWriterType_Diagnostics_Counters_StatePausedByParent_Active
    \value DataSetWriterType_Diagnostics_Counters_StatePausedByParent_Classification
    \value DataSetWriterType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod
    \value DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod_Active
    \value DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value DataSetWriterType_Diagnostics_LiveValues
    \value DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages
    \value DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages_Active
    \value DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages_Classification
    \value DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange
    \value DataSetWriterType_Diagnostics_LiveValues_MessageSequenceNumber
    \value DataSetWriterType_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_LiveValues_StatusCode
    \value DataSetWriterType_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_LiveValues_MajorVersion
    \value DataSetWriterType_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel
    \value DataSetWriterType_Diagnostics_LiveValues_MinorVersion
    \value DataSetWriterType_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics
    \value DataSetReaderType_Diagnostics_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_TotalInformation
    \value DataSetReaderType_Diagnostics_TotalInformation_Active
    \value DataSetReaderType_Diagnostics_TotalInformation_Classification
    \value DataSetReaderType_Diagnostics_TotalInformation_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_TotalInformation_TimeFirstChange
    \value DataSetReaderType_Diagnostics_TotalError
    \value DataSetReaderType_Diagnostics_TotalError_Active
    \value DataSetReaderType_Diagnostics_TotalError_Classification
    \value DataSetReaderType_Diagnostics_TotalError_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_TotalError_TimeFirstChange
    \value DataSetReaderType_Diagnostics_Reset
    \value DataSetReaderType_Diagnostics_SubError
    \value DataSetReaderType_Diagnostics_Counters
    \value DataSetReaderType_Diagnostics_Counters_StateError
    \value DataSetReaderType_Diagnostics_Counters_StateError_Active
    \value DataSetReaderType_Diagnostics_Counters_StateError_Classification
    \value DataSetReaderType_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_Counters_StateError_TimeFirstChange
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod_Active
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalByParent
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalByParent_Active
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalByParent_Classification
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalFromError
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalFromError_Active
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalFromError_Classification
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value DataSetReaderType_Diagnostics_Counters_StatePausedByParent
    \value DataSetReaderType_Diagnostics_Counters_StatePausedByParent_Active
    \value DataSetReaderType_Diagnostics_Counters_StatePausedByParent_Classification
    \value DataSetReaderType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod
    \value DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod_Active
    \value DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value DataSetReaderType_Diagnostics_LiveValues
    \value DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages
    \value DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages_Active
    \value DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages_Classification
    \value DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_Counters_FailedDataSetMessages_TimeFirstChange
    \value DataSetReaderType_Diagnostics_Counters_DecryptionErrors
    \value DataSetReaderType_Diagnostics_Counters_DecryptionErrors_Active
    \value DataSetReaderType_Diagnostics_Counters_DecryptionErrors_Classification
    \value DataSetReaderType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_Counters_DecryptionErrors_TimeFirstChange
    \value DataSetReaderType_Diagnostics_LiveValues_MessageSequenceNumber
    \value DataSetReaderType_Diagnostics_LiveValues_MessageSequenceNumber_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_LiveValues_StatusCode
    \value DataSetReaderType_Diagnostics_LiveValues_StatusCode_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_LiveValues_MajorVersion
    \value DataSetReaderType_Diagnostics_LiveValues_MajorVersion_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_LiveValues_MinorVersion
    \value DataSetReaderType_Diagnostics_LiveValues_MinorVersion_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_LiveValues_SecurityTokenID
    \value DataSetReaderType_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel
    \value DataSetReaderType_Diagnostics_LiveValues_TimeToNextTokenID
    \value DataSetReaderType_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel
    \value PubSubDiagnosticsType
    \value PubSubDiagnosticsType_DiagnosticsLevel
    \value PubSubDiagnosticsType_TotalInformation
    \value PubSubDiagnosticsType_TotalInformation_Active
    \value PubSubDiagnosticsType_TotalInformation_Classification
    \value PubSubDiagnosticsType_TotalInformation_DiagnosticsLevel
    \value PubSubDiagnosticsType_TotalInformation_TimeFirstChange
    \value PubSubDiagnosticsType_TotalError
    \value PubSubDiagnosticsType_TotalError_Active
    \value PubSubDiagnosticsType_TotalError_Classification
    \value PubSubDiagnosticsType_TotalError_DiagnosticsLevel
    \value PubSubDiagnosticsType_TotalError_TimeFirstChange
    \value PubSubDiagnosticsType_Reset
    \value PubSubDiagnosticsType_SubError
    \value PubSubDiagnosticsType_Counters
    \value PubSubDiagnosticsType_Counters_StateError
    \value PubSubDiagnosticsType_Counters_StateError_Active
    \value PubSubDiagnosticsType_Counters_StateError_Classification
    \value PubSubDiagnosticsType_Counters_StateError_DiagnosticsLevel
    \value PubSubDiagnosticsType_Counters_StateError_TimeFirstChange
    \value PubSubDiagnosticsType_Counters_StateOperationalByMethod
    \value PubSubDiagnosticsType_Counters_StateOperationalByMethod_Active
    \value PubSubDiagnosticsType_Counters_StateOperationalByMethod_Classification
    \value PubSubDiagnosticsType_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsType_Counters_StateOperationalByMethod_TimeFirstChange
    \value PubSubDiagnosticsType_Counters_StateOperationalByParent
    \value PubSubDiagnosticsType_Counters_StateOperationalByParent_Active
    \value PubSubDiagnosticsType_Counters_StateOperationalByParent_Classification
    \value PubSubDiagnosticsType_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PubSubDiagnosticsType_Counters_StateOperationalByParent_TimeFirstChange
    \value PubSubDiagnosticsType_Counters_StateOperationalFromError
    \value PubSubDiagnosticsType_Counters_StateOperationalFromError_Active
    \value PubSubDiagnosticsType_Counters_StateOperationalFromError_Classification
    \value PubSubDiagnosticsType_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PubSubDiagnosticsType_Counters_StateOperationalFromError_TimeFirstChange
    \value PubSubDiagnosticsType_Counters_StatePausedByParent
    \value PubSubDiagnosticsType_Counters_StatePausedByParent_Active
    \value PubSubDiagnosticsType_Counters_StatePausedByParent_Classification
    \value PubSubDiagnosticsType_Counters_StatePausedByParent_DiagnosticsLevel
    \value PubSubDiagnosticsType_Counters_StatePausedByParent_TimeFirstChange
    \value PubSubDiagnosticsType_Counters_StateDisabledByMethod
    \value PubSubDiagnosticsType_Counters_StateDisabledByMethod_Active
    \value PubSubDiagnosticsType_Counters_StateDisabledByMethod_Classification
    \value PubSubDiagnosticsType_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsType_Counters_StateDisabledByMethod_TimeFirstChange
    \value PubSubDiagnosticsType_LiveValues
    \value DiagnosticsLevel
    \value DiagnosticsLevel_EnumStrings
    \value PubSubDiagnosticsCounterType
    \value PubSubDiagnosticsCounterType_Active
    \value PubSubDiagnosticsCounterType_Classification
    \value PubSubDiagnosticsCounterType_DiagnosticsLevel
    \value PubSubDiagnosticsCounterType_TimeFirstChange
    \value PubSubDiagnosticsCounterClassification
    \value PubSubDiagnosticsCounterClassification_EnumStrings
    \value PubSubDiagnosticsRootType
    \value PubSubDiagnosticsRootType_DiagnosticsLevel
    \value PubSubDiagnosticsRootType_TotalInformation
    \value PubSubDiagnosticsRootType_TotalInformation_Active
    \value PubSubDiagnosticsRootType_TotalInformation_Classification
    \value PubSubDiagnosticsRootType_TotalInformation_DiagnosticsLevel
    \value PubSubDiagnosticsRootType_TotalInformation_TimeFirstChange
    \value PubSubDiagnosticsRootType_TotalError
    \value PubSubDiagnosticsRootType_TotalError_Active
    \value PubSubDiagnosticsRootType_TotalError_Classification
    \value PubSubDiagnosticsRootType_TotalError_DiagnosticsLevel
    \value PubSubDiagnosticsRootType_TotalError_TimeFirstChange
    \value PubSubDiagnosticsRootType_Reset
    \value PubSubDiagnosticsRootType_SubError
    \value PubSubDiagnosticsRootType_Counters
    \value PubSubDiagnosticsRootType_Counters_StateError
    \value PubSubDiagnosticsRootType_Counters_StateError_Active
    \value PubSubDiagnosticsRootType_Counters_StateError_Classification
    \value PubSubDiagnosticsRootType_Counters_StateError_DiagnosticsLevel
    \value PubSubDiagnosticsRootType_Counters_StateError_TimeFirstChange
    \value PubSubDiagnosticsRootType_Counters_StateOperationalByMethod
    \value PubSubDiagnosticsRootType_Counters_StateOperationalByMethod_Active
    \value PubSubDiagnosticsRootType_Counters_StateOperationalByMethod_Classification
    \value PubSubDiagnosticsRootType_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsRootType_Counters_StateOperationalByMethod_TimeFirstChange
    \value PubSubDiagnosticsRootType_Counters_StateOperationalByParent
    \value PubSubDiagnosticsRootType_Counters_StateOperationalByParent_Active
    \value PubSubDiagnosticsRootType_Counters_StateOperationalByParent_Classification
    \value PubSubDiagnosticsRootType_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PubSubDiagnosticsRootType_Counters_StateOperationalByParent_TimeFirstChange
    \value PubSubDiagnosticsRootType_Counters_StateOperationalFromError
    \value PubSubDiagnosticsRootType_Counters_StateOperationalFromError_Active
    \value PubSubDiagnosticsRootType_Counters_StateOperationalFromError_Classification
    \value PubSubDiagnosticsRootType_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PubSubDiagnosticsRootType_Counters_StateOperationalFromError_TimeFirstChange
    \value PubSubDiagnosticsRootType_Counters_StatePausedByParent
    \value PubSubDiagnosticsRootType_Counters_StatePausedByParent_Active
    \value PubSubDiagnosticsRootType_Counters_StatePausedByParent_Classification
    \value PubSubDiagnosticsRootType_Counters_StatePausedByParent_DiagnosticsLevel
    \value PubSubDiagnosticsRootType_Counters_StatePausedByParent_TimeFirstChange
    \value PubSubDiagnosticsRootType_Counters_StateDisabledByMethod
    \value PubSubDiagnosticsRootType_Counters_StateDisabledByMethod_Active
    \value PubSubDiagnosticsRootType_Counters_StateDisabledByMethod_Classification
    \value PubSubDiagnosticsRootType_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsRootType_Counters_StateDisabledByMethod_TimeFirstChange
    \value PubSubDiagnosticsRootType_LiveValues
    \value PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters
    \value PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel
    \value PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders
    \value PubSubDiagnosticsRootType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel
    \value PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters
    \value PubSubDiagnosticsRootType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel
    \value PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders
    \value PubSubDiagnosticsRootType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel
    \value PubSubDiagnosticsConnectionType
    \value PubSubDiagnosticsConnectionType_DiagnosticsLevel
    \value PubSubDiagnosticsConnectionType_TotalInformation
    \value PubSubDiagnosticsConnectionType_TotalInformation_Active
    \value PubSubDiagnosticsConnectionType_TotalInformation_Classification
    \value PubSubDiagnosticsConnectionType_TotalInformation_DiagnosticsLevel
    \value PubSubDiagnosticsConnectionType_TotalInformation_TimeFirstChange
    \value PubSubDiagnosticsConnectionType_TotalError
    \value PubSubDiagnosticsConnectionType_TotalError_Active
    \value PubSubDiagnosticsConnectionType_TotalError_Classification
    \value PubSubDiagnosticsConnectionType_TotalError_DiagnosticsLevel
    \value PubSubDiagnosticsConnectionType_TotalError_TimeFirstChange
    \value PubSubDiagnosticsConnectionType_Reset
    \value PubSubDiagnosticsConnectionType_SubError
    \value PubSubDiagnosticsConnectionType_Counters
    \value PubSubDiagnosticsConnectionType_Counters_StateError
    \value PubSubDiagnosticsConnectionType_Counters_StateError_Active
    \value PubSubDiagnosticsConnectionType_Counters_StateError_Classification
    \value PubSubDiagnosticsConnectionType_Counters_StateError_DiagnosticsLevel
    \value PubSubDiagnosticsConnectionType_Counters_StateError_TimeFirstChange
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod_Active
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod_Classification
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalByMethod_TimeFirstChange
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent_Active
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent_Classification
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalByParent_TimeFirstChange
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError_Active
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError_Classification
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PubSubDiagnosticsConnectionType_Counters_StateOperationalFromError_TimeFirstChange
    \value PubSubDiagnosticsConnectionType_Counters_StatePausedByParent
    \value PubSubDiagnosticsConnectionType_Counters_StatePausedByParent_Active
    \value PubSubDiagnosticsConnectionType_Counters_StatePausedByParent_Classification
    \value PubSubDiagnosticsConnectionType_Counters_StatePausedByParent_DiagnosticsLevel
    \value PubSubDiagnosticsConnectionType_Counters_StatePausedByParent_TimeFirstChange
    \value PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod
    \value PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod_Active
    \value PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod_Classification
    \value PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsConnectionType_Counters_StateDisabledByMethod_TimeFirstChange
    \value PubSubDiagnosticsConnectionType_LiveValues
    \value PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress
    \value PubSubDiagnosticsConnectionType_LiveValues_ResolvedAddress_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType
    \value PubSubDiagnosticsWriterGroupType_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_TotalInformation
    \value PubSubDiagnosticsWriterGroupType_TotalInformation_Active
    \value PubSubDiagnosticsWriterGroupType_TotalInformation_Classification
    \value PubSubDiagnosticsWriterGroupType_TotalInformation_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_TotalInformation_TimeFirstChange
    \value PubSubDiagnosticsWriterGroupType_TotalError
    \value PubSubDiagnosticsWriterGroupType_TotalError_Active
    \value PubSubDiagnosticsWriterGroupType_TotalError_Classification
    \value PubSubDiagnosticsWriterGroupType_TotalError_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_TotalError_TimeFirstChange
    \value PubSubDiagnosticsWriterGroupType_Reset
    \value PubSubDiagnosticsWriterGroupType_SubError
    \value PubSubDiagnosticsWriterGroupType_Counters
    \value PubSubDiagnosticsWriterGroupType_Counters_StateError
    \value PubSubDiagnosticsWriterGroupType_Counters_StateError_Active
    \value PubSubDiagnosticsWriterGroupType_Counters_StateError_Classification
    \value PubSubDiagnosticsWriterGroupType_Counters_StateError_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_Counters_StateError_TimeFirstChange
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Active
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_Classification
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByMethod_TimeFirstChange
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Active
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_Classification
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalByParent_TimeFirstChange
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Active
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_Classification
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_Counters_StateOperationalFromError_TimeFirstChange
    \value PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent
    \value PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Active
    \value PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_Classification
    \value PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_Counters_StatePausedByParent_TimeFirstChange
    \value PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod
    \value PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Active
    \value PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_Classification
    \value PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_Counters_StateDisabledByMethod_TimeFirstChange
    \value PubSubDiagnosticsWriterGroupType_LiveValues
    \value PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages
    \value PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Active
    \value PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_Classification
    \value PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_Counters_SentNetworkMessages_TimeFirstChange
    \value PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions
    \value PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Active
    \value PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_Classification
    \value PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_Counters_FailedTransmissions_TimeFirstChange
    \value PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors
    \value PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Active
    \value PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_Classification
    \value PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_Counters_EncryptionErrors_TimeFirstChange
    \value PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters
    \value PubSubDiagnosticsWriterGroupType_LiveValues_ConfiguredDataSetWriters_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters
    \value PubSubDiagnosticsWriterGroupType_LiveValues_OperationalDataSetWriters_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID
    \value PubSubDiagnosticsWriterGroupType_LiveValues_SecurityTokenID_DiagnosticsLevel
    \value PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID
    \value PubSubDiagnosticsWriterGroupType_LiveValues_TimeToNextTokenID_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType
    \value PubSubDiagnosticsReaderGroupType_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_TotalInformation
    \value PubSubDiagnosticsReaderGroupType_TotalInformation_Active
    \value PubSubDiagnosticsReaderGroupType_TotalInformation_Classification
    \value PubSubDiagnosticsReaderGroupType_TotalInformation_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_TotalInformation_TimeFirstChange
    \value PubSubDiagnosticsReaderGroupType_TotalError
    \value PubSubDiagnosticsReaderGroupType_TotalError_Active
    \value PubSubDiagnosticsReaderGroupType_TotalError_Classification
    \value PubSubDiagnosticsReaderGroupType_TotalError_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_TotalError_TimeFirstChange
    \value PubSubDiagnosticsReaderGroupType_Reset
    \value PubSubDiagnosticsReaderGroupType_SubError
    \value PubSubDiagnosticsReaderGroupType_Counters
    \value PubSubDiagnosticsReaderGroupType_Counters_StateError
    \value PubSubDiagnosticsReaderGroupType_Counters_StateError_Active
    \value PubSubDiagnosticsReaderGroupType_Counters_StateError_Classification
    \value PubSubDiagnosticsReaderGroupType_Counters_StateError_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_Counters_StateError_TimeFirstChange
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Active
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_Classification
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByMethod_TimeFirstChange
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Active
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_Classification
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalByParent_TimeFirstChange
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Active
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_Classification
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_Counters_StateOperationalFromError_TimeFirstChange
    \value PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent
    \value PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Active
    \value PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_Classification
    \value PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_Counters_StatePausedByParent_TimeFirstChange
    \value PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod
    \value PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Active
    \value PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_Classification
    \value PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_Counters_StateDisabledByMethod_TimeFirstChange
    \value PubSubDiagnosticsReaderGroupType_LiveValues
    \value PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages
    \value PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Active
    \value PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_Classification
    \value PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_Counters_ReceivedNetworkMessages_TimeFirstChange
    \value PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages
    \value PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Active
    \value PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_Classification
    \value PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange
    \value PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors
    \value PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Active
    \value PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_Classification
    \value PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_Counters_DecryptionErrors_TimeFirstChange
    \value PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders
    \value PubSubDiagnosticsReaderGroupType_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel
    \value PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders
    \value PubSubDiagnosticsReaderGroupType_LiveValues_OperationalDataSetReaders_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType
    \value PubSubDiagnosticsDataSetWriterType_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_TotalInformation
    \value PubSubDiagnosticsDataSetWriterType_TotalInformation_Active
    \value PubSubDiagnosticsDataSetWriterType_TotalInformation_Classification
    \value PubSubDiagnosticsDataSetWriterType_TotalInformation_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_TotalInformation_TimeFirstChange
    \value PubSubDiagnosticsDataSetWriterType_TotalError
    \value PubSubDiagnosticsDataSetWriterType_TotalError_Active
    \value PubSubDiagnosticsDataSetWriterType_TotalError_Classification
    \value PubSubDiagnosticsDataSetWriterType_TotalError_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_TotalError_TimeFirstChange
    \value PubSubDiagnosticsDataSetWriterType_Reset
    \value PubSubDiagnosticsDataSetWriterType_SubError
    \value PubSubDiagnosticsDataSetWriterType_Counters
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateError
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateError_Active
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateError_Classification
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateError_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateError_TimeFirstChange
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Active
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_Classification
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByMethod_TimeFirstChange
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Active
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_Classification
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalByParent_TimeFirstChange
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Active
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_Classification
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateOperationalFromError_TimeFirstChange
    \value PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent
    \value PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Active
    \value PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_Classification
    \value PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_Counters_StatePausedByParent_TimeFirstChange
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Active
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_Classification
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_Counters_StateDisabledByMethod_TimeFirstChange
    \value PubSubDiagnosticsDataSetWriterType_LiveValues
    \value PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages
    \value PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Active
    \value PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_Classification
    \value PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_Counters_FailedDataSetMessages_TimeFirstChange
    \value PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber
    \value PubSubDiagnosticsDataSetWriterType_LiveValues_MessageSequenceNumber_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode
    \value PubSubDiagnosticsDataSetWriterType_LiveValues_StatusCode_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion
    \value PubSubDiagnosticsDataSetWriterType_LiveValues_MajorVersion_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion
    \value PubSubDiagnosticsDataSetWriterType_LiveValues_MinorVersion_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType
    \value PubSubDiagnosticsDataSetReaderType_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_TotalInformation
    \value PubSubDiagnosticsDataSetReaderType_TotalInformation_Active
    \value PubSubDiagnosticsDataSetReaderType_TotalInformation_Classification
    \value PubSubDiagnosticsDataSetReaderType_TotalInformation_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_TotalInformation_TimeFirstChange
    \value PubSubDiagnosticsDataSetReaderType_TotalError
    \value PubSubDiagnosticsDataSetReaderType_TotalError_Active
    \value PubSubDiagnosticsDataSetReaderType_TotalError_Classification
    \value PubSubDiagnosticsDataSetReaderType_TotalError_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_TotalError_TimeFirstChange
    \value PubSubDiagnosticsDataSetReaderType_Reset
    \value PubSubDiagnosticsDataSetReaderType_SubError
    \value PubSubDiagnosticsDataSetReaderType_Counters
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateError
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateError_Active
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateError_Classification
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateError_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateError_TimeFirstChange
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Active
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_Classification
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByMethod_TimeFirstChange
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Active
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_Classification
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalByParent_TimeFirstChange
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Active
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_Classification
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateOperationalFromError_TimeFirstChange
    \value PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent
    \value PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Active
    \value PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_Classification
    \value PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_Counters_StatePausedByParent_TimeFirstChange
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Active
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_Classification
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_Counters_StateDisabledByMethod_TimeFirstChange
    \value PubSubDiagnosticsDataSetReaderType_LiveValues
    \value PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages
    \value PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Active
    \value PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_Classification
    \value PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_Counters_FailedDataSetMessages_TimeFirstChange
    \value PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors
    \value PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Active
    \value PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_Classification
    \value PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_Counters_DecryptionErrors_TimeFirstChange
    \value PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber
    \value PubSubDiagnosticsDataSetReaderType_LiveValues_MessageSequenceNumber_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode
    \value PubSubDiagnosticsDataSetReaderType_LiveValues_StatusCode_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion
    \value PubSubDiagnosticsDataSetReaderType_LiveValues_MajorVersion_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion
    \value PubSubDiagnosticsDataSetReaderType_LiveValues_MinorVersion_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID
    \value PubSubDiagnosticsDataSetReaderType_LiveValues_SecurityTokenID_DiagnosticsLevel
    \value PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID
    \value PubSubDiagnosticsDataSetReaderType_LiveValues_TimeToNextTokenID_DiagnosticsLevel
    \value CertificateGroupType_CertificateExpired_ShelvingState_AvailableTransitions
    \value CertificateGroupType_CertificateExpired_ShelvingState_UnshelveTime
    \value CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve
    \value CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve_InputArguments
    \value CertificateGroupType_CertificateExpired_ShelvingState_Unshelve
    \value CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve
    \value CertificateGroupType_CertificateExpired_SuppressedOrShelved
    \value CertificateGroupType_CertificateExpired_MaxTimeShelved
    \value CertificateGroupType_CertificateExpired_AudibleEnabled
    \value CertificateGroupType_CertificateExpired_AudibleSound
    \value CertificateGroupType_CertificateExpired_AudibleSound_ListId
    \value CertificateGroupType_CertificateExpired_AudibleSound_AgencyId
    \value CertificateGroupType_CertificateExpired_AudibleSound_VersionId
    \value CertificateGroupType_CertificateExpired_SilenceState
    \value CertificateGroupType_CertificateExpired_SilenceState_Id
    \value CertificateGroupType_CertificateExpired_SilenceState_Name
    \value CertificateGroupType_CertificateExpired_SilenceState_Number
    \value CertificateGroupType_CertificateExpired_SilenceState_EffectiveDisplayName
    \value CertificateGroupType_CertificateExpired_SilenceState_TransitionTime
    \value CertificateGroupType_CertificateExpired_SilenceState_EffectiveTransitionTime
    \value CertificateGroupType_CertificateExpired_SilenceState_TrueState
    \value CertificateGroupType_CertificateExpired_SilenceState_FalseState
    \value CertificateGroupType_CertificateExpired_OnDelay
    \value CertificateGroupType_CertificateExpired_OffDelay
    \value CertificateGroupType_CertificateExpired_FirstInGroupFlag
    \value CertificateGroupType_CertificateExpired_FirstInGroup
    \value CertificateGroupType_CertificateExpired_LatchedState
    \value CertificateGroupType_CertificateExpired_LatchedState_Id
    \value CertificateGroupType_CertificateExpired_LatchedState_Name
    \value CertificateGroupType_CertificateExpired_LatchedState_Number
    \value CertificateGroupType_CertificateExpired_LatchedState_EffectiveDisplayName
    \value CertificateGroupType_CertificateExpired_LatchedState_TransitionTime
    \value CertificateGroupType_CertificateExpired_LatchedState_EffectiveTransitionTime
    \value CertificateGroupType_CertificateExpired_LatchedState_TrueState
    \value CertificateGroupType_CertificateExpired_LatchedState_FalseState
    \value CertificateGroupType_CertificateExpired_ReAlarmTime
    \value CertificateGroupType_CertificateExpired_ReAlarmRepeatCount
    \value CertificateGroupType_CertificateExpired_Silence
    \value CertificateGroupType_CertificateExpired_Suppress
    \value CertificateGroupType_CertificateExpired_Unsuppress
    \value CertificateGroupType_CertificateExpired_RemoveFromService
    \value CertificateGroupType_CertificateExpired_PlaceInService
    \value CertificateGroupType_CertificateExpired_Reset
    \value CertificateGroupType_CertificateExpired_NormalState
    \value CertificateGroupType_CertificateExpired_ExpirationDate
    \value CertificateGroupType_CertificateExpired_ExpirationLimit
    \value CertificateGroupType_CertificateExpired_CertificateType
    \value CertificateGroupType_CertificateExpired_Certificate
    \value CertificateGroupType_TrustListOutOfDate
    \value CertificateGroupType_TrustListOutOfDate_EventId
    \value CertificateGroupType_TrustListOutOfDate_EventType
    \value CertificateGroupType_TrustListOutOfDate_SourceNode
    \value CertificateGroupType_TrustListOutOfDate_SourceName
    \value CertificateGroupType_TrustListOutOfDate_Time
    \value CertificateGroupType_TrustListOutOfDate_ReceiveTime
    \value CertificateGroupType_TrustListOutOfDate_LocalTime
    \value CertificateGroupType_TrustListOutOfDate_Message
    \value CertificateGroupType_TrustListOutOfDate_Severity
    \value CertificateGroupType_TrustListOutOfDate_ConditionClassId
    \value CertificateGroupType_TrustListOutOfDate_ConditionClassName
    \value CertificateGroupType_TrustListOutOfDate_ConditionSubClassId
    \value CertificateGroupType_TrustListOutOfDate_ConditionSubClassName
    \value CertificateGroupType_TrustListOutOfDate_ConditionName
    \value CertificateGroupType_TrustListOutOfDate_BranchId
    \value CertificateGroupType_TrustListOutOfDate_Retain
    \value CertificateGroupType_TrustListOutOfDate_EnabledState
    \value CertificateGroupType_TrustListOutOfDate_EnabledState_Id
    \value CertificateGroupType_TrustListOutOfDate_EnabledState_Name
    \value CertificateGroupType_TrustListOutOfDate_EnabledState_Number
    \value CertificateGroupType_TrustListOutOfDate_EnabledState_EffectiveDisplayName
    \value CertificateGroupType_TrustListOutOfDate_EnabledState_TransitionTime
    \value CertificateGroupType_TrustListOutOfDate_EnabledState_EffectiveTransitionTime
    \value CertificateGroupType_TrustListOutOfDate_EnabledState_TrueState
    \value CertificateGroupType_TrustListOutOfDate_EnabledState_FalseState
    \value CertificateGroupType_TrustListOutOfDate_Quality
    \value CertificateGroupType_TrustListOutOfDate_Quality_SourceTimestamp
    \value CertificateGroupType_TrustListOutOfDate_LastSeverity
    \value CertificateGroupType_TrustListOutOfDate_LastSeverity_SourceTimestamp
    \value CertificateGroupType_TrustListOutOfDate_Comment
    \value CertificateGroupType_TrustListOutOfDate_Comment_SourceTimestamp
    \value CertificateGroupType_TrustListOutOfDate_ClientUserId
    \value CertificateGroupType_TrustListOutOfDate_Disable
    \value CertificateGroupType_TrustListOutOfDate_Enable
    \value CertificateGroupType_TrustListOutOfDate_AddComment
    \value CertificateGroupType_TrustListOutOfDate_AddComment_InputArguments
    \value CertificateGroupType_TrustListOutOfDate_AckedState
    \value CertificateGroupType_TrustListOutOfDate_AckedState_Id
    \value CertificateGroupType_TrustListOutOfDate_AckedState_Name
    \value CertificateGroupType_TrustListOutOfDate_AckedState_Number
    \value CertificateGroupType_TrustListOutOfDate_AckedState_EffectiveDisplayName
    \value CertificateGroupType_TrustListOutOfDate_AckedState_TransitionTime
    \value CertificateGroupType_TrustListOutOfDate_AckedState_EffectiveTransitionTime
    \value CertificateGroupType_TrustListOutOfDate_AckedState_TrueState
    \value CertificateGroupType_TrustListOutOfDate_AckedState_FalseState
    \value CertificateGroupType_TrustListOutOfDate_ConfirmedState
    \value CertificateGroupType_TrustListOutOfDate_ConfirmedState_Id
    \value CertificateGroupType_TrustListOutOfDate_ConfirmedState_Name
    \value CertificateGroupType_TrustListOutOfDate_ConfirmedState_Number
    \value CertificateGroupType_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName
    \value CertificateGroupType_TrustListOutOfDate_ConfirmedState_TransitionTime
    \value CertificateGroupType_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime
    \value CertificateGroupType_TrustListOutOfDate_ConfirmedState_TrueState
    \value CertificateGroupType_TrustListOutOfDate_ConfirmedState_FalseState
    \value CertificateGroupType_TrustListOutOfDate_Acknowledge
    \value CertificateGroupType_TrustListOutOfDate_Acknowledge_InputArguments
    \value CertificateGroupType_TrustListOutOfDate_Confirm
    \value CertificateGroupType_TrustListOutOfDate_Confirm_InputArguments
    \value CertificateGroupType_TrustListOutOfDate_ActiveState
    \value CertificateGroupType_TrustListOutOfDate_ActiveState_Id
    \value CertificateGroupType_TrustListOutOfDate_ActiveState_Name
    \value CertificateGroupType_TrustListOutOfDate_ActiveState_Number
    \value CertificateGroupType_TrustListOutOfDate_ActiveState_EffectiveDisplayName
    \value CertificateGroupType_TrustListOutOfDate_ActiveState_TransitionTime
    \value CertificateGroupType_TrustListOutOfDate_ActiveState_EffectiveTransitionTime
    \value CertificateGroupType_TrustListOutOfDate_ActiveState_TrueState
    \value CertificateGroupType_TrustListOutOfDate_ActiveState_FalseState
    \value CertificateGroupType_TrustListOutOfDate_InputNode
    \value CertificateGroupType_TrustListOutOfDate_SuppressedState
    \value CertificateGroupType_TrustListOutOfDate_SuppressedState_Id
    \value CertificateGroupType_TrustListOutOfDate_SuppressedState_Name
    \value CertificateGroupType_TrustListOutOfDate_SuppressedState_Number
    \value CertificateGroupType_TrustListOutOfDate_SuppressedState_EffectiveDisplayName
    \value CertificateGroupType_TrustListOutOfDate_SuppressedState_TransitionTime
    \value CertificateGroupType_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime
    \value CertificateGroupType_TrustListOutOfDate_SuppressedState_TrueState
    \value CertificateGroupType_TrustListOutOfDate_SuppressedState_FalseState
    \value CertificateGroupType_TrustListOutOfDate_OutOfServiceState
    \value CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Id
    \value CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Name
    \value CertificateGroupType_TrustListOutOfDate_OutOfServiceState_Number
    \value CertificateGroupType_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName
    \value CertificateGroupType_TrustListOutOfDate_OutOfServiceState_TransitionTime
    \value CertificateGroupType_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime
    \value CertificateGroupType_TrustListOutOfDate_OutOfServiceState_TrueState
    \value CertificateGroupType_TrustListOutOfDate_OutOfServiceState_FalseState
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Id
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Name
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_Number
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Id
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Name
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_Number
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_AvailableStates
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_AvailableTransitions
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_UnshelveTime
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve
    \value CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve
    \value CertificateGroupType_TrustListOutOfDate_SuppressedOrShelved
    \value CertificateGroupType_TrustListOutOfDate_MaxTimeShelved
    \value CertificateGroupType_TrustListOutOfDate_AudibleEnabled
    \value CertificateGroupType_TrustListOutOfDate_AudibleSound
    \value CertificateGroupType_TrustListOutOfDate_AudibleSound_ListId
    \value CertificateGroupType_TrustListOutOfDate_AudibleSound_AgencyId
    \value CertificateGroupType_TrustListOutOfDate_AudibleSound_VersionId
    \value CertificateGroupType_TrustListOutOfDate_SilenceState
    \value CertificateGroupType_TrustListOutOfDate_SilenceState_Id
    \value CertificateGroupType_TrustListOutOfDate_SilenceState_Name
    \value CertificateGroupType_TrustListOutOfDate_SilenceState_Number
    \value CertificateGroupType_TrustListOutOfDate_SilenceState_EffectiveDisplayName
    \value CertificateGroupType_TrustListOutOfDate_SilenceState_TransitionTime
    \value CertificateGroupType_TrustListOutOfDate_SilenceState_EffectiveTransitionTime
    \value CertificateGroupType_TrustListOutOfDate_SilenceState_TrueState
    \value CertificateGroupType_TrustListOutOfDate_SilenceState_FalseState
    \value CertificateGroupType_TrustListOutOfDate_OnDelay
    \value CertificateGroupType_TrustListOutOfDate_OffDelay
    \value CertificateGroupType_TrustListOutOfDate_FirstInGroupFlag
    \value CertificateGroupType_TrustListOutOfDate_FirstInGroup
    \value CertificateGroupType_TrustListOutOfDate_LatchedState
    \value CertificateGroupType_TrustListOutOfDate_LatchedState_Id
    \value CertificateGroupType_TrustListOutOfDate_LatchedState_Name
    \value CertificateGroupType_TrustListOutOfDate_LatchedState_Number
    \value CertificateGroupType_TrustListOutOfDate_LatchedState_EffectiveDisplayName
    \value CertificateGroupType_TrustListOutOfDate_LatchedState_TransitionTime
    \value CertificateGroupType_TrustListOutOfDate_LatchedState_EffectiveTransitionTime
    \value CertificateGroupType_TrustListOutOfDate_LatchedState_TrueState
    \value CertificateGroupType_TrustListOutOfDate_LatchedState_FalseState
    \value CertificateGroupType_TrustListOutOfDate_ReAlarmTime
    \value CertificateGroupType_TrustListOutOfDate_ReAlarmRepeatCount
    \value CertificateGroupType_TrustListOutOfDate_Silence
    \value CertificateGroupType_TrustListOutOfDate_Suppress
    \value CertificateGroupType_TrustListOutOfDate_Unsuppress
    \value CertificateGroupType_TrustListOutOfDate_RemoveFromService
    \value CertificateGroupType_TrustListOutOfDate_PlaceInService
    \value CertificateGroupType_TrustListOutOfDate_Reset
    \value CertificateGroupType_TrustListOutOfDate_NormalState
    \value CertificateGroupType_TrustListOutOfDate_TrustListId
    \value CertificateGroupType_TrustListOutOfDate_LastUpdateTime
    \value CertificateGroupType_TrustListOutOfDate_UpdateFrequency
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustList_UpdateFrequency
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventId
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EventType
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceNode
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SourceName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Time
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReceiveTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LocalTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Message
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Severity
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassId
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionClassName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConditionName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_BranchId
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Retain
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ClientUserId
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_InputNode
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleEnabled
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_Number
    \value DataSetOrderingType
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OnDelay
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_OffDelay
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroup
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReAlarmTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Silence
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_NormalState
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationDate
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ExpirationLimit
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_CertificateType
    \value CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Certificate
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventId
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EventType
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceNode
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SourceName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Time
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LocalTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Message
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Severity
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConditionName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_BranchId
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Retain
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_InputNode
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OnDelay
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_OffDelay
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Silence
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_NormalState
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_TrustListId
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime
    \value CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustList_UpdateFrequency
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventId
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EventType
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceNode
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SourceName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Time
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReceiveTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LocalTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Message
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Severity
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassId
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionClassName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConditionName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_BranchId
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Retain
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ClientUserId
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_InputNode
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleEnabled
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OnDelay
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_OffDelay
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_FirstInGroup
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReAlarmTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Silence
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_NormalState
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ExpirationDate
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ExpirationLimit
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_CertificateType
    \value CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Certificate
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventId
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EventType
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceNode
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SourceName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Time
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LocalTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Message
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Severity
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConditionName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_BranchId
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Retain
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_InputNode
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OnDelay
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_OffDelay
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Silence
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_NormalState
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_TrustListId
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime
    \value CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_UpdateFrequency
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EventId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EventType
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SourceNode
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SourceName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Time
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReceiveTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LocalTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Message
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Severity
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionClassId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionClassName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConditionName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_BranchId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Retain
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Quality
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LastSeverity
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Comment
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ClientUserId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_InputNode
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId
    \value VersionTime
    \value SessionlessInvokeResponseType
    \value SessionlessInvokeResponseType_Encoding_DefaultXml
    \value SessionlessInvokeResponseType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_FieldTargetDataType
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_SecurityTokenID_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID
    \value ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues_TimeToNextTokenID_DiagnosticsLevel
    \value ReaderGroupType_DataSetReaderName_Placeholder_SubscribedDataSet
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id
    \value ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables
    \value ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_InputArguments
    \value ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables_OutputArguments
    \value ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror
    \value ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_InputArguments
    \value ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror_OutputArguments
    \value ReaderGroupType_Diagnostics
    \value ReaderGroupType_Diagnostics_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_TotalInformation
    \value ReaderGroupType_Diagnostics_TotalInformation_Active
    \value ReaderGroupType_Diagnostics_TotalInformation_Classification
    \value ReaderGroupType_Diagnostics_TotalInformation_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_TotalInformation_TimeFirstChange
    \value ReaderGroupType_Diagnostics_TotalError
    \value ReaderGroupType_Diagnostics_TotalError_Active
    \value ReaderGroupType_Diagnostics_TotalError_Classification
    \value ReaderGroupType_Diagnostics_TotalError_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_TotalError_TimeFirstChange
    \value ReaderGroupType_Diagnostics_Reset
    \value ReaderGroupType_Diagnostics_SubError
    \value ReaderGroupType_Diagnostics_Counters
    \value ReaderGroupType_Diagnostics_Counters_StateError
    \value ReaderGroupType_Diagnostics_Counters_StateError_Active
    \value ReaderGroupType_Diagnostics_Counters_StateError_Classification
    \value ReaderGroupType_Diagnostics_Counters_StateError_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_Counters_StateError_TimeFirstChange
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Active
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_Classification
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalByMethod_TimeFirstChange
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalByParent
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Active
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_Classification
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalByParent_TimeFirstChange
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalFromError
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Active
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_Classification
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_Counters_StateOperationalFromError_TimeFirstChange
    \value ReaderGroupType_Diagnostics_Counters_StatePausedByParent
    \value ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Active
    \value ReaderGroupType_Diagnostics_Counters_StatePausedByParent_Classification
    \value ReaderGroupType_Diagnostics_Counters_StatePausedByParent_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_Counters_StatePausedByParent_TimeFirstChange
    \value ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod
    \value ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Active
    \value ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_Classification
    \value ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_Counters_StateDisabledByMethod_TimeFirstChange
    \value ReaderGroupType_Diagnostics_LiveValues
    \value ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages
    \value ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Active
    \value ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_Classification
    \value ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_Counters_ReceivedNetworkMessages_TimeFirstChange
    \value ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages
    \value ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Active
    \value ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_Classification
    \value ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_Counters_ReceivedInvalidNetworkMessages_TimeFirstChange
    \value ReaderGroupType_Diagnostics_Counters_DecryptionErrors
    \value ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Active
    \value ReaderGroupType_Diagnostics_Counters_DecryptionErrors_Classification
    \value ReaderGroupType_Diagnostics_Counters_DecryptionErrors_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_Counters_DecryptionErrors_TimeFirstChange
    \value ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders
    \value ReaderGroupType_Diagnostics_LiveValues_ConfiguredDataSetReaders_DiagnosticsLevel
    \value ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders
    \value ReaderGroupType_Diagnostics_LiveValues_OperationalDataSetReaders_DiagnosticsLevel
    \value ReaderGroupType_TransportSettings
    \value ReaderGroupType_MessageSettings
    \value ReaderGroupType_AddDataSetReader
    \value ReaderGroupType_AddDataSetReader_InputArguments
    \value ReaderGroupType_AddDataSetReader_OutputArguments
    \value ReaderGroupType_RemoveDataSetReader
    \value ReaderGroupType_RemoveDataSetReader_InputArguments
    \value PubSubGroupTypeAddReaderMethodType
    \value PubSubGroupTypeAddReaderMethodType_InputArguments
    \value PubSubGroupTypeAddReaderMethodType_OutputArguments
    \value ReaderGroupTransportType
    \value ReaderGroupMessageType
    \value DataSetWriterType_DataSetWriterId
    \value DataSetWriterType_DataSetFieldContentMask
    \value DataSetWriterType_KeyFrameCount
    \value DataSetWriterType_MessageSettings
    \value DataSetWriterMessageType
    \value DataSetReaderType_PublisherId
    \value DataSetReaderType_WriterGroupId
    \value DataSetReaderType_DataSetWriterId
    \value DataSetReaderType_DataSetMetaData
    \value DataSetReaderType_DataSetFieldContentMask
    \value DataSetReaderType_MessageReceiveTimeout
    \value DataSetReaderType_MessageSettings
    \value DataSetReaderMessageType
    \value UadpWriterGroupMessageType
    \value UadpWriterGroupMessageType_GroupVersion
    \value UadpWriterGroupMessageType_DataSetOrdering
    \value UadpWriterGroupMessageType_NetworkMessageContentMask
    \value UadpWriterGroupMessageType_SamplingOffset
    \value UadpWriterGroupMessageType_PublishingOffset
    \value UadpDataSetWriterMessageType
    \value UadpDataSetWriterMessageType_DataSetMessageContentMask
    \value UadpDataSetWriterMessageType_ConfiguredSize
    \value UadpDataSetWriterMessageType_NetworkMessageNumber
    \value UadpDataSetWriterMessageType_DataSetOffset
    \value UadpDataSetReaderMessageType
    \value UadpDataSetReaderMessageType_GroupVersion
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name
    \value UadpDataSetReaderMessageType_NetworkMessageNumber
    \value UadpDataSetReaderMessageType_DataSetClassId
    \value UadpDataSetReaderMessageType_NetworkMessageContentMask
    \value UadpDataSetReaderMessageType_DataSetMessageContentMask
    \value UadpDataSetReaderMessageType_PublishingInterval
    \value UadpDataSetReaderMessageType_ProcessingOffset
    \value UadpDataSetReaderMessageType_ReceiveOffset
    \value JsonWriterGroupMessageType
    \value JsonWriterGroupMessageType_NetworkMessageContentMask
    \value JsonDataSetWriterMessageType
    \value JsonDataSetWriterMessageType_DataSetMessageContentMask
    \value JsonDataSetReaderMessageType
    \value JsonDataSetReaderMessageType_NetworkMessageContentMask
    \value JsonDataSetReaderMessageType_DataSetMessageContentMask
    \value DatagramWriterGroupTransportType
    \value DatagramWriterGroupTransportType_MessageRepeatCount
    \value DatagramWriterGroupTransportType_MessageRepeatDelay
    \value BrokerWriterGroupTransportType
    \value BrokerWriterGroupTransportType_QueueName
    \value BrokerDataSetWriterTransportType
    \value BrokerDataSetWriterTransportType_QueueName
    \value BrokerDataSetWriterTransportType_MetaDataQueueName
    \value BrokerDataSetWriterTransportType_MetaDataUpdateTime
    \value BrokerDataSetReaderTransportType
    \value BrokerDataSetReaderTransportType_QueueName
    \value BrokerDataSetReaderTransportType_MetaDataQueueName
    \value NetworkAddressType
    \value NetworkAddressType_NetworkInterface
    \value NetworkAddressUrlType
    \value NetworkAddressUrlType_NetworkInterface
    \value NetworkAddressUrlType_Url
    \value WriterGroupDataType_Encoding_DefaultBinary
    \value NetworkAddressDataType_Encoding_DefaultBinary
    \value NetworkAddressUrlDataType_Encoding_DefaultBinary
    \value ReaderGroupDataType_Encoding_DefaultBinary
    \value PubSubConfigurationDataType_Encoding_DefaultBinary
    \value DatagramWriterGroupTransportDataType_Encoding_DefaultBinary
    \value OpcUa_BinarySchema_WriterGroupDataType
    \value OpcUa_BinarySchema_WriterGroupDataType_DataTypeVersion
    \value OpcUa_BinarySchema_WriterGroupDataType_DictionaryFragment
    \value OpcUa_BinarySchema_NetworkAddressDataType
    \value OpcUa_BinarySchema_NetworkAddressDataType_DataTypeVersion
    \value OpcUa_BinarySchema_NetworkAddressDataType_DictionaryFragment
    \value OpcUa_BinarySchema_NetworkAddressUrlDataType
    \value OpcUa_BinarySchema_NetworkAddressUrlDataType_DataTypeVersion
    \value OpcUa_BinarySchema_NetworkAddressUrlDataType_DictionaryFragment
    \value OpcUa_BinarySchema_ReaderGroupDataType
    \value OpcUa_BinarySchema_ReaderGroupDataType_DataTypeVersion
    \value OpcUa_BinarySchema_ReaderGroupDataType_DictionaryFragment
    \value OpcUa_BinarySchema_PubSubConfigurationDataType
    \value OpcUa_BinarySchema_PubSubConfigurationDataType_DataTypeVersion
    \value OpcUa_BinarySchema_PubSubConfigurationDataType_DictionaryFragment
    \value OpcUa_BinarySchema_DatagramWriterGroupTransportDataType
    \value OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DataTypeVersion
    \value OpcUa_BinarySchema_DatagramWriterGroupTransportDataType_DictionaryFragment
    \value WriterGroupDataType_Encoding_DefaultXml
    \value NetworkAddressDataType_Encoding_DefaultXml
    \value NetworkAddressUrlDataType_Encoding_DefaultXml
    \value ReaderGroupDataType_Encoding_DefaultXml
    \value PubSubConfigurationDataType_Encoding_DefaultXml
    \value DatagramWriterGroupTransportDataType_Encoding_DefaultXml
    \value OpcUa_XmlSchema_WriterGroupDataType
    \value OpcUa_XmlSchema_WriterGroupDataType_DataTypeVersion
    \value OpcUa_XmlSchema_WriterGroupDataType_DictionaryFragment
    \value OpcUa_XmlSchema_NetworkAddressDataType
    \value OpcUa_XmlSchema_NetworkAddressDataType_DataTypeVersion
    \value OpcUa_XmlSchema_NetworkAddressDataType_DictionaryFragment
    \value OpcUa_XmlSchema_NetworkAddressUrlDataType
    \value OpcUa_XmlSchema_NetworkAddressUrlDataType_DataTypeVersion
    \value OpcUa_XmlSchema_NetworkAddressUrlDataType_DictionaryFragment
    \value OpcUa_XmlSchema_ReaderGroupDataType
    \value OpcUa_XmlSchema_ReaderGroupDataType_DataTypeVersion
    \value OpcUa_XmlSchema_ReaderGroupDataType_DictionaryFragment
    \value OpcUa_XmlSchema_PubSubConfigurationDataType
    \value OpcUa_XmlSchema_PubSubConfigurationDataType_DataTypeVersion
    \value OpcUa_XmlSchema_PubSubConfigurationDataType_DictionaryFragment
    \value OpcUa_XmlSchema_DatagramWriterGroupTransportDataType
    \value OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DataTypeVersion
    \value OpcUa_XmlSchema_DatagramWriterGroupTransportDataType_DictionaryFragment
    \value WriterGroupDataType_Encoding_DefaultJson
    \value NetworkAddressDataType_Encoding_DefaultJson
    \value NetworkAddressUrlDataType_Encoding_DefaultJson
    \value ReaderGroupDataType_Encoding_DefaultJson
    \value PubSubConfigurationDataType_Encoding_DefaultJson
    \value DatagramWriterGroupTransportDataType_Encoding_DefaultJson
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OnDelay
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_OffDelay
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_FirstInGroup
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Silence
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_NormalState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ExpirationDate
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_CertificateType
    \value CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Certificate
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EventId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EventType
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SourceName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Time
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Message
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Severity
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_BranchId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Retain
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Quality
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Comment
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_InputNode
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Silence
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_NormalState
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime
    \value CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_UpdateFrequency
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EventId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EventType
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SourceNode
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SourceName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Time
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReceiveTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LocalTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Message
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Severity
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionClassId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionClassName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionSubClassId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionSubClassName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConditionName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_BranchId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Retain
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_EnabledState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Quality
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Quality_SourceTimestamp
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LastSeverity
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LastSeverity_SourceTimestamp
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Comment
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Comment_SourceTimestamp
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ClientUserId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AckedState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ConfirmedState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ActiveState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_InputNode
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OutOfServiceState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_AvailableStates
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_AvailableTransitions
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_UnshelveTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SuppressedOrShelved
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_MaxTimeShelved
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleEnabled
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound_ListId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound_AgencyId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AudibleSound_VersionId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_SilenceState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OnDelay
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_OffDelay
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_FirstInGroupFlag
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_FirstInGroup
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_LatchedState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReAlarmTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ReAlarmRepeatCount
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Silence
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_NormalState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ExpirationDate
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ExpirationLimit
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_CertificateType
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Certificate
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EventId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EventType
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SourceNode
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SourceName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Time
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReceiveTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LocalTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Message
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Severity
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionClassId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionClassName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionSubClassId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionSubClassName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConditionName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_BranchId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Retain
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_EnabledState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Quality
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Quality_SourceTimestamp
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastSeverity
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastSeverity_SourceTimestamp
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Comment
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Comment_SourceTimestamp
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ClientUserId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AckedState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ConfirmedState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ActiveState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_InputNode
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OutOfServiceState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_AvailableStates
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_AvailableTransitions
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_UnshelveTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SuppressedOrShelved
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_MaxTimeShelved
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleEnabled
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound_ListId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound_AgencyId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AudibleSound_VersionId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_SilenceState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OnDelay
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_OffDelay
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_FirstInGroupFlag
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_FirstInGroup
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Id
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Name
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_Number
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_EffectiveDisplayName
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_TransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_EffectiveTransitionTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_TrueState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LatchedState_FalseState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReAlarmTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ReAlarmRepeatCount
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Silence
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_NormalState
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_TrustListId
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_LastUpdateTime
    \value CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_UpdateFrequency
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime
    \value ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime
    \value ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime
    \value ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime
    \value ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime
    \value ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate
    \value ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId
    \value ServerConfiguratio