# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial

from typing import Optional

from checkboxpanel import CheckBoxPanel

from PySide6.QtWidgets import QWidget

# flake8: noqa E:122

CORE_DESC = """Provides core non-GUI functionality, like signal and slots, properties, base
classes of item models, serialization, and more."""


GUI_DESC = """Extends QtCore with GUI functionality: Events, windows and screens, OpenGL
and raster-based 2D painting, as well as images."""


_MODULES = [
'Basic modules',
('Core', 'Qt Core', True, CORE_DESC),
('Gui', 'Qt GUI', False, GUI_DESC),
('Widgets', 'Qt Widgets', False,
 "Provides ready to use Widgets for your application, including graphical elements for your UI."),
 'QML and Qt Quick',
('Qml', 'Qt QML', False,
 'The base Python API to interact with the module.'),
('Quick', 'Qt Quick', False,
 'Provides classes to embed Qt Quick in Qt applications.'),
('QuickWidgets', 'Qt QuickWidgets', False,
 'Provides the QQuickWidget class to embed Qt Quick in widget-based applications.'),
 'Data visualization',
('Charts', 'Qt Charts', False,
 'Provides a set of easy to use chart components.'),
('DataVisualization', 'Qt DataVisualization', False,
 'Provides a way to visualize data in 3D as bar, scatter, or surface graphs.'),
 'WebEngine',
('WebEngineWidgets', 'Qt WebEngineWidgets', False,
 'Provides widgets to handle Web content.')
]


class QtModuleChooser(CheckBoxPanel):
    """Presents Qt Modules"""

    def __init__(self, parent: Optional[QWidget] = None):
        t = 'Enable Qt Modules'
        super(QtModuleChooser, self).__init__(t, _MODULES, 4, parent)
        self.setCheckable(True)
