// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#include "objectview.h"
#include "objectmodel.h"
#include "str.h"

Str ObjectView::displayModelData()
{
    if (!m_model)
        return {"(NULL)"};
    return Str("Name: %VAR").arg(m_model->objectName());
}

void ObjectView::modifyModelData(Str &data)
{
    if (m_model)
        m_model->setObjectName(data);
}

ObjectType *ObjectView::getRawModelData()
{
    return m_model->data();
}
